/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.SenderRhsPadding;
import io.aeron.driver.cmd.SenderCmd;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public class Sender
extends SenderRhsPadding
implements Agent,
Consumer<SenderCmd> {
    private static final NetworkPublication[] EMPTY_PUBLICATIONS = new NetworkPublication[0];
    private final long statusMessageReadTimeoutNs;
    private final int dutyCycleRatio;
    private final ControlTransportPoller controlTransportPoller;
    private final OneToOneConcurrentArrayQueue<SenderCmd> commandQueue;
    private final AtomicCounter totalBytesSent;
    private final NanoClock nanoClock;
    private final DriverConductorProxy conductorProxy;
    private NetworkPublication[] networkPublications = EMPTY_PUBLICATIONS;

    public Sender(MediaDriver.Context ctx) {
        this.controlTransportPoller = ctx.controlTransportPoller();
        this.commandQueue = ctx.senderCommandQueue();
        this.totalBytesSent = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_SENT);
        this.nanoClock = ctx.cachedNanoClock();
        this.statusMessageReadTimeoutNs = ctx.statusMessageTimeoutNs() / 2L;
        this.dutyCycleRatio = Configuration.sendToStatusMessagePollRatio();
        this.conductorProxy = ctx.driverConductorProxy();
    }

    public void onClose() {
        this.controlTransportPoller.close();
    }

    public int doWork() {
        int workCount = this.commandQueue.drain((Consumer)this, 10);
        long nowNs = this.nanoClock.nanoTime();
        int bytesSent = this.doSend(nowNs);
        int bytesReceived = 0;
        if (0 == bytesSent || ++this.dutyCycleCounter == this.dutyCycleRatio || nowNs >= this.controlPollDeadlineNs) {
            bytesReceived = this.controlTransportPoller.pollTransports();
            this.dutyCycleCounter = 0;
            this.controlPollDeadlineNs = nowNs + this.statusMessageReadTimeoutNs;
        }
        return workCount + bytesSent + bytesReceived;
    }

    public String roleName() {
        return "sender";
    }

    public void onRegisterSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        channelEndpoint.openChannel(this.conductorProxy);
        channelEndpoint.registerForRead(this.controlTransportPoller);
        channelEndpoint.indicateActive();
    }

    public void onCloseSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        channelEndpoint.close();
    }

    public void onNewNetworkPublication(NetworkPublication publication) {
        this.networkPublications = (NetworkPublication[])ArrayUtil.add((Object[])this.networkPublications, (Object)publication);
        publication.channelEndpoint().registerForSend(publication);
    }

    public void onRemoveNetworkPublication(NetworkPublication publication) {
        this.networkPublications = (NetworkPublication[])ArrayUtil.remove((Object[])this.networkPublications, (Object)publication);
        publication.channelEndpoint().unregisterForSend(publication);
        publication.senderRelease();
    }

    public void onAddDestination(SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        channelEndpoint.addDestination(address);
    }

    public void onRemoveDestination(SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        channelEndpoint.removeDestination(address);
    }

    @Override
    public void accept(SenderCmd cmd) {
        cmd.execute(this);
    }

    private int doSend(long nowNs) {
        int i;
        int startingIndex;
        int bytesSent = 0;
        NetworkPublication[] publications = this.networkPublications;
        int length = publications.length;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length; ++i) {
            bytesSent += publications[i].send(nowNs);
        }
        for (i = 0; i < startingIndex; ++i) {
            bytesSent += publications[i].send(nowNs);
        }
        this.totalBytesSent.getAndAddOrdered((long)bytesSent);
        return bytesSent;
    }
}

