/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.SecuredCi;
import com.xebialabs.deployit.repository.sql.base.SecuredCiQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.CiPathValidation;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001=\u00111\"T8wK\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019B\u0001\u0001\t\u0015/A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0007CA\t\u0016\u0013\t1\"A\u0001\tDSB\u000bG\u000f\u001b,bY&$\u0017\r^5p]B\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0005E\u0006\u001cX-\u0003\u0002\u001d3\tI1+Z2ve\u0016$7)\u001b\u0005\t=\u0001\u0011)\u0019!C!?\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t\u0001\u0005\u0005\u0002\"U5\t!E\u0003\u0002$I\u0005!1m\u001c:f\u0015\t)c%\u0001\u0003kI\n\u001c'BA\u0014)\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u0015\u0002\u0007=\u0014x-\u0003\u0002,E\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"AQ\u0006\u0001B\u0001B\u0003%\u0001%A\u0007kI\n\u001cG+Z7qY\u0006$X\r\t\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u00051\u0012M\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00022i5\t!G\u0003\u00024\t\u0005I\u0011M\u001d;jM\u0006\u001cGo]\u0005\u0003kI\u0012a#\u0011:uS\u001a\f7\r\u001e#bi\u0006\u0014V\r]8tSR|'/\u001f\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005\u00012m\\7nC:$g+\u00197jI\u0006$xN\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\t!B^1mS\u0012\fG/[8o\u0013\ti$H\u0001\tD_6l\u0017M\u001c3WC2LG-\u0019;pe\"Aq\b\u0001BC\u0002\u0013\u0005\u0001)A\u0004n_Z,7)[:\u0016\u0003\u0005\u00032A\u0011'P\u001d\t\u0019\u0015J\u0004\u0002E\u000f6\tQI\u0003\u0002G\u001d\u00051AH]8pizJ\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015.\u000bq\u0001]1dW\u0006<WMC\u0001I\u0013\tieJ\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tQ5\n\u0005\u0003Q'V+V\"A)\u000b\u0005IC\u0011\u0001B;uS2L!\u0001V)\u0003\u000bQ+\b\u000f\\3\u0011\u0005YSfBA,Y!\t!5*\u0003\u0002Z\u0017\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI6\n\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003B\u0003!iwN^3DSN\u0004\u0003\u0002\u00031\u0001\u0005\u000b\u0007I1A1\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001c!\t\u0019g-D\u0001e\u0015\t)QM\u0003\u0002$\u0011%\u0011q\r\u001a\u0002\u000b'FdG)[1mK\u000e$\b\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u0002\u0017M\fH\u000eR5bY\u0016\u001cG\u000f\t\u0005\u0006W\u0002!\t\u0001\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b5\u0004\u0018O]:\u0015\u00059|\u0007CA\t\u0001\u0011\u0015\u0001'\u000eq\u0001c\u0011\u0015q\"\u000e1\u0001!\u0011\u0015y#\u000e1\u00011\u0011\u00159$\u000e1\u00019\u0011\u0015y$\u000e1\u0001B\u0011\u0015)\b\u0001\"\u0011w\u0003\u001d)\u00070Z2vi\u0016$\"a^>\u0011\u0005aLX\"A&\n\u0005i\\%\u0001B+oSRDQ\u0001 ;A\u0002u\fqaY8oi\u0016DH\u000f\u0005\u0002\u0012}&\u0011qP\u0001\u0002\u0011\u0007\"\fgnZ3TKR\u001cuN\u001c;fqRDq!a\u0001\u0001\t\u0003\n)!\u0001\u0005wC2LG-\u0019;f)\r9\u0018q\u0001\u0005\u0007y\u0006\u0005\u0001\u0019A?\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e\u0005!Qn\u001c<f)\u001d9\u0018qBA\n\u0003/Aq!!\u0005\u0002\n\u0001\u0007Q+A\u0003pY\u0012LE\rC\u0004\u0002\u0016\u0005%\u0001\u0019A+\u0002\u000b9,w/\u00133\t\rq\fI\u00011\u0001~\u0011\u001d\tY\u0002\u0001C\u0005\u0003;\t1#];fef\fe\u000e\u001a)sKZ\u000bG.\u001b3bi\u0016$\u0002\"a\b\u0002@\u0005\u0005\u00131\t\t\u0007q\u0006\u0005R+!\n\n\u0007\u0005\r2J\u0001\u0004UkBdWM\r\t\b\u0003O\ty#VA\u001a\u001b\t\tICC\u0002S\u0003WQ!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\tICA\u0002NCB\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY#\u0001\u0003mC:<\u0017\u0002BA\u001f\u0003o\u0011aa\u00142kK\u000e$\bbBA\t\u00033\u0001\r!\u0016\u0005\b\u0003+\tI\u00021\u0001V\u0011\u0019a\u0018\u0011\u0004a\u0001{\"9\u0011q\t\u0001\u0005\n\u0005%\u0013AD;qI\u0006$XmU3dkJLG/\u001f\u000b\bo\u0006-\u00131OA<\u0011!\ti%!\u0012A\u0002\u0005=\u0013A\u00019l!\u0011\t\t&!\u001c\u000f\t\u0005M\u00131\u000e\b\u0005\u0003+\nIG\u0004\u0003\u0002X\u0005\u001dd\u0002BA-\u0003KrA!a\u0017\u0002d9!\u0011QLA1\u001d\r!\u0015qL\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011B\u0001\u000e\u0005\u0013\tQ\u0015$\u0003\u0003\u0002p\u0005E$\u0001C\"j!.#\u0016\u0010]3\u000b\u0005)K\u0002\u0002CA;\u0003\u000b\u0002\r!a\u0014\u0002\u0011A\f'/\u001a8u!.Dq!!\u001f\u0002F\u0001\u0007Q+A\u0004oK^\u0004\u0016\r\u001e5\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\u0005aa/\u00197jI\u0006$X-T8wKR9q/!!\u0002\u0004\u0006\u0015\u0005bBA\t\u0003w\u0002\r!\u0016\u0005\b\u0003+\tY\b1\u0001V\u0011\u0019a\u00181\u0010a\u0001{\u0002")
public class MoveCommand
extends UpdatePathCommand
implements CiPathValidation,
SecuredCi {
    private final JdbcTemplate jdbcTemplate;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> moveCis;
    private final SqlDialect sqlDialect;
    private String SELECT_SECURED_CI;
    private String UPDATE_SECURED_CI;
    private volatile byte bitmap$0;

    @Override
    public Option<Integer> getSecuredCi(Integer pk) {
        return SecuredCi.getSecuredCi$(this, pk);
    }

    @Override
    public void setSecuredCi(Integer pk, Integer securedCi) {
        SecuredCi.setSecuredCi$(this, pk, securedCi);
    }

    @Override
    public void validateCiStoredInCorrectPath(String id, Type ciType, ChangeSetContext context) {
        CiPathValidation.validateCiStoredInCorrectPath$(this, id, ciType, context);
    }

    private String SELECT_SECURED_CI$lzycompute() {
        MoveCommand moveCommand = this;
        synchronized (moveCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.SELECT_SECURED_CI = SecuredCiQueries.SELECT_SECURED_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.SELECT_SECURED_CI;
    }

    @Override
    public String SELECT_SECURED_CI() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.SELECT_SECURED_CI$lzycompute() : this.SELECT_SECURED_CI;
    }

    private String UPDATE_SECURED_CI$lzycompute() {
        MoveCommand moveCommand = this;
        synchronized (moveCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.UPDATE_SECURED_CI = SecuredCiQueries.UPDATE_SECURED_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.UPDATE_SECURED_CI;
    }

    @Override
    public String UPDATE_SECURED_CI() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.UPDATE_SECURED_CI$lzycompute() : this.UPDATE_SECURED_CI;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> moveCis() {
        return this.moveCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.move((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateMove((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void move(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        String newPath = package$.MODULE$.idToPath(newId);
        Integer parentPk = this.updateNameAndPath(oldPath, newPath);
        this.updateSecurity(package$.MODULE$.asCiPKType(map3.get(CIS$.MODULE$.ID().name())), parentPk, newPath);
        EventBusHolder.publish((Object)new CiMovedEvent(package$.MODULE$.readBaseCiFromMap(map3), newId));
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newId, ChangeSetContext context) {
        String string = oldId;
        String string2 = newId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        this.commandValidator.checkMoveAllowed(ciType);
        this.validateCiStoredInCorrectPath(newId, ciType, context);
        return new Tuple2((Object)oldPath, (Object)map);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSecurity(Integer pk, Integer parentPk, String newPath) {
        boolean bl = false;
        Some some = null;
        Option<Integer> option = this.getSecuredCi(pk);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Integer n = (Integer)some.value();
            Integer n2 = pk;
            Integer n3 = n;
            if (!(n2 != null ? !((Object)n2).equals(n3) : n3 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Integer securedPk = (Integer)some.value();
        Option<Integer> option2 = this.getSecuredCi(parentPk);
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            Integer newSecuredPk = (Integer)some2.value();
            this.jdbcTemplate().update(this.UPDATE_SECURED_ID(), new Object[]{newSecuredPk, newPath, newPath + "/%", securedPk});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            this.jdbcTemplate().update(this.UPDATE_SECURED_ID(), new Object[]{null, newPath, newPath + "/%", securedPk});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void validateMove(String oldId, String newId, ChangeSetContext context) {
        this.queryAndPreValidate(oldId, newId, context);
        if (this.exists(newId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{newId});
        }
    }

    public MoveCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactDataRepository, CommandValidator commandValidator, Iterable<Tuple<String, String>> moveCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.commandValidator = commandValidator;
        this.moveCis = moveCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactDataRepository);
        CiPathValidation.$init$(this);
        SecuredCiQueries.$init$(this);
        SecuredCi.$init$(this);
    }
}

