/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.InsertCommand;
import com.xebialabs.deployit.repository.sql.reader.CiReader;
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificInserter;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.license.LicenseCiCounter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0001\u0003\u0001=\u00111bQ8qs\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!D%og\u0016\u0014HoQ8n[\u0006tG\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0011\u0017\u00031QGMY2UK6\u0004H.\u0019;f+\u00059\u0002C\u0001\r\"\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005qi\u0012\u0001\u00026eE\u000eT!AH\u0010\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001a\u00051QEMY2UK6\u0004H.\u0019;f\u0011%!\u0003A!A!\u0002\u00139R%A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0005\u0003+IA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0013CJ$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002*Y5\t!F\u0003\u0002,\t\u0005I\u0011M\u001d;jM\u0006\u001cGo]\u0005\u0003[)\u0012!#\u0011:uS\u001a\f7\r\u001e*fa>\u001c\u0018\u000e^8ss\"Aq\u0006\u0001B\u0001B\u0003%\u0001'\u0001\fbeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z!\tI\u0013'\u0003\u00023U\t1\u0012I\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003M\u0019\u0017\u000eS5ti>\u0014\u0018PU3q_NLGo\u001c:z!\t1t'D\u0001\u0005\u0013\tADAA\nDS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0003E\u0001\u0018m]:x_J$WI\\2ssB$XM\u001d\t\u0003y}j\u0011!\u0010\u0006\u0003}!\tA!\u001e;jY&\u0011\u0001)\u0010\u0002\u0012!\u0006\u001c8o^8sI\u0016s7M]=qi\u0016\u0014\b\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002!1L7-\u001a8tK\u000eK7i\\;oi\u0016\u0014\bC\u0001#H\u001b\u0005)%B\u0001$\u000b\u0003\u001da\u0017nY3og\u0016L!\u0001S#\u0003!1K7-\u001a8tK\u000eK7i\\;oi\u0016\u0014\b\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\u0011\rL'+Z1eKJ\u0004\"\u0001T(\u000e\u00035S!A\u0014\u0003\u0002\rI,\u0017\rZ3s\u0013\t\u0001VJ\u0001\u0005DSJ+\u0017\rZ3s\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0016aG2sK\u0006$X\rV=qKN\u0003XmY5gS\u000eLen]3si\u0016\u00148\u000fE\u0003U/f\u001b70D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005%1UO\\2uS>t'\u0007\u0005\u0002[C6\t1L\u0003\u0002];\u00069!/\u001a4mK\u000e$(B\u00010`\u0003\r\t\u0007/\u001b\u0006\u0003A\"\ta\u0001\u001d7vO&t\u0017B\u00012\\\u0005\u0011!\u0016\u0010]3\u0011\u0005\u0011DhBA3v\u001d\t17O\u0004\u0002he:\u0011\u0001.\u001d\b\u0003SBt!A[8\u000f\u0005-tW\"\u00017\u000b\u00055t\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u001e\u0003\u0002\t\t\f7/Z\u0005\u0003m^\fq\u0001]1dW\u0006<WM\u0003\u0002u\t%\u0011\u0011P\u001f\u0002\t\u0007&\u00046\nV=qK*\u0011ao\u001e\t\u0006y\u0006\u0005\u0011q\u0001\b\u0003{~t!a\u001b@\n\u0003YK!A^+\n\t\u0005\r\u0011Q\u0001\u0002\u0005\u0019&\u001cHO\u0003\u0002w+B!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0011\t\u0001b\u001d9fG&4\u0017nY\u0005\u0005\u0003#\tYA\u0001\u000bUsB,7\u000b]3dS\u001aL7-\u00138tKJ$XM\u001d\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0011\u0001E2p[6\fg\u000e\u001a,bY&$\u0017\r^8s!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\r\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\t\u0005\u0005\u00121\u0004\u0002\u0011\u0007>lW.\u00198e-\u0006d\u0017\u000eZ1u_JD!\"!\n\u0001\u0005\u000b\u0007I\u0011AA\u0014\u0003\u001d\u0019w\u000e]=DSN,\"!!\u000b\u0011\u000bq\fY#a\f\n\t\u00055\u0012Q\u0001\u0002\t\u0013R,'/\u00192mKB9A(!\r\u00026\u0005U\u0012bAA\u001a{\t)A+\u001e9mKB!\u0011qGA \u001d\u0011\tI$a\u000f\u0011\u0005-,\u0016bAA\u001f+\u00061\u0001K]3eK\u001aLA!!\u0011\u0002D\t11\u000b\u001e:j]\u001eT1!!\u0010V\u0011)\t9\u0005\u0001B\u0001B\u0003%\u0011\u0011F\u0001\tG>\u0004\u0018pQ5tA!Q\u00111\n\u0001\u0003\u0006\u0004%\u0019!!\u0014\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0006\u0003+R!A\u0007\u0005\n\t\u0005e\u00131\u000b\u0002\u000b'FdG)[1mK\u000e$\bBCA/\u0001\t\u0005\t\u0015!\u0003\u0002P\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\na\u0001P5oSRtDCFA3\u0003W\ni'a\u001c\u0002r\u0005M\u0014QOA<\u0003s\nY(! \u0015\t\u0005\u001d\u0014\u0011\u000e\t\u0003#\u0001A\u0001\"a\u0013\u0002`\u0001\u000f\u0011q\n\u0005\u0007+\u0005}\u0003\u0019A\f\t\r\u001d\ny\u00061\u0001)\u0011\u0019y\u0013q\fa\u0001a!1A'a\u0018A\u0002UBaAOA0\u0001\u0004Y\u0004B\u0002\"\u0002`\u0001\u00071\t\u0003\u0004K\u0003?\u0002\ra\u0013\u0005\u0007%\u0006}\u0003\u0019A*\t\u0011\u0005U\u0011q\fa\u0001\u0003/A\u0001\"!\n\u0002`\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003\u0003\u0003A\u0011IAB\u0003\u001d)\u00070Z2vi\u0016$B!!\"\u0002\fB\u0019A+a\"\n\u0007\u0005%UK\u0001\u0003V]&$\b\u0002CAG\u0003\u007f\u0002\r!a$\u0002\u000f\r|g\u000e^3yiB\u0019\u0011#!%\n\u0007\u0005M%A\u0001\tDQ\u0006tw-Z*fi\u000e{g\u000e^3yi\"9\u0011q\u0013\u0001\u0005B\u0005e\u0015\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005\u0015\u00151\u0014\u0005\t\u0003\u001b\u000b)\n1\u0001\u0002\u0010\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0016\u0001B2paf$\u0002\"!\"\u0002$\u0006\u001d\u00161\u0016\u0005\t\u0003K\u000bi\n1\u0001\u00026\u00051aM]8n\u0013\u0012D\u0001\"!+\u0002\u001e\u0002\u0007\u0011QG\u0001\u0005i>LE\r\u0003\u0005\u0002\u000e\u0006u\u0005\u0019AAH\u0011\u001d\ty\u000b\u0001C\u0005\u0003c\u000b\u0011C]3qY\u0006\u001cWMU3gKJ,gnY3t)\u0011\t))a-\t\u0011\u0005U\u0016Q\u0016a\u0001\u0003o\u000b!B]3gKJ,gnY3t!!\t9$!/\u00026\u0005u\u0016\u0002BA^\u0003\u0007\u00121!T1q!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb;\u0006\u0019Q\u000fZ7\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007bBAf\u0001\u0011%\u0011QZ\u0001\rm\u0006d\u0017\u000eZ1uK\u000e{\u0007/\u001f\u000b\t\u0003\u000b\u000by-!5\u0002T\"A\u0011QUAe\u0001\u0004\t)\u0004\u0003\u0005\u0002*\u0006%\u0007\u0019AA\u001b\u0011!\ti)!3A\u0002\u0005=\u0005bBAl\u0001\u0011%\u0011\u0011\\\u0001\te\u0016t\u0017-\\3DSRA\u0011QQAn\u0003?\f\t\u000f\u0003\u0005\u0002^\u0006U\u0007\u0019AA_\u0003\t\u0019\u0017\u000e\u0003\u0005\u0002&\u0006U\u0007\u0019AA\u001b\u0011!\tI+!6A\u0002\u0005U\u0002bBAs\u0001\u0011%\u0011q]\u0001\u000bm\u0006d\u0017\u000eZ1uK\u000eKG\u0003CAC\u0003S\fY/!<\t\u0011\u0005\u0015\u00161\u001da\u0001\u0003kA\u0001\"!+\u0002d\u0002\u0007\u0011Q\u0007\u0005\t\u0003;\f\u0019\u000f1\u0001\u0002>\u0002")
public class CopyCommand
extends InsertCommand {
    private final ArtifactRepository artifactRepository;
    private final ArtifactDataRepository artifactDataRepository;
    private final CiReader ciReader;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> copyCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public Iterable<Tuple<String, String>> copyCis() {
        return this.copyCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.copy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateCopy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void copy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        Buffer tuples = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache(package$.MODULE$.asCiPKType(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            String copiedId = ci.getId();
            this.renameCi(ci, fromId, toId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)copiedId), (Object)ci);
        }, Buffer$.MODULE$.canBuildFrom());
        this.replaceReferences((scala.collection.immutable.Map<String, ConfigurationItem>)tuples.toMap(Predef$.MODULE$.$conforms()));
        this.insertCis((Iterable<ConfigurationItem>)((Iterable)tuples.map((Function1 & Serializable & scala.Serializable)x$1 -> (ConfigurationItem)x$1._2(), Buffer$.MODULE$.canBuildFrom())), context, (Function2<Integer, ConfigurationItem, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(ciPk, copiedCi) -> {
            CopyCommand.$anonfun$copy$4(this, fromId, toId, ciPk, copiedCi);
            return BoxedUnit.UNIT;
        });
        EventBusHolder.publish((Object)new CiCopiedEvent(ci, toId));
    }

    private void replaceReferences(scala.collection.immutable.Map<String, ConfigurationItem> references) {
        references.values().foreach((Function1 & Serializable & scala.Serializable)newCi -> {
            CopyCommand.$anonfun$replaceReferences$1(references, newCi);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCopy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        this.insertCisValidation((Iterable<ConfigurationItem>)((Iterable)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache(package$.MODULE$.asCiPKType(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            this.renameCi(ci, fromId, toId);
            return ci;
        }, Buffer$.MODULE$.canBuildFrom())), context);
    }

    private void renameCi(ConfigurationItem ci, String fromId, String toId) {
        String newId = toId + ci.getId().substring(fromId.length());
        ci.setId(newId);
    }

    private void validateCi(String fromId, String toId, ConfigurationItem ci) {
        Type type = ci.getType();
        Type type2 = Type.valueOf(Root.class);
        Checks.checkArgument(((type == null ? type2 != null : !type.equals(type2)) ? 1 : 0) != 0, (String)"Cannot copy root node [%s].", (Object[])new Object[]{toId});
        this.commandValidator.checkCopyAllowed(this.ciReader.readByPath((String)package$.MODULE$.parentPath(fromId).get(), 0).getType(), this.ciReader.readByPath((String)package$.MODULE$.parentPath(toId).get(), 0).getType());
        if (this.exists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
    }

    public static final /* synthetic */ void $anonfun$copy$4(CopyCommand $this, String fromId$1, String toId$1, Integer ciPk, ConfigurationItem copiedCi) {
        ConfigurationItem configurationItem = copiedCi;
        if (configurationItem instanceof SourceArtifact) {
            SourceArtifact sourceArtifact = (SourceArtifact)configurationItem;
            String fromCiId = fromId$1 + sourceArtifact.getId().substring(toId$1.length());
            $this.artifactDataRepository.copy(fromCiId, ciPk);
            $this.artifactRepository.updateFilename(ciPk, $this.artifactRepository.getFilename(fromCiId));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceCiReference$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        Object object = pd$1.get(newCi$1);
        if (object instanceof ConfigurationItem) {
            ConfigurationItem configurationItem = (ConfigurationItem)object;
            pd$1.set(newCi$1, references$1.getOrElse((Object)configurationItem.getId(), (Function0 & Serializable & scala.Serializable)() -> configurationItem));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceListReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        ListIterator itr = ((java.util.List)pd$1.get(newCi$1)).listIterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                itr.set(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$5(HashSet toAdd$1, Iterator itr$2, ConfigurationItem ci) {
        toAdd$1.add(ci);
        itr$2.remove();
    }

    private static final void replaceSetReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        HashSet toAdd = new HashSet();
        Set set = (Set)pd$1.get(newCi$1);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)ci -> {
                CopyCommand.$anonfun$replaceReferences$5(toAdd, itr, ci);
                return BoxedUnit.UNIT;
            });
        }
        set.addAll(toAdd);
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$2(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd) {
        PropertyKind propertyKind = pd.getKind();
        if (PropertyKind.CI.equals(propertyKind)) {
            CopyCommand.replaceCiReference$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.LIST_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceListReferences$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.SET_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceSetReferences$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi) {
        ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(newCi.getType().getDescriptor().getPropertyDescriptors()).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            CopyCommand.$anonfun$replaceReferences$2(references$1, newCi, pd);
            return BoxedUnit.UNIT;
        });
    }

    public CopyCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, ArtifactDataRepository artifactDataRepository, CiHistoryRepository ciHistoryRepository, PasswordEncrypter passwordEncrypter, LicenseCiCounter licenseCiCounter, CiReader ciReader, Function2<Type, Integer, List<TypeSpecificInserter>> createTypeSpecificInserters, CommandValidator commandValidator, Iterable<Tuple<String, String>> copyCis, SqlDialect sqlDialect) {
        this.artifactRepository = artifactRepository;
        this.artifactDataRepository = artifactDataRepository;
        this.ciReader = ciReader;
        this.commandValidator = commandValidator;
        this.copyCis = copyCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository, artifactDataRepository, ciHistoryRepository, passwordEncrypter, licenseCiCounter, createTypeSpecificInserters);
    }
}

