/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import org.apache.jackrabbit.core.query.lucene.TransformConstants;

final class OffsetCharSequence
implements CharSequence,
Comparable<OffsetCharSequence>,
TransformConstants {
    private final int transform;
    private final int offset;
    private CharSequence base;

    OffsetCharSequence(int offset, CharSequence base, int transform) {
        this.offset = offset;
        this.base = base;
        this.transform = transform;
    }

    OffsetCharSequence(int offset, CharSequence base) {
        this(offset, base, 0);
    }

    public void setBase(CharSequence base) {
        this.base = base;
    }

    @Override
    public int length() {
        return this.base.length() - this.offset;
    }

    @Override
    public char charAt(int index) {
        if (this.transform == 0) {
            return this.base.charAt(index + this.offset);
        }
        if (this.transform == 1) {
            return Character.toLowerCase(this.base.charAt(index + this.offset));
        }
        if (this.transform == 2) {
            return Character.toUpperCase(this.base.charAt(index + this.offset));
        }
        return this.base.charAt(index + this.offset);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        CharSequence seq = this.base.subSequence(start + this.offset, end + this.offset);
        if (this.transform != 0) {
            seq = new OffsetCharSequence(0, seq, this.transform);
        }
        return seq;
    }

    @Override
    public String toString() {
        if (this.transform == 0) {
            return this.base.subSequence(this.offset, this.base.length()).toString();
        }
        int len = this.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buf.append(this.charAt(i));
        }
        return buf.toString();
    }

    @Override
    public int compareTo(OffsetCharSequence other) {
        int len1 = this.length();
        int len2 = other.length();
        int lim = Math.min(len1, len2);
        for (int i = 0; i < lim; ++i) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 == (c2 = other.charAt(i))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

