/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.Configuration;
import io.aeron.driver.buffer.MappedRawLog;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;

public class RawLogFactory {
    private static final String PUBLICATIONS = "publications";
    private static final String IMAGES = "images";
    private final int filePageSize;
    private final boolean checkStorage;
    private final ErrorHandler errorHandler;
    private final File publicationsDir;
    private final File imagesDir;
    private final FileStore fileStore;

    public RawLogFactory(String dataDirectoryName, int filePageSize, boolean checkStorage, ErrorHandler errorHandler) {
        this.filePageSize = filePageSize;
        this.checkStorage = checkStorage;
        this.errorHandler = errorHandler;
        File dataDir = new File(dataDirectoryName);
        this.publicationsDir = new File(dataDir, PUBLICATIONS);
        this.imagesDir = new File(dataDir, IMAGES);
        IoUtil.ensureDirectoryExists((File)this.publicationsDir, (String)PUBLICATIONS);
        IoUtil.ensureDirectoryExists((File)this.imagesDir, (String)IMAGES);
        FileStore fs = null;
        try {
            if (checkStorage) {
                fs = Files.getFileStore(dataDir.toPath());
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        this.fileStore = fs;
    }

    public RawLog newNetworkPublication(String channel, int sessionId, int streamId, long correlationId, int termBufferLength, boolean useSparseFiles) {
        return this.newInstance(this.publicationsDir, channel, sessionId, streamId, correlationId, termBufferLength, useSparseFiles);
    }

    public RawLog newNetworkedImage(String channel, int sessionId, int streamId, long correlationId, int termBufferLength, boolean useSparseFiles) {
        return this.newInstance(this.imagesDir, channel, sessionId, streamId, correlationId, termBufferLength, useSparseFiles);
    }

    public RawLog newIpcPublication(int sessionId, int streamId, long correlationId, int termBufferLength, boolean useSparseFiles) {
        return this.newInstance(this.publicationsDir, "ipc", sessionId, streamId, correlationId, termBufferLength, useSparseFiles);
    }

    private RawLog newInstance(File rootDir, String channel, int sessionId, int streamId, long correlationId, int termBufferLength, boolean useSparseFiles) {
        this.validateTermBufferLength(termBufferLength);
        if (this.checkStorage) {
            this.checkStorage(termBufferLength);
        }
        File location = RawLogFactory.streamLocation(rootDir, channel, sessionId, streamId, correlationId);
        return new MappedRawLog(location, useSparseFiles, termBufferLength, this.filePageSize, this.errorHandler);
    }

    private void checkStorage(int termBufferLength) {
        long usableSpace = this.getUsableSpace();
        long logLength = LogBufferDescriptor.computeLogLength((int)termBufferLength, (int)this.filePageSize);
        if (usableSpace <= Configuration.LOW_FILE_STORE_WARNING_THRESHOLD) {
            System.out.format("Warning: space is running low in %s threshold=%,d usable=%,d%n", this.fileStore, Configuration.LOW_FILE_STORE_WARNING_THRESHOLD, usableSpace);
        }
        if (usableSpace < logLength) {
            throw new IllegalStateException("Insufficient usable storage for new log of length=" + logLength + " in " + this.fileStore);
        }
    }

    private long getUsableSpace() {
        long usableSpace = 0L;
        try {
            usableSpace = this.fileStore.getUsableSpace();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return usableSpace;
    }

    private void validateTermBufferLength(int termBufferLength) {
        if (termBufferLength < 0 || termBufferLength > 0x40000000) {
            throw new IllegalArgumentException("invalid buffer length: " + termBufferLength + " max is " + 0x40000000);
        }
    }

    private static File streamLocation(File rootDir, String channel, int sessionId, int streamId, long correlationId) {
        String fileName = channel + '-' + Integer.toHexString(sessionId) + '-' + Integer.toHexString(streamId) + '-' + Long.toHexString(correlationId) + ".logbuffer";
        return new File(rootDir, fileName);
    }
}

