/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.SecuredCi;
import com.xebialabs.deployit.repository.sql.base.SecuredCiQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.CiPathValidation;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\t\u0012\u0001yA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t%\f\u0005\tu\u0001\u0011\t\u0011)A\u0005]!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011!\u0004!Q1A\u0005\u0004%D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\tYQj\u001c<f\u0007>lW.\u00198e\u0015\t\u00112#\u0001\u0005d_6l\u0017M\u001c3t\u0015\t!R#A\u0002tc2T!AF\f\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u00193\u0005AA-\u001a9m_fLGO\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M!\u0001aH\u0012'!\t\u0001\u0013%D\u0001\u0012\u0013\t\u0011\u0013CA\tVa\u0012\fG/\u001a)bi\"\u001cu.\\7b]\u0012\u0004\"\u0001\t\u0013\n\u0005\u0015\n\"\u0001E\"j!\u0006$\bNV1mS\u0012\fG/[8o!\t9#&D\u0001)\u0015\tI3#\u0001\u0003cCN,\u0017BA\u0016)\u0005%\u0019VmY;sK\u0012\u001c\u0015.\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001/!\ty\u0003(D\u00011\u0015\t\t$'\u0001\u0003d_J,'BA\u001a5\u0003\u0011QGMY2\u000b\u0005U2\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003]\n1a\u001c:h\u0013\tI\u0004G\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\u0017CJ$\u0018NZ1di\u0012\u000bG/\u0019*fa>\u001c\u0018\u000e^8ssB\u0011Q\bQ\u0007\u0002})\u0011qhE\u0001\nCJ$\u0018NZ1diNL!!\u0011 \u0003-\u0005\u0013H/\u001b4bGR$\u0015\r^1SKB|7/\u001b;pef\f\u0001cY8n[\u0006tGMV1mS\u0012\fGo\u001c:\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019+\u0012A\u0003<bY&$\u0017\r^5p]&\u0011\u0001*\u0012\u0002\u0011\u0007>lW.\u00198e-\u0006d\u0017\u000eZ1u_J\fq!\\8wK\u000eK7/F\u0001L!\rae+\u0017\b\u0003\u001bNs!AT)\u000e\u0003=S!\u0001U\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+V\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AU\u0005\u0003/b\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003)V\u0003BAW/`?6\t1L\u0003\u0002]/\u0005!Q\u000f^5m\u0013\tq6LA\u0003UkBdW\r\u0005\u0002aI:\u0011\u0011M\u0019\t\u0003\u001dVK!aY+\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GV\u000b\u0001\"\\8wK\u000eK7\u000fI\u0001\u000bgFdG)[1mK\u000e$X#\u00016\u0011\u0005-tW\"\u00017\u000b\u0005Qi'BA\u0019\u0018\u0013\tyGN\u0001\u0006Tc2$\u0015.\u00197fGR\f1b]9m\t&\fG.Z2uA\u00051A(\u001b8jiz\"Ra\u001d<xqf$\"\u0001^;\u0011\u0005\u0001\u0002\u0001\"\u00025\n\u0001\bQ\u0007\"\u0002\u0017\n\u0001\u0004q\u0003\"B\u001e\n\u0001\u0004a\u0004\"\u0002\"\n\u0001\u0004\u0019\u0005\"B%\n\u0001\u0004Y\u0015aB3yK\u000e,H/\u001a\u000b\u0004y\u0006\u0005\u0001CA?\u007f\u001b\u0005)\u0016BA@V\u0005\u0011)f.\u001b;\t\u000f\u0005\r!\u00021\u0001\u0002\u0006\u000591m\u001c8uKb$\bc\u0001\u0011\u0002\b%\u0019\u0011\u0011B\t\u0003!\rC\u0017M\\4f'\u0016$8i\u001c8uKb$\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\u0007q\fy\u0001C\u0004\u0002\u0004-\u0001\r!!\u0002\u0002\t5|g/\u001a\u000b\by\u0006U\u0011\u0011DA\u000f\u0011\u0019\t9\u0002\u0004a\u0001?\u0006)q\u000e\u001c3JI\"1\u00111\u0004\u0007A\u0002}\u000bQA\\3x\u0013\u0012Dq!a\u0001\r\u0001\u0004\t)!A\nrk\u0016\u0014\u00180\u00118e!J,g+\u00197jI\u0006$X\r\u0006\u0005\u0002$\u0005\r\u0013QIA$!\u0019i\u0018QE0\u0002*%\u0019\u0011qE+\u0003\rQ+\b\u000f\\33!\u001d\tY#a\r`\u0003oi!!!\f\u000b\u0007q\u000byC\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\u0011\t)$!\f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\u0011\ti$a\f\u0002\t1\fgnZ\u0005\u0005\u0003\u0003\nYD\u0001\u0004PE*,7\r\u001e\u0005\u0007\u0003/i\u0001\u0019A0\t\r\u0005mQ\u00021\u0001`\u0011\u001d\t\u0019!\u0004a\u0001\u0003\u000b\ta\"\u001e9eCR,7+Z2ve&$\u0018\u0010F\u0004}\u0003\u001b\n)(!\u001f\t\u000f\u0005=c\u00021\u0001\u0002R\u0005\u0011\u0001o\u001b\t\u0005\u0003'\nyG\u0004\u0003\u0002V\u00055d\u0002BA,\u0003WrA!!\u0017\u0002j9!\u00111LA4\u001d\u0011\ti&!\u001a\u000f\t\u0005}\u00131\r\b\u0004\u001d\u0006\u0005\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002\u0015+%\u0011\u0011fE\u0005\u0003)\"JA!!\u001d\u0002t\tA1)\u001b)L)f\u0004XM\u0003\u0002UQ!9\u0011q\u000f\bA\u0002\u0005E\u0013\u0001\u00039be\u0016tG\u000fU6\t\r\u0005md\u00021\u0001`\u0003\u001dqWm\u001e)bi\"\fAB^1mS\u0012\fG/Z'pm\u0016$r\u0001`AA\u0003\u0007\u000b)\t\u0003\u0004\u0002\u0018=\u0001\ra\u0018\u0005\u0007\u00037y\u0001\u0019A0\t\u000f\u0005\rq\u00021\u0001\u0002\u0006\u0001")
public class MoveCommand
extends UpdatePathCommand
implements CiPathValidation,
SecuredCi {
    private final JdbcTemplate jdbcTemplate;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> moveCis;
    private final SqlDialect sqlDialect;
    private String SELECT_SECURED_CI;
    private String UPDATE_SECURED_CI;
    private volatile byte bitmap$0;

    @Override
    public Option<Integer> getSecuredCi(Integer pk) {
        return SecuredCi.getSecuredCi$(this, pk);
    }

    @Override
    public void setSecuredCi(Integer pk, Integer securedCi) {
        SecuredCi.setSecuredCi$(this, pk, securedCi);
    }

    @Override
    public void validateCiStoredInCorrectPath(String id, Type ciType, ChangeSetContext context) {
        CiPathValidation.validateCiStoredInCorrectPath$(this, id, ciType, context);
    }

    private String SELECT_SECURED_CI$lzycompute() {
        MoveCommand moveCommand = this;
        synchronized (moveCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.SELECT_SECURED_CI = SecuredCiQueries.SELECT_SECURED_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.SELECT_SECURED_CI;
    }

    @Override
    public String SELECT_SECURED_CI() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.SELECT_SECURED_CI$lzycompute() : this.SELECT_SECURED_CI;
    }

    private String UPDATE_SECURED_CI$lzycompute() {
        MoveCommand moveCommand = this;
        synchronized (moveCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.UPDATE_SECURED_CI = SecuredCiQueries.UPDATE_SECURED_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.UPDATE_SECURED_CI;
    }

    @Override
    public String UPDATE_SECURED_CI() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.UPDATE_SECURED_CI$lzycompute() : this.UPDATE_SECURED_CI;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> moveCis() {
        return this.moveCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.move((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateMove((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void move(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        String newPath = package$.MODULE$.idToPath(newId);
        Integer parentPk = this.updateNameAndPath(oldPath, newPath);
        this.updateSecurity(package$.MODULE$.asCiPKType(map3.get(CIS$.MODULE$.ID().name())), parentPk, newPath);
        EventBusHolder.publish((Object)new CiMovedEvent(package$.MODULE$.readBaseCiFromMap(map3), newId));
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newId, ChangeSetContext context) {
        String string = oldId;
        String string2 = newId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        this.commandValidator.checkMoveAllowed(ciType);
        this.validateCiStoredInCorrectPath(newId, ciType, context);
        return new Tuple2((Object)oldPath, (Object)map);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSecurity(Integer pk, Integer parentPk, String newPath) {
        boolean bl = false;
        Some some = null;
        Option<Integer> option = this.getSecuredCi(pk);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Integer n = (Integer)some.value();
            Integer n2 = pk;
            Integer n3 = n;
            if (!(n2 != null ? !((Object)n2).equals(n3) : n3 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Integer securedPk = (Integer)some.value();
        Option<Integer> option2 = this.getSecuredCi(parentPk);
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            Integer newSecuredPk = (Integer)some2.value();
            this.jdbcTemplate().update(this.UPDATE_SECURED_ID(), new Object[]{newSecuredPk, newPath, new StringBuilder(2).append(newPath).append("/%").toString(), securedPk});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            this.jdbcTemplate().update(this.UPDATE_SECURED_ID(), new Object[]{null, newPath, new StringBuilder(2).append(newPath).append("/%").toString(), securedPk});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void validateMove(String oldId, String newId, ChangeSetContext context) {
        this.queryAndPreValidate(oldId, newId, context);
        if (this.exists(newId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{newId});
        }
    }

    public MoveCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactDataRepository, CommandValidator commandValidator, Iterable<Tuple<String, String>> moveCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.commandValidator = commandValidator;
        this.moveCis = moveCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactDataRepository);
        CiPathValidation.$init$(this);
        SecuredCiQueries.$init$(this);
        SecuredCi.$init$(this);
    }
}

