/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.os.ErrorHandler;
import org.rzo.yajsw.os.FileManager;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.Keyboard;
import org.rzo.yajsw.os.Mouse;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.ProcessManager;
import org.rzo.yajsw.os.ServiceManager;
import org.rzo.yajsw.os.SystemInformation;
import org.rzo.yajsw.os.ms.win.w32.WindowsJavaHome;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPErrorHandler;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPFileManager;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPKeyboard;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPMouse;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcess;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcessManager;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPService;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPServiceManager;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPSystemInformation;

public class OperatingSystemWindowsXP
extends OperatingSystem {
    static Keyboard _keyboardInstance;
    static Mouse _mouseInstance;
    static ProcessManager _processManager;
    static FileManager _fileManager;
    static ServiceManager _serviceManager;
    static ErrorHandler _errorHandler;
    static SystemInformation _systemInformation;

    @Override
    public Keyboard keyboardInstance() {
        if (_keyboardInstance == null) {
            _keyboardInstance = WindowsXPKeyboard.instance();
        }
        return _keyboardInstance;
    }

    @Override
    public Mouse mouseInstance() {
        if (_mouseInstance == null) {
            _mouseInstance = WindowsXPMouse.instance();
        }
        return _mouseInstance;
    }

    @Override
    public ProcessManager processManagerInstance() {
        if (_processManager == null) {
            _processManager = WindowsXPProcessManager.instance();
        }
        return _processManager;
    }

    @Override
    public FileManager fileManagerInstance() {
        if (_fileManager == null) {
            _fileManager = WindowsXPFileManager.instance();
        }
        return _fileManager;
    }

    @Override
    public ErrorHandler errorHandlerInstance() {
        return _errorHandler;
    }

    @Override
    public JavaHome getJavaHome(Configuration config) {
        return new WindowsJavaHome(config);
    }

    @Override
    public ServiceManager serviceManagerInstance() {
        if (_serviceManager == null) {
            _serviceManager = WindowsXPServiceManager.instance();
        }
        return _serviceManager;
    }

    @Override
    public SystemInformation systemInformation() {
        return _systemInformation;
    }

    @Override
    public boolean setWorkingDir(String name) {
        return new WindowsXPProcess().changeWorkingDir(name);
    }

    @Override
    public Object getServiceFailureActions(Configuration config) {
        return WindowsXPService.getServiceFailureActions(config);
    }

    @Override
    public long getUptime() {
        return new WindowsXPProcess().getUptime();
    }

    @Override
    public void reboot() {
        try {
            new WindowsXPProcess().reboot();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        _errorHandler = new WindowsXPErrorHandler();
        _systemInformation = new WindowsXPSystemInformation();
    }
}

