/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.UnknownRevisionException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository$;
import com.xebialabs.deployit.repository.sql.HistoryQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

@Repository
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tu\u0001\u0011\t\u0011)A\u0005]!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003>\u0011!A\u0005A!b\u0001\n\u0007I\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bE\u0003A\u0011\u0001*\t\u000bI\u0004A\u0011A:\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013<qAa\u0003\u0017\u0011\u0003\u0011iA\u0002\u0004\u0016-!\u0005!q\u0002\u0005\u0007#>!\tA!\u0005\t\u000f\tMq\u0002\"\u0001\u0003\u0016!I!1D\bC\u0002\u0013\u0015!Q\u0004\u0005\t\u0005[y\u0001\u0015!\u0004\u0003 !9!qF\b\u0005\u0002\tE\"aE\"j\u0011&\u001cHo\u001c:z%\u0016\u0004xn]5u_JL(BA\f\u0019\u0003\r\u0019\u0018\u000f\u001c\u0006\u00033i\t!B]3q_NLGo\u001c:z\u0015\tYB$\u0001\u0005eKBdw._5u\u0015\tib$A\u0005yK\nL\u0017\r\\1cg*\tq$A\u0002d_6\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015+\u001b\u00051\u0012BA\u0016\u0017\u00059A\u0015n\u001d;pef\fV/\u001a:jKN\fAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012A\f\t\u0003_aj\u0011\u0001\r\u0006\u0003cI\nAaY8sK*\u00111\u0007N\u0001\u0005U\u0012\u00147M\u0003\u00026m\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00018\u0003\ry'oZ\u0005\u0003sA\u0012AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013AB7baB,'/F\u0001>!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005eCR\f'-\u001b8e\u0015\t\u00115)A\u0004kC\u000e\\7o\u001c8\u000b\u0005\u0011s\u0012!\u00034bgR,'\u000f_7m\u0013\t1uH\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001K!\tYe*D\u0001M\u0015\t9RJ\u0003\u000225%\u0011q\n\u0014\u0002\u000b'FdG)[1mK\u000e$\u0018aC:rY\u0012K\u0017\r\\3di\u0002\na\u0001P5oSRtDcA*i[R\u0011A+\u0016\t\u0003S\u0001AQ\u0001S\u0004A\u0004)CC!V,bEB\u0011\u0001lX\u0007\u00023*\u0011!lW\u0001\u000bC:tw\u000e^1uS>t'B\u0001/^\u0003\u001d1\u0017m\u0019;pefT!A\u0018\u001b\u0002\u000b\t,\u0017M\\:\n\u0005\u0001L&!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005\u0019\u0017AD7bS:\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0015\u0003+\u0016\u0004\"\u0001\u00174\n\u0005\u001dL&!C!vi><\u0018N]3e\u0011\u0015as\u00011\u0001/Q\u0011Aw+\u00196\"\u0003-\f\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3)\u0005!,\u0007\"B\u001e\b\u0001\u0004i\u0004\u0006B7XC>\f\u0013\u0001]\u0001\u000eQ&\u001cHo\u001c:z\u001b\u0006\u0004\b/\u001a:)\u00055,\u0017aE4fiZ+'o]5p]J+g/[:j_:\u001cHc\u0001;\u0002\u0002A\u0019QO\u001f?\u000e\u0003YT!a\u001e=\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0003MSN$\bCA?\u007f\u001b\u0005A\u0012BA@\u0019\u0005e\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c*fm&\u001c\u0018n\u001c8\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006\u0005\u0011\u0011\u000e\u001a\t\u0005\u0003\u000f\t)B\u0004\u0003\u0002\n\u0005E\u0001cAA\u0006I5\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0001\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0014\u0011\na\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u0011aa\u0015;sS:<'bAA\nI\u0005\tb-\u001a;dQJ+g/[:j_:$\u0015\r^1\u0015\t\u0005}\u0011Q\f\t\u0005kj\f\t\u0003E\u0006$\u0003G\t9#!\f\u0002X\u0005\u0015\u0011bAA\u0013I\t1A+\u001e9mKR\u00022aIA\u0015\u0013\r\tY\u0003\n\u0002\u0004\u0013:$\b\u0003BA\u0018\u0003#rA!!\r\u0002L9!\u00111GA$\u001d\u0011\t)$!\u0012\u000f\t\u0005]\u00121\t\b\u0005\u0003s\t\tE\u0004\u0003\u0002<\u0005}b\u0002BA\u0006\u0003{I\u0011aH\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012BA\f\u0019\u0013\r\tIEF\u0001\u0005E\u0006\u001cX-\u0003\u0003\u0002N\u0005=\u0013a\u00029bG.\fw-\u001a\u0006\u0004\u0003\u00132\u0012\u0002BA*\u0003+\u0012\u0001bQ5Q\u0017RK\b/\u001a\u0006\u0005\u0003\u001b\ny\u0005E\u0002v\u00033J1!a\u0017w\u0005!\u0019\u0015\r\\3oI\u0006\u0014\bbBA\u0002\u0013\u0001\u0007\u0011QA\u0001\u0010GJ,\u0017\r^3SKZL7/[8ogR!\u00111MA5!\u0011)\u0018Q\r?\n\u0007\u0005\u001ddOA\u0005BeJ\f\u0017\u0010T5ti\"9\u00111\u000e\u0006A\u0002\u0005}\u0011!B5uK6\u001c\u0018\u0001\u0004:fC\u0012\u0014VM^5tS>tW\u0003BA9\u0003o\"b!a\u001d\u0002\u0018\u0006e\u0005\u0003BA;\u0003ob\u0001\u0001B\u0004\u0002z-\u0011\r!a\u001f\u0003\u0003Q\u000bB!! \u0002\u0004B\u00191%a \n\u0007\u0005\u0005EEA\u0004O_RD\u0017N\\4\u0011\t\u0005\u0015\u00151S\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006\u0019Q\u000fZ7\u000b\t\u00055\u0015qR\u0001\u0004CBL'bAAI5\u00051\u0001\u000f\\;hS:LA!!&\u0002\b\n\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\t\u000f\u0005\r1\u00021\u0001\u0002\u0006!9\u00111T\u0006A\u0002\u0005\u0015\u0011\u0001\u0004:fm&\u001c\u0018n\u001c8OC6,\u0017AB5og\u0016\u0014H\u000f\u0006\u0006\u0002\"\u0006\u001d\u00161VAX\u0003\u0007\u00042aIAR\u0013\r\t)\u000b\n\u0002\u0005+:LG\u000fC\u0004\u0002*2\u0001\r!!\f\u0002\u0005A\\\u0007bBAW\u0019\u0001\u0007\u00111Q\u0001\u0003G&Dq!!-\r\u0001\u0004\t\u0019,A\u0002o_^\u0004B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,\u0001\u0003uS6,'bAA_m\u0005!!n\u001c3b\u0013\u0011\t\t-a.\u0003\u0011\u0011\u000bG/\u001a+j[\u0016Dq!!2\r\u0001\u0004\t)!\u0001\u0005vg\u0016\u0014h*Y7f\u0003\u0019!W\r\\3uKR!\u0011\u0011UAf\u0011\u001d\tI+\u0004a\u0001\u0003[Ac\u0001AAhC\u0006u\u0007\u0003BAi\u00033l!!a5\u000b\u0007i\u000b)NC\u0002\u0002XR\n1\u0002\u001e:b]N\f7\r^5p]&!\u00111\\Aj\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0012\u0011q\\\u0001\u0017[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\":\u0001!a9\u0002r\u0006M\b\u0003BAs\u0003[l!!a:\u000b\u0007i\u000bIOC\u0002\u0002lR\nqaY8oi\u0016DH/\u0003\u0003\u0002p\u0006\u001d(!B*d_B,\u0017!\u00039s_bLXj\u001c3fI\t\t)0\u0003\u0003\u0002x\u0006e\u0018\u0001\u0004+B%\u001e+EkX\"M\u0003N\u001b&\u0002BA~\u0003O\fqbU2pa\u0016$\u0007K]8ys6{G-\u001a\u0015\u0004\u0001\u0005}\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015A'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\u0003\u0003\u0004\tQ!+\u001a9pg&$xN]=\u0002'\rK\u0007*[:u_JL(+\u001a9pg&$xN]=\u0011\u0005%z1CA\b#)\t\u0011i!A\nj]\u0012,\u0007\u0010V8SKZL7/[8o\u001d\u0006lW\r\u0006\u0003\u0002\u0006\t]\u0001b\u0002B\r#\u0001\u0007\u0011qE\u0001\u0004S\u0012D\u0018!\u00038b[\u0016\u0014VmZ3y+\t\u0011y\u0002\u0005\u0003\u0003\"\t%RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u00115\fGo\u00195j]\u001eT!a\u001e\u0013\n\t\t-\"1\u0005\u0002\u0006%\u0016<W\r_\u0001\u000b]\u0006lWMU3hKb\u0004\u0013!D:i_VdGMV3sg&|g\u000e\u0006\u0004\u00034\te\"1\b\t\u0004G\tU\u0012b\u0001B\u001cI\t9!i\\8mK\u0006t\u0007bBA\u0002)\u0001\u0007\u0011Q\u0001\u0005\b\u0005{!\u0002\u0019\u0001B \u0003\u0019\u0019\u0017\u000eV=qKB!!\u0011\tB$\u001b\t\u0011\u0019E\u0003\u0003\u0003F\u0005-\u0015a\u0002:fM2,7\r^\u0005\u0005\u0005\u0013\u0012\u0019E\u0001\u0003UsB,\u0007")
public class CiHistoryRepository
implements HistoryQueries {
    private final JdbcTemplate jdbcTemplate;
    private final ObjectMapper mapper;
    private final SqlDialect sqlDialect;
    private String INSERT;
    private String DELETE;
    private String SELECT_CI;
    private String SELECT_REVISIONS;
    private volatile byte bitmap$0;

    public static boolean shouldVersion(String string, Type type) {
        return CiHistoryRepository$.MODULE$.shouldVersion(string, type);
    }

    public static Regex nameRegex() {
        return CiHistoryRepository$.MODULE$.nameRegex();
    }

    public static String indexToRevisionName(int n) {
        return CiHistoryRepository$.MODULE$.indexToRevisionName(n);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private String INSERT$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.INSERT = HistoryQueries.INSERT$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String DELETE$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.DELETE = HistoryQueries.DELETE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String SELECT_CI$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SELECT_CI = HistoryQueries.SELECT_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SELECT_CI;
    }

    @Override
    public String SELECT_CI() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SELECT_CI$lzycompute() : this.SELECT_CI;
    }

    private String SELECT_REVISIONS$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SELECT_REVISIONS = HistoryQueries.SELECT_REVISIONS$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SELECT_REVISIONS;
    }

    @Override
    public String SELECT_REVISIONS() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SELECT_REVISIONS$lzycompute() : this.SELECT_REVISIONS;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public List<ConfigurationItemRevision> getVersionRevisions(String id) {
        return this.createRevisions(this.fetchRevisionData(id));
    }

    private List<Tuple4<Object, Integer, Calendar, String>> fetchRevisionData(String id) {
        return this.jdbcTemplate().query(this.SELECT_REVISIONS(), (rs, row) -> {
            Integer pk = package$.MODULE$.asCiPKType(BoxesRunTime.boxToInteger((int)rs.getInt(1)));
            Calendar timestamp = com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(rs.getTimestamp(2));
            String username = rs.getString(3);
            return new Tuple4((Object)BoxesRunTime.boxToInteger((int)row), (Object)pk, (Object)timestamp, (Object)username);
        }, new Object[]{package$.MODULE$.idToPath(id)});
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<ConfigurationItemRevision> createRevisions(List<Tuple4<Object, Integer, Calendar, String>> items) {
        void var3_2;
        ArrayList<ConfigurationItemRevision> result = new ArrayList<ConfigurationItemRevision>(items.size());
        Iterator<Tuple4<Object, Integer, Calendar, String>> itr = items.iterator();
        while (itr.hasNext()) {
            Tuple4<Object, Integer, Calendar, String> tuple4 = itr.next();
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            int row = BoxesRunTime.unboxToInt((Object)tuple4._1());
            Calendar timestamp = (Calendar)tuple4._3();
            String username = (String)tuple4._4();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)row), (Object)timestamp, (Object)username);
            Tuple3 tuple32 = tuple3;
            int row2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Calendar timestamp2 = (Calendar)tuple32._2();
            String username2 = (String)tuple32._3();
            result.add(itr.hasNext() ? new ConfigurationItemRevision(CiHistoryRepository$.MODULE$.indexToRevisionName(row2), timestamp2, username2) : new ConfigurationItemRevision("current", timestamp2, username2));
        }
        return var3_2;
    }

    public <T extends ConfigurationItem> T readRevision(String id, String revisionName) {
        String string = revisionName;
        Option option = CiHistoryRepository$.MODULE$.nameRegex().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw CiHistoryRepository.throwUnknownRevision$1(revisionName, id);
        }
        String res = (String)((LinearSeqOptimized)option.get()).apply(0);
        int n = new StringOps(Predef$.MODULE$.augmentString(res)).toInt();
        int idx = n;
        List<Tuple4<Object, Integer, Calendar, String>> revisions = this.fetchRevisionData(id);
        if (revisions.size() < idx) {
            throw CiHistoryRepository.throwUnknownRevision$1(revisionName, id);
        }
        Integer pk = (Integer)revisions.get(idx)._2();
        List result = this.jdbcTemplate().queryForList(this.SELECT_CI(), String.class, new Object[]{pk, package$.MODULE$.idToPath(id)});
        String ci_json = (String)result.get(0);
        return (T)((ConfigurationItem)this.mapper().readValue(ci_json, ConfigurationItem.class));
    }

    public void insert(Integer pk, ConfigurationItem ci, DateTime now, String userName) {
        block0: {
            if (!CiHistoryRepository$.MODULE$.shouldVersion(ci.getId(), ci.getType())) break block0;
            this.jdbcTemplate().update(this.INSERT(), new Object[]{pk, com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(now), Option$.MODULE$.apply((Object)userName).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<system>"), this.mapper().writerFor(ConfigurationItem.class).writeValueAsString((Object)ci)});
        }
    }

    public void delete(Integer pk) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{pk});
    }

    private static final Nothing$ throwUnknownRevision$1(String revisionName$1, String id$1) {
        throw new UnknownRevisionException("Cannot find revision [%s] for configuration item [%s]", new Object[]{revisionName$1, id$1});
    }

    public CiHistoryRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="historyMapper") ObjectMapper mapper, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.mapper = mapper;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        HistoryQueries.$init$(this);
    }
}

