/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.session;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.ahessian.session.Session;
import org.rzo.netty.ahessian.session.SessionFactory;

@ChannelHandler.Sharable
public class ClientSessionFilter
extends ChannelInboundHandlerAdapter {
    private Session _session = null;
    private boolean _hasSession = false;
    private String _sessionId = "";
    private SessionFactory _factory = new SessionFactory();
    private ChannelPipelineFactory _mixinFactory;
    private static Map<String, ChannelPipelineFactory.HandlerList> _sessionPipelines = Collections.synchronizedMap(new HashMap());
    private List<Runnable> _sessionClosedListeners = Collections.synchronizedList(new ArrayList());
    private List<Runnable> _sessionNewListeners = Collections.synchronizedList(new ArrayList());
    private static AttributeKey SESSION = AttributeKey.valueOf((String)"SESSION");

    public ClientSessionFilter(ChannelPipelineFactory mixinFactory) {
        this._mixinFactory = mixinFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String id = this._session == null ? "?" : this._session.getId();
        ctx.writeAndFlush((Object)ctx.alloc().buffer().writeBytes(id.getBytes()));
    }

    public void messageReceived(ChannelHandlerContext ctx, Object e) throws Exception {
        if (this._hasSession) {
            ctx.fireChannelRead(e);
        } else {
            ByteBuf b = (ByteBuf)e;
            this._sessionId = this._sessionId + b.toString(Charset.forName("UTF-8"));
            this.checkSession(ctx);
        }
    }

    private void checkSession(ChannelHandlerContext ctx) {
        if (this._sessionId.length() == this._factory.getSessionIdLength() * 2) {
            if (this._session == null) {
                this.newSession(ctx);
            } else if (this._session.getId().equals(this._sessionId)) {
                this.confirmSession(ctx);
            } else {
                this.changedSession(ctx);
            }
        }
    }

    private void changedSession(ChannelHandlerContext ctx) {
        this.closeSession(this._session);
        this.newSession(ctx);
    }

    private void closeSession(Session session) {
        for (Runnable listener : this._sessionClosedListeners) {
            try {
                listener.run();
            }
            catch (Throwable e) {
                Constants.ahessianLogger.warn("", e);
            }
        }
        ChannelPipelineFactory.HandlerList p = _sessionPipelines.remove(session.getId());
    }

    private void confirmSession(ChannelHandlerContext ctx) {
        ChannelPipelineFactory.HandlerList pipeline = _sessionPipelines.get(this._session.getId());
        this.handleSession(ctx, pipeline);
    }

    private void newSession(ChannelHandlerContext ctx) {
        this._session = this._factory.createSession(this._sessionId);
        ChannelPipelineFactory.HandlerList pipeline = null;
        try {
            pipeline = this._mixinFactory.getPipeline();
            _sessionPipelines.put(this._session.getId(), pipeline);
        }
        catch (Exception e) {
            Constants.ahessianLogger.warn("", (Throwable)e);
        }
        this.handleSession(ctx, pipeline);
        for (Runnable listener : this._sessionNewListeners) {
            try {
                listener.run();
            }
            catch (Throwable ex) {
                Constants.ahessianLogger.warn("", ex);
            }
        }
    }

    private void handleSession(ChannelHandlerContext ctx, ChannelPipelineFactory.HandlerList pipeline) {
        this._hasSession = true;
        pipeline.mixin(ctx);
        ctx.channel().attr(SESSION).set((Object)this._session);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this._hasSession = false;
        this._sessionId = "";
        ctx.fireChannelInactive();
    }

    public void addSessionClosedListener(Runnable listener) {
        this._sessionClosedListeners.add(listener);
    }

    public void removeSessionClosedListener(Runnable listener) {
        this._sessionClosedListeners.remove(listener);
    }

    public void addSessionNewListener(Runnable listener) {
        this._sessionNewListeners.add(listener);
    }
}

