/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.DebugChannelEndpointConfiguration;
import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class DebugReceiveChannelEndpoint
extends ReceiveChannelEndpoint {
    private final LossGenerator dataLossGenerator;
    private final LossGenerator controlLossGenerator;
    private final UnsafeBuffer controlBuffer = new UnsafeBuffer(ByteBuffer.allocate(0));

    public DebugReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dispatcher, AtomicCounter statusIndicator, MediaDriver.Context context) {
        this(udpChannel, dispatcher, statusIndicator, context, DebugChannelEndpointConfiguration.receiveDataLossGeneratorSupplier(), DebugChannelEndpointConfiguration.receiveControlLossGeneratorSupplier());
    }

    public DebugReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dispatcher, AtomicCounter statusIndicator, MediaDriver.Context context, LossGenerator dataLossGenerator, LossGenerator controlLossGenerator) {
        super(udpChannel, dispatcher, statusIndicator, context);
        this.dataLossGenerator = dataLossGenerator;
        this.controlLossGenerator = controlLossGenerator;
    }

    @Override
    public int sendTo(ByteBuffer buffer, InetSocketAddress remoteAddress) {
        int result = buffer.remaining();
        this.controlBuffer.wrap(buffer, buffer.position(), buffer.remaining());
        if (!this.controlLossGenerator.shouldDropFrame(remoteAddress, this.controlBuffer, buffer.remaining())) {
            result = super.sendTo(buffer, remoteAddress);
        }
        return result;
    }

    @Override
    public int onDataPacket(DataHeaderFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        int result = 0;
        if (!this.dataLossGenerator.shouldDropFrame(srcAddress, buffer, length)) {
            result = super.onDataPacket(header, buffer, length, srcAddress);
        }
        return result;
    }

    @Override
    public void onSetupMessage(SetupFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        if (!this.dataLossGenerator.shouldDropFrame(srcAddress, buffer, header.frameLength())) {
            super.onSetupMessage(header, buffer, length, srcAddress);
        }
    }

    @Override
    public void onRttMeasurement(RttMeasurementFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        if (!this.dataLossGenerator.shouldDropFrame(srcAddress, buffer, header.frameLength())) {
            super.onRttMeasurement(header, buffer, length, srcAddress);
        }
    }
}

