/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache;
import akka.io.SimpleDnsCache$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import akka.io.dns.internal.DnsClient;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001-\u0011Q\"Q:z]\u000e$en]\"bG\",'BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\r!gn\u001d\u0006\u0003\u000f!\t!![8\u000b\u0003%\tA!Y6lC\u000e\u00011c\u0001\u0001\r!A\u0011QBD\u0007\u0002\r%\u0011qB\u0002\u0002\u0004\t:\u001c\bCA\u0007\u0012\u0013\t\u0011bA\u0001\u000bQKJLw\u000eZ5d\u0007\u0006\u001c\u0007.Z\"mK\u0006tW\u000f\u001d\u0005\u0006)\u0001!\t!F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003\tAq!\u0007\u0001C\u0002\u0013%!$A\u0003dC\u000eDW-F\u0001\u001c!\raReJ\u0007\u0002;)\u0011adH\u0001\u0007CR|W.[2\u000b\u0005\u0001\n\u0013AC2p]\u000e,(O]3oi*\u0011!eI\u0001\u0005kRLGNC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019j\"aD!u_6L7MU3gKJ,gnY3\u0011\t!\u0012TG\u0014\b\u0003SAr!AK\u0018\u000f\u0005-rS\"\u0001\u0017\u000b\u00055R\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u00022\r\u0005q1+[7qY\u0016$en]\"bG\",\u0017BA\u001a5\u0005\u0015\u0019\u0015m\u00195f\u0015\t\td\u0001\u0005\u00037sm\u001aU\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\rQ+\b\u000f\\33!\ta\u0004I\u0004\u0002>}A\u00111fN\u0005\u0003\u007f]\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qh\u000e\t\u0003\t.s!!R%\u000f\u0005\u0019CeBA\u0015H\u0013\t)a!\u0003\u0002\u0004\t%\u0011!JA\u0001\u0011\u0003NLhn\u0019#ogJ+7o\u001c7wKJL!\u0001T'\u0003\u0013E+XM]=UsB,'B\u0001&\u0003!\ty%K\u0004\u0002F!&\u0011\u0011KA\u0001\n\t:\u001c8\t\\5f]RL!a\u0015+\u0003\r\u0005s7o^3s\u0015\t\t&\u0001\u0003\u0004W\u0001\u0001\u0006IaG\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u000fa\u0003!\u0019!C\u00053\u0006Aa.\u00198p\u0005\u0006\u001cX-F\u0001[!\t14,\u0003\u0002]o\t!Aj\u001c8h\u0011\u0019q\u0006\u0001)A\u00055\u0006Ia.\u00198p\u0005\u0006\u001cX\r\t\u0005\u0006A\u0002!\t%Y\u0001\u0007G\u0006\u001c\u0007.\u001a3\u0015\u0005\td\u0007c\u0001\u001cdK&\u0011Am\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019LgBA\u0007h\u0013\tAg!A\u0002E]NL!A[6\u0003\u0011I+7o\u001c7wK\u0012T!\u0001\u001b\u0004\t\u000b5|\u0006\u0019A\u001e\u0002\t9\fW.\u001a\u0005\u0006_\u0002!\t\u0002]\u0001\u0006G2|7m\u001b\u000b\u00025\"1!\u000f\u0001C\u0003\rM\f1aZ3u)\t!X\u000fE\u00027G:CQA^9A\u0002U\n1a[3z\u0011\u0019A\b\u0001\"\u0002\u0007s\u0006\u0019\u0001/\u001e;\u0015\u000bilh0!\u0001\u0011\u0005YZ\u0018B\u0001?8\u0005\u0011)f.\u001b;\t\u000bY<\b\u0019A\u001b\t\u000b}<\b\u0019\u0001(\u0002\u000fI,7m\u001c:eg\"1\u00111A<A\u0002i\u000b\u0011\u0002\u001e;m\u001b&dG.[:)\u0007]\f9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiaN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u0017\u0011q\u0001^1jYJ,7\rC\u0004\u0002\u0016\u0001!)%a\u0006\u0002\u000f\rdW-\u00198vaR\t!\u0010\u000b\u0003\u0002\u0014\u0005\u001d\u0001f\u0001\u0001\u0002\u001eA!\u0011qDA\u0012\u001b\t\t\tCC\u0002\u0002\u000e!IA!!\n\u0002\"\tY\u0011J\u001c;fe:\fG.\u00119j\u0001")
public class AsyncDnsCache
extends Dns
implements PeriodicCacheCleanup {
    private final AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer>> cache = new AtomicReference(new SimpleDnsCache.Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    private AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer>> cache() {
        return this.cache;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        return this.cache().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)ipv4 -> this.cache().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$)).map((Function1 & Serializable & scala.Serializable)ipv6 -> Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)((Iterable)((TraversableLike)ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ARecord) {
                    ARecord aRecord = (ARecord)A1;
                    object = aRecord.ip();
                } else if (A1 instanceof AAAARecord) {
                    AAAARecord aAAARecord = (AAAARecord)A1;
                    object = aAAARecord.ip();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ResourceRecord x1) {
                ResourceRecord resourceRecord = x1;
                boolean bl = resourceRecord instanceof ARecord ? true : resourceRecord instanceof AAAARecord;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())))));
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final Option<DnsClient.Answer> get(Tuple2<String, AsyncDnsResolver.QueryType> key) {
        return this.cache().get().get(key);
    }

    public final void put(Tuple2<String, AsyncDnsResolver.QueryType> key, DnsClient.Answer records, long ttlMillis) {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer> c;
        do {
            c = this.cache().get();
        } while (!this.cache().compareAndSet(c, c.put(key, records, ttlMillis)));
    }

    @Override
    public final void cleanup() {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer> c;
        do {
            c = this.cache().get();
        } while (!this.cache().compareAndSet(c, c.cleanup()));
    }
}

