/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ut!\u0002-Z\u0011\u0003qf!\u00021Z\u0011\u0003\t\u0007\"\u00025\u0002\t\u0003IW\u0001\u00026\u0002\u0001-D!\"!\u0005\u0002\u0005\u0004%\taWA\n\u0011!\ty-\u0001Q\u0001\n\u0005UaABAo\u0003\u0001\ty\u000e\u0003\u0006\u0002b\u001a\u0011)\u0019!C\u0001\u0003GD!\"a>\u0007\u0005\u0003\u0005\u000b\u0011BAs\u0011\u0019Ag\u0001\"\u0001\u0002z\"I\u0011q \u0004C\u0002\u0013\u0005!\u0011\u0001\u0005\t\u0005\u001b1\u0001\u0015!\u0003\u0003\u0004!I!q\u0002\u0004C\u0002\u0013\u0005!\u0011\u0001\u0005\t\u0005#1\u0001\u0015!\u0003\u0003\u0004!9!1\u0003\u0004\u0005\u000e\tU\u0001b\u0002B\u000e\u0003\u0011\u0005!Q\u0004\u0004\u0007\u0003K\t!)a\n\t\u0015\u0005U\u0002C!f\u0001\n\u0003\t9\u0004\u0003\u0006\u0002FA\u0011\t\u0012)A\u0005\u0003sA!\"a\u0012\u0011\u0005+\u0007I\u0011AA%\u0011)\t\t\u0006\u0005B\tB\u0003%\u00111\n\u0005\u0007QB!\t!a\u0015\t\u0013\u0005e\u0003#!A\u0005\u0002\u0005m\u0003\"CA1!E\u0005I\u0011AA2\u0011%\tI\bEI\u0001\n\u0003\tY\bC\u0005\u0002\u0000A\t\t\u0011\"\u0011\u0002\u0002\"I\u00111\u0013\t\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003;\u0003\u0012\u0011!C\u0001\u0003?C\u0011\"!*\u0011\u0003\u0003%\t%a*\t\u0013\u0005U\u0006#!A\u0005\u0002\u0005]\u0006\"CAa!\u0005\u0005I\u0011IAb\u0011%\t)\rEA\u0001\n\u0003\n9\rC\u0005\u0002JB\t\t\u0011\"\u0011\u0002L\u001eI!\u0011F\u0001\u0002\u0002#\u0005!1\u0006\u0004\n\u0003K\t\u0011\u0011!E\u0001\u0005[Aa\u0001\u001b\u0012\u0005\u0002\tm\u0002\"CAcE\u0005\u0005IQIAd\u0011%\u0011iDIA\u0001\n\u0003\u0013y\u0004C\u0005\u0003F\t\n\t\u0011\"!\u0003H!I!Q\u000b\u0012\u0002\u0002\u0013%!q\u000b\u0005\b\u0005?\nA\u0011\u0001B1\u0011\u001d\u0011y(\u0001C\u0001\u0005\u00033Q\u0001Y-\u0001\u0005\u0007C!\"a\u0012+\u0005\u000b\u0007I\u0011\u0001BF\u0011)\t\tF\u000bB\u0001B\u0003%!\u0011\u0010\u0005\u0007Q*\"\tA!$\t\u0013\tM%F1A\u0005\u0002\tU\u0005\u0002\u0003BNU\u0001\u0006IAa&\t\u0013\tu%F1A\u0005\u0002\t}\u0005\u0002\u0003BQU\u0001\u0006I!!/\t\u0011\t\r&\u0006)A\u0005\u0005KC\u0011B!-+\u0005\u0004%\tAa-\t\u0011\tm&\u0006)A\u0005\u0005kC\u0011B!0+\u0005\u0004%IAa0\t\u0011\t-(\u0006)A\u0005\u0005\u0003D\u0001B!<+\t\u0003Y&q\u001e\u0005\b\u0005?RC\u0011\u0002B{\u0011\u001d\u0019\tA\u000bC\u0001\u0007\u0007Aqaa\u0007+\t\u0003\u0019i\u0002C\u0004\u0004\u001c)\"\ta!\u0015\t\u000f\ru#\u0006\"\u0003\u0004`!91\u0011\u000e\u0016\u0005\u0002\r-\u0004bBB\u000eU\u0011\u00051q\u0013\u0005\b\u0007OSC\u0011ABU\u0011\u001d\u0019iK\u000bC\u0001\u0007_Cqaa0+\t\u0003\u0019\t\rC\u0005\u0004J*\u0012\r\u0011\"\u0003\u0004L\"A1\u0011\u001c\u0016!\u0002\u0013\u0019i\rC\u0005\u0004\\*\u0012\r\u0011\"\u0003\u0004^\"A1\u0011\u001d\u0016!\u0002\u0013\u0019y\u000e\u0003\u0006\u0004d*\u0012\r\u0011\"\u0001\\\u0007KD\u0001ba;+A\u0003%1q\u001d\u0005\b\u0007[TC\u0011BBx\u0011\u001d!YA\u000bC\u0005\t\u001bAq\u0001b\u0005+\t\u0013!)\u0002C\u0005\u0005\")\u0012\r\u0011\"\u0003\u0005$!AAq\u0007\u0016!\u0002\u0013!)\u0003C\u0005\u0005:)\u0012\r\u0011\"\u0001\u0005<!AAq\b\u0016!\u0002\u0013!i\u0004C\u0005\u0005B)\u0012\r\u0011\"\u0003\u0005D!AAq\t\u0016!\u0002\u0013!)\u0005C\u0004\u0005J)\"I\u0001b\u0013\t\u0013\u0011E#F1A\u0005\n\t}\u0005\u0002\u0003C*U\u0001\u0006I!!/\t\u0013\u0011U#F1A\u0005\n\t}\u0005\u0002\u0003C,U\u0001\u0006I!!/\t\u000f\u0011e#\u0006\"\u0003\u0005\\!AAq\f\u0016\u0005\u0002m#\t'A\u0007TKJL\u0017\r\\5{CRLwN\u001c\u0006\u00035n\u000bQb]3sS\u0006d\u0017N_1uS>t'\"\u0001/\u0002\t\u0005\\7.Y\u0002\u0001!\ty\u0016!D\u0001Z\u00055\u0019VM]5bY&T\u0018\r^5p]N\u0011\u0011A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0002K\u0006)1oY1mC&\u0011q\r\u001a\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q&aD\"mCN\u001c8+\u001a:jC2L'0\u001a:\u0011\u000b\rdg.a\u0003\n\u00055$'A\u0002+va2,'\u0007\r\u0002pyB\u0019\u0001o\u001e>\u000f\u0005E,\bC\u0001:e\u001b\u0005\u0019(B\u0001;^\u0003\u0019a$o\\8u}%\u0011a\u000fZ\u0001\u0007!J,G-\u001a4\n\u0005aL(!B\"mCN\u001c(B\u0001<e!\tYH\u0010\u0004\u0001\u0005\u0013u\u001c\u0011\u0011!A\u0001\u0006\u0003q(aA0%cE\u0019q0!\u0002\u0011\u0007\r\f\t!C\u0002\u0002\u0004\u0011\u0014qAT8uQ&tw\rE\u0002d\u0003\u000fI1!!\u0003e\u0005\r\te.\u001f\t\u0004?\u00065\u0011bAA\b3\nQ1+\u001a:jC2L'0\u001a:\u00027\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\t\t)\u0002\u0005\u0004\u0002\u0018\u0005u\u0011\u0011E\u0007\u0003\u00033Q1!a\u0007e\u0003\u0011)H/\u001b7\n\t\u0005}\u0011\u0011\u0004\u0002\u0010\tft\u0017-\\5d-\u0006\u0014\u0018.\u00192mKB\u0019\u00111\u0005\t\u000e\u0003\u0005\u00111\"\u00138g_Jl\u0017\r^5p]N1\u0001CYA\u0015\u0003_\u00012aYA\u0016\u0013\r\ti\u0003\u001a\u0002\b!J|G-^2u!\r\u0019\u0017\u0011G\u0005\u0004\u0003g!'\u0001D*fe&\fG.\u001b>bE2,\u0017aB1eIJ,7o]\u000b\u0003\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fY\u0016!B1di>\u0014\u0018\u0002BA\"\u0003{\u0011q!\u00113ee\u0016\u001c8/\u0001\u0005bI\u0012\u0014Xm]:!\u0003\u0019\u0019\u0018p\u001d;f[V\u0011\u00111\n\t\u0005\u0003w\ti%\u0003\u0003\u0002P\u0005u\"aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007\u0005\u0006\u0004\u0002\"\u0005U\u0013q\u000b\u0005\b\u0003k)\u0002\u0019AA\u001d\u0011\u001d\t9%\u0006a\u0001\u0003\u0017\nAaY8qsR1\u0011\u0011EA/\u0003?B\u0011\"!\u000e\u0017!\u0003\u0005\r!!\u000f\t\u0013\u0005\u001dc\u0003%AA\u0002\u0005-\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KRC!!\u000f\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003%)hn\u00195fG.,GMC\u0002\u0002t\u0011\f!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u$\u0006BA&\u0003O\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bA\u0001\\1oO*\u0011\u0011QR\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0006\u001d%AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0018B\u00191-!'\n\u0007\u0005mEMA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0006\u0005\u0005\u0006\"CAR7\u0005\u0005\t\u0019AAL\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0016\t\u0007\u0003W\u000b\t,!\u0002\u000e\u0005\u00055&bAAXI\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0016Q\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002:\u0006}\u0006cA2\u0002<&\u0019\u0011Q\u00183\u0003\u000f\t{w\u000e\\3b]\"I\u00111U\u000f\u0002\u0002\u0003\u0007\u0011QA\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qS\u0001\ti>\u001cFO]5oOR\u0011\u00111Q\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u0016Q\u001a\u0005\n\u0003G\u0003\u0013\u0011!a\u0001\u0003\u000b\tAdY;se\u0016tG\u000f\u0016:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>t\u0007\u0005K\u0002\u0006\u0003'\u0004B!!6\u0002Z6\u0011\u0011q\u001b\u0006\u0004\u0003gZ\u0016\u0002BAn\u0003/\u00141\"\u00138uKJt\u0017\r\\!qS\nA1+\u001a;uS:<7o\u0005\u0002\u0007E\u000611m\u001c8gS\u001e,\"!!:\u0011\t\u0005\u001d\u00181_\u0007\u0003\u0003STA!!9\u0002l*!\u0011Q^Ax\u0003!!\u0018\u0010]3tC\u001a,'BAAy\u0003\r\u0019w.\\\u0005\u0005\u0003k\fIO\u0001\u0004D_:4\u0017nZ\u0001\bG>tg-[4!)\u0011\tY0!@\u0011\u0007\u0005\rb\u0001C\u0004\u0002b&\u0001\r!!:\u0002\u0017M+'/[1mSj,'o]\u000b\u0003\u0005\u0007\u0001r\u0001\u001dB\u0003\u0005\u0013\u0011I!C\u0002\u0003\be\u00141!T1q!\r\u0001(1B\u0005\u0004\u0003#K\u0018\u0001D*fe&\fG.\u001b>feN\u0004\u0013!F*fe&\fG.\u001b>bi&|gNQ5oI&twm]\u0001\u0017'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4tA\u0005Y1m\u001c8gS\u001e$v.T1q)\u0011\u0011\u0019Aa\u0006\t\u000f\tea\u00021\u0001\u0002f\u0006\u00191MZ4\u0002'M,'/[1mSj,G-Q2u_J\u0004\u0016\r\u001e5\u0015\t\t%!q\u0004\u0005\b\u0005Cy\u0001\u0019\u0001B\u0012\u0003!\t7\r^8s%\u00164\u0007\u0003BA\u001e\u0005KIAAa\n\u0002>\tA\u0011i\u0019;peJ+g-A\u0006J]\u001a|'/\\1uS>t\u0007cAA\u0012EM)!Ea\f\u00020AQ!\u0011\u0007B\u001c\u0003s\tY%!\t\u000e\u0005\tM\"b\u0001B\u001bI\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u001d\u0005g\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011Y#A\u0003baBd\u0017\u0010\u0006\u0004\u0002\"\t\u0005#1\t\u0005\b\u0003k)\u0003\u0019AA\u001d\u0011\u001d\t9%\na\u0001\u0003\u0017\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003J\tE\u0003#B2\u0003L\t=\u0013b\u0001B'I\n1q\n\u001d;j_:\u0004ba\u00197\u0002:\u0005-\u0003\"\u0003B*M\u0005\u0005\t\u0019AA\u0011\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003ZA!\u0011Q\u0011B.\u0013\u0011\u0011i&a\"\u0003\r=\u0013'.Z2u\u0003a9\u0018\u000e\u001e5Ue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\\\u000b\u0005\u0005G\u0012I\u0007\u0006\u0003\u0003f\t]D\u0003\u0002B4\u0005[\u00022a\u001fB5\t\u0019\u0011Y\u0007\u000bb\u0001}\n\tA\u000bC\u0004\u0003p!\u0002\rA!\u001d\u0002\u0003\u0019\u0004Ra\u0019B:\u0005OJ1A!\u001ee\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0002H!\u0002\rA!\u001f\u0011\t\u0005m\"1P\u0005\u0005\u0005{\niDA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0010hKR\u001cUO\u001d:f]R$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]R\u0011\u0011\u0011E\n\u0005U\t\u0014)\t\u0005\u0003\u0002<\t\u001d\u0015\u0002\u0002BE\u0003{\u0011\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0016\u0005\teD\u0003\u0002BH\u0005#\u0003\"a\u0018\u0016\t\u000f\u0005\u001dS\u00061\u0001\u0003z\u0005A1/\u001a;uS:<7/\u0006\u0002\u0003\u0018B\u0019!\u0011\u0014\u0004\u000f\u0005}\u0003\u0011!C:fiRLgnZ:!\u0003Y\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>tWCAA]\u0003]\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>t\u0007%\u0001\u0003`Y><\u0007\u0003\u0002BT\u0005[k!A!+\u000b\u0007\t-6,A\u0003fm\u0016tG/\u0003\u0003\u00030\n%&\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'/A\u0002m_\u001e,\"A!.\u0011\t\t\u001d&qW\u0005\u0005\u0005s\u0013IK\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u000e[\u0006t\u0017NZ3ti\u000e\u000b7\r[3\u0016\u0005\t\u0005\u0007C\u0002Bb\u0005\u001f\u0014\u0019.\u0004\u0002\u0003F*!!q\u0019Be\u0003\u0019\tGo\\7jG*!!1\u001aBg\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u00037\tY)\u0003\u0003\u0003R\n\u0015'aD!u_6L7MU3gKJ,gnY3\u0011\u0011\tU'1\u001cB\u0005\u0005;l!Aa6\u000b\t\te\u0017QV\u0001\nS6lW\u000f^1cY\u0016LAAa\u0002\u0003XB)1Ma\u0013\u0003`B\"!\u0011\u001dBt!\u0019\t)Ia9\u0003f&\u0019\u00010a\"\u0011\u0007m\u00149\u000f\u0002\u0006\u0003jZ\n\t\u0011!A\u0003\u0002y\u00141a\u0018\u00133\u00039i\u0017M\\5gKN$8)Y2iK\u0002\n\u0001d]3sS\u0006d\u0017N_1uS>t\u0017J\u001c4pe6\fG/[8o+\t\u0011\t\u0010E\u0002\u0003\u001aBA3aNAj+\u0011\u00119Pa?\u0015\t\te(Q \t\u0004w\nmHA\u0002B6q\t\u0007a\u0010C\u0004\u0003pa\u0002\rAa@\u0011\u000b\r\u0014\u0019H!?\u0002\u0013M,'/[1mSj,G\u0003BB\u0003\u0007/\u0001b!a\u0006\u0004\b\r-\u0011\u0002BB\u0005\u00033\u00111\u0001\u0016:z!\u0015\u00197QBB\t\u0013\r\u0019y\u0001\u001a\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004G\u000eM\u0011bAB\u000bI\n!!)\u001f;f\u0011\u0019\u0019I\"\u000fa\u0001E\u0006\tq.A\u0006eKN,'/[1mSj,W\u0003BB\u0010\u0007K!\u0002b!\t\u0004(\r-2q\u0006\t\u0007\u0003/\u00199aa\t\u0011\u0007m\u001c)\u0003\u0002\u0004\u0003li\u0012\rA \u0005\b\u0007SQ\u0004\u0019AB\u0006\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u0019iC\u000fa\u0001\u0003/\u000bAb]3sS\u0006d\u0017N_3s\u0013\u0012Dqa!\r;\u0001\u0004\u0019\u0019$A\u0003dY\u0006T(\u0010E\u0003d\u0005\u0017\u001a)\u0004\r\u0003\u00048\rm\u0002\u0003\u00029x\u0007s\u00012a_B\u001e\t1\u0019ida\u0010\u0002\u0002\u0003\u0005)\u0011AB(\u0005\ryF\u0005\u000e\u0005\b\u0007cQ\u0004\u0019AB!!\u0015\u0019'1JB\"a\u0011\u0019)e!\u0013\u0011\tA<8q\t\t\u0004w\u000e%C\u0001DB\u001f\u0007\u007f\t\t\u0011!A\u0003\u0002\r-\u0013cA@\u0004NA\u00191p!\n\u0012\u0007}\u001c\u0019\u0003\u0006\u0005\u0004T\rU3qKB-!\u0015\t9ba\u0002c\u0011\u001d\u0019Ic\u000fa\u0001\u0007\u0017Aqa!\f<\u0001\u0004\t9\nC\u0004\u0004\\m\u0002\rA!\u0003\u0002\u00115\fg.\u001b4fgR\fA\u0003Z3tKJL\u0017\r\\5{K\nKH/Z!se\u0006LHc\u00022\u0004b\r\r4q\r\u0005\b\u0007Sa\u0004\u0019AB\u0006\u0011\u001d\u0019)\u0007\u0010a\u0001\u0003\u0017\t!b]3sS\u0006d\u0017N_3s\u0011\u001d\u0019Y\u0006\u0010a\u0001\u0005\u0013\tQ\u0003Z3tKJL\u0017\r\\5{K\nKH/\u001a\"vM\u001a,'\u000fF\u0004c\u0007[\u001aiha \t\u000f\r=T\b1\u0001\u0004r\u0005\u0019!-\u001e4\u0011\t\rM4\u0011P\u0007\u0003\u0007kRAaa\u001e\u0002\f\u0006\u0019a.[8\n\t\rm4Q\u000f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBB\u0017{\u0001\u0007\u0011q\u0013\u0005\b\u00077j\u0004\u0019\u0001B\u0005Q\u0015i41QBK!\u0015\u00197QQBE\u0013\r\u00199\t\u001a\u0002\u0007i\"\u0014xn^:\u0011\t\r-5\u0011S\u0007\u0003\u0007\u001bSAaa$\u0002\f\u0006\u0011\u0011n\\\u0005\u0005\u0007'\u001biI\u0001\rO_R\u001cVM]5bY&T\u0018M\u00197f\u000bb\u001cW\r\u001d;j_:\u001c#a!#\u0016\t\re5q\u0014\u000b\u0007\u00077\u001b\tka)\u0011\r\u0005]1qABO!\rY8q\u0014\u0003\u0007\u0005Wr$\u0019\u0001@\t\u000f\r%b\b1\u0001\u0004\f!91\u0011\u0007 A\u0002\r\u0015\u0006\u0003\u00029x\u0007;\u000b\u0011CZ5oIN+'/[1mSj,'OR8s)\u0011\tYaa+\t\r\req\b1\u0001c\u00035\u0019XM]5bY&TXM\u001d$peR!\u00111BBY\u0011\u001d\u0019\t\u0004\u0011a\u0001\u0007g\u0003Da!.\u0004:B!\u0001o^B\\!\rY8\u0011\u0018\u0003\f\u0007w\u001b\t,!A\u0001\u0002\u000b\u0005aPA\u0002`IaBS\u0001QBB\u0007+\u000bAb]3sS\u0006d\u0017N_3s\u001f\u001a$Baa1\u0004FB1\u0011qCB\u0004\u0003\u0017Aqaa2B\u0001\u0004\u0011I!A\u0007tKJL\u0017\r\\5{KJ4\u0015KT\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\u0014H)\u001a;bS2\u001cXCABg!\u0019\u0011)na4\u0004T&!1\u0011\u001bBl\u0005\r\u0019V-\u001d\t\u0004?\u000eU\u0017bABl3\n\t2+\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0002%M,'/[1mSj,'\u000fR3uC&d7\u000fI\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0006\u0002\u0004`B9\u0001O!\u0002\u0003\n\u0005-\u0011\u0001D:fe&\fG.\u001b>feN\u0004\u0013\u0001\u00032j]\u0012LgnZ:\u0016\u0005\r\u001d\bC\u0002Bk\u0007\u001f\u001cI\u000fE\u0002\u0003\u001a\u000e\t\u0011BY5oI&twm\u001d\u0011\u00029\u0015t7/\u001e:f\u001f:d\u00170\u00117m_^,GmU3sS\u0006d\u0017N_3sgR!1\u0011_B|!\r\u001971_\u0005\u0004\u0007k$'\u0001B+oSRDqa!?I\u0001\u0004\u0019Y0\u0001\u0003ji\u0016\u0014\bCBB\u007f\t\u000f\tYA\u0004\u0003\u0004\u0000\u0012\rab\u0001:\u0005\u0002%\tQ-C\u0002\u0005\u0006\u0011\fq\u0001]1dW\u0006<W-\u0003\u0003\u00024\u0012%!b\u0001C\u0003I\u0006\u00192\r[3dW\u001e{wn\u001a7f!J|Go\u001c2vMR!\u0011\u0011\u0018C\b\u0011\u001d!\t\"\u0013a\u0001\u0005\u0013\t\u0011b\u00197bgNt\u0015-\\3\u0002\tM|'\u000f\u001e\u000b\u0005\u0007O$9\u0002C\u0004\u0005\u001a)\u0003\r\u0001b\u0007\u0002\u0005%t\u0007CBB\u007f\t;\u0019I/\u0003\u0003\u0005 \u0011%!\u0001C%uKJ\f'\r\\3\u0002\u001bM,'/[1mSj,'/T1q+\t!)\u0003\u0005\u0005\u0005(\u0011%BQFA\u0006\u001b\t\u0011I-\u0003\u0003\u0005,\t%'!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\"Aq\u0006C\u001a!\u0011\u0001x\u000f\"\r\u0011\u0007m$\u0019\u0004\u0002\u0006\u000561\u000b\t\u0011!A\u0003\u0002y\u0014Aa\u0018\u00132a\u0005q1/\u001a:jC2L'0\u001a:NCB\u0004\u0013\u0001F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u00180\u0006\u0002\u0005>A9\u0001O!\u0002\u0002\u0018\u0006-\u0011!F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u0018\u0010I\u0001\u001acVL7m[*fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u00180\u0006\u0002\u0005FA)1m!\u0004\u0002\f\u0005Q\u0012/^5dWN+'/[1mSj,'OQ=JI\u0016tG/\u001b;zA\u0005\tr-\u001a;TKJL\u0017\r\\5{KJ\u0014\u00150\u00133\u0015\t\u0005-AQ\n\u0005\b\t\u001f\n\u0006\u0019AAL\u0003\tIG-A\u0011jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G-\u0001\u0012jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G\rI\u0001!SN<\u0016M\u001d8j]\u001e|eNT8WKJLg-[2bi&|g.\u00128bE2,G-A\u0011jg^\u000b'O\\5oO>sgj\u001c,fe&4\u0017nY1uS>tWI\\1cY\u0016$\u0007%\u0001\u000ejg\u0012K7/\u00197m_^,GMS1wCN+'/[1mSj,'\u000f\u0006\u0003\u0002:\u0012u\u0003bBB3-\u0002\u0007\u00111B\u0001\u001eg\"|W\u000f\u001c3XCJt\u0017IY8vi*\u000bg/Y*fe&\fG.\u001b>feR1\u0011\u0011\u0018C2\tcBq\u0001\"\u001aX\u0001\u0004!9'A\btKJL\u0017\r\\5{K\u0012\u001cE.Y:ta\u0011!I\u0007\"\u001c\u0011\tA<H1\u000e\t\u0004w\u00125Da\u0003C8\tG\n\t\u0011!A\u0003\u0002y\u0014Aa\u0018\u00132e!91QM,A\u0002\u0005-\u0001fA,\u0002T\u0002")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(154).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(168).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                object = serializerWithStringManifest.fromBinary(bytes, manifest);
            } else {
                Object object2;
                String string = manifest;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object2 = serializer.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
                } else {
                    Object object3;
                    Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                    Option option = cache.get((Object)manifest);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Option cachedClassManifest = (Option)some.value();
                        object3 = serializer.fromBinary(bytes, cachedClassManifest);
                    } else if (None$.MODULE$.equals(option)) {
                        Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                        if (!(try_ instanceof Success)) {
                            if (try_ instanceof Failure) {
                                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                            }
                            throw new MatchError(try_);
                        }
                        Success success = (Success)try_;
                        Class classManifest = (Class)success.value();
                        Some classManifestOption = new Some((Object)classManifest);
                        this.updateCache$1(cache, manifest, (Option)classManifestOption);
                        Object object4 = serializer.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                        object3 = object4;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object2 = object3;
                }
                object = object2;
            }
            return object;
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Object object2;
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object2 = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object2 = this.deserializeByteArray(bytes, serializer2, manifest);
            }
            object = object2;
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer serializer5;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.bindings().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer5 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                scala.collection.immutable.Seq possibilitiesWithoutJavaSerializer = (scala.collection.immutable.Seq)seq.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Serializer s = (Serializer)tuple2._2();
                        String string = s.getClass().getName();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer5 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer4 = serializer5;
            Serializer serializer6 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer6 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer6;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Serializer> serializerOf(String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var3_2 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this, fqn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String fqn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : new Try<T>(A1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (scala.collection.immutable.Seq)((TraversableLike)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF(Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(scala.collection.immutable.Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(scala.collection.immutable.Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 != null && tuple2._2() instanceof JavaSerializer ? false : tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string;
        String string2;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string2 = className;
                if (alias != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string3 = string = alias;
        String string4 = "none";
        boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$5) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (scala.collection.immutable.Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (scala.collection.immutable.Seq)vector.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x1;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            String string;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = v;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string2).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Map result = fromConfig.$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        this.serializers = result;
        scala.collection.immutable.Iterable fromConfig2 = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            String string;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string = className;
                    if (alias != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1 & Serializable & scala.Serializable)detail -> (scala.collection.immutable.Seq)detail.useFor().map((Function1 & Serializable & scala.Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$3, x1$1);
                    if (tuple22 == null) break block2;
                    map = (ConcurrentHashMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            ConcurrentHashMap concurrentHashMap = map;
            return concurrentHashMap;
        });
        this.serializerByIdentity = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus((GenTraversableOnce)this.serializers().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()));
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$5);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            Config config2;
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            if (config.getBoolean("akka.actor.enable-additional-serialization-bindings") || !config.getBoolean("akka.actor.allow-java-serialization") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled")) {
                Config bs = defaultBindings.withFallback((ConfigMergeable)config.getConfig("akka.actor.additional-serialization-bindings"));
                String additionalWhenJavaOffKey = "akka.actor.java-serialization-disabled-additional-serialization-bindings";
                config2 = !config.getBoolean("akka.actor.allow-java-serialization") ? bs.withFallback((ConfigMergeable)config.getConfig(additionalWhenJavaOffKey)) : bs;
            } else {
                config2 = defaultBindings;
            }
            Config bindings = config2;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

