/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.cluster.server;

import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ipfilter.IpFilterRuleList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rzo.netty.ahessian.application.cluster.client.ClusterClient;
import org.rzo.netty.ahessian.application.cluster.server.ClusterServiceImpl;
import org.rzo.netty.ahessian.application.cluster.server.SeedClusterService;
import org.rzo.netty.ahessian.application.cluster.service.ClusterService;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryBuilder;
import org.rzo.netty.ahessian.bootstrap.DefaultClient;
import org.rzo.netty.ahessian.bootstrap.DefaultServer;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.mcast.discovery.DiscoveryClient;
import org.rzo.netty.mcast.discovery.DiscoveryListener;
import org.rzo.netty.mcast.discovery.DiscoveryServer;

public class ClusterServer {
    int _serverPort = 0;
    String _clusterName;
    String _clientName;
    Map<InetSocketAddress, DefaultClient> _seedClients = new ConcurrentHashMap<InetSocketAddress, DefaultClient>();
    List<InetSocketAddress> _seeds = new CopyOnWriteArrayList<InetSocketAddress>();
    String _ipFilter;
    DiscoveryServer _discoveryServer;
    DiscoveryClient _discovery;
    AtomicBoolean _connectingSeeds = new AtomicBoolean(false);
    static Executor _executor = Executors.newCachedThreadPool();
    ClusterServiceImpl _service;
    ClusterService.Member _me;
    InetSocketAddress _myAddress;
    String _myHost;
    InetAddress _address;

    public ClusterServer() throws Exception {
        this(null, 0, true, true, null, "DefaultCluster", ClusterClient.getHostName() + "-" + System.currentTimeMillis(), new InetSocketAddress[0]);
    }

    public ClusterServer(int port) throws Exception {
        this(null, port, false, false, null, "DefaultCluster", ClusterClient.getHostName() + "-" + System.currentTimeMillis(), new InetSocketAddress[0]);
    }

    public ClusterServer(int port, InetSocketAddress ... seeds) throws Exception {
        this(null, port, false, false, null, "DefaultCluster", ClusterClient.getHostName() + "-" + System.currentTimeMillis(), seeds);
    }

    public ClusterServer(InetAddress address, int port, boolean useDiscoveryServer, boolean useClientDiscovery, String ipFilter, String clusterName, String clientName, InetSocketAddress ... seeds) throws Exception {
        this._serverPort = port;
        this._address = address;
        this._ipFilter = ipFilter;
        this._clusterName = clusterName;
        this._clientName = clientName;
        this._service = new ClusterServiceImpl();
        this._service.setClusterName(this._clusterName);
        this._myHost = ClusterClient.getHostName();
        this._me = this._service.createMember(this._clusterName, this._clientName, null, true, this._myHost);
        this._service.setServer(this._me);
        ChannelPipelineFactoryBuilder builder = new ChannelPipelineFactoryBuilder<SeedClusterService>().rpcServiceInterface(SeedClusterService.class).rpcServerService(this._service).serviceThreads(10).serverHeartbeat(45000L).debug().ipFilter(ipFilter);
        builder.disconnectedListener(new HessianRPCServiceHandler.ConnectListener(){

            @Override
            public void run() {
            }

            @Override
            public void run(Channel channel) {
                if (ClusterServer.this._service != null) {
                    ClusterServer.this._service.disconnected(channel);
                }
            }
        });
        HashSet<String> channelOptions = new HashSet<String>();
        channelOptions.add("TCP_NODELAY");
        this._serverPort = port;
        DefaultServer server = new DefaultServer(NioServerSocketChannel.class, builder, channelOptions, this._serverPort, this._address);
        server.start();
        Channel channel = server.getChannel();
        this._myAddress = (InetSocketAddress)channel.localAddress();
        this._serverPort = this._myAddress.getPort();
        if (seeds != null) {
            for (InetSocketAddress seed : seeds) {
                if (this.isMyAddress(seed)) continue;
                this._seeds.add(seed);
            }
        }
        if (useDiscoveryServer) {
            this._discoveryServer = new DiscoveryServer();
            this._discoveryServer.setDebug(true);
            if (this._ipFilter != null) {
                this._discoveryServer.setIpSet(new IpFilterRuleList(this._ipFilter));
            }
            this._discoveryServer.setName(clusterName);
            this._discoveryServer.setPort(this._serverPort);
            this._discoveryServer.init();
        }
        if (useClientDiscovery) {
            this._discovery = new DiscoveryClient();
            this._discovery.setName(clusterName);
            this._discovery.setDebug(true);
            this._discovery.addListener(new DiscoveryListener(){

                @Override
                public void newHost(String name, String host) {
                    int port;
                    String[] x = host.split("&");
                    String hostName = x[1];
                    InetSocketAddress address = new InetSocketAddress(hostName, port = Integer.parseInt(x[2]));
                    if (ClusterServer.this._seeds.contains(address) || ClusterServer.this.isMyAddress(address)) {
                        return;
                    }
                    ClusterServer.this._seeds.add(address);
                    ClusterServer.this.connectSeeds();
                }
            });
            this._discovery.init();
        }
        this.connectSeeds();
    }

    protected boolean isMyAddress(InetSocketAddress address) {
        try {
            return this._myAddress.getPort() == address.getPort() && (this.isLocalhost(address) || this._myHost.equals(InetAddress.getByName(address.getHostName()).getAddress()));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isLocalhost(InetSocketAddress address) {
        try {
            if (address.getHostName().equals(InetAddress.getLocalHost().getHostName())) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        try {
            InetAddress[] addrs;
            for (InetAddress inetAddress : addrs = InetAddress.getAllByName("127.0.0.1")) {
                if (!inetAddress.getHostName().equals(address.getHostName())) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                for (NetworkInterface in : Collections.list(interfaces)) {
                    for (InterfaceAddress interfaceAddress : in.getInterfaceAddresses()) {
                        if (!interfaceAddress.getAddress().getHostName().equals(address.getHostName())) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void connectSeeds() {
        _executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!ClusterServer.this._connectingSeeds.compareAndSet(false, true)) {
                    return;
                }
                boolean connectedToAll = false;
                while (!connectedToAll) {
                    connectedToAll = true;
                    for (InetSocketAddress address : ClusterServer.this._seeds) {
                        if (ClusterServer.this._seedClients.get(address) != null) continue;
                        connectedToAll = connectedToAll && ClusterServer.this.connectToSeed(address);
                    }
                    if (connectedToAll) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                ClusterServer.this._connectingSeeds.set(false);
            }
        });
    }

    private boolean connectToSeed(final InetSocketAddress seed) {
        System.out.println("connect to seed " + seed);
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        options.put("sync", Boolean.valueOf(true));
        options.put("timeout", Long.valueOf(2000L));
        ChannelPipelineFactoryBuilder builder = new ChannelPipelineFactoryBuilder().serviceThreads(10).rpcServiceInterface(SeedClusterService.class).clientHeartbeat(30000L).serviceOptions(options);
        builder.debug();
        HashSet<String> channelOptions = new HashSet<String>();
        channelOptions.add("TCP_NODELAY");
        final DefaultClient client = new DefaultClient(NioSocketChannel.class, builder, channelOptions);
        client.setRemoteAddress(seed.getHostName(), seed.getPort());
        client.connectedListener(new HessianRPCServiceHandler.ConnectListener(){

            @Override
            public void run() {
                try {
                    ((SeedClusterService)client.proxy()).seedJoin(ClusterServer.this._me, new ServerListener());
                    ClusterServer.this._seedClients.put(seed, client);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void run(Channel channel) {
            }
        });
        client.disconnectedListener(new HessianRPCServiceHandler.ConnectListener(){

            @Override
            public void run() {
                ClusterServer.this._seedClients.remove(client.getChannel().remoteAddress());
                ClusterServer.this.connectSeeds();
            }

            @Override
            public void run(Channel channel) {
            }
        });
        try {
            client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void disconnect() {
    }

    public List<ClusterService.Member> getMembers() {
        return this._service.getMembers();
    }

    public static void main(String[] args) throws Exception {
        ClusterServer server1 = new ClusterServer(15010, new InetSocketAddress("127.0.0.1", 15010), new InetSocketAddress("127.0.0.1", 15011), new InetSocketAddress("127.0.0.1", 15012));
        ClusterServer server2 = new ClusterServer(15011, new InetSocketAddress("127.0.0.1", 15010), new InetSocketAddress("127.0.0.1", 15011), new InetSocketAddress("127.0.0.1", 15012));
        ClusterServer server3 = new ClusterServer(15012, new InetSocketAddress("127.0.0.1", 15010), new InetSocketAddress("127.0.0.1", 15011), new InetSocketAddress("127.0.0.1", 15012));
        while (true) {
            System.out.println(server1.getMembers());
            Thread.sleep(5000L);
        }
    }

    public class ServerListener
    implements ClusterService.ClusterEventListener {
        @Override
        public void setDone(boolean value) {
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void joined(ClusterService.Member member) {
            if (member.getName() != ClusterServer.this._me.getName()) {
                ClusterServer.this._service.seedJoin(member, null);
            }
        }

        @Override
        public void left(ClusterService.Member member) {
            ClusterServer.this._service.leave(member.getName());
        }
    }
}

