/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.core.rest.util.RepositoryHelper;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xldeploy.packager.StreamFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUg\u0001\u0002\u00180\u0001iB\u0001b\u0012\u0001\u0003\u0002\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0019!C\u0001!\"A\u0011\f\u0001B\u0001B\u0003&\u0011\n\u0003\u0005[\u0001\t\u0005\r\u0011\"\u0001\\\u0011!\u0011\u0007A!a\u0001\n\u0003\u0019\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0015\u0002/\t\u0011\u0019\u0004!\u00111A\u0005\u0002\u001dD\u0001B\u001c\u0001\u0003\u0002\u0004%\ta\u001c\u0005\tc\u0002\u0011\t\u0011)Q\u0005Q\"A!\u000f\u0001BA\u0002\u0013\u00051\u000f\u0003\u0005}\u0001\t\u0005\r\u0011\"\u0001~\u0011!y\bA!A!B\u0013!\bBCA\u0001\u0001\t\u0005\r\u0011\"\u0001\u0002\u0004!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0004%\t!a\u0007\t\u0015\u0005}\u0001A!A!B\u0013\t)\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003\u0002CA8\u0001\u0001\u0006I!a\u0015\t\u0013\u0005E\u0004A1A\u0005\n\u0005M\u0004\u0002CAA\u0001\u0001\u0006I!!\u001e\t\u0013\u0005\r\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAS\u0001\u0001\u0006I!a\"\t\u0017\u0005\u001d\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0016\u0005\f\u0003o\u0003\u0001\u0019!a\u0001\n\u0013\tI\fC\u0006\u0002>\u0002\u0001\r\u0011!Q!\n\u0005-\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003'\u0004A\u0011IAk\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!!8\u0001\t\u0003\ny\u000eC\u0004\u0002z\u0002!\t%a?\t\u000f\t\u001d\u0001\u0001\"\u0005\u0003\n!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0013\u0001\u0011%!q\u0005\u0005\b\u0005{\u0001A\u0011\u0002B \u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqA!\u0018\u0001\t\u0013\u0011y\u0006C\u0004\u0003l\u0001!IA!\u001c\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!q\u0014\u0001\u0005\n\t\u0005\u0006b\u0002BU\u0001\u0011%!1\u0016\u0005\b\u0005g\u0002A\u0011\u0002BY\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqAa/\u0001\t\u0013\u0011i\fC\u0004\u0003H\u0002!IA!3\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003P\n\u0019\u0012*\u001c9peR,'oU3sm&\u001cW-S7qY*\u0011\u0001'M\u0001\tS6\u0004xN\u001d;fe*\u0011!gM\u0001\bg\u0016\u0014h/[2f\u0015\t!T'\u0001\u0005eKBdw._5u\u0015\t1t'A\u0005yK\nL\u0017\r\\1cg*\t\u0001(A\u0002d_6\u001c\u0001aE\u0002\u0001w\r\u0003\"\u0001P!\u000e\u0003uR!AP \u0002\t1\fgn\u001a\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0004PE*,7\r\u001e\t\u0003\t\u0016k\u0011aL\u0005\u0003\r>\u0012q\"S7q_J$XM]*feZL7-Z\u0001\u0012e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,W#A%\u0011\u0005)kU\"A&\u000b\u00051\u001b\u0014A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011aj\u0013\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017!\u0006:fa>\u001c\u0018\u000e^8ssN+'O^5dK~#S-\u001d\u000b\u0003#^\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013A!\u00168ji\"9\u0001LAA\u0001\u0002\u0004I\u0015a\u0001=%c\u0005\u0011\"/\u001a9pg&$xN]=TKJ4\u0018nY3!\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!aX\u001a\u0002\u0011M,7-\u001e:jifL!!\u00190\u0003\u0017I{G.Z*feZL7-Z\u0001\u0010e>dWmU3sm&\u001cWm\u0018\u0013fcR\u0011\u0011\u000b\u001a\u0005\b1\u0016\t\t\u00111\u0001]\u00031\u0011x\u000e\\3TKJ4\u0018nY3!\u0003%1\u0018\r\\5eCR|'/F\u0001i!\tIG.D\u0001k\u0015\tY\u0017'\u0001\u0006wC2LG-\u0019;j_:L!!\u001c6\u0003\u0013Y\u000bG.\u001b3bi>\u0014\u0018!\u0004<bY&$\u0017\r^8s?\u0012*\u0017\u000f\u0006\u0002Ra\"9\u0001\fCA\u0001\u0002\u0004A\u0017A\u0003<bY&$\u0017\r^8sA\u0005AQM\u001c:jG\",'/F\u0001u!\t)(0D\u0001w\u0015\t9\b0\u0001\u0005qC\u000e\\\u0017mZ3s\u0015\tIX'\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0013\tYhO\u0001\fT_V\u00148-Z!si&4\u0017m\u0019;F]JL7\r[3s\u00031)gN]5dQ\u0016\u0014x\fJ3r)\t\tf\u0010C\u0004Y\u0017\u0005\u0005\t\u0019\u0001;\u0002\u0013\u0015t'/[2iKJ\u0004\u0013\u0001\u0005:fa>\u001c\u0018\u000e^8ss\"+G\u000e]3s+\t\t)\u0001\u0005\u0003\u0002\b\u0005UQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003sKN$(bAA\ng\u0005!1m\u001c:f\u0013\u0011\t9\"!\u0003\u0003!I+\u0007o\\:ji>\u0014\u0018\u0010S3ma\u0016\u0014\u0018\u0001\u0006:fa>\u001c\u0018\u000e^8ss\"+G\u000e]3s?\u0012*\u0017\u000fF\u0002R\u0003;A\u0001\u0002\u0017\b\u0002\u0002\u0003\u0007\u0011QA\u0001\u0012e\u0016\u0004xn]5u_JL\b*\u001a7qKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty\u0003\u0005\u0002E\u0001!)q\t\u0005a\u0001\u0013\")!\f\u0005a\u00019\")a\r\u0005a\u0001Q\")!\u000f\u0005a\u0001i\"9\u0011\u0011\u0001\tA\u0002\u0005\u0015\u0001f\u0001\t\u00024A!\u0011QGA&\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012AC1o]>$\u0018\r^5p]*!\u0011QHA \u0003\u001d1\u0017m\u0019;pefTA!!\u0011\u0002D\u0005)!-Z1og*!\u0011QIA$\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA%\u0003\ry'oZ\u0005\u0005\u0003\u001b\n9DA\u0005BkR|w/\u001b:fI\u0006I\u0011.\u001c9peR,'o]\u000b\u0003\u0003'\u0002b!!\u0016\u0002Z\u0005uSBAA,\u0015\r\tYaP\u0005\u0005\u00037\n9F\u0001\u0003MSN$\b\u0003BA0\u0003Wj!!!\u0019\u000b\u0007A\n\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014aA1qS*\u0019\u0011\u0011N\u001a\u0002\rM,'O^3s\u0013\u0011\ti'!\u0019\u0003\u0011%k\u0007o\u001c:uKJ\f!\"[7q_J$XM]:!\u0003\u0019awnZ4feV\u0011\u0011Q\u000f\t\u0005\u0003o\ni(\u0004\u0002\u0002z)!\u00111PA$\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\ty(!\u001f\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0001#[:D_2dWm\u0019;j_:\\\u0015N\u001c3\u0016\u0005\u0005\u001d\u0005c\u0002*\u0002\n\u00065\u0015qT\u0005\u0004\u0003\u0017\u001b&!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ty)a'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000bqA]3gY\u0016\u001cGO\u0003\u0003\u0002f\u0005]%bAAMg\u00051\u0001\u000f\\;hS:LA!!(\u0002\u0012\na\u0001K]8qKJ$\u0018pS5oIB\u0019!+!)\n\u0007\u0005\r6KA\u0004C_>dW-\u00198\u0002#%\u001c8i\u001c7mK\u000e$\u0018n\u001c8LS:$\u0007%\u0001\u000ej[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u00180\u0006\u0002\u0002,B!\u0011QVAZ\u001b\t\tyKC\u0002\u00022~\n!![8\n\t\u0005U\u0016q\u0016\u0002\u0005\r&dW-\u0001\u0010j[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u0018p\u0018\u0013fcR\u0019\u0011+a/\t\u0011aC\u0012\u0011!a\u0001\u0003W\u000b1$[7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef\u0004\u0013!D5oSRLU\u000e]8si\u0016\u00148\u000fF\u0001RQ\rQ\u0012Q\u0019\t\u0005\u0003\u000f\fy-\u0004\u0002\u0002J*!\u0011\u0011HAf\u0015\t\ti-A\u0003kCZ\f\u00070\u0003\u0003\u0002R\u0006%'!\u0004)pgR\u001cuN\\:ueV\u001cG/A\u000fhKRLU\u000e]8si\u0006\u0014G.\u001a)bG.\fw-\u001a#je\u0016\u001cGo\u001c:z)\t\tY+A\u000ftKRLU\u000e]8si\u0006\u0014G.\u001a)bG.\fw-\u001a#je\u0016\u001cGo\u001c:z)\r\t\u00161\u001c\u0005\b\u0003Oc\u0002\u0019AAV\u00031a\u0017n\u001d;QC\u000e\\\u0017mZ3t)\t\t\t\u000f\u0005\u0004\u0002V\u0005e\u00131\u001d\t\u0005\u0003K\f\u0019P\u0004\u0003\u0002h\u0006=\bcAAu'6\u0011\u00111\u001e\u0006\u0004\u0003[L\u0014A\u0002\u001fs_>$h(C\u0002\u0002rN\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA{\u0003o\u0014aa\u0015;sS:<'bAAy'\u0006i\u0011.\u001c9peR\u0004\u0016mY6bO\u0016$B!a9\u0002~\"9\u0011q \u0010A\u0002\t\u0005\u0011AB:pkJ\u001cW\r\u0005\u0003\u0002`\t\r\u0011\u0002\u0002B\u0003\u0003C\u0012A\"S7q_J$8k\\;sG\u0016\fqb\u00195fG.\u0004VM]7jgNLwN\u001c\u000b\u0006#\n-!\u0011\u0004\u0005\b\u0005\u001by\u0002\u0019\u0001B\b\u0003)\u0001XM]7jgNLwN\u001c\t\u0005\u0005#\u0011)\"\u0004\u0002\u0003\u0014)\u0019!Q\u00020\n\t\t]!1\u0003\u0002\u000b!\u0016\u0014X.[:tS>t\u0007b\u0002B\u000e?\u0001\u0007\u00111]\u0001\u0015_:\u001cuN\u001c4jOV\u0014\u0018\r^5p]&#X-\\:\u0002\u0011\u0011|\u0017*\u001c9peR$b!a9\u0003\"\t\r\u0002bBA\u0000A\u0001\u0007!\u0011\u0001\u0005\u0007a\u0001\u0002\r!!\u0018\u0002!M\u001c\u0017M\u001c)mC\u000e,\u0007n\u001c7eKJ\u001cH#B)\u0003*\tM\u0002b\u0002B\u0016C\u0001\u0007!QF\u0001\u0010S6\u0004xN\u001d;fIB\u000b7m[1hKB!\u0011q\fB\u0018\u0013\u0011\u0011\t$!\u0019\u0003\u001f%k\u0007o\u001c:uK\u0012\u0004\u0016mY6bO\u0016DqA!\u000e\"\u0001\u0004\u00119$A\u0002dib\u0004B!a\u0018\u0003:%!!1HA1\u0005AIU\u000e]8si&twmQ8oi\u0016DH/\u0001\rsKN|GN^3B]\u0012,eN]5dQ\u0006\u0013H/\u001b4bGR$2!\u0015B!\u0011\u001d\u0011\u0019E\ta\u0001\u0005\u000b\nab]8ve\u000e,\u0017I\u001d;jM\u0006\u001cG\u000f\u0005\u0003\u0003H\tESB\u0001B%\u0015\u0011\u0011YE!\u0014\u0002\u0011\u0005\u0014H/\u001b4bGRTAAa\u0014\u0002\u0016\u0006\u0019Q\u000fZ7\n\t\tM#\u0011\n\u0002\u000f'>,(oY3BeRLg-Y2u\u0003UI7/\u0011:uS\u001a\f7\r\u001e)sK\u0016s'/[2iK\u0012$B!a(\u0003Z!9!1L\u0012A\u0002\t\u0015\u0013A\u00033fa2|\u00170\u00192mK\u0006i1\r[3dW&k\u0007o\u001c:uK\u0012$2!\u0015B1\u0011\u001d\u0011\u0019\u0007\na\u0001\u0005K\n1\u0002]1dW\u0006<W-\u00138g_B!\u0011q\fB4\u0013\u0011\u0011I'!\u0019\u0003\u0017A\u000b7m[1hK&sgm\\\u0001\u000fGJ,\u0017\r^3F]RLG/[3t)\u001d\t&q\u000eB9\u0005kBqAa\u000b&\u0001\u0004\u0011i\u0003C\u0004\u0003t\u0015\u0002\r!a(\u0002\u0013%\u001cX\u000b]4sC\u0012,\u0007b\u0002B<K\u0001\u0007!\u0011P\u0001\u0012i>\u001c%/Z1uK\u000e{G\u000e\\3di>\u0014\bCBA+\u0005w\u0012y(\u0003\u0003\u0003~\u0005]#aA*fiB!!\u0011\u0011BB\u001b\t\u0011i%\u0003\u0003\u0003\u0006\n5#!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\u00061b-\u001b7uKJ,\u00050[:uS:<\u0007+Y2lC\u001e,7\u000f\u0006\u0003\u0003\f\nU\u0005CBAs\u0005\u001b\u0013y)\u0003\u0003\u0003~\u0005]\b\u0003BAH\u0005#KAAa%\u0002\u0012\n\u0011\u0002K]8qKJ$\u0018\u0010R3tGJL\u0007\u000f^8s\u0011\u001d\u00119J\na\u0001\u00053\u000bqA^3sg&|g\u000e\u0005\u0003\u0003\u0002\nm\u0015\u0002\u0002BO\u0005\u001b\u0012qAV3sg&|g.\u0001\u0010de\u0016\fG/\u001a(fgR,GmQ8oM&<WO]1uS>t\u0017\n^3ngR)\u0011Ka)\u0003(\"9!QU\u0014A\u0002\t}\u0014AA2j\u0011\u001d\u00119h\na\u0001\u0005s\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0004#\n5\u0006b\u0002BXQ\u0001\u0007!\u0011P\u0001\ti>\u001c%/Z1uKR!\u0011q\u0014BZ\u0011\u001d\u0011\u0019'\u000ba\u0001\u0005K\nq!\u00199q\u001d\u0006lW\r\u0006\u0003\u0002d\ne\u0006b\u0002B2U\u0001\u0007!QM\u0001\u0013gV\u00147\u000b\u001e:j]\u001e\fe\r^3s\u0019\u0006\u001cH\u000f\u0006\u0004\u0002d\n}&1\u0019\u0005\b\u0005\u0003\\\u0003\u0019AAr\u0003\u0005\u0019\bb\u0002BcW\u0001\u0007\u00111]\u0001\u0004g\u0016\u0004\u0018aE:vEN#(/\u001b8h\u0005\u00164wN]3MCN$HCBAr\u0005\u0017\u0014i\rC\u0004\u0003B2\u0002\r!a9\t\u000f\t\u0015G\u00061\u0001\u0002dR)\u0011K!5\u0003T\"9!1O\u0017A\u0002\u0005}\u0005b\u0002B2[\u0001\u0007!Q\r")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactEnricher enricher;
    private RepositoryHelper repositoryHelper;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactEnricher enricher() {
        return this.enricher;
    }

    public void enricher_$eq(SourceArtifactEnricher x$1) {
        this.enricher = x$1;
    }

    public RepositoryHelper repositoryHelper() {
        return this.repositoryHelper;
    }

    public void repositoryHelper_$eq(RepositoryHelper x$1) {
        this.repositoryHelper = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", new Object[]{importerClasses});
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(importerClasses).asScala()).filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable & scala.Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", new Object[]{XmlManifestDarImporter.class});
        this.logger().info("Importers configured in XL Deploy: {}", new Object[]{this.importers()});
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)List$.MODULE$.apply((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable & scala.Serializable)importer -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((ListableImporter)importer).list(this.importablePackageDirectory())).asScala()).map((Function1 & Serializable & scala.Serializable)pkgFound -> pkgFound, Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).asJava()));
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        try {
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Importer importer = (Importer)some.value();
            String string2 = this.doImport(source, importer);
            string = string2;
        }
        finally {
            source.cleanUp();
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.repositoryHelper().publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        block0: {
            if (!(importedPackage.getVersion() instanceof DeploymentPackage)) break block0;
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).asScala()).foreach((Function1 & Serializable & scala.Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable & scala.Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringBuilder(53).append("Could not open stream of uri ").append(sourceArtifact.getFileUri()).append(" of unresolved artifact ").append(sourceArtifact).toString(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        void var2_2;
        boolean isPreEnrichedArtifact = deployable.hasProperty("preEnrichedArtifact") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preEnrichedArtifact"));
        this.logger().info(new StringBuilder(26).append("Artifact ").append(deployable).append(" is ").append((Object)(isPreEnrichedArtifact ? "" : "not")).append(" pre-enriched").toString());
        return (boolean)var2_2;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(version.getType().getDescriptor().getPropertyDescriptors()).asScala()).toSet();
        return !(version instanceof CompositePackage) ? propertyDescriptors : (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$2)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(propertyDescriptors).asScala()).withFilter((Function1 & Serializable & scala.Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        Seq msgs = (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(toCreate).asScala()).foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, tc) -> {
            Seq validated = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.validator().validate(tc, (java.util.List)Lists.newArrayList((Iterable)toCreate))).asScala();
            return validated.nonEmpty() ? (Seq)acc.$plus$plus((GenTraversableOnce)validated, Seq$.MODULE$.canBuildFrom()) : acc;
        });
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean bl;
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).asScala()).toList();
        int n = applications.length();
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                if (locationSpecified) {
                    String string = ((ConfigurationItemData)applications.head()).getId();
                    String string2 = packageInfo.getApplicationId();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), ((ConfigurationItemData)applications.head()).getId());
                    }
                }
                String appId = ((ConfigurationItemData)applications.head()).getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(43).append("Found more than 1 [").append(((ConfigurationItemData)applications.head()).getType()).append("] with the same name: [").append(applications.mkString(", ")).append("]").toString());
            }
        }
        return bl;
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions.IMPORT_UPGRADE : DeployitPermissions.IMPORT_INITIAL;
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", new Object[]{importerClass});
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(32).append("Could not instantiate importer: ").append(importerClass).toString(), e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", new Object[]{sourceArtifact});
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                $this.enricher().enrichArtifact(sourceArtifact);
            }
        } else {
            $this.logger().info(new StringBuilder(29).append("Resolving artifact ").append(sourceArtifact).append(" from url ").append(sourceArtifact.getFileUri()).toString());
            $this.resolveAndEnrichArtifact(sourceArtifact);
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            $this.enricher().enrichArtifact(sourceArtifact$1, new StreamFile(resolve$1.getFileName(), is));
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$2) {
        String string = x$2.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind()));
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)propertyDescriptor.get(ci$1)).asScala()).withFilter((Function1 & Serializable & scala.Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable & scala.Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactEnricher enricher, RepositoryHelper repositoryHelper) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.enricher = enricher;
        this.repositoryHelper = repositoryHelper;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
    }
}

