/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import com.caucho.hessian4.io.SerializerFactory;
import io.netty.channel.ChannelHandlerContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.io.InputStreamHandler;
import org.rzo.netty.ahessian.io.OutputStreamHandler;
import org.rzo.netty.ahessian.rpc.io.Hessian2Input;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.session.ServerSessionFilter;

public class HessianRPCCallDecoder
implements InputStreamConsumer,
Constants {
    HessianRPCServiceHandler _factory;
    SerializerFactory sFactory = new SerializerFactory();
    volatile Hessian2Input in = null;

    public HessianRPCCallDecoder() {
    }

    public HessianRPCCallDecoder(AbstractSerializerFactory serializerFactory) {
        if (serializerFactory != null) {
            this.sFactory.addFactory(serializerFactory);
        }
    }

    @Override
    public void consume(ChannelHandlerContext ctx, InputStream inx) {
        HessianRPCCallMessage result = null;
        boolean getNextMessage = true;
        if (this.in == null || this.in.isClosed() || this.in.getInputStream() != inx) {
            this.in = new Hessian2Input(inx);
            this.in.setSerializerFactory(this.sFactory);
        }
        while (ctx.channel().isActive() && getNextMessage) {
            try {
                if (this.in.bufferEmpty()) break;
                int ch = this.in.read();
                if (ch != 72) {
                    if (ch == 0) {
                        ahessianLogger.info("H expected got Ping");
                        continue;
                    }
                    ahessianLogger.warn("H expected got 0x" + Integer.toHexString(ch & 0xFF) + " (" + (char)ch + ")");
                    continue;
                }
                this.in.read();
                this.in.read();
                this.in.readEnvelope();
                String h = this.in.readString();
                if (!"H".equals(h)) {
                    ahessianLogger.warn("missing header");
                    continue;
                }
                HashMap<Object, Object> headers = new HashMap<Object, Object>();
                String methodName = null;
                ArrayList<Object> values = new ArrayList<Object>();
                int l = this.in.readInt();
                for (int i = 0; i < l; ++i) {
                    Integer key = this.in.readInt();
                    Object value = this.in.readObject();
                    headers.put(key, value);
                }
                this.in.readCall();
                methodName = this.in.readMethod();
                int argsLength = this.in.readInt();
                for (int i = 0; i < argsLength; ++i) {
                    values.add(this.in.readObject());
                }
                this.in.completeCall();
                this.in.completeEnvelope();
                this.in.resetReferences();
                result = new HessianRPCCallMessage(methodName, values.toArray(), headers, OutputStreamHandler.getOutputEncoder(ctx));
                result.setServer(true);
                result.setHasSessionFilter((Boolean)headers.get(HAS_SESSION_FILTER_HEADER_KEY));
                result.setSession(ServerSessionFilter.getSession(ctx));
                result.setHandler(InputStreamHandler.getHandler(ctx));
            }
            catch (Exception ex) {
                Constants.ahessianLogger.warn("", (Throwable)ex);
                result = null;
            }
            if (this.in.bufferEmpty()) {
                getNextMessage = false;
            }
            if (result == null) continue;
            ctx.fireChannelRead(result);
        }
    }

    @Override
    public boolean isBufferEmpty() {
        return this.in != null && this.in.bufferEmpty();
    }

    @Override
    public void setContext(ChannelHandlerContext ctx) {
        if (this.in == null) {
            this.in = new Hessian2Input(InputStreamHandler.getInputStream(ctx));
            this.in.setSerializerFactory(this.sFactory);
        }
    }
}

