/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.ClassBasedLocalDescriptor;
import com.xebialabs.deployit.booter.local.GenerateDeployableLocalDescriptor;
import com.xebialabs.deployit.booter.local.GeneratedParameterLocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.SyntheticLocalDescriptor;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TypeDefinitions {
    private final Map<Type, TypeDefinition> typeDefs = new HashMap<Type, TypeDefinition>();
    private LocalDescriptorRegistry registry;
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitions.class);

    public TypeDefinitions(LocalDescriptorRegistry registry) {
        this.registry = registry;
    }

    void defineType(Class clazz) {
        ClassBasedTypeDefinition typeDef = new ClassBasedTypeDefinition(clazz);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    public void addTypeDef(TypeDefinition typeDef) {
        OverthereUtils.checkState((!this.typeDefs.containsKey(typeDef.type) ? 1 : 0) != 0, (String)"Trying to register duplicate definition for type [%s]. Existing: [%s], duplicate: [%s]", (Object[])new Object[]{typeDef.type, this.typeDefs.get(typeDef.type), typeDef});
        this.typeDefs.put(typeDef.type, typeDef);
    }

    void defineType(Element element) {
        SyntheticBasedTypeDefinition typeDef = new SyntheticBasedTypeDefinition(element);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineGeneratedType(Element element, Element owner) {
        GeneratedTypeDefinition typeDef = new GeneratedTypeDefinition(owner, element);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineGeneratedParameterType(Element methodDef, Element type) {
        GeneratedParameterTypeDefinition typeDef = new GeneratedParameterTypeDefinition(type, methodDef);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void modifyType(Element element) {
        TypeMod typeMod = new TypeMod(XmlUtils.getRequiredTypeAttribute(element, "type"), element);
        OverthereUtils.checkState((boolean)this.typeDefs.containsKey(typeMod.type), (String)"Detected type-modification for non-existing type [%s]", (Object[])new Object[]{typeMod.type});
        this.typeDefs.get((Object)((TypeMod)typeMod).type).typeModifications.push(typeMod);
        logger.debug("Found: {}", (Object)typeMod);
    }

    public Collection<TypeDefinition> getDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeDefs.values());
    }

    TypeDefinition getDefinition(Type type) {
        return (TypeDefinition)OverthereUtils.checkNotNull((Object)this.typeDefs.get(type), (String)"Could not find a type definition associated with type [%s]", (Object[])new Object[]{type});
    }

    private static boolean isClassACi(Class<?> clazz) {
        return clazz != null && ConfigurationItem.class.isAssignableFrom(clazz);
    }

    private static Type type(Class<?> clazz) {
        if (TypeDefinitions.isClassACi(clazz)) {
            return Type.valueOf(clazz);
        }
        return null;
    }

    public static Type generatedParameterType(Type type, String name) {
        return Type.valueOf((String)(type.toString() + "_" + name));
    }

    class GeneratedParameterTypeDefinition
    extends TypeDefinition {
        private final Type owner;
        private final Element methodDef;

        public GeneratedParameterTypeDefinition(Element owner, Element methodDef) {
            this.owner = XmlUtils.getRequiredTypeAttribute(owner, "type");
            this.methodDef = methodDef;
            String methodName = XmlUtils.getRequiredStringAttribute(methodDef, "name");
            this.type = TypeDefinitions.generatedParameterType(this.owner, methodName);
            this.superType = Type.valueOf(Parameters.class);
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            if (!LocalDescriptorRegistry.exists((Type)this.owner)) {
                typeDefinitions.getDefinition(this.owner).register(typeDefinitions);
            }
            return new GeneratedParameterLocalDescriptor(this.type, this.methodDef);
        }
    }

    class GeneratedTypeDefinition
    extends SyntheticBasedTypeDefinition {
        Type owner;

        private GeneratedTypeDefinition(Element owner, Element generatedElement) {
            super(generatedElement);
            this.owner = XmlUtils.getRequiredTypeAttribute(owner, "type");
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            if (!LocalDescriptorRegistry.exists((Type)this.owner)) {
                typeDefinitions.getDefinition(this.owner).register(typeDefinitions);
            }
            return new GenerateDeployableLocalDescriptor((SyntheticLocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)this.owner));
        }
    }

    class SyntheticBasedTypeDefinition
    extends TypeDefinition {
        private Element element;

        public SyntheticBasedTypeDefinition(Element element) {
            this.element = element;
            this.type = XmlUtils.getRequiredTypeAttribute(element, "type");
            this.superType = XmlUtils.getRequiredTypeAttribute(element, "extends");
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            return new SyntheticLocalDescriptor(this.element);
        }
    }

    class ClassBasedTypeDefinition
    extends TypeDefinition {
        private Class<? extends ConfigurationItem> clazz;
        private List<Type> interfaces;

        public ClassBasedTypeDefinition(Class<? extends ConfigurationItem> ci) {
            this.interfaces = new ArrayList<Type>();
            this.type = TypeDefinitions.type(ci);
            this.superType = TypeDefinitions.type(ci.getSuperclass());
            this.interfaces = ReflectionUtils.getAllInterfaces(ci).stream().filter(x$0 -> TypeDefinitions.isClassACi(x$0)).map(Type::valueOf).collect(Collectors.toList());
            this.clazz = ci;
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            for (Type anInterface : this.interfaces) {
                if (LocalDescriptorRegistry.exists((Type)anInterface)) continue;
                typeDefinitions.getDefinition(anInterface).register(typeDefinitions);
            }
            return new ClassBasedLocalDescriptor(this.clazz);
        }

        @Override
        protected void registerAsSubtype(Type type) {
            super.registerAsSubtype(type);
            for (Type anInterface : this.interfaces) {
                this.registerSuperType(anInterface, type);
            }
        }
    }

    public abstract class TypeDefinition {
        Type type;
        Type superType;
        Deque<TypeMod> typeModifications = new ArrayDeque<TypeMod>();

        public void setType(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public Type getSuperType() {
            return this.superType;
        }

        public void setSuperType(Type superType) {
            this.superType = superType;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.type + "]";
        }

        public final void register(TypeDefinitions typeDefinitions) {
            if (LocalDescriptorRegistry.exists((Type)this.type)) {
                return;
            }
            if (this.superType != null && !LocalDescriptorRegistry.exists((Type)this.superType)) {
                typeDefinitions.getDefinition(this.superType).register(typeDefinitions);
            }
            LocalDescriptor descriptor = this.createDescriptor(typeDefinitions);
            TypeDefinitions.this.registry.register(descriptor);
            this.applyTypeModifications(descriptor);
        }

        protected abstract LocalDescriptor createDescriptor(TypeDefinitions var1);

        void applyTypeModifications(LocalDescriptor descriptor) {
            for (TypeMod typeModification : this.typeModifications) {
                descriptor.applyTypeModification(typeModification.modification);
            }
        }

        final void registerTypeTree() {
            this.registerAsSubtype(this.type);
        }

        protected void registerAsSubtype(Type type) {
            if (this.superType != null) {
                this.registerSuperType(this.superType, type);
                TypeDefinitions.this.getDefinition(this.superType).registerAsSubtype(type);
            }
        }

        protected void registerSuperType(Type superType, Type type) {
            TypeDefinitions.this.registry.registerSubtype(superType, type);
        }
    }

    class TypeMod {
        private Type type;
        private Element modification;

        protected TypeMod(Type type, Element modification) {
            this.type = type;
            this.modification = modification;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.type + "]";
        }
    }
}

