/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.artifact.resolution;

import com.xebialabs.deployit.engine.spi.artifact.resolution.ArtifactResolver;
import com.xebialabs.deployit.engine.spi.artifact.resolution.CannotLocateArtifactException;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import java.io.Serializable;
import java.net.URI;
import nl.javadude.scannit.Scannit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ArtifactResolverRegistry$ {
    public static ArtifactResolverRegistry$ MODULE$;
    private Map<String, ArtifactResolver> lookupTable;
    private final Seq<String> storedArtifactSchemes;
    private volatile boolean bitmap$0;

    static {
        new ArtifactResolverRegistry$();
    }

    private Map<String, ArtifactResolver> lookupTable$lzycompute() {
        ArtifactResolverRegistry$ artifactResolverRegistry$ = this;
        synchronized (artifactResolverRegistry$) {
            if (!this.bitmap$0) {
                this.lookupTable = this.createLookupTable(Scannit.getInstance());
                this.bitmap$0 = true;
            }
        }
        return this.lookupTable;
    }

    private Map<String, ArtifactResolver> lookupTable() {
        return !this.bitmap$0 ? this.lookupTable$lzycompute() : this.lookupTable;
    }

    private final Seq<String> storedArtifactSchemes() {
        return this.storedArtifactSchemes;
    }

    public ArtifactResolver lookup(URI location) {
        return (ArtifactResolver)this.lookupTable().getOrElse((Object)location.getScheme(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(53).append("Can not find a resolver for ").append(Option$.MODULE$.apply((Object)location.getScheme()).getOrElse((Function0 & Serializable & scala.Serializable)() -> location.toString())).append(". Supported schemes are: ").append(MODULE$.lookupTable().keySet().mkString(",")).toString());
        });
    }

    public ArtifactResolver lookup(String location2) {
        return (ArtifactResolver)this.withLocation(location2, (Function1 & Serializable & scala.Serializable)location -> MODULE$.lookup((URI)location));
    }

    public ResolvedArtifactFile resolve(SourceArtifact artifact) {
        return (ResolvedArtifactFile)this.withLocation(artifact.getFileUri(), (Function1 & Serializable & scala.Serializable)l -> MODULE$.lookup((URI)l).resolveLocation(artifact));
    }

    public boolean validate(SourceArtifact artifact) {
        return BoxesRunTime.unboxToBoolean(this.withLocation(artifact.getFileUri(), (Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)ArtifactResolverRegistry$.$anonfun$validate$1(artifact, uri))));
    }

    public boolean isStoredArtifact(SourceArtifact artifact) {
        return artifact.getFileUri() == null || artifact.getFileUri().isEmpty() || BoxesRunTime.unboxToBoolean(this.withLocation(artifact.getFileUri(), (Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)ArtifactResolverRegistry$.$anonfun$isStoredArtifact$1(uri))));
    }

    public boolean isExternalArtifact(SourceArtifact artifact) {
        return !this.isStoredArtifact(artifact);
    }

    private <T> T withLocation(String location, Function1<URI, T> body) {
        Option option;
        block6: {
            Option option2;
            Try try_;
            Success success;
            boolean bl;
            block5: {
                bl = false;
                success = null;
                try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)location).map((Function1 & Serializable & scala.Serializable)x$1 -> new URI((String)x$1)));
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new CannotLocateArtifactException(e);
                }
                if (!(try_ instanceof Success)) break block5;
                bl = true;
                success = (Success)try_;
                option = (Option)success.value();
                if (option instanceof Some) break block6;
            }
            if (bl && None$.MODULE$.equals(option2 = (Option)success.value())) {
                throw new CannotLocateArtifactException("Passed a 'null' artifact location.");
            }
            throw new MatchError((Object)try_);
        }
        Some some = (Some)option;
        URI uri = (URI)some.value();
        Object object = body.apply((Object)uri);
        return (T)object;
    }

    public Map<String, ArtifactResolver> createLookupTable(Scannit scannit) {
        return (Map)ImplicitConversions$.MODULE$.set$u0020asScala(scannit.getTypesAnnotatedWith(ArtifactResolver.Resolver.class)).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(m, c) -> {
            if (!ArtifactResolver.class.isAssignableFrom((Class<?>)c)) {
                throw new IllegalStateException(new StringBuilder(33).append("Class ").append(c).append(" annotated with ").append(ArtifactResolver.Resolver.class).append(" is not an ").append(ArtifactResolver.class).toString());
            }
            ArtifactResolver.Resolver resolver = c.getAnnotation(ArtifactResolver.Resolver.class);
            Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolver.protocols())).find((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)m.contains((Object)key)));
            if (option instanceof Some) {
                Some some = (Some)option;
                String protocol = (String)some.value();
                throw new IllegalStateException(new StringBuilder(47).append("Found duplicate artifact resolver for protocol ").append(protocol).toString());
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            ArtifactResolver instance = (ArtifactResolver)c.newInstance();
            Map map = m.$plus$plus((GenTraversableOnce)((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolver.protocols())).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2(x$2, (Object)instance), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            return map;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(SourceArtifact artifact$2, URI uri) {
        return MODULE$.lookup(uri).validateCorrectness(artifact$2);
    }

    public static final /* synthetic */ boolean $anonfun$isStoredArtifact$1(URI uri) {
        return MODULE$.storedArtifactSchemes().contains((Object)uri.getScheme());
    }

    private ArtifactResolverRegistry$() {
        MODULE$ = this;
        this.storedArtifactSchemes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jcr", "internal"}));
    }
}

