/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.core.rest.util.RepositoryHelper;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001\u0002\u00180\u0001iB\u0001b\u0012\u0001\u0003\u0002\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0019!C\u0001!\"A\u0011\f\u0001B\u0001B\u0003&\u0011\n\u0003\u0005[\u0001\t\u0005\r\u0011\"\u0001\\\u0011!\u0011\u0007A!a\u0001\n\u0003\u0019\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0015\u0002/\t\u0011\u0019\u0004!\u00111A\u0005\u0002\u001dD\u0001B\u001c\u0001\u0003\u0002\u0004%\ta\u001c\u0005\tc\u0002\u0011\t\u0011)Q\u0005Q\"A!\u000f\u0001BA\u0002\u0013\u00051\u000f\u0003\u0005\u007f\u0001\t\u0005\r\u0011\"\u0001\u0000\u0011%\t\u0019\u0001\u0001B\u0001B\u0003&A\u000f\u0003\u0006\u0002\u0006\u0001\u0011\t\u0019!C\u0001\u0003\u000fA!\"!\b\u0001\u0005\u0003\u0007I\u0011AA\u0010\u0011)\t\u0019\u0003\u0001B\u0001B\u0003&\u0011\u0011\u0002\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA,\u0011%\t)\b\u0001b\u0001\n\u0013\t9\b\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA=\u0011%\t9\t\u0001b\u0001\n\u0013\tI\t\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAF\u0011-\tY\u000b\u0001a\u0001\u0002\u0004%I!!,\t\u0017\u0005m\u0006\u00011AA\u0002\u0013%\u0011Q\u0018\u0005\f\u0003\u0003\u0004\u0001\u0019!A!B\u0013\ty\u000bC\u0004\u0002D\u0002!\t!!2\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003{\u0004A\u0011IA\u0000\u0011\u001d\u0011Y\u0001\u0001C\t\u0005\u001bAqA!\t\u0001\t\u0013\u0011\u0019\u0003C\u0004\u0003*\u0001!IAa\u000b\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!\u0011\f\u0001\u0005\n\tm\u0003b\u0002B1\u0001\u0011%!1\r\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001bCqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003.\u0002!IAa,\t\u000f\t]\u0004\u0001\"\u0003\u00036\"9!\u0011\u0018\u0001\u0005\n\tm\u0006b\u0002B`\u0001\u0011%!\u0011\u0019\u0005\b\u0005\u0017\u0004A\u0011\u0002Bg\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005'\u00141#S7q_J$XM]*feZL7-Z%na2T!\u0001M\u0019\u0002\u0011%l\u0007o\u001c:uKJT!AM\u001a\u0002\u000fM,'O^5dK*\u0011A'N\u0001\tI\u0016\u0004Hn\\=ji*\u0011agN\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001O\u0001\u0004G>l7\u0001A\n\u0004\u0001m\u001a\u0005C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011a\u0017M\\4\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0011+U\"A\u0018\n\u0005\u0019{#aD%na>\u0014H/\u001a:TKJ4\u0018nY3\u0002#I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-F\u0001J!\tQU*D\u0001L\u0015\ta5'\u0001\u0006sKB|7/\u001b;pefL!AT&\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-A\u000bsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRDq\u0001\u0017\u0002\u0002\u0002\u0003\u0007\u0011*A\u0002yIE\n!C]3q_NLGo\u001c:z'\u0016\u0014h/[2fA\u0005Y!o\u001c7f'\u0016\u0014h/[2f+\u0005a\u0006CA/a\u001b\u0005q&BA04\u0003!\u0019XmY;sSRL\u0018BA1_\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u001fI|G.Z*feZL7-Z0%KF$\"!\u00153\t\u000fa+\u0011\u0011!a\u00019\u0006a!o\u001c7f'\u0016\u0014h/[2fA\u0005Ia/\u00197jI\u0006$xN]\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.M\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017BA7k\u0005%1\u0016\r\\5eCR|'/A\u0007wC2LG-\u0019;pe~#S-\u001d\u000b\u0003#BDq\u0001\u0017\u0005\u0002\u0002\u0003\u0007\u0001.\u0001\u0006wC2LG-\u0019;pe\u0002\nqa]2b]:,'/F\u0001u!\t)H0D\u0001w\u0015\t9\b0\u0001\u0007qY\u0006\u001cW\r[8mI\u0016\u00148O\u0003\u0002zu\u0006A\u0001/Y2lC\u001e,'O\u0003\u0002|k\u0005A\u0001\u0010\u001c3fa2|\u00170\u0003\u0002~m\n)2k\\;sG\u0016\f%\u000f^5gC\u000e$8kY1o]\u0016\u0014\u0018aC:dC:tWM]0%KF$2!UA\u0001\u0011\u001dA6\"!AA\u0002Q\f\u0001b]2b]:,'\u000fI\u0001\u0011e\u0016\u0004xn]5u_JL\b*\u001a7qKJ,\"!!\u0003\u0011\t\u0005-\u0011\u0011D\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!Q\u000f^5m\u0015\u0011\t\u0019\"!\u0006\u0002\tI,7\u000f\u001e\u0006\u0004\u0003/\u0019\u0014\u0001B2pe\u0016LA!a\u0007\u0002\u000e\t\u0001\"+\u001a9pg&$xN]=IK2\u0004XM]\u0001\u0015e\u0016\u0004xn]5u_JL\b*\u001a7qKJ|F%Z9\u0015\u0007E\u000b\t\u0003\u0003\u0005Y\u001d\u0005\u0005\t\u0019AA\u0005\u0003E\u0011X\r]8tSR|'/\u001f%fYB,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u0011\u0005\u0011\u0003\u0001\"B$\u0011\u0001\u0004I\u0005\"\u0002.\u0011\u0001\u0004a\u0006\"\u00024\u0011\u0001\u0004A\u0007\"\u0002:\u0011\u0001\u0004!\bbBA\u0003!\u0001\u0007\u0011\u0011\u0002\u0015\u0004!\u0005]\u0002\u0003BA\u001d\u0003\u001fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u000bC:tw\u000e^1uS>t'\u0002BA!\u0003\u0007\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002F\u0005\u001d\u0013!\u00022fC:\u001c(\u0002BA%\u0003\u0017\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u001b\n1a\u001c:h\u0013\u0011\t\t&a\u000f\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!C5na>\u0014H/\u001a:t+\t\t9\u0006\u0005\u0004\u0002Z\u0005u\u0013\u0011M\u0007\u0003\u00037R1!a\u0004@\u0013\u0011\ty&a\u0017\u0003\t1K7\u000f\u001e\t\u0005\u0003G\ny'\u0004\u0002\u0002f)\u0019\u0001'a\u001a\u000b\t\u0005%\u00141N\u0001\u0004CBL'bAA7g\u000511/\u001a:wKJLA!!\u001d\u0002f\tA\u0011*\u001c9peR,'/\u0001\u0006j[B|'\u000f^3sg\u0002\na\u0001\\8hO\u0016\u0014XCAA=!\u0011\tY(!!\u000e\u0005\u0005u$\u0002BA@\u0003\u0017\nQa\u001d7gi)LA!a!\u0002~\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\tjg\u000e{G\u000e\\3di&|gnS5oIV\u0011\u00111\u0012\t\b%\u00065\u0015\u0011SAR\u0013\r\tyi\u0015\u0002\n\rVt7\r^5p]F\u0002B!a%\u0002 6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0004sK\u001adWm\u0019;\u000b\t\u0005%\u00141\u0014\u0006\u0004\u0003;\u001b\u0014A\u00029mk\u001eLg.\u0003\u0003\u0002\"\u0006U%\u0001\u0004)s_B,'\u000f^=LS:$\u0007c\u0001*\u0002&&\u0019\u0011qU*\u0003\u000f\t{w\u000e\\3b]\u0006\t\u0012n]\"pY2,7\r^5p].Kg\u000e\u001a\u0011\u00025%l\u0007o\u001c:uC\ndW\rU1dW\u0006<W\rR5sK\u000e$xN]=\u0016\u0005\u0005=\u0006\u0003BAY\u0003ok!!a-\u000b\u0007\u0005Uv(\u0001\u0002j_&!\u0011\u0011XAZ\u0005\u00111\u0015\u000e\\3\u0002=%l\u0007o\u001c:uC\ndW\rU1dW\u0006<W\rR5sK\u000e$xN]=`I\u0015\fHcA)\u0002@\"A\u0001\fGA\u0001\u0002\u0004\ty+A\u000ej[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u0018\u0010I\u0001\u000eS:LG/S7q_J$XM]:\u0015\u0003EC3AGAe!\u0011\tY-a5\u000e\u0005\u00055'\u0002BA\u001f\u0003\u001fT!!!5\u0002\u000b)\fg/\u0019=\n\t\u0005U\u0017Q\u001a\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002;\u001d,G/S7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef$\"!a,\u0002;M,G/S7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef$2!UAp\u0011\u001d\tY\u000b\ba\u0001\u0003_\u000bA\u0002\\5tiB\u000b7m[1hKN$\"!!:\u0011\r\u0005e\u0013QLAt!\u0011\tI/a>\u000f\t\u0005-\u00181\u001f\t\u0004\u0003[\u001cVBAAx\u0015\r\t\t0O\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U8+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\fYP\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003k\u001c\u0016!D5na>\u0014H\u000fU1dW\u0006<W\r\u0006\u0003\u0002h\n\u0005\u0001b\u0002B\u0002=\u0001\u0007!QA\u0001\u0007g>,(oY3\u0011\t\u0005\r$qA\u0005\u0005\u0005\u0013\t)G\u0001\u0007J[B|'\u000f^*pkJ\u001cW-A\bdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o)\u0015\t&q\u0002B\u000f\u0011\u001d\u0011\tb\ba\u0001\u0005'\t!\u0002]3s[&\u001c8/[8o!\u0011\u0011)B!\u0007\u000e\u0005\t]!b\u0001B\t=&!!1\u0004B\f\u0005)\u0001VM]7jgNLwN\u001c\u0005\b\u0005?y\u0002\u0019AAt\u0003QygnQ8oM&<WO]1uS>t\u0017\n^3ng\u0006AAm\\%na>\u0014H\u000f\u0006\u0004\u0002h\n\u0015\"q\u0005\u0005\b\u0005\u0007\u0001\u0003\u0019\u0001B\u0003\u0011\u0019\u0001\u0004\u00051\u0001\u0002b\u0005\u00012oY1o!2\f7-\u001a5pY\u0012,'o\u001d\u000b\u0006#\n5\"q\u0007\u0005\b\u0005_\t\u0003\u0019\u0001B\u0019\u0003=IW\u000e]8si\u0016$\u0007+Y2lC\u001e,\u0007\u0003BA2\u0005gIAA!\u000e\u0002f\ty\u0011*\u001c9peR,G\rU1dW\u0006<W\rC\u0004\u0003:\u0005\u0002\rAa\u000f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002d\tu\u0012\u0002\u0002B \u0003K\u0012\u0001#S7q_J$\u0018N\\4D_:$X\r\u001f;\u00021I,7o\u001c7wK\u0006sG-\u00128sS\u000eD\u0017I\u001d;jM\u0006\u001cG\u000fF\u0002R\u0005\u000bBqAa\u0012#\u0001\u0004\u0011I%\u0001\bt_V\u00148-Z!si&4\u0017m\u0019;\u0011\t\t-#QK\u0007\u0003\u0005\u001bRAAa\u0014\u0003R\u0005A\u0011M\u001d;jM\u0006\u001cGO\u0003\u0003\u0003T\u0005e\u0015aA;e[&!!q\u000bB'\u00059\u0019v.\u001e:dK\u0006\u0013H/\u001b4bGR\fQ#[:BeRLg-Y2u!J,WI\u001c:jG\",G\r\u0006\u0003\u0002$\nu\u0003b\u0002B0G\u0001\u0007!\u0011J\u0001\u000bI\u0016\u0004Hn\\=bE2,\u0017!D2iK\u000e\\\u0017*\u001c9peR,G\rF\u0002R\u0005KBqAa\u001a%\u0001\u0004\u0011I'A\u0006qC\u000e\\\u0017mZ3J]\u001a|\u0007\u0003BA2\u0005WJAA!\u001c\u0002f\tY\u0001+Y2lC\u001e,\u0017J\u001c4p\u00039\u0019'/Z1uK\u0016sG/\u001b;jKN$r!\u0015B:\u0005k\u0012I\bC\u0004\u00030\u0015\u0002\rA!\r\t\u000f\t]T\u00051\u0001\u0002$\u0006I\u0011n]+qOJ\fG-\u001a\u0005\b\u0005w*\u0003\u0019\u0001B?\u0003E!xn\u0011:fCR,7i\u001c7mK\u000e$xN\u001d\t\u0007\u00033\u0012yHa!\n\t\t\u0005\u00151\f\u0002\u0004'\u0016$\b\u0003\u0002BC\u0005\u000fk!A!\u0015\n\t\t%%\u0011\u000b\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017A\u00064jYR,'/\u0012=jgRLgn\u001a)bG.\fw-Z:\u0015\t\t=%\u0011\u0014\t\u0007\u0003S\u0014\tJa%\n\t\t\u0005\u00151 \t\u0005\u0003'\u0013)*\u0003\u0003\u0003\u0018\u0006U%A\u0005)s_B,'\u000f^=EKN\u001c'/\u001b9u_JDqAa''\u0001\u0004\u0011i*A\u0004wKJ\u001c\u0018n\u001c8\u0011\t\t\u0015%qT\u0005\u0005\u0005C\u0013\tFA\u0004WKJ\u001c\u0018n\u001c8\u0002=\r\u0014X-\u0019;f\u001d\u0016\u001cH/\u001a3D_:4\u0017nZ;sCRLwN\\%uK6\u001cH#B)\u0003(\n-\u0006b\u0002BUO\u0001\u0007!1Q\u0001\u0003G&DqAa\u001f(\u0001\u0004\u0011i(\u0001\u0005wC2LG-\u0019;f)\r\t&\u0011\u0017\u0005\b\u0005gC\u0003\u0019\u0001B?\u0003!!xn\u0011:fCR,G\u0003BAR\u0005oCqAa\u001a*\u0001\u0004\u0011I'A\u0004baBt\u0015-\\3\u0015\t\u0005\u001d(Q\u0018\u0005\b\u0005OR\u0003\u0019\u0001B5\u0003I\u0019XOY*ue&tw-\u00114uKJd\u0015m\u001d;\u0015\r\u0005\u001d(1\u0019Bd\u0011\u001d\u0011)m\u000ba\u0001\u0003O\f\u0011a\u001d\u0005\b\u0005\u0013\\\u0003\u0019AAt\u0003\r\u0019X\r]\u0001\u0014gV\u00147\u000b\u001e:j]\u001e\u0014UMZ8sK2\u000b7\u000f\u001e\u000b\u0007\u0003O\u0014yM!5\t\u000f\t\u0015G\u00061\u0001\u0002h\"9!\u0011\u001a\u0017A\u0002\u0005\u001dH#B)\u0003V\n]\u0007b\u0002B<[\u0001\u0007\u00111\u0015\u0005\b\u0005Oj\u0003\u0019\u0001B5\u0001")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactScanner scanner;
    private RepositoryHelper repositoryHelper;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactScanner scanner() {
        return this.scanner;
    }

    public void scanner_$eq(SourceArtifactScanner x$1) {
        this.scanner = x$1;
    }

    public RepositoryHelper repositoryHelper() {
        return this.repositoryHelper;
    }

    public void repositoryHelper_$eq(RepositoryHelper x$1) {
        this.repositoryHelper = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", new Object[]{importerClasses});
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(importerClasses).asScala()).filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable & scala.Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", new Object[]{XmlManifestDarImporter.class});
        this.logger().info("Importers configured in XL Deploy: {}", new Object[]{this.importers()});
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)List$.MODULE$.apply((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable & scala.Serializable)importer -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((ListableImporter)importer).list(this.importablePackageDirectory())).asScala()).map((Function1 & Serializable & scala.Serializable)pkgFound -> pkgFound, Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).asJava()));
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        try {
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Importer importer = (Importer)some.value();
            String string2 = this.doImport(source, importer);
            string = string2;
        }
        finally {
            source.cleanUp();
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.repositoryHelper().publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        block0: {
            if (!(importedPackage.getVersion() instanceof DeploymentPackage)) break block0;
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).asScala()).foreach((Function1 & Serializable & scala.Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable & scala.Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringBuilder(53).append("Could not open stream of uri ").append(sourceArtifact.getFileUri()).append(" of unresolved artifact ").append(sourceArtifact).toString(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        void var2_2;
        boolean isPreEnrichedArtifact = deployable.hasProperty("preScannedPlaceholders") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preScannedPlaceholders"));
        this.logger().info(new StringBuilder(26).append("Artifact ").append(deployable).append(" is ").append((Object)(isPreEnrichedArtifact ? "" : "not")).append(" pre-enriched").toString());
        return (boolean)var2_2;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(version.getType().getDescriptor().getPropertyDescriptors()).asScala()).toSet();
        return !(version instanceof CompositePackage) ? propertyDescriptors : (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$2)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(propertyDescriptors).asScala()).withFilter((Function1 & Serializable & scala.Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        Seq msgs = (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(toCreate).asScala()).foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, tc) -> {
            Seq validated = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.validator().validate(tc, (java.util.List)Lists.newArrayList((Iterable)toCreate))).asScala();
            return validated.nonEmpty() ? (Seq)acc.$plus$plus((GenTraversableOnce)validated, Seq$.MODULE$.canBuildFrom()) : acc;
        });
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean bl;
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).asScala()).toList();
        int n = applications.length();
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                if (locationSpecified) {
                    String string = ((ConfigurationItemData)applications.head()).getId();
                    String string2 = packageInfo.getApplicationId();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), ((ConfigurationItemData)applications.head()).getId());
                    }
                }
                String appId = ((ConfigurationItemData)applications.head()).getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(43).append("Found more than 1 [").append(((ConfigurationItemData)applications.head()).getType()).append("] with the same name: [").append(applications.mkString(", ")).append("]").toString());
            }
        }
        return bl;
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions.IMPORT_UPGRADE : DeployitPermissions.IMPORT_INITIAL;
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", new Object[]{importerClass});
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(32).append("Could not instantiate importer: ").append(importerClass).toString(), e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", new Object[]{sourceArtifact});
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact).addChecksumAndScan($this.scanner());
            }
        } else {
            $this.logger().info(new StringBuilder(29).append("Resolving artifact ").append(sourceArtifact).append(" from url ").append(sourceArtifact.getFileUri()).toString());
            $this.resolveAndEnrichArtifact(sourceArtifact);
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact$1).addChecksumAndScan($this.scanner(), resolve$1.getFileName(), is);
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$2) {
        String string = x$2.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind()));
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)propertyDescriptor.get(ci$1)).asScala()).withFilter((Function1 & Serializable & scala.Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable & scala.Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactScanner scanner, RepositoryHelper repositoryHelper) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.scanner = scanner;
        this.repositoryHelper = repositoryHelper;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
    }
}

