/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.InsertCommand;
import com.xebialabs.deployit.repository.sql.reader.CiReader;
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificInserter;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\r\u001b\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0006\u0004%\t%\f\u0005\nu\u0001\u0011\t\u0011)A\u0005]mB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD!\"!\r\u0001\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\ty\u0004\u0001B\u0001B\u0003%\u0011\u0011\t\u0005\u000b\u0003+\u0002!Q1A\u0005\u0002\u0005]\u0003BCA;\u0001\t\u0005\t\u0015!\u0003\u0002Z!Q\u0011q\u000f\u0001\u0003\u0006\u0004%\u0019!!\u001f\t\u0015\u0005\u001d\u0005A!A!\u0002\u0013\tY\bC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!!>\u0001\t\u0013\t9\u0010C\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n\tY1i\u001c9z\u0007>lW.\u00198e\u0015\tYB$\u0001\u0005d_6l\u0017M\u001c3t\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\"E\u0005AA-\u001a9m_fLGO\u0003\u0002$I\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S)j\u0011AG\u0005\u0003Wi\u0011Q\"\u00138tKJ$8i\\7nC:$\u0017\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u0018\u0011\u0005=BT\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001B2pe\u0016T!a\r\u001b\u0002\t)$'m\u0019\u0006\u0003kY\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0002$\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017!\u00046eE\u000e$V-\u001c9mCR,\u0007%\u0003\u0002-U\u0005\u0011\u0012M\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z!\tq\u0014)D\u0001@\u0015\t\u0001E$A\u0005beRLg-Y2ug&\u0011!i\u0010\u0002\u0013\u0003J$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u00180\u0001\fbeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z!\tqT)\u0003\u0002G\u007f\t1\u0012I\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u00180A\ndS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002J\u00156\tA$\u0003\u0002L9\t\u00192)\u001b%jgR|'/\u001f*fa>\u001c\u0018\u000e^8ss\u0006\t\u0002/Y:to>\u0014H-\u00128def\u0004H/\u001a:\u0011\u00059\u000bV\"A(\u000b\u0005A\u0003\u0013\u0001B;uS2L!AU(\u0003#A\u000b7o]<pe\u0012,en\u0019:zaR,'/\u0001\tmS\u000e,gn]3DS\u000e{WO\u001c;feB\u0011Q\u000bW\u0007\u0002-*\u0011qKI\u0001\bY&\u001cWM\\:f\u0013\tIfK\u0001\tMS\u000e,gn]3DS\u000e{WO\u001c;fe\u0006A1-\u001b*fC\u0012,'\u000f\u0005\u0002]?6\tQL\u0003\u0002_9\u00051!/Z1eKJL!\u0001Y/\u0003\u0011\rK'+Z1eKJ\f1d\u0019:fCR,G+\u001f9f'B,7-\u001b4jG&s7/\u001a:uKJ\u001c\bCB2gQJ\f)\"D\u0001e\u0015\u0005)\u0017!B:dC2\f\u0017BA4e\u0005%1UO\\2uS>t'\u0007\u0005\u0002ja6\t!N\u0003\u0002lY\u00069!/\u001a4mK\u000e$(BA7o\u0003\r\t\u0007/\u001b\u0006\u0003_\u0002\na\u0001\u001d7vO&t\u0017BA9k\u0005\u0011!\u0016\u0010]3\u0011\u0007M\fyAD\u0002u\u0003\u0013q1!^A\u0003\u001d\r1\u00181\u0001\b\u0004o\u0006\u0005aB\u0001=\u0000\u001d\tIhP\u0004\u0002{{6\t1P\u0003\u0002}M\u00051AH]8pizJ\u0011!J\u0005\u0003G\u0011J!!\t\u0012\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\r\t9\u0001H\u0001\u0005E\u0006\u001cX-\u0003\u0003\u0002\f\u00055\u0011a\u00029bG.\fw-\u001a\u0006\u0004\u0003\u000fa\u0012\u0002BA\t\u0003'\u0011\u0001bQ5Q\u0017RK\b/\u001a\u0006\u0005\u0003\u0017\ti\u0001\u0005\u0004\u0002\u0018\u0005}\u0011Q\u0005\b\u0005\u00033\tiBD\u0002{\u00037I\u0011!Z\u0005\u0004\u0003\u0017!\u0017\u0002BA\u0011\u0003G\u0011A\u0001T5ti*\u0019\u00111\u00023\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u001d\u0003!\u0019\b/Z2jM&\u001c\u0017\u0002BA\u0018\u0003S\u0011A\u0003V=qKN\u0003XmY5gS\u000eLen]3si\u0016\u0014\u0018\u0001E2p[6\fg\u000e\u001a,bY&$\u0017\r^8s!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d=\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\t\u0005u\u0012q\u0007\u0002\u0011\u0007>lW.\u00198e-\u0006d\u0017\u000eZ1u_J\fac]2n)J\f7-Z1cS2LG/_*feZL7-\u001a\t\u0005\u0003\u0007\n\t&\u0004\u0002\u0002F)!\u0011qIA%\u0003\u001d\u0019XM\u001d<jG\u0016TA!a\u0013\u0002N\u0005\u00191m\\2\u000b\u0007\u0005=#%\u0001\u0006yYBd\u0017\r\u001e4pe6LA!a\u0015\u0002F\t12kQ'Ue\u0006\u001cW-\u00192jY&$\u0018pU3sm&\u001cW-A\u0004d_BL8)[:\u0016\u0005\u0005e\u0003CBA\f\u00037\ny&\u0003\u0003\u0002^\u0005\r\"\u0001C%uKJ\f'\r\\3\u0011\u000f9\u000b\t'!\u001a\u0002f%\u0019\u00111M(\u0003\u000bQ+\b\u000f\\3\u0011\t\u0005\u001d\u0014q\u000e\b\u0005\u0003S\nY\u0007\u0005\u0002{I&\u0019\u0011Q\u000e3\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t(a\u001d\u0003\rM#(/\u001b8h\u0015\r\ti\u0007Z\u0001\tG>\u0004\u0018pQ5tA\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\u0007u\t\tI\u0003\u00022A%!\u0011QQA@\u0005)\u0019\u0016\u000f\u001c#jC2,7\r^\u0001\fgFdG)[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0019\u0003\u001b\u000b\u0019*!&\u0002\u0018\u0006e\u00151TAO\u0003?\u000b\t+a)\u0002&\u0006\u001dF\u0003BAH\u0003#\u0003\"!\u000b\u0001\t\u000f\u0005]\u0004\u0003q\u0001\u0002|!)A\u0006\u0005a\u0001]!)A\b\u0005a\u0001{!)1\t\u0005a\u0001\t\")q\t\u0005a\u0001\u0011\")A\n\u0005a\u0001\u001b\")1\u000b\u0005a\u0001)\")!\f\u0005a\u00017\")\u0011\r\u0005a\u0001E\"9\u0011\u0011\u0007\tA\u0002\u0005M\u0002bBA !\u0001\u0007\u0011\u0011\t\u0005\b\u0003+\u0002\u0002\u0019AA-\u0003\u001d)\u00070Z2vi\u0016$B!!,\u00024B\u00191-a,\n\u0007\u0005EFM\u0001\u0003V]&$\bbBA[#\u0001\u0007\u0011qW\u0001\bG>tG/\u001a=u!\rI\u0013\u0011X\u0005\u0004\u0003wS\"\u0001E\"iC:<WmU3u\u0007>tG/\u001a=u\u0003!1\u0018\r\\5eCR,G\u0003BAW\u0003\u0003Dq!!.\u0013\u0001\u0004\t9,\u0001\u0003d_BLH\u0003CAW\u0003\u000f\fY-a4\t\u000f\u0005%7\u00031\u0001\u0002f\u00051aM]8n\u0013\u0012Dq!!4\u0014\u0001\u0004\t)'\u0001\u0003u_&#\u0007bBA['\u0001\u0007\u0011qW\u0001\u0012e\u0016\u0004H.Y2f%\u00164WM]3oG\u0016\u001cH\u0003BAW\u0003+Dq!a6\u0015\u0001\u0004\tI.\u0001\u0006sK\u001a,'/\u001a8dKN\u0004\u0002\"a\u001a\u0002\\\u0006\u0015\u0014q\\\u0005\u0005\u0003;\f\u0019HA\u0002NCB\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003Kd\u0017aA;e[&!\u0011\u0011^Ar\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\\u0001\rm\u0006d\u0017\u000eZ1uK\u000e{\u0007/\u001f\u000b\t\u0003[\u000by/!=\u0002t\"9\u0011\u0011Z\u000bA\u0002\u0005\u0015\u0004bBAg+\u0001\u0007\u0011Q\r\u0005\b\u0003k+\u0002\u0019AA\\\u0003!\u0011XM\\1nK\u000eKG\u0003CAW\u0003s\fi0a@\t\u000f\u0005mh\u00031\u0001\u0002`\u0006\u00111-\u001b\u0005\b\u0003\u00134\u0002\u0019AA3\u0011\u001d\tiM\u0006a\u0001\u0003K\nqa\u00197fC:,\u0006\u000f\u0006\u0003\u0002.\n\u0015\u0001bBA~/\u0001\u0007\u0011q\\\u0001\u000bm\u0006d\u0017\u000eZ1uK\u000eKG\u0003CAW\u0005\u0017\u0011iAa\u0004\t\u000f\u0005%\u0007\u00041\u0001\u0002f!9\u0011Q\u001a\rA\u0002\u0005\u0015\u0004bBA~1\u0001\u0007\u0011q\u001c")
public class CopyCommand
extends InsertCommand {
    private final ArtifactRepository artifactRepository;
    private final ArtifactDataRepository artifactDataRepository;
    private final CiReader ciReader;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> copyCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public Iterable<Tuple<String, String>> copyCis() {
        return this.copyCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.copy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateCopy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void copy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem oldCi = this.ciReader.readByPath(path, 0, false);
        this.validateCi(fromId, toId, oldCi);
        Buffer tuples = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringBuilder(2).append(path).append("/%").toString()})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache((Integer)package$.MODULE$.asCiPKType().apply(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            String copiedId = ci.getId();
            this.renameCi(ci, fromId, toId);
            this.cleanUp(ci);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)copiedId), (Object)ci);
        }, Buffer$.MODULE$.canBuildFrom());
        this.replaceReferences((scala.collection.immutable.Map<String, ConfigurationItem>)tuples.toMap(Predef$.MODULE$.$conforms()));
        this.insertCis((Iterable<ConfigurationItem>)((Iterable)tuples.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConfigurationItem currentCi;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ConfigurationItem configurationItem = currentCi = (ConfigurationItem)tuple2._2();
            return configurationItem;
        }, Buffer$.MODULE$.canBuildFrom())), context, (Function2<Integer, ConfigurationItem, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(ciPk, copiedCi) -> {
            CopyCommand.$anonfun$copy$4(this, fromId, toId, ciPk, copiedCi);
            return BoxedUnit.UNIT;
        });
        EventBusHolder.publish((Object)new CiCopiedEvent(oldCi, toId));
    }

    private void replaceReferences(scala.collection.immutable.Map<String, ConfigurationItem> references) {
        references.values().foreach((Function1 & Serializable & scala.Serializable)newCi -> {
            CopyCommand.$anonfun$replaceReferences$1(references, newCi);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCopy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0, this.ciReader.readByPath$default$3());
        this.validateCi(fromId, toId, ci);
        this.insertCisValidation((Iterable<ConfigurationItem>)((Iterable)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringBuilder(2).append(path).append("/%").toString()})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache((Integer)package$.MODULE$.asCiPKType().apply(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            this.renameCi(ci, fromId, toId);
            return ci;
        }, Buffer$.MODULE$.canBuildFrom())), context);
    }

    private void renameCi(ConfigurationItem ci, String fromId, String toId) {
        String newId = new StringBuilder(0).append(toId).append(ci.getId().substring(fromId.length())).toString();
        ci.setId(newId);
    }

    private void cleanUp(ConfigurationItem ci) {
        package$.MODULE$.asBaseConfigurationItem(ci, (Function1 & Serializable & scala.Serializable)baseCi -> {
            CopyCommand.$anonfun$cleanUp$1(baseCi);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCi(String fromId, String toId, ConfigurationItem ci) {
        Type type = ci.getType();
        Type type2 = Type.valueOf(Root.class);
        Checks.checkArgument(((type == null ? type2 != null : !type.equals(type2)) ? 1 : 0) != 0, (String)"Cannot copy root node [%s].", (Object[])new Object[]{toId});
        this.commandValidator.checkCopyAllowed(this.ciReader.readByPath((String)package$.MODULE$.parentPath(fromId).get(), 0, this.ciReader.readByPath$default$3()).getType(), this.ciReader.readByPath((String)package$.MODULE$.parentPath(toId).get(), 0, this.ciReader.readByPath$default$3()).getType());
        if (this.exists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
    }

    public static final /* synthetic */ void $anonfun$copy$4(CopyCommand $this, String fromId$1, String toId$1, Integer ciPk, ConfigurationItem copiedCi) {
        ConfigurationItem configurationItem = copiedCi;
        if (configurationItem instanceof SourceArtifact) {
            SourceArtifact sourceArtifact = (SourceArtifact)configurationItem;
            String fromCiId = new StringBuilder(0).append(fromId$1).append(sourceArtifact.getId().substring(toId$1.length())).toString();
            $this.artifactDataRepository.copy(fromCiId, ciPk);
            $this.artifactRepository.updateFilename(ciPk, $this.artifactRepository.getFilename(fromCiId));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceCiReference$1(PropertyDescriptor pd$1, ConfigurationItem newCi$1, scala.collection.immutable.Map references$1) {
        Object object = pd$1.get(newCi$1);
        if (object instanceof ConfigurationItem) {
            ConfigurationItem configurationItem = (ConfigurationItem)object;
            pd$1.set(newCi$1, references$1.getOrElse((Object)configurationItem.getId(), (Function0 & Serializable & scala.Serializable)() -> configurationItem));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceListReferences$1(PropertyDescriptor pd$1, ConfigurationItem newCi$1, scala.collection.immutable.Map references$1) {
        ListIterator itr = ((java.util.List)pd$1.get(newCi$1)).listIterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                itr.set(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$5(HashSet toAdd$1, Iterator itr$2, ConfigurationItem ci) {
        toAdd$1.add(ci);
        itr$2.remove();
    }

    private static final void replaceSetReferences$1(PropertyDescriptor pd$1, ConfigurationItem newCi$1, scala.collection.immutable.Map references$1) {
        HashSet toAdd = new HashSet();
        Set set = (Set)pd$1.get(newCi$1);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)ci -> {
                CopyCommand.$anonfun$replaceReferences$5(toAdd, itr, ci);
                return BoxedUnit.UNIT;
            });
        }
        set.addAll(toAdd);
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$2(ConfigurationItem newCi$1, scala.collection.immutable.Map references$1, PropertyDescriptor pd) {
        PropertyKind propertyKind = pd.getKind();
        if (PropertyKind.CI.equals(propertyKind)) {
            CopyCommand.replaceCiReference$1(pd, newCi$1, references$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.LIST_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceListReferences$1(pd, newCi$1, references$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.SET_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceSetReferences$1(pd, newCi$1, references$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi) {
        ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(newCi.getType().getDescriptor().getPropertyDescriptors()).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            CopyCommand.$anonfun$replaceReferences$2(newCi, references$1, pd);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanUp$1(BaseConfigurationItem baseCi) {
        baseCi.get$ciAttributes().setScmTraceabilityDataId(null);
    }

    public CopyCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, ArtifactDataRepository artifactDataRepository, CiHistoryRepository ciHistoryRepository, PasswordEncrypter passwordEncrypter, LicenseCiCounter licenseCiCounter, CiReader ciReader, Function2<Type, Integer, List<TypeSpecificInserter>> createTypeSpecificInserters, CommandValidator commandValidator, SCMTraceabilityService scmTraceabilityService, Iterable<Tuple<String, String>> copyCis, SqlDialect sqlDialect) {
        this.artifactRepository = artifactRepository;
        this.artifactDataRepository = artifactDataRepository;
        this.ciReader = ciReader;
        this.commandValidator = commandValidator;
        this.copyCis = copyCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository, artifactDataRepository, ciHistoryRepository, passwordEncrypter, licenseCiCounter, createTypeSpecificInserters, scmTraceabilityService);
    }
}

