/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.test;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.test.BeforeOAuth2Context;
import org.springframework.security.oauth2.client.test.OAuth2ContextConfiguration;
import org.springframework.security.oauth2.client.test.RestTemplateHolder;
import org.springframework.security.oauth2.client.test.TestAccounts;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;

public class OAuth2ContextSetup
extends TestWatchman {
    private static Log logger = LogFactory.getLog(OAuth2ContextSetup.class);
    private OAuth2ProtectedResourceDetails resource;
    private OAuth2RestTemplate client;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private final RestTemplateHolder clientHolder;
    private final TestAccounts testAccounts;
    private OAuth2AccessToken accessToken;
    private boolean initializeAccessToken = true;
    private RestOperations savedClient;
    private AccessTokenProvider accessTokenProvider;
    private final Environment environment;

    public static OAuth2ContextSetup withEnvironment(RestTemplateHolder clientHolder, Environment environment) {
        return new OAuth2ContextSetup(clientHolder, null, environment);
    }

    public static OAuth2ContextSetup withTestAccounts(RestTemplateHolder clientHolder, TestAccounts testAccounts) {
        return new OAuth2ContextSetup(clientHolder, testAccounts, null);
    }

    public static OAuth2ContextSetup standard(RestTemplateHolder clientHolder) {
        return new OAuth2ContextSetup(clientHolder, null, null);
    }

    private OAuth2ContextSetup(RestTemplateHolder clientHolder, TestAccounts testAccounts, Environment environment) {
        this.clientHolder = clientHolder;
        this.testAccounts = testAccounts;
        this.environment = environment;
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        this.initializeIfNecessary(method, target);
        return super.apply(base, method, target);
    }

    public void starting(FrameworkMethod method) {
        if (this.resource != null) {
            logger.info((Object)("Starting OAuth2 context for: " + this.resource));
            DefaultAccessTokenRequest request = new DefaultAccessTokenRequest();
            request.setAll(this.parameters);
            this.client = this.createRestTemplate(this.resource, request);
            if (this.initializeAccessToken) {
                this.accessToken = null;
                this.accessToken = this.getAccessToken();
            }
            this.savedClient = this.clientHolder.getRestTemplate();
            this.clientHolder.setRestTemplate(this.client);
        }
    }

    public void finished(FrameworkMethod method) {
        if (this.resource != null) {
            logger.info((Object)("Ending OAuth2 context for: " + this.resource));
            if (this.savedClient != null) {
                this.clientHolder.setRestTemplate(this.savedClient);
            }
        }
    }

    public void setAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public OAuth2AccessToken getAccessToken() {
        if (this.resource == null || this.client == null) {
            return null;
        }
        if (this.accessToken != null) {
            return this.accessToken;
        }
        if (this.accessTokenProvider != null) {
            this.client.setAccessTokenProvider(this.accessTokenProvider);
        }
        try {
            return this.client.getAccessToken();
        }
        catch (OAuth2AccessDeniedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
    }

    public OAuth2RestTemplate getRestTemplate() {
        return this.client;
    }

    public OAuth2ProtectedResourceDetails getResource() {
        return this.resource;
    }

    public AccessTokenRequest getAccessTokenRequest() {
        return this.client.getOAuth2ClientContext().getAccessTokenRequest();
    }

    public OAuth2ClientContext getOAuth2ClientContext() {
        return this.client.getOAuth2ClientContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary(FrameworkMethod method, Object target) {
        TestClass testClass = new TestClass(target.getClass());
        OAuth2ContextConfiguration contextConfiguration = this.findOAuthContextConfiguration(method, testClass);
        if (contextConfiguration == null) {
            return;
        }
        this.initializeAccessToken = contextConfiguration.initialize();
        this.resource = this.creatResource(target, contextConfiguration);
        List befores = testClass.getAnnotatedMethods(BeforeOAuth2Context.class);
        if (!befores.isEmpty()) {
            logger.debug((Object)"Running @BeforeOAuth2Context methods");
            for (FrameworkMethod before : befores) {
                RestOperations savedServerClient = this.clientHolder.getRestTemplate();
                OAuth2ContextConfiguration beforeConfiguration = this.findOAuthContextConfiguration(before, testClass);
                if (beforeConfiguration != null) {
                    OAuth2ProtectedResourceDetails resource = this.creatResource(target, beforeConfiguration);
                    DefaultAccessTokenRequest beforeRequest = new DefaultAccessTokenRequest();
                    beforeRequest.setAll(this.parameters);
                    OAuth2RestTemplate client = this.createRestTemplate(resource, beforeRequest);
                    this.clientHolder.setRestTemplate(client);
                }
                DefaultAccessTokenRequest request = new DefaultAccessTokenRequest();
                request.setAll(this.parameters);
                this.client = this.createRestTemplate(this.resource, request);
                List<FrameworkMethod> list = Arrays.asList(before);
                try {
                    new RunBefores(new Statement(){

                        public void evaluate() {
                        }
                    }, list, target).evaluate();
                }
                catch (AssumptionViolatedException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable e) {
                    logger.debug((Object)"Exception in befores", e);
                    Assert.assertThat((Object)e, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anything()));
                }
                finally {
                    this.clientHolder.setRestTemplate(savedServerClient);
                }
            }
        }
    }

    private OAuth2RestTemplate createRestTemplate(OAuth2ProtectedResourceDetails resource, AccessTokenRequest request) {
        DefaultOAuth2ClientContext context = new DefaultOAuth2ClientContext(request);
        OAuth2RestTemplate client = new OAuth2RestTemplate(resource, context);
        this.setupConnectionFactory(client);
        client.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse response) throws IOException {
                return false;
            }
        });
        if (this.accessTokenProvider != null) {
            client.setAccessTokenProvider(this.accessTokenProvider);
        }
        return client;
    }

    private void setupConnectionFactory(OAuth2RestTemplate client) {
        if (Boolean.getBoolean("http.components.enabled") && ClassUtils.isPresent((String)"org.apache.http.client.config.RequestConfig", null)) {
            client.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(){

                protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                    HttpClientContext context = HttpClientContext.create();
                    context.setRequestConfig(this.getRequestConfig());
                    return context;
                }

                protected RequestConfig getRequestConfig() {
                    RequestConfig.Builder builder = RequestConfig.custom().setCookieSpec("ignoreCookies").setAuthenticationEnabled(false).setRedirectsEnabled(false);
                    return builder.build();
                }
            });
        } else {
            client.setRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory(){

                protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
                    super.prepareConnection(connection, httpMethod);
                    connection.setInstanceFollowRedirects(false);
                }
            });
        }
    }

    private OAuth2ProtectedResourceDetails creatResource(Object target, OAuth2ContextConfiguration contextLoader) {
        Constructor constructor;
        Class<? extends OAuth2ProtectedResourceDetails> type = contextLoader.value();
        if (type == OAuth2ProtectedResourceDetails.class) {
            type = contextLoader.resource();
        }
        if ((constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{TestAccounts.class})) != null && this.testAccounts != null) {
            return (OAuth2ProtectedResourceDetails)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.testAccounts});
        }
        constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{Environment.class});
        if (constructor != null && this.environment != null) {
            return (OAuth2ProtectedResourceDetails)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.environment});
        }
        constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{Object.class});
        if (constructor != null) {
            return (OAuth2ProtectedResourceDetails)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{target});
        }
        return (OAuth2ProtectedResourceDetails)BeanUtils.instantiate(type);
    }

    private OAuth2ContextConfiguration findOAuthContextConfiguration(FrameworkMethod method, TestClass testClass) {
        OAuth2ContextConfiguration methodConfiguration = (OAuth2ContextConfiguration)method.getAnnotation(OAuth2ContextConfiguration.class);
        if (methodConfiguration != null) {
            return methodConfiguration;
        }
        if (testClass.getJavaClass().isAnnotationPresent(OAuth2ContextConfiguration.class)) {
            return testClass.getJavaClass().getAnnotation(OAuth2ContextConfiguration.class);
        }
        return null;
    }
}

