/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.core.rest.util.RepositoryHelper;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xldeploy.packager.StreamFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001B\u00193\u0001uB\u0001B\u0013\u0001\u0003\u0002\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0019!C\u0001'\"AA\f\u0001B\u0001B\u0003&A\n\u0003\u0005^\u0001\t\u0005\r\u0011\"\u0001_\u0011!)\u0007A!a\u0001\n\u00031\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0015B0\t\u0011%\u0004!\u00111A\u0005\u0002)D\u0001\"\u001d\u0001\u0003\u0002\u0004%\tA\u001d\u0005\ti\u0002\u0011\t\u0011)Q\u0005W\"AQ\u000f\u0001BA\u0002\u0013\u0005a\u000fC\u0005\u0000\u0001\t\u0005\r\u0011\"\u0001\u0002\u0002!I\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006Ka\u001e\u0005\u000b\u0003\u000f\u0001!\u00111A\u0005\u0002\u0005%\u0001BCA\u0010\u0001\t\u0005\r\u0011\"\u0001\u0002\"!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006K!a\u0003\t\u0015\u0005\u001d\u0002A!a\u0001\n\u0003\tI\u0003\u0003\u0006\u00028\u0001\u0011\t\u0019!C\u0001\u0003sA!\"!\u0010\u0001\u0005\u0003\u0005\u000b\u0015BA\u0016\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003B\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005=\u0005\u0001)A\u0005\u0003gB\u0011\"!%\u0001\u0005\u0004%I!a%\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003+C\u0011\"a)\u0001\u0005\u0004%I!!*\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003OC1\"a2\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002J\"Y\u0011q\u001b\u0001A\u0002\u0003\u0007I\u0011BAm\u0011-\ti\u000e\u0001a\u0001\u0002\u0003\u0006K!a3\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u00111\u001f\u0001\u0005B\u0005U\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003{\u0004A\u0011IA\u0000\u0011\u001d\u0011I\u0002\u0001C!\u00057AqAa\n\u0001\t#\u0011I\u0003C\u0004\u0003>\u0001!IAa\u0010\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005{\u0002A\u0011\u0002B@\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001bCqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u0003@\u0002!IA!1\t\u000f\t%\u0007\u0001\"\u0003\u0003L\"9!1\u0013\u0001\u0005\n\tE\u0007b\u0002Bk\u0001\u0011%!q\u001b\u0005\b\u00057\u0004A\u0011\u0002Bo\u0011\u001d\u00119\u000f\u0001C\u0005\u0005SDqAa\n\u0001\t\u0013\u0011yOA\nJ[B|'\u000f^3s'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u00024i\u0005A\u0011.\u001c9peR,'O\u0003\u00026m\u000591/\u001a:wS\u000e,'BA\u001c9\u0003!!W\r\u001d7ps&$(BA\u001d;\u0003%AXMY5bY\u0006\u00147OC\u0001<\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aH\u0012\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019y%M[3diB\u0011q\tS\u0007\u0002e%\u0011\u0011J\r\u0002\u0010\u00136\u0004xN\u001d;feN+'O^5dK\u0006\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\u001c\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002R\u001d\n\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002+I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cWm\u0018\u0013fcR\u0011AK\u0017\t\u0003+bk\u0011A\u0016\u0006\u0002/\u0006)1oY1mC&\u0011\u0011L\u0016\u0002\u0005+:LG\u000fC\u0004\\\u0005\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0013'\u0001\nsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\u0013a\u0003:pY\u0016\u001cVM\u001d<jG\u0016,\u0012a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0003EZ\n\u0001b]3dkJLG/_\u0005\u0003I\u0006\u00141BU8mKN+'O^5dK\u0006y!o\u001c7f'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002UO\"91,BA\u0001\u0002\u0004y\u0016\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013!\u0003<bY&$\u0017\r^8s+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u000185\u0003)1\u0018\r\\5eCRLwN\\\u0005\u0003a6\u0014\u0011BV1mS\u0012\fGo\u001c:\u0002\u001bY\fG.\u001b3bi>\u0014x\fJ3r)\t!6\u000fC\u0004\\\u0011\u0005\u0005\t\u0019A6\u0002\u0015Y\fG.\u001b3bi>\u0014\b%\u0001\u0005f]JL7\r[3s+\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003!\u0001\u0018mY6bO\u0016\u0014(B\u0001?9\u0003!AH\u000eZ3qY>L\u0018B\u0001@z\u0005Y\u0019v.\u001e:dK\u0006\u0013H/\u001b4bGR,eN]5dQ\u0016\u0014\u0018\u0001D3oe&\u001c\u0007.\u001a:`I\u0015\fHc\u0001+\u0002\u0004!91lCA\u0001\u0002\u00049\u0018!C3oe&\u001c\u0007.\u001a:!\u0003A\u0011X\r]8tSR|'/\u001f%fYB,'/\u0006\u0002\u0002\fA!\u0011QBA\u000e\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001B;uS2TA!!\u0006\u0002\u0018\u0005!!/Z:u\u0015\r\tIBN\u0001\u0005G>\u0014X-\u0003\u0003\u0002\u001e\u0005=!\u0001\u0005*fa>\u001c\u0018\u000e^8ss\"+G\u000e]3s\u0003Q\u0011X\r]8tSR|'/\u001f%fYB,'o\u0018\u0013fcR\u0019A+a\t\t\u0011ms\u0011\u0011!a\u0001\u0003\u0017\t\u0011C]3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:!\u0003e\u0019\u0007.Z2lgVl\u0017\t\\4pe&$\b.\u001c)s_ZLG-\u001a:\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005Eb'\u0001\u0005dQ\u0016\u001c7n];n\u0013\u0011\t)$a\f\u00033\rCWmY6tk6\fEnZ8sSRDW\u000e\u0015:pm&$WM]\u0001\u001eG\",7m[:v[\u0006cwm\u001c:ji\"l\u0007K]8wS\u0012,'o\u0018\u0013fcR\u0019A+a\u000f\t\u0011m\u000b\u0012\u0011!a\u0001\u0003W\t!d\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5n!J|g/\u001b3fe\u0002\na\u0001P5oSRtDCDA\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013q\n\t\u0003\u000f\u0002AQAS\nA\u00021CQ!X\nA\u0002}CQ![\nA\u0002-DQ!^\nA\u0002]Dq!a\u0002\u0014\u0001\u0004\tY\u0001C\u0004\u0002(M\u0001\r!a\u000b)\u0007M\t\u0019\u0006\u0005\u0003\u0002V\u0005-TBAA,\u0015\u0011\tI&a\u0017\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002^\u0005}\u0013a\u00024bGR|'/\u001f\u0006\u0005\u0003C\n\u0019'A\u0003cK\u0006t7O\u0003\u0003\u0002f\u0005\u001d\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005%\u0014aA8sO&!\u0011QNA,\u0005%\tU\u000f^8xSJ,G-A\u0005j[B|'\u000f^3sgV\u0011\u00111\u000f\t\u0007\u0003k\nI(! \u000e\u0005\u0005]$bAA\t\u0005&!\u00111PA<\u0005\u0011a\u0015n\u001d;\u0011\t\u0005}\u00141R\u0007\u0003\u0003\u0003S1aMAB\u0015\u0011\t))a\"\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002\nZ\naa]3sm\u0016\u0014\u0018\u0002BAG\u0003\u0003\u0013\u0001\"S7q_J$XM]\u0001\u000bS6\u0004xN\u001d;feN\u0004\u0013A\u00027pO\u001e,'/\u0006\u0002\u0002\u0016B!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006\u001d\u0014!B:mMRR\u0017\u0002BAP\u00033\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0011SN\u001cu\u000e\u001c7fGRLwN\\&j]\u0012,\"!a*\u0011\u000fU\u000bI+!,\u0002@&\u0019\u00111\u0016,\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAX\u0003wk!!!-\u000b\t\u0005M\u0016QW\u0001\be\u00164G.Z2u\u0015\u0011\t))a.\u000b\u0007\u0005ef'\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003{\u000b\tL\u0001\u0007Qe>\u0004XM\u001d;z\u0017&tG\rE\u0002V\u0003\u0003L1!a1W\u0005\u001d\u0011un\u001c7fC:\f\u0011#[:D_2dWm\u0019;j_:\\\u0015N\u001c3!\u0003iIW\u000e]8si\u0006\u0014G.\u001a)bG.\fw-\u001a#je\u0016\u001cGo\u001c:z+\t\tY\r\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\tNQ\u0001\u0003S>LA!!6\u0002P\n!a)\u001b7f\u0003yIW\u000e]8si\u0006\u0014G.\u001a)bG.\fw-\u001a#je\u0016\u001cGo\u001c:z?\u0012*\u0017\u000fF\u0002U\u00037D\u0001bW\u000e\u0002\u0002\u0003\u0007\u00111Z\u0001\u001cS6\u0004xN\u001d;bE2,\u0007+Y2lC\u001e,G)\u001b:fGR|'/\u001f\u0011\u0002\u001b%t\u0017\u000e^%na>\u0014H/\u001a:t)\u0005!\u0006fA\u000f\u0002fB!\u0011q]Ax\u001b\t\tIO\u0003\u0003\u0002Z\u0005-(BAAw\u0003\u0015Q\u0017M^1y\u0013\u0011\t\t0!;\u0003\u001bA{7\u000f^\"p]N$(/^2u\u0003u9W\r^%na>\u0014H/\u00192mKB\u000b7m[1hK\u0012K'/Z2u_JLHCAAf\u0003u\u0019X\r^%na>\u0014H/\u00192mKB\u000b7m[1hK\u0012K'/Z2u_JLHc\u0001+\u0002|\"9\u0011qY\u0010A\u0002\u0005-\u0017\u0001\u00047jgR\u0004\u0016mY6bO\u0016\u001cHC\u0001B\u0001!\u0019\t)(!\u001f\u0003\u0004A!!Q\u0001B\n\u001d\u0011\u00119Aa\u0004\u0011\u0007\t%a+\u0004\u0002\u0003\f)\u0019!Q\u0002\u001f\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\tBV\u0001\u0007!J,G-\u001a4\n\t\tU!q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tEa+A\u0007j[B|'\u000f\u001e)bG.\fw-\u001a\u000b\u0005\u0005\u0007\u0011i\u0002C\u0004\u0003 \u0005\u0002\rA!\t\u0002\rM|WO]2f!\u0011\tyHa\t\n\t\t\u0015\u0012\u0011\u0011\u0002\r\u00136\u0004xN\u001d;T_V\u00148-Z\u0001\u0010G\",7m\u001b)fe6L7o]5p]R)AKa\u000b\u0003:!9!Q\u0006\u0012A\u0002\t=\u0012A\u00039fe6L7o]5p]B!!\u0011\u0007B\u001b\u001b\t\u0011\u0019DC\u0002\u0003.\u0005LAAa\u000e\u00034\tQ\u0001+\u001a:nSN\u001c\u0018n\u001c8\t\u000f\tm\"\u00051\u0001\u0003\u0004\u0005!rN\\\"p]\u001aLw-\u001e:bi&|g.\u0013;f[N\f\u0001\u0002Z8J[B|'\u000f\u001e\u000b\u0007\u0005\u0007\u0011\tEa\u0011\t\u000f\t}1\u00051\u0001\u0003\"!11g\ta\u0001\u0003{\n\u0001c]2b]Bc\u0017mY3i_2$WM]:\u0015\u000bQ\u0013IEa\u0015\t\u000f\t-C\u00051\u0001\u0003N\u0005y\u0011.\u001c9peR,G\rU1dW\u0006<W\r\u0005\u0003\u0002\u0000\t=\u0013\u0002\u0002B)\u0003\u0003\u0013q\"S7q_J$X\r\u001a)bG.\fw-\u001a\u0005\b\u0005+\"\u0003\u0019\u0001B,\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u007f\u0012I&\u0003\u0003\u0003\\\u0005\u0005%\u0001E%na>\u0014H/\u001b8h\u0007>tG/\u001a=u\u0003a\u0011Xm]8mm\u0016\fe\u000eZ#oe&\u001c\u0007.\u0011:uS\u001a\f7\r\u001e\u000b\u0004)\n\u0005\u0004b\u0002B2K\u0001\u0007!QM\u0001\u000fg>,(oY3BeRLg-Y2u!\u0011\u00119G!\u001d\u000e\u0005\t%$\u0002\u0002B6\u0005[\n\u0001\"\u0019:uS\u001a\f7\r\u001e\u0006\u0005\u0005_\n),A\u0002vI6LAAa\u001d\u0003j\tq1k\\;sG\u0016\f%\u000f^5gC\u000e$\u0018!F5t\u0003J$\u0018NZ1diB\u0013X-\u00128sS\u000eDW\r\u001a\u000b\u0005\u0003\u007f\u0013I\bC\u0004\u0003|\u0019\u0002\rA!\u001a\u0002\u0015\u0011,\u0007\u000f\\8zC\ndW-A\u0007dQ\u0016\u001c7.S7q_J$X\r\u001a\u000b\u0004)\n\u0005\u0005b\u0002BBO\u0001\u0007!QQ\u0001\fa\u0006\u001c7.Y4f\u0013:4w\u000e\u0005\u0003\u0002\u0000\t\u001d\u0015\u0002\u0002BE\u0003\u0003\u00131\u0002U1dW\u0006<W-\u00138g_\u0006q1M]3bi\u0016,e\u000e^5uS\u0016\u001cHc\u0002+\u0003\u0010\nE%Q\u0013\u0005\b\u0005\u0017B\u0003\u0019\u0001B'\u0011\u001d\u0011\u0019\n\u000ba\u0001\u0003\u007f\u000b\u0011\"[:Va\u001e\u0014\u0018\rZ3\t\u000f\t]\u0005\u00061\u0001\u0003\u001a\u0006\tBo\\\"sK\u0006$XmQ8mY\u0016\u001cGo\u001c:\u0011\r\u0005U$1\u0014BP\u0013\u0011\u0011i*a\u001e\u0003\u0007M+G\u000f\u0005\u0003\u0003\"\n\rVB\u0001B7\u0013\u0011\u0011)K!\u001c\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W.\u0001\fgS2$XM]#ySN$\u0018N\\4QC\u000e\\\u0017mZ3t)\u0011\u0011YK!.\u0011\r\t\u0015!Q\u0016BX\u0013\u0011\u0011iJa\u0006\u0011\t\u0005=&\u0011W\u0005\u0005\u0005g\u000b\tL\u0001\nQe>\u0004XM\u001d;z\t\u0016\u001c8M]5qi>\u0014\bb\u0002B\\S\u0001\u0007!\u0011X\u0001\bm\u0016\u00148/[8o!\u0011\u0011\tKa/\n\t\tu&Q\u000e\u0002\b-\u0016\u00148/[8o\u0003y\u0019'/Z1uK:+7\u000f^3e\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l7\u000fF\u0003U\u0005\u0007\u00149\rC\u0004\u0003F*\u0002\rAa(\u0002\u0005\rL\u0007b\u0002BLU\u0001\u0007!\u0011T\u0001\tm\u0006d\u0017\u000eZ1uKR\u0019AK!4\t\u000f\t=7\u00061\u0001\u0003\u001a\u0006AAo\\\"sK\u0006$X\r\u0006\u0003\u0002@\nM\u0007b\u0002BBY\u0001\u0007!QQ\u0001\bCB\u0004h*Y7f)\u0011\u0011\u0019A!7\t\u000f\t\rU\u00061\u0001\u0003\u0006\u0006\u00112/\u001e2TiJLgnZ!gi\u0016\u0014H*Y:u)\u0019\u0011\u0019Aa8\u0003d\"9!\u0011\u001d\u0018A\u0002\t\r\u0011!A:\t\u000f\t\u0015h\u00061\u0001\u0003\u0004\u0005\u00191/\u001a9\u0002'M,(m\u0015;sS:<')\u001a4pe\u0016d\u0015m\u001d;\u0015\r\t\r!1\u001eBw\u0011\u001d\u0011\to\fa\u0001\u0005\u0007AqA!:0\u0001\u0004\u0011\u0019\u0001F\u0003U\u0005c\u0014\u0019\u0010C\u0004\u0003\u0014B\u0002\r!a0\t\u000f\t\r\u0005\u00071\u0001\u0003\u0006\u0002")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactEnricher enricher;
    private RepositoryHelper repositoryHelper;
    private ChecksumAlgorithmProvider checksumAlgorithmProvider;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactEnricher enricher() {
        return this.enricher;
    }

    public void enricher_$eq(SourceArtifactEnricher x$1) {
        this.enricher = x$1;
    }

    public RepositoryHelper repositoryHelper() {
        return this.repositoryHelper;
    }

    public void repositoryHelper_$eq(RepositoryHelper x$1) {
        this.repositoryHelper = x$1;
    }

    public ChecksumAlgorithmProvider checksumAlgorithmProvider() {
        return this.checksumAlgorithmProvider;
    }

    public void checksumAlgorithmProvider_$eq(ChecksumAlgorithmProvider x$1) {
        this.checksumAlgorithmProvider = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", new Object[]{importerClasses});
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(importerClasses).asScala()).filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable & scala.Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", new Object[]{XmlManifestDarImporter.class});
        this.logger().info("Importers configured in XL Deploy: {}", new Object[]{this.importers()});
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)List$.MODULE$.apply((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable & scala.Serializable)importer -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((ListableImporter)importer).list(this.importablePackageDirectory())).asScala()).map((Function1 & Serializable & scala.Serializable)pkgFound -> pkgFound, Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).asJava()));
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        try {
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Importer importer = (Importer)some.value();
            String string2 = this.doImport(source, importer);
            string = string2;
        }
        finally {
            source.cleanUp();
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.repositoryHelper().publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        block0: {
            if (!(importedPackage.getVersion() instanceof DeploymentPackage)) break block0;
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).asScala()).foreach((Function1 & Serializable & scala.Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable & scala.Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringBuilder(53).append("Could not open stream of uri ").append(sourceArtifact.getFileUri()).append(" of unresolved artifact ").append(sourceArtifact).toString(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        void var2_2;
        boolean isPreEnrichedArtifact = deployable.hasProperty("preEnrichedArtifact") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preEnrichedArtifact"));
        this.logger().info(new StringBuilder(26).append("Artifact ").append(deployable).append(" is ").append((Object)(isPreEnrichedArtifact ? "" : "not")).append(" pre-enriched").toString());
        return (boolean)var2_2;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(version.getType().getDescriptor().getPropertyDescriptors()).asScala()).toSet();
        return !(version instanceof CompositePackage) ? propertyDescriptors : (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$2)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(propertyDescriptors).asScala()).withFilter((Function1 & Serializable & scala.Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        Seq msgs = (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(toCreate).asScala()).foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, tc) -> {
            Seq validated = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.validator().validate(tc, (java.util.List)Lists.newArrayList((Iterable)toCreate))).asScala();
            return validated.nonEmpty() ? (Seq)acc.$plus$plus((GenTraversableOnce)validated, Seq$.MODULE$.canBuildFrom()) : acc;
        });
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean bl;
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).asScala()).toList();
        int n = applications.length();
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                if (locationSpecified) {
                    String string = ((ConfigurationItemData)applications.head()).getId();
                    String string2 = packageInfo.getApplicationId();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), ((ConfigurationItemData)applications.head()).getId());
                    }
                }
                String appId = ((ConfigurationItemData)applications.head()).getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(43).append("Found more than 1 [").append(((ConfigurationItemData)applications.head()).getType()).append("] with the same name: [").append(applications.mkString(", ")).append("]").toString());
            }
        }
        return bl;
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions.IMPORT_UPGRADE : DeployitPermissions.IMPORT_INITIAL;
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", new Object[]{importerClass});
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(32).append("Could not instantiate importer: ").append(importerClass).toString(), e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", new Object[]{sourceArtifact});
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                $this.enricher().enrichArtifact(sourceArtifact, (Function0 & Serializable & scala.Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
            }
        } else {
            $this.logger().info(new StringBuilder(29).append("Resolving artifact ").append(sourceArtifact).append(" from url ").append(sourceArtifact.getFileUri()).toString());
            $this.resolveAndEnrichArtifact(sourceArtifact);
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            $this.enricher().enrichArtifact(sourceArtifact$1, new StreamFile(resolve$1.getFileName(), is), (Function0 & Serializable & scala.Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$2) {
        String string = x$2.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind()));
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)propertyDescriptor.get(ci$1)).asScala()).withFilter((Function1 & Serializable & scala.Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable & scala.Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactEnricher enricher, RepositoryHelper repositoryHelper, ChecksumAlgorithmProvider checksumAlgorithmProvider) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.enricher = enricher;
        this.repositoryHelper = repositoryHelper;
        this.checksumAlgorithmProvider = checksumAlgorithmProvider;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
    }
}

