/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.change.CheckSum;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.core.DropAllCommand;
import liquibase.command.core.ExecuteSqlCommand;
import liquibase.command.core.SnapshotCommand;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.integration.commandline.ChangeExecListenerUtils;
import liquibase.integration.commandline.CommandLineOutputAppender;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogLevel;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.core.DefaultLoggerConfiguration;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.xml.XMLResourceBundle;
import liquibase.util.xml.XmlResourceBundleControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final String ERRORMSG_UNEXPECTED_PARAMETERS = "unexpected.command.parameters";
    private static final liquibase.logging.Logger LOG = LogService.getLog(Main.class);
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private static XMLResourceBundle commandLineHelpBundle = (XMLResourceBundle)ResourceBundle.getBundle("liquibase/i18n/liquibase-commandline-helptext", new XmlResourceBundleControl());
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String outputDefaultSchema;
    protected String outputDefaultCatalog;
    protected String liquibaseCatalogName;
    protected String liquibaseSchemaName;
    protected String databaseChangeLogTableName;
    protected String databaseChangeLogLockTableName;
    protected String databaseChangeLogTablespaceName;
    protected String defaultCatalogName;
    protected String changeLogFile;
    protected String overwriteOutputFile;
    protected String classpath;
    protected String contexts;
    protected String labels;
    protected String driverPropertiesFile;
    protected String propertyProviderClass;
    protected String changeExecListenerClass;
    protected String changeExecListenerPropertiesFile;
    protected Boolean promptForNonLocalDatabase;
    protected Boolean includeSystemClasspath;
    protected Boolean strict = Boolean.TRUE;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataOutputDirectory;
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultCatalogName;
    protected String referenceDefaultSchemaName;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new LinkedHashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();
    protected String outputFile;
    protected String excludeObjects;
    protected Boolean includeCatalog;
    protected String includeObjects;
    protected Boolean includeSchema;
    protected Boolean includeTablespace;
    protected String outputSchemasAs;
    protected String referenceSchemas;
    protected String schemas;
    protected String snapshotFormat;

    public static void main(String[] args) {
        int errorLevel = 0;
        try {
            errorLevel = Main.run(args);
        }
        catch (LiquibaseException e) {
            System.exit(-1);
        }
        System.exit(errorLevel);
    }

    public static int run(String[] args) throws LiquibaseException {
        Main.setupLogging();
        liquibase.logging.Logger log = LogService.getLog(Main.class);
        boolean outputLoggingEnabled = false;
        try {
            GlobalConfiguration globalConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
            if (!globalConfiguration.getShouldRun()) {
                log.warning(LogType.USER_MESSAGE, String.format(coreBundle.getString("did.not.run.because.param.was.set.to.false"), LiquibaseConfiguration.getInstance().describeValueLookupLogic(globalConfiguration.getProperty("shouldRun"))));
                return 0;
            }
            Main main = new Main();
            log.info(LogType.USER_MESSAGE, CommandLineUtils.getBanner());
            if (args.length == 1 && "--help".equals(args[0])) {
                main.printHelp(System.out);
                return 0;
            }
            if (args.length == 1 && "--version".equals(args[0])) {
                log.info(LogType.USER_MESSAGE, String.format(coreBundle.getString("version.number"), LiquibaseUtil.getBuildVersion() + StreamUtil.getLineSeparator()));
                return 0;
            }
            try {
                main.parseOptions(args);
            }
            catch (CommandLineParsingException e) {
                log.warning(LogType.USER_MESSAGE, coreBundle.getString("how.to.display.help"));
                throw e;
            }
            List<String> setupMessages = main.checkSetup();
            if (!setupMessages.isEmpty()) {
                main.printHelp(setupMessages, System.err);
                return 1;
            }
            main.applyDefaults();
            main.configureClassLoader();
            main.doMigration();
            if ("update".equals(main.command)) {
                log.info(LogType.USER_MESSAGE, coreBundle.getString("update.successful"));
            } else if (main.command.startsWith("rollback") && !main.command.endsWith("SQL")) {
                log.info(LogType.USER_MESSAGE, coreBundle.getString("rollback.successful"));
            } else if (!main.command.endsWith("SQL")) {
                log.info(LogType.USER_MESSAGE, String.format(coreBundle.getString("command.successful"), main.command));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            if (message == null) {
                message = coreBundle.getString("unknown.reason");
            }
            try {
                if (e.getCause() instanceof ValidationFailedException) {
                    ((ValidationFailedException)e.getCause()).printDescriptiveError(System.out);
                } else {
                    log.severe(LogType.USER_MESSAGE, String.format(coreBundle.getString("unexpected.error"), message), e);
                    log.severe(LogType.USER_MESSAGE, Main.generateLogLevelWarningMessage(outputLoggingEnabled));
                }
            }
            catch (IllegalFormatException e1) {
                e1.printStackTrace();
            }
            throw new LiquibaseException(String.format(coreBundle.getString("unexpected.error"), message), e);
        }
        return 0;
    }

    protected static void setupLogging() {
        LogLevel defaultLogLevel = LiquibaseConfiguration.getInstance().getConfiguration(DefaultLoggerConfiguration.class).getLogLevel();
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        if ("ch.qos.logback.classic.Logger".equals(rootLogger.getClass().getName())) {
            CommandLineOutputAppender.setupLogging(rootLogger, defaultLogLevel);
        } else {
            System.err.println("Liquibase command line logging cannot be configured; a supported org.slf4j.Logger implementation is not on the classpath.");
        }
    }

    private static String generateLogLevelWarningMessage(boolean outputLoggingEnabled) {
        if (outputLoggingEnabled) {
            return "";
        }
        return "\n\n" + coreBundle.getString("for.more.information.use.loglevel.flag");
    }

    private static String[] splitArg(String arg) throws CommandLineParsingException {
        String[] splitArg = arg.split("=", 2);
        if (splitArg.length < 2) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("could.not.parse.expression"), arg));
        }
        splitArg[0] = splitArg[0].replaceFirst("--", "");
        return splitArg;
    }

    private static boolean isChangeLogRequired(String command) {
        return command.toLowerCase().startsWith("update") || command.toLowerCase().startsWith("rollback") || "calculateCheckSum".equalsIgnoreCase(command) || "status".equalsIgnoreCase(command) || "validate".equalsIgnoreCase(command) || "changelogSync".equalsIgnoreCase(command) || "changelogSyncSQL".equalsIgnoreCase(command) || "generateChangeLog".equalsIgnoreCase(command);
    }

    private static boolean isCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateCount".equalsIgnoreCase(arg) || "updateCountSQL".equalsIgnoreCase(arg) || "updateToTag".equalsIgnoreCase(arg) || "updateToTagSQL".equalsIgnoreCase(arg) || "rollback".equalsIgnoreCase(arg) || "rollbackToDate".equalsIgnoreCase(arg) || "rollbackCount".equalsIgnoreCase(arg) || "rollbackSQL".equalsIgnoreCase(arg) || "rollbackToDateSQL".equalsIgnoreCase(arg) || "rollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "futureRollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackToTagSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "tag".equalsIgnoreCase(arg) || "tagExists".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "status".equalsIgnoreCase(arg) || "unexpectedChangeSets".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "diff".equalsIgnoreCase(arg) || "diffChangeLog".equalsIgnoreCase(arg) || "generateChangeLog".equalsIgnoreCase(arg) || "snapshot".equalsIgnoreCase(arg) || "snapshotReference".equalsIgnoreCase(arg) || "executeSql".equalsIgnoreCase(arg) || "calculateCheckSum".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "dbDoc".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    private static boolean isNoArgCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    private static void addWarFileClasspathEntries(File classPathFile, List<URL> urls) throws IOException {
        URL jarUrl = new URL("jar:" + classPathFile.toURI().toURL() + "!/WEB-INF/classes/");
        LOG.info(LogType.LOG, "adding '" + jarUrl + "' to classpath");
        urls.add(jarUrl);
        try (JarFile warZip = new JarFile(classPathFile);){
            Enumeration<JarEntry> entries = warZip.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("WEB-INF/lib") || !entry.getName().toLowerCase().endsWith(".jar")) continue;
                File jar = Main.extract(warZip, entry);
                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                LOG.info(LogType.LOG, "adding '" + newUrl + "' to classpath");
                urls.add(newUrl);
                jar.deleteOnExit();
            }
        }
    }

    private static File extract(JarFile jar, JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("liquibase.tmp", null);
        try (BufferedInputStream inStream = new BufferedInputStream(jar.getInputStream(entry));
             BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int status;
            while ((status = inStream.read()) != -1) {
                outStream.write(status);
            }
        }
        return tempFile;
    }

    protected void parseDefaultPropertyFiles() throws CommandLineParsingException {
        File[] potentialPropertyFiles = new File[2];
        potentialPropertyFiles[0] = new File(this.defaultsFile);
        String localDefaultsPathName = this.defaultsFile.replaceFirst("(\\.[^\\.]+)$", ".local$1");
        potentialPropertyFiles[1] = new File(localDefaultsPathName);
        for (File potentialPropertyFile : potentialPropertyFiles) {
            try {
                if (potentialPropertyFile.exists()) {
                    this.parseDefaultPropertyFileFromFile(potentialPropertyFile);
                    continue;
                }
                this.parseDefaultPropertyFileFromResource(potentialPropertyFile);
            }
            catch (IOException e) {
                throw new CommandLineParsingException(e);
            }
        }
    }

    private void parseDefaultPropertyFileFromResource(File potentialPropertyFile) throws IOException, CommandLineParsingException {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(potentialPropertyFile.getAbsolutePath());){
            if (resourceAsStream != null) {
                this.parsePropertiesFile(resourceAsStream);
            }
        }
    }

    private void parseDefaultPropertyFileFromFile(File potentialPropertyFile) throws IOException, CommandLineParsingException {
        try (FileInputStream stream = new FileInputStream(potentialPropertyFile);){
            this.parsePropertiesFile(stream);
        }
    }

    protected String[] fixupArgs(String[] args) {
        ArrayList<String> fixedArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ((arg.startsWith("--") || arg.startsWith("-D")) && !arg.contains("=")) {
                String nextArg = null;
                if (i + 1 < args.length) {
                    nextArg = args[i + 1];
                }
                if (nextArg != null && !nextArg.startsWith("--") && !Main.isCommand(nextArg)) {
                    arg = arg + "=" + nextArg;
                    ++i;
                }
            }
            arg = arg.replace("\\,", ",");
            fixedArgs.add(arg);
        }
        return fixedArgs.toArray(new String[fixedArgs.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.command == null) {
            messages.add(coreBundle.getString("command.not.passed"));
        } else if (!Main.isCommand(this.command)) {
            messages.add(String.format(coreBundle.getString("command.unknown"), this.command));
        } else {
            if (StringUtils.trimToNull(this.url) == null) {
                messages.add(String.format(coreBundle.getString("option.required"), "--url"));
            }
            if (Main.isChangeLogRequired(this.command) && StringUtils.trimToNull(this.changeLogFile) == null) {
                messages.add(String.format(coreBundle.getString("option.required"), "--changeLogFile"));
            }
            if (Main.isNoArgCommand(this.command) && !this.commandParams.isEmpty()) {
                messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
            } else {
                this.validateCommandParameters(messages);
            }
        }
        return messages;
    }

    private void checkForUnexpectedCommandParameter(List<String> messages) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (!"updateCount".equalsIgnoreCase(this.command) && !"updateCountSQL".equalsIgnoreCase(this.command) && !"updateToTag".equalsIgnoreCase(this.command) && !"updateToTagSQL".equalsIgnoreCase(this.command) && !"calculateCheckSum".equalsIgnoreCase(this.command) && !"dbDoc".equalsIgnoreCase(this.command) && !"tag".equalsIgnoreCase(this.command) && !"tagExists".equalsIgnoreCase(this.command)) break block3;
                        if (this.commandParams.isEmpty() || !this.commandParams.iterator().next().startsWith("-")) break block4;
                        messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
                        break block4;
                    }
                    if (!"status".equalsIgnoreCase(this.command) && !"unexpectedChangeSets".equalsIgnoreCase(this.command)) break block5;
                    if (this.commandParams.isEmpty() || this.commandParams.iterator().next().equalsIgnoreCase("--verbose")) break block4;
                    messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
                    break block4;
                }
                if (!"diff".equalsIgnoreCase(this.command) && !"diffChangeLog".equalsIgnoreCase(this.command)) break block6;
                if (this.commandParams.isEmpty()) break block4;
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--referenceUsername") || cmdParm.startsWith("--referencePassword") || cmdParm.startsWith("--referenceDriver") || cmdParm.startsWith("--referenceDefaultCatalogName") || cmdParm.startsWith("--referenceDefaultSchemaName") || cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--schemas") || cmdParm.startsWith("--outputSchemasAs") || cmdParm.startsWith("--referenceSchemas") || cmdParm.startsWith("--referenceUrl") || cmdParm.startsWith("--excludeObjects") || cmdParm.startsWith("--includeObjects") || cmdParm.startsWith("--diffTypes") || cmdParm.startsWith("--snapshotFormat")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
                break block4;
            }
            if (("snapshot".equalsIgnoreCase(this.command) || "generateChangeLog".equalsIgnoreCase(this.command)) && !this.commandParams.isEmpty()) {
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--schemas") || cmdParm.startsWith("--snapshotFormat")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            }
        }
    }

    private void validateCommandParameters(List<String> messages) {
        this.checkForUnexpectedCommandParameter(messages);
        this.checkForMissingCommandParameters(messages);
        this.checkForMalformedCommandParameters(messages);
    }

    private void checkForMissingCommandParameters(List<String> messages) {
        if ((this.commandParams.isEmpty() || this.commandParams.iterator().next().startsWith("-")) && "calculateCheckSum".equalsIgnoreCase(this.command)) {
            messages.add(coreBundle.getString("changeset.identifier.missing"));
        }
    }

    private void checkForMalformedCommandParameters(List<String> messages) {
        if (this.commandParams.isEmpty()) {
            return;
        }
        int CHANGESET_MINIMUM_IDENTIFIER_PARTS = 3;
        if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
            for (String param : this.commandParams) {
                String[] parts;
                if (param == null || param.startsWith("-") || (parts = param.split("::")).length >= 3) continue;
                messages.add(coreBundle.getString("changeset.identifier.must.have.form.filepath.id.author"));
                break;
            }
        } else if ("diffChangeLog".equalsIgnoreCase(this.command) && this.diffTypes != null && this.diffTypes.toLowerCase().contains("data")) {
            messages.add(String.format(coreBundle.getString("including.data.diffchangelog.has.no.effect"), "diffTypes", "generateChangeLog"));
        }
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws IOException, CommandLineParsingException {
        Properties props = new Properties();
        props.load(propertiesInputStream);
        if (props.containsKey("strict")) {
            this.strict = Boolean.valueOf(props.getProperty("strict"));
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            try {
                if ("promptOnNonLocalDatabase".equals(entry.getKey())) continue;
                if (((String)entry.getKey()).startsWith("parameter.")) {
                    this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
                    continue;
                }
                Field field = this.getClass().getDeclaredField((String)entry.getKey());
                Object currentValue = field.get(this);
                if (currentValue != null) continue;
                String value = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                    continue;
                }
                field.set(this, value);
            }
            catch (NoSuchFieldException ignored) {
                if (this.strict.booleanValue()) {
                    throw new CommandLineParsingException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
                }
                LogService.getLog(this.getClass()).warning(LogType.LOG, String.format(coreBundle.getString("parameter.ignored"), entry.getKey()));
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
            }
        }
    }

    protected void printHelp(List<String> errorMessages, PrintStream stream) {
        stream.println(coreBundle.getString("errors"));
        for (String message : errorMessages) {
            stream.println("  " + message);
        }
        stream.println();
    }

    protected void printHelp(PrintStream stream) {
        String helpText = commandLineHelpBundle.getString("commandline-helptext");
        stream.println(helpText);
    }

    protected void parseOptions(String[] paramArgs) throws CommandLineParsingException {
        String[] args = this.fixupArgs(paramArgs);
        boolean seenCommand = false;
        for (String arg : args) {
            if (Main.isCommand(arg)) {
                this.command = arg;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                seenCommand = true;
                continue;
            }
            if (seenCommand) {
                if (arg.startsWith("-D")) {
                    String[] splitArg = Main.splitArg(arg);
                    String attributeName = splitArg[0].replaceFirst("^-D", "");
                    String value = splitArg[1];
                    this.changeLogParameters.put(attributeName, value);
                    continue;
                }
                this.commandParams.add(arg);
                if (!arg.startsWith("--")) continue;
                this.parseOptionArgument(arg);
                continue;
            }
            if (arg.startsWith("--")) {
                this.parseOptionArgument(arg);
                continue;
            }
            throw new CommandLineParsingException(String.format(coreBundle.getString("unexpected.value"), arg));
        }
        this.parseDefaultPropertyFiles();
    }

    private void parseOptionArgument(String arg) throws CommandLineParsingException {
        String PROMPT_FOR_VALUE = "PROMPT";
        if (arg.toLowerCase().startsWith("--verbose")) {
            return;
        }
        String[] splitArg = Main.splitArg(arg);
        String attributeName = splitArg[0];
        String value = splitArg[1];
        if ("PROMPT".equalsIgnoreCase(StringUtils.trimToEmpty(value))) {
            Console c = System.console();
            if (c == null) {
                throw new CommandLineParsingException(String.format(MessageFormat.format(coreBundle.getString("cannot.prompt.for.the.value.no.console"), attributeName), new Object[0]));
            }
            value = attributeName.toLowerCase().contains("password") ? new String(c.readPassword(attributeName + ": ", new Object[0])) : c.readLine(attributeName + ": ", new Object[0]);
        }
        try {
            Field field = this.getClass().getDeclaredField(attributeName);
            if (field.getType().equals(Boolean.class)) {
                field.set(this, Boolean.valueOf(value));
            } else {
                field.set(this, value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("option.unknown"), attributeName));
        }
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "off";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
        if (this.outputDefaultCatalog == null) {
            this.outputDefaultCatalog = "true";
        }
        if (this.outputDefaultSchema == null) {
            this.outputDefaultSchema = "true";
        }
        if (this.defaultsFile == null) {
            this.defaultsFile = "liquibase.properties";
        }
        if (this.includeSchema == null) {
            this.includeSchema = false;
        }
        if (this.includeCatalog == null) {
            this.includeCatalog = false;
        }
        if (this.includeTablespace == null) {
            this.includeTablespace = false;
        }
    }

    protected void configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] classpathSoFar = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            for (String classpathEntry : classpathSoFar) {
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new CommandLineParsingException(String.format(coreBundle.getString("does.not.exist"), classPathFile.getAbsolutePath()));
                }
                if (classpathEntry.endsWith(".war")) {
                    try {
                        Main.addWarFileClasspathEntries(classPathFile, urls);
                        continue;
                    }
                    catch (IOException e) {
                        throw new CommandLineParsingException(e);
                    }
                }
                if (classpathEntry.endsWith(".ear")) {
                    try (JarFile earZip = new JarFile(classPathFile);){
                        Enumeration<JarEntry> entries = earZip.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().toLowerCase().endsWith(".jar")) {
                                File jar = Main.extract(earZip, entry);
                                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                                urls.add(newUrl);
                                LOG.debug(LogType.LOG, String.format(coreBundle.getString("adding.to.classpath"), newUrl));
                                jar.deleteOnExit();
                                continue;
                            }
                            if (!entry.getName().toLowerCase().endsWith("war")) continue;
                            File warFile = Main.extract(earZip, entry);
                            Main.addWarFileClasspathEntries(warFile, urls);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new CommandLineParsingException(e);
                    }
                }
                URL newUrl = null;
                try {
                    newUrl = new File(classpathEntry).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new CommandLineParsingException(e);
                }
                LOG.debug(LogType.LOG, String.format(coreBundle.getString("adding.to.classpath"), newUrl));
                urls.add(newUrl);
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
            }
        });
        ServiceLocator.getInstance().setResourceAccessor(new ClassLoaderResourceAccessor(this.classLoader));
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doMigration() throws Exception {
        if ("help".equalsIgnoreCase(this.command)) {
            this.printHelp(System.err);
            return;
        }
        FileSystemResourceAccessor fsOpener = new FileSystemResourceAccessor();
        CommandLineResourceAccessor clOpener = new CommandLineResourceAccessor(this.classLoader);
        CompositeResourceAccessor fileOpener = new CompositeResourceAccessor(fsOpener, clOpener);
        Database database = CommandLineUtils.createDatabaseObject(fileOpener, this.url, this.username, this.password, this.driver, this.defaultCatalogName, this.defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), this.databaseClass, this.driverPropertiesFile, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
        database.setLiquibaseTablespaceName(this.databaseChangeLogTablespaceName);
        try {
            SnapshotCommand snapshotCommand;
            if (this.excludeObjects != null && this.includeObjects != null) {
                throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("cannot.specify.both"), "excludeObjects", "includeObjects"));
            }
            StandardObjectChangeFilter objectChangeFilter = null;
            CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas(this.schemas, this.referenceSchemas, this.outputSchemasAs, this.defaultCatalogName, this.defaultSchemaName, this.referenceDefaultCatalogName, this.referenceDefaultSchemaName, database);
            CompareControl.SchemaComparison[] finalSchemaComparisons = computedSchemas.finalSchemaComparisons;
            DiffOutputControl diffOutputControl = new DiffOutputControl(this.includeCatalog, this.includeSchema, this.includeTablespace, finalSchemaComparisons);
            if (this.excludeObjects != null) {
                objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.excludeObjects);
                diffOutputControl.setObjectChangeFilter(objectChangeFilter);
            }
            if (this.includeObjects != null) {
                objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.includeObjects);
                diffOutputControl.setObjectChangeFilter(objectChangeFilter);
            }
            for (CompareControl.SchemaComparison schema : finalSchemaComparisons) {
                diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
                diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
            }
            if ("diff".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doDiff(this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, StringUtils.trimToNull(this.diffTypes), finalSchemaComparisons);
                return;
            }
            if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doDiffToChangeLog(this.changeLogFile, this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, diffOutputControl, objectChangeFilter, StringUtils.trimToNull(this.diffTypes), finalSchemaComparisons);
                return;
            }
            if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                File file;
                String currentChangeLogFile = this.changeLogFile;
                if (currentChangeLogFile == null) {
                    currentChangeLogFile = "";
                }
                if ((file = new File(currentChangeLogFile)).exists() && !Boolean.parseBoolean(this.overwriteOutputFile)) {
                    throw new LiquibaseException(String.format(coreBundle.getString("changelogfile.already.exists"), currentChangeLogFile));
                }
                try {
                    if (file.delete()) {
                        // empty if block
                    }
                }
                catch (SecurityException e) {
                    throw new LiquibaseException(String.format(coreBundle.getString("attempt.to.delete.the.file.failed.cannot.continue"), currentChangeLogFile), e);
                }
                CatalogAndSchema[] finalTargetSchemas = computedSchemas.finalTargetSchemas;
                CommandLineUtils.doGenerateChangeLog(currentChangeLogFile, database, finalTargetSchemas, StringUtils.trimToNull(this.diffTypes), StringUtils.trimToNull(this.changeSetAuthor), StringUtils.trimToNull(this.changeSetContext), StringUtils.trimToNull(this.dataOutputDirectory), diffOutputControl);
                return;
            }
            if ("snapshot".equalsIgnoreCase(this.command)) {
                snapshotCommand = (SnapshotCommand)CommandFactory.getInstance().getCommand("snapshot");
                snapshotCommand.setDatabase(database);
                snapshotCommand.setSchemas(this.getCommandParam("schemas", database.getDefaultSchema().getSchemaName()));
                snapshotCommand.setSerializerFormat(this.getCommandParam("snapshotFormat", null));
                Writer outputWriter = this.getOutputWriter();
                String result = ((SnapshotCommand.SnapshotCommandResult)snapshotCommand.execute()).print();
                outputWriter.write(result);
                outputWriter.flush();
                outputWriter.close();
                return;
            }
            if ("executeSql".equalsIgnoreCase(this.command)) {
                ExecuteSqlCommand executeSqlCommand = (ExecuteSqlCommand)CommandFactory.getInstance().getCommand("executeSql");
                executeSqlCommand.setDatabase(database);
                executeSqlCommand.setSql(this.getCommandParam("sql", null));
                executeSqlCommand.setSqlFile(this.getCommandParam("sqlFile", null));
                executeSqlCommand.setDelimiter(this.getCommandParam("delimiter", ";"));
                Writer outputWriter = this.getOutputWriter();
                outputWriter.write(((CommandResult)executeSqlCommand.execute()).print());
                outputWriter.flush();
                outputWriter.close();
                return;
            }
            if ("snapshotReference".equalsIgnoreCase(this.command)) {
                snapshotCommand = (SnapshotCommand)CommandFactory.getInstance().getCommand("snapshot");
                Database referenceDatabase = this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener);
                snapshotCommand.setDatabase(referenceDatabase);
                snapshotCommand.setSchemas(this.getCommandParam("schemas", referenceDatabase.getDefaultSchema().getSchemaName()));
                snapshotCommand.setSerializerFormat(this.getCommandParam("snapshotFormat", null));
                Writer outputWriter = this.getOutputWriter();
                outputWriter.write(((SnapshotCommand.SnapshotCommandResult)snapshotCommand.execute()).print());
                outputWriter.flush();
                outputWriter.close();
                return;
            }
            Liquibase liquibase = new Liquibase(this.changeLogFile, (ResourceAccessor)fileOpener, database);
            ChangeExecListener listener = ChangeExecListenerUtils.getChangeExecListener(liquibase.getDatabase(), liquibase.getResourceAccessor(), this.changeExecListenerClass, this.changeExecListenerPropertiesFile);
            liquibase.setChangeExecListener(listener);
            database.setCurrentDateTimeFunction(this.currentDateTimeFunction);
            for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            if ("listLocks".equalsIgnoreCase(this.command)) {
                liquibase.reportLocks(System.err);
                return;
            }
            if ("releaseLocks".equalsIgnoreCase(this.command)) {
                LockService lockService = LockServiceFactory.getInstance().getLockService(database);
                lockService.forceReleaseLock();
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("successfully.released.database.change.log.locks"), liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("tag".equalsIgnoreCase(this.command)) {
                liquibase.tag(this.getCommandArgument());
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("successfully.tagged"), liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("tagExists".equalsIgnoreCase(this.command)) {
                String tag = this.commandParams.iterator().next();
                boolean exists = liquibase.tagExists(tag);
                if (exists) {
                    LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("tag.exists"), tag, liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                    return;
                }
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("tag.does.not.exist"), tag, liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("dropAll".equals(this.command)) {
                DropAllCommand dropAllCommand = (DropAllCommand)CommandFactory.getInstance().getCommand("dropAll");
                dropAllCommand.setDatabase(liquibase.getDatabase());
                dropAllCommand.setSchemas(this.getCommandParam("schemas", database.getDefaultSchema().getSchemaName()));
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, ((CommandResult)dropAllCommand.execute()).print());
                return;
            }
            if ("status".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportStatus(runVerbose, new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                return;
            }
            if ("unexpectedChangeSets".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportUnexpectedChangeSets(runVerbose, this.contexts, this.getOutputWriter());
                return;
            }
            if ("validate".equalsIgnoreCase(this.command)) {
                try {
                    liquibase.validate();
                }
                catch (ValidationFailedException e) {
                    e.printDescriptiveError(System.err);
                    try {
                        database.rollback();
                        database.close();
                        return;
                    }
                    catch (DatabaseException e2) {
                        LogService.getLog(this.getClass()).warning(LogType.LOG, coreBundle.getString("problem.closing.connection"), e2);
                    }
                    return;
                }
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, coreBundle.getString("no.validation.errors.found"));
                return;
            }
            if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                liquibase.clearCheckSums();
                return;
            }
            if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
                CheckSum checkSum = null;
                checkSum = liquibase.calculateCheckSum(this.commandParams.iterator().next());
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, checkSum.toString());
                return;
            }
            if ("dbDoc".equalsIgnoreCase(this.command)) {
                if (this.commandParams.isEmpty()) {
                    throw new CommandLineParsingException(coreBundle.getString("dbdoc.requires.output.directory"));
                }
                if (this.changeLogFile == null) {
                    throw new CommandLineParsingException(coreBundle.getString("dbdoc.requires.changelog.parameter"));
                }
                liquibase.generateDocumentation(this.commandParams.iterator().next(), this.contexts);
                return;
            }
            try {
                if ("update".equalsIgnoreCase(this.command)) {
                    liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("changelogSync".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateCount".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateToTag".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels));
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "updateToTag"));
                }
                if ("updateToTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "updateToTagSQL"));
                }
                if ("updateSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollback".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "rollback"));
                    }
                    liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.timestamp"), "rollbackToDate"));
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackCount".equalsIgnoreCase(this.command)) {
                    liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "rollbackSQL"));
                    }
                    liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.timestamp"), "rollbackToDateSQL"));
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.count"), "rollbackCountSQL"));
                    }
                    liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                    liquibase.futureRollbackSQL(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.count"), "futureRollbackCountSQL"));
                    }
                    liquibase.futureRollbackSQL((Integer)Integer.parseInt(this.getCommandArgument()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackFromTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "futureRollbackFromTagSQL"));
                    }
                    liquibase.futureRollbackSQL(this.getCommandArgument(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateTestingRollback".equalsIgnoreCase(this.command)) {
                    liquibase.updateTestingRollback(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                throw new CommandLineParsingException(String.format(coreBundle.getString("command.unknown"), this.command));
            }
            catch (ParseException ignored) {
                throw new CommandLineParsingException(coreBundle.getString("timeformat.invalid"));
            }
        }
        finally {
            try {
                database.rollback();
                database.close();
            }
            catch (DatabaseException e) {
                LogService.getLog(this.getClass()).warning(LogType.LOG, coreBundle.getString("problem.closing.connection"), e);
            }
        }
    }

    private String getCommandArgument() {
        for (String param : this.commandParams) {
            if (param.contains("=")) continue;
            return param;
        }
        return null;
    }

    private String getCommandParam(String paramName, String defaultValue) throws CommandLineParsingException {
        for (String param : this.commandParams) {
            if (!param.contains("=")) continue;
            String[] splitArg = Main.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if (!attributeName.equalsIgnoreCase(paramName)) continue;
            return value;
        }
        return defaultValue;
    }

    private Database createReferenceDatabaseFromCommandParams(Set<String> commandParams, ResourceAccessor resourceAccessor) throws CommandLineParsingException, DatabaseException {
        String refDriver = this.referenceDriver;
        String refUrl = this.referenceUrl;
        String refUsername = this.referenceUsername;
        String refPassword = this.referencePassword;
        String defSchemaName = this.referenceDefaultSchemaName;
        String defCatalogName = this.referenceDefaultCatalogName;
        for (String param : commandParams) {
            String[] splitArg = Main.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("referenceDriver".equalsIgnoreCase(attributeName)) {
                refDriver = value;
                continue;
            }
            if ("referenceUrl".equalsIgnoreCase(attributeName)) {
                refUrl = value;
                continue;
            }
            if ("referenceUsername".equalsIgnoreCase(attributeName)) {
                refUsername = value;
                continue;
            }
            if ("referencePassword".equalsIgnoreCase(attributeName)) {
                refPassword = value;
                continue;
            }
            if ("referenceDefaultCatalogName".equalsIgnoreCase(attributeName)) {
                defCatalogName = value;
                continue;
            }
            if ("referenceDefaultSchemaName".equalsIgnoreCase(attributeName)) {
                defSchemaName = value;
                continue;
            }
            if (!"dataOutputDirectory".equalsIgnoreCase(attributeName)) continue;
            this.dataOutputDirectory = value;
        }
        if (refUrl == null) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("option.required"), "--referenceUrl"));
        }
        return CommandLineUtils.createDatabaseObject(resourceAccessor, refUrl, refUsername, refPassword, refDriver, defCatalogName, defSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), null, null, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
    }

    private Writer getOutputWriter() throws IOException {
        String charsetName = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding();
        if (this.outputFile != null) {
            try {
                FileOutputStream fileOut = new FileOutputStream(this.outputFile, false);
                return new OutputStreamWriter((OutputStream)fileOut, charsetName);
            }
            catch (IOException e) {
                LogService.getLog(this.getClass()).severe(LogType.LOG, String.format(coreBundle.getString("could.not.create.output.file"), this.outputFile));
                throw e;
            }
        }
        return new OutputStreamWriter((OutputStream)System.out, charsetName);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }

    private static enum OPTIONS {

        private static final String VERBOSE = "verbose";
        private static final String CHANGELOG_FILE = "changeLogFile";
        private static final String DATA_OUTPUT_DIRECTORY = "dataOutputDirectory";
        private static final String DIFF_TYPES = "diffTypes";
        private static final String EXCLUDE_OBJECTS = "excludeObjects";
        private static final String INCLUDE_CATALOG = "includeCatalog";
        private static final String INCLUDE_OBJECTS = "includeObjects";
        private static final String INCLUDE_SCHEMA = "includeSchema";
        private static final String INCLUDE_TABLESPACE = "includeTablespace";
        private static final String OUTPUT_SCHEMAS_AS = "outputSchemasAs";
        private static final String REFERENCE_DEFAULT_CATALOG_NAME = "referenceDefaultCatalogName";
        private static final String REFERENCE_DEFAULT_SCHEMA_NAME = "referenceDefaultSchemaName";
        private static final String REFERENCE_DRIVER = "referenceDriver";
        private static final String REFERENCE_PASSWORD = "referencePassword";
        private static final String REFERENCE_SCHEMAS = "referenceSchemas";
        private static final String REFERENCE_URL = "referenceUrl";
        private static final String REFERENCE_USERNAME = "referenceUsername";
        private static final String SCHEMAS = "schemas";
        private static final String URL = "url";
        private static final String HELP = "help";
        private static final String VERSION = "version";
        private static final String SNAPSHOT_FORMAT = "snapshotFormat";
    }

    private static enum COMMANDS {

        private static final String CALCULATE_CHECKSUM = "calculateCheckSum";
        private static final String CHANGELOG_SYNC = "changelogSync";
        private static final String CHANGELOG_SYNC_SQL = "changelogSyncSQL";
        private static final String CLEAR_CHECKSUMS = "clearCheckSums";
        private static final String DB_DOC = "dbDoc";
        private static final String DIFF = "diff";
        private static final String DIFF_CHANGELOG = "diffChangeLog";
        private static final String DROP_ALL = "dropAll";
        private static final String EXECUTE_SQL = "executeSql";
        private static final String FUTURE_ROLLBACK_COUNT_SQL = "futureRollbackCountSQL";
        private static final String FUTURE_ROLLBACK_FROM_TAG_SQL = "futureRollbackFromTagSQL";
        private static final String FUTURE_ROLLBACK_SQL = "futureRollbackSQL";
        private static final String FUTURE_ROLLBACK_TO_TAG_SQL = "futureRollbackToTagSQL";
        private static final String GENERATE_CHANGELOG = "generateChangeLog";
        private static final String HELP = "help";
        private static final String LIST_LOCKS = "listLocks";
        private static final String MARK_NEXT_CHANGESET_RAN = "markNextChangeSetRan";
        private static final String MARK_NEXT_CHANGESET_RAN_SQL = "markNextChangeSetRanSQL";
        private static final String MIGRATE = "migrate";
        private static final String MIGRATE_SQL = "migrateSQL";
        private static final String RELEASE_LOCKS = "releaseLocks";
        private static final String ROLLBACK = "rollback";
        private static final String ROLLBACK_COUNT = "rollbackCount";
        private static final String ROLLBACK_COUNT_SQL = "rollbackCountSQL";
        private static final String ROLLBACK_SCRIPT = "rollbackScript";
        private static final String ROLLBACK_SQL = "rollbackSQL";
        private static final String ROLLBACK_TO_DATE = "rollbackToDate";
        private static final String ROLLBACK_TO_DATE_SQL = "rollbackToDateSQL";
        private static final String SNAPSHOT = "snapshot";
        private static final String SNAPSHOT_REFERENCE = "snapshotReference";
        private static final String STATUS = "status";
        private static final String TAG = "tag";
        private static final String TAG_EXISTS = "tagExists";
        private static final String UNEXPECTED_CHANGESETS = "unexpectedChangeSets";
        private static final String UPDATE = "update";
        private static final String UPDATE_COUNT = "updateCount";
        private static final String UPDATE_COUNT_SQL = "updateCountSQL";
        private static final String UPDATE_SQL = "updateSQL";
        private static final String UPDATE_TESTING_ROLLBACK = "updateTestingRollback";
        private static final String UPDATE_TO_TAG = "updateToTag";
        private static final String UPDATE_TO_TAG_SQL = "updateToTagSQL";
        private static final String VALIDATE = "validate";
    }

    private static enum FILE_SUFFIXES {

        private static final String FILE_SUFFIX_EAR = ".ear";
        private static final String WAR_FILE_SUFFIX = ".war";
    }
}

