/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemProperties;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApi;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.joda.time.DateTime;

@Path(value="/repository")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@PublicApi
public interface RepositoryService {
    @GET
    @Path(value="ci/new")
    public ConfigurationItem construct(@QueryParam(value="type") Type var1);

    @GET
    @Path(value="ci/{ID:.+}")
    public ConfigurationItem read(@PathParam(value="ID") String var1);

    @POST
    @Path(value="ci/{ID:.+}")
    public ConfigurationItem create(@PathParam(value="ID") String var1, ConfigurationItem var2);

    @POST
    @Path(value="ci/{ID:.+}")
    @Consumes(value={"multipart/form-data"})
    public ConfigurationItem create(@PathParam(value="ID") String var1, @MultipartForm ArtifactAndData var2);

    @PUT
    @Path(value="ci/{ID:.+}")
    public ConfigurationItem update(@PathParam(value="ID") String var1, ConfigurationItem var2);

    @PUT
    @Path(value="ci/{ID:.+}")
    @Consumes(value={"multipart/form-data"})
    public ConfigurationItem update(@PathParam(value="ID") String var1, @MultipartForm ArtifactAndData var2);

    @DELETE
    @Path(value="ci/{ID:.+}")
    public void delete(@PathParam(value="ID") String var1);

    @POST
    @Path(value="cis/delete")
    public void deleteList(List<String> var1);

    @POST
    @Path(value="cis/read")
    public List<ConfigurationItem> read(List<String> var1);

    @POST
    @Path(value="cis")
    public List<ConfigurationItem> create(List<ConfigurationItem> var1);

    @PUT
    @Path(value="cis")
    public List<ConfigurationItem> update(List<ConfigurationItem> var1);

    @GET
    @Path(value="exists/{ID:.+}")
    public Boolean exists(@PathParam(value="ID") String var1);

    @POST
    @Path(value="move/{ID:.+}")
    public ConfigurationItem move(@PathParam(value="ID") String var1, @QueryParam(value="newId") String var2);

    @POST
    @Path(value="copy/{ID:.+}")
    public ConfigurationItem copy(@PathParam(value="ID") String var1, @QueryParam(value="newId") String var2);

    @POST
    @Path(value="rename/{ID:.+}")
    public ConfigurationItem rename(@PathParam(value="ID") String var1, @QueryParam(value="newName") String var2);

    @GET
    @Path(value="query")
    public List<ConfigurationItemId> query(@QueryParam(value="type") Type var1, @QueryParam(value="parent") String var2, @QueryParam(value="ancestor") String var3, @QueryParam(value="namePattern") String var4, @QueryParam(value="lastModifiedBefore") DateTime var5, @QueryParam(value="lastModifiedAfter") DateTime var6, @QueryParam(value="page") long var7, @QueryParam(value="resultsPerPage") long var9);

    @GET
    @Path(value="v2/query")
    public List<ConfigurationItemId> queryV2(@QueryParam(value="type") Type var1, @QueryParam(value="parent") String var2, @QueryParam(value="ancestor") String var3, @QueryParam(value="namePattern") String var4, @QueryParam(value="idPattern") String var5, @QueryParam(value="lastModifiedBefore") DateTime var6, @QueryParam(value="lastModifiedAfter") DateTime var7, @QueryParam(value="page") long var8, @QueryParam(value="resultsPerPage") long var10);

    @GET
    @Path(value="v3/query")
    public List<ConfigurationItemId> queryV3(@QueryParam(value="type") Type var1, @QueryParam(value="parent") String var2, @QueryParam(value="ancestor") String var3, @QueryParam(value="namePattern") String var4, @QueryParam(value="idPattern") String var5, @QueryParam(value="lastModifiedBefore") DateTime var6, @QueryParam(value="lastModifiedAfter") DateTime var7, @QueryParam(value="page") long var8, @QueryParam(value="resultsPerPage") long var10, @QueryParam(value="properties") ConfigurationItemProperties var12);

    @POST
    @Path(value="candidate-values")
    public List<ConfigurationItemId> candidateValues(@QueryParam(value="propertyName") String var1, @QueryParam(value="namePattern") String var2, @QueryParam(value="idPattern") String var3, @QueryParam(value="page") long var4, @QueryParam(value="resultsPerPage") long var6, ConfigurationItem var8);

    @POST
    @Path(value="validate")
    public List<ConfigurationItem> validate(List<ConfigurationItem> var1);
}

