/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;

class CommittableIndexReader
extends FilterIndexReader {
    private static final int DELETE_HISTORY_SIZE = 1000;
    private volatile long modCount;
    private final List<Integer> deleteHistory = new LinkedList<Integer>();
    private final BitSet deletedDocs = new BitSet();

    CommittableIndexReader(IndexReader in) {
        super(in);
        this.modCount = in.getVersion();
        int maxDocs = in.maxDoc();
        for (int i = 0; i < maxDocs; ++i) {
            if (!in.isDeleted(i)) continue;
            this.deletedDocs.set(i);
        }
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        super.doDelete(n);
        ++this.modCount;
        if (this.deleteHistory.size() >= 1000) {
            this.deleteHistory.remove(0);
        }
        this.deleteHistory.add(n);
        this.deletedDocs.set(n);
    }

    long getModificationCount() {
        return this.modCount;
    }

    Collection<Integer> getDeletedSince(long modCount) throws IllegalArgumentException {
        if (modCount > this.modCount) {
            throw new IllegalArgumentException("modCount: " + modCount + " > " + this.modCount);
        }
        if (modCount == this.modCount) {
            return Collections.emptyList();
        }
        long num = this.modCount - modCount;
        if (num > (long)this.deleteHistory.size()) {
            return null;
        }
        ArrayList<Integer> deletes = new ArrayList<Integer>((int)num);
        for (Integer d : this.deleteHistory.subList((int)((long)this.deleteHistory.size() - num), this.deleteHistory.size())) {
            deletes.add(d);
        }
        return deletes;
    }

    BitSet getDeletedDocs() {
        return (BitSet)this.deletedDocs.clone();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("CommittableIndexReader(");
        buffer.append(this.in);
        buffer.append(',');
        buffer.append(this.modCount);
        buffer.append(')');
        return buffer.toString();
    }
}

