/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnboundedFifoByteBuffer {
    protected byte[] buffer;
    protected int head;
    protected int tail;

    public UnboundedFifoByteBuffer() {
        this(32);
    }

    public UnboundedFifoByteBuffer(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.buffer = new byte[initialSize + 1];
        this.head = 0;
        this.tail = 0;
    }

    public int size() {
        int size = 0;
        size = this.tail < this.head ? this.buffer.length - this.head + this.tail : this.tail - this.head;
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(byte b) {
        if (this.size() + 1 >= this.buffer.length) {
            byte[] tmp = new byte[(this.buffer.length - 1) * 2 + 1];
            int j = 0;
            int i = this.head;
            while (i != this.tail) {
                tmp[j] = this.buffer[i];
                this.buffer[i] = 0;
                ++j;
                if (++i != this.buffer.length) continue;
                i = 0;
            }
            this.buffer = tmp;
            this.head = 0;
            this.tail = j;
        }
        this.buffer[this.tail] = b;
        ++this.tail;
        if (this.tail >= this.buffer.length) {
            this.tail = 0;
        }
        return true;
    }

    public byte get() {
        if (this.isEmpty()) {
            throw new IllegalStateException("The buffer is already empty");
        }
        return this.buffer[this.head];
    }

    public byte remove() {
        if (this.isEmpty()) {
            throw new IllegalStateException("The buffer is already empty");
        }
        byte element = this.buffer[this.head];
        ++this.head;
        if (this.head >= this.buffer.length) {
            this.head = 0;
        }
        return element;
    }

    private int increment(int index) {
        if (++index >= this.buffer.length) {
            index = 0;
        }
        return index;
    }

    private int decrement(int index) {
        if (--index < 0) {
            index = this.buffer.length - 1;
        }
        return index;
    }

    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int index;
            private int lastReturnedIndex;
            {
                this.index = UnboundedFifoByteBuffer.this.head;
                this.lastReturnedIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.index != UnboundedFifoByteBuffer.this.tail;
            }

            @Override
            public Byte next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoByteBuffer.this.increment(this.index);
                return new Byte(UnboundedFifoByteBuffer.this.buffer[this.lastReturnedIndex]);
            }

            @Override
            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == UnboundedFifoByteBuffer.this.head) {
                    UnboundedFifoByteBuffer.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int i = this.lastReturnedIndex + 1;
                while (i != UnboundedFifoByteBuffer.this.tail) {
                    if (i >= UnboundedFifoByteBuffer.this.buffer.length) {
                        UnboundedFifoByteBuffer.this.buffer[i - 1] = UnboundedFifoByteBuffer.this.buffer[0];
                        i = 0;
                        continue;
                    }
                    UnboundedFifoByteBuffer.this.buffer[i - 1] = UnboundedFifoByteBuffer.this.buffer[i];
                    ++i;
                }
                this.lastReturnedIndex = -1;
                UnboundedFifoByteBuffer.this.tail = UnboundedFifoByteBuffer.this.decrement(UnboundedFifoByteBuffer.this.tail);
                UnboundedFifoByteBuffer.this.buffer[UnboundedFifoByteBuffer.this.tail] = 0;
                this.index = UnboundedFifoByteBuffer.this.decrement(this.index);
            }
        };
    }
}

