/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;

public class DescriptorHelper {
    public static void describe(String typeName) {
        DescriptorHelper.describeType(typeName);
    }

    private static void describeType(String shortType) {
        Type type = Type.valueOf((String)shortType);
        if (!DescriptorRegistry.exists((Type)type)) {
            System.out.println();
            System.out.printf("No ConfigurationItem named \"%s\" found.\n", shortType);
            System.out.println();
            return;
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        System.out.println();
        System.out.printf("ConfigurationItem %s:\n", descriptor.getType());
        System.out.printf("Description: %s\n", descriptor.getDescription());
        System.out.println("Control tasks:");
        for (MethodDescriptor controlTask : descriptor.getControlTasks()) {
            System.out.printf("\t. %s: %s\n", controlTask.getName(), controlTask.getDescription());
        }
        System.out.println("Properties:");
        for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
            System.out.printf("\t%s %s(%s): %s\n", DescriptorHelper.getPropertyModifier(property), property.getName(), DescriptorHelper.getType(property), property.getDescription());
            if (property.getKind() != PropertyKind.ENUM) continue;
            System.out.printf("\t\tValues: %s\n", property.getEnumValues());
        }
        System.out.println();
        System.out.println("Properties marked with a '!' are required for discovery.");
        System.out.println("Properties marked with a '*' are required.");
        System.out.println();
    }

    private static String getPropertyModifier(PropertyDescriptor property) {
        return property.isRequired() ? "*" : "-";
    }

    private static String getType(PropertyDescriptor property) {
        PropertyKind type = property.getKind();
        switch (type) {
            case CI: {
                return property.getReferencedType().toString();
            }
            case SET_OF_CI: {
                return String.format("Set<%s>", property.getReferencedType());
            }
            case LIST_OF_CI: {
                return String.format("List<%s>", property.getReferencedType());
            }
            case SET_OF_STRING: {
                return "Set<String>";
            }
            case LIST_OF_STRING: {
                return "List<String>";
            }
        }
        return type.name();
    }
}

