/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.DatabaseConfig;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Configuration
@EnableTransactionManagement
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\u0006%\u0002!\t!\u000f\u0005\u0006)\u0002!I!\u0016\u0005\u0006E\u0002!\ta\u0019\u0005\u0006U\u0002!\ta\u0019\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\u0006}\u0002!\tA\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\t9\u0002\u0001C\u0001\u0003\u0007Aq!a\u0007\u0001\t\u0013\tibB\u0004\u0002TUA\t!!\u0016\u0007\rQ)\u0002\u0012AA,\u0011\u0019!t\u0002\"\u0001\u0002Z!9\u00111L\b\u0005\u0002\u0005u\u0003bBA?\u001f\u0011%\u0011q\u0010\u0005\b\u0003\u001b{A\u0011AAH\u0005A\u0019\u0016\u000f\\\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u0017/\u000511m\u001c8gS\u001eT!\u0001G\r\u0002\t\r|'/\u001a\u0006\u00035m\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u00039u\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003y\t1aY8n\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006g24GG\u001b\u0006\u0002Y\u0005AqM]5{u2,G-\u0003\u0002/S\t9Aj\\4hS:<\u0017!\u0003=mI\u000e{gNZ5h!\t\t$'D\u0001\u0016\u0013\t\u0019TCA\u0005YY\u0012\u001cuN\u001c4jO\u00061A(\u001b8jiz\"\"AN\u001c\u0011\u0005E\u0002\u0001\"B\u0018\u0003\u0001\u0004\u0001\u0014AD7bS:$\u0015\r^1T_V\u00148-Z\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0004gFd'\"A \u0002\u000b)\fg/\u0019=\n\u0005\u0005c$A\u0003#bi\u0006\u001cv.\u001e:dK\"\"1aQ(Q!\t!U*D\u0001F\u0015\t1u)\u0001\u0006b]:|G/\u0019;j_:T!\u0001S%\u0002\u000f\r|g\u000e^3yi*\u0011!jS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA*A\u0002pe\u001eL!AT#\u0003\t\t+\u0017M\\\u0001\u000eI\u0016\u001cHO]8z\u001b\u0016$\bn\u001c3\"\u0003E\u000bQa\u00197pg\u0016\f1C]3q_J$\u0018N\\4ECR\f7k\\;sG\u0016DC\u0001B\"P!\u00061\u0012N\\:ueVlWM\u001c;fI\u0012\u000bG/Y*pkJ\u001cW\r\u0006\u0002WAB\u0011qKX\u0007\u00021*\u0011\u0011LW\u0001\u0005U\u0012\u00147M\u0003\u0002\\9\u00069Q.\u001a;sS\u000e\u001c(BA/\u001e\u0003\u0015!\u0018\u000fZ3w\u0013\ty\u0006L\u0001\fJ]N$(/^7f]R,G\rR1uCN{WO]2f\u0011\u0015\tW\u00011\u0001;\u0003)!\u0017\r^1T_V\u00148-Z\u0001\u000f[\u0006LgnU9m\t&\fG.Z2u+\u0005!\u0007CA3h\u001b\u00051'BA\u001f\u0018\u0013\tAgM\u0001\u0006Tc2$\u0015.\u00197fGRD#AB\"\u0002'I,\u0007o\u001c:uS:<7+\u001d7ES\u0006dWm\u0019;)\u0005\u001d\u0019\u0015\u0001E7bS:TEMY2UK6\u0004H.\u0019;f+\u0005q\u0007CA8s\u001b\u0005\u0001(B\u0001\rr\u0015\tI\u0016*\u0003\u0002ta\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\u0012\u0001bQ\u0001\u0017[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4feV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{\u0013\u0006YAO]1og\u0006\u001cG/[8o\u0013\ta\u0018P\u0001\u000eQY\u0006$hm\u001c:n)J\fgn]1di&|g.T1oC\u001e,'\u000f\u000b\u0002\n\u0007\u0006Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJD#AC\"\u0002-%t\u0017\u000e^5bY&TX-T1j]\u0012\u000bG/\u00192bg\u0016$\"!!\u0002\u0011\u0007\t\n9!C\u0002\u0002\n\r\u0012A!\u00168ji\"\u001a1\"!\u0004\u0011\t\u0005=\u00111C\u0007\u0003\u0003#Q!A\u0012 \n\t\u0005U\u0011\u0011\u0003\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u00027%t\u0017\u000e^5bY&TXMU3q_J$\u0018N\\4ECR\f'-Y:fQ\ra\u0011QB\u0001\u0010kB$\u0017\r^3MSF,\u0018NY1tKRA\u0011QAA\u0010\u0003s\tY\u0004C\u0004\u0002\"5\u0001\r!a\t\u0002\rM\u001c\u0007.Z7b!\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003S\u0019SBAA\u0016\u0015\r\ticH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E2%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\u0019\u0003\"B1\u000e\u0001\u0004Q\u0004BBA\u001f\u001b\u0001\u0007A-A\u0004eS\u0006dWm\u0019;)\u0007\u0001\t\t\u0005\u0005\u0003\u0002D\u0005\u001dSBAA#\u0015\t1\u00150\u0003\u0003\u0002J\u0005\u0015#aG#oC\ndW\r\u0016:b]N\f7\r^5p]6\u000bg.Y4f[\u0016tG\u000fK\u0002\u0001\u0003\u001b\u00022\u0001RA(\u0013\r\t\t&\u0012\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002!M\u000bHnQ8oM&<WO]1uS>t\u0007CA\u0019\u0010'\ty\u0011\u0005\u0006\u0002\u0002V\u0005\u0001\u0002.[6be&$\u0015\r^1T_V\u00148-\u001a\u000b\u0007\u0003?\ny'!\u001f\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u00051\u0001.[6be&T1!!\u001b\u001e\u0003\u0019Q\u0018\r\u001f=fe&!\u0011QNA2\u0005AA\u0015n[1sS\u0012\u000bG/Y*pkJ\u001cW\rC\u0004\u0002rE\u0001\r!a\u001d\u0002\u0011\u0011\fG/\u00192bg\u0016\u00042!MA;\u0013\r\t9(\u0006\u0002\u000f\t\u0006$\u0018MY1tK\u000e{gNZ5h\u0011\u001d\tY(\u0005a\u0001\u0003G\tAA\\1nK\u0006a\u0001.[6be&\u001cuN\u001c4jOR1\u0011\u0011QAD\u0003\u0013\u0003B!!\u0019\u0002\u0004&!\u0011QQA2\u00051A\u0015n[1sS\u000e{gNZ5h\u0011\u00191\"\u00031\u0001\u0002t!9\u00111\u0012\nA\u0002\u0005\r\u0012\u0001\u00039p_2t\u0015-\\3\u0002!1L\u0017/^5cCN,7i\u001c8uKb$HCBA\u0012\u0003#\u000b\u0019\n\u0003\u0004\u0002>M\u0001\r\u0001\u001a\u0005\b\u0003+\u001b\u0002\u0019AAL\u0003\r\u0019wN\u001c\t\u0005\u00033\u000b\t+\u0004\u0002\u0002\u001c*\u0019Q(!(\u000b\u0005\u0005}\u0015\u0001\u00026bm\u0006LA!a)\u0002\u001c\nQ1i\u001c8oK\u000e$\u0018n\u001c8")
public class SqlConfiguration
implements Logging {
    private final XldConfig xldConfig;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String liquibaseContext(SqlDialect sqlDialect, Connection connection) {
        return SqlConfiguration$.MODULE$.liquibaseContext(sqlDialect, connection);
    }

    public static HikariDataSource hikariDataSource(DatabaseConfig databaseConfig, String string) {
        return SqlConfiguration$.MODULE$.hikariDataSource(databaseConfig, string);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.xldConfig.repository().database(), "MainPool"));
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.xldConfig.reporting().database(), "ReportingPool"));
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect mainSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Detected SQL dialect for main: ").append(dialect).append(".").toString());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect reportingSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Detected SQL dialect for reporting: ").append(dialect).append(".").toString());
        return var1_1;
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new JdbcTemplate(this.mainDataSource());
    }

    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new DataSourceTransactionManager(this.mainDataSource());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/main-schema.yaml", this.mainDataSource(), this.mainSqlDialect());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/reporting-schema.yaml", this.reportingDataSource(), this.reportingSqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Detected liquibase context: ").append(context).toString());
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(connection)).update(context);
        }
    }

    public SqlConfiguration(XldConfig xldConfig) {
        this.xldConfig = xldConfig;
        Logging.$init$((Logging)this);
    }
}

