/*
 * Decompiled with CFR 0.152.
 */
package kamon.trace;

import akka.actor.ReflectiveDynamicAccess;
import com.typesafe.config.Config;
import kamon.trace.ClockSampler;
import kamon.trace.LevelOfDetail;
import kamon.trace.LevelOfDetail$MetricsOnly$;
import kamon.trace.LevelOfDetail$SimpleTrace$;
import kamon.trace.NoSampling$;
import kamon.trace.OrderedSampler;
import kamon.trace.RandomSampler;
import kamon.trace.SampleAll$;
import kamon.trace.Sampler;
import kamon.trace.ThresholdSampler;
import kamon.trace.TraceSettings;
import kamon.util.ConfigTools$;
import kamon.util.ConfigTools$Syntax$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.sys.package$;

public final class TraceSettings$
implements Serializable {
    public static TraceSettings$ MODULE$;

    static {
        new TraceSettings$();
    }

    public TraceSettings apply(Config config) {
        Sampler sampler;
        LevelOfDetail$MetricsOnly$ detailLevel;
        LevelOfDetail levelOfDetail;
        Config tracerConfig = config.getConfig("kamon.trace");
        String string = tracerConfig.getString("level-of-detail");
        if ("metrics-only".equals(string)) {
            levelOfDetail = LevelOfDetail$MetricsOnly$.MODULE$;
        } else if ("simple-trace".equals(string)) {
            levelOfDetail = LevelOfDetail$SimpleTrace$.MODULE$;
        } else {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown tracer level of detail [", "] present in the configuration file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
        }
        LevelOfDetail$MetricsOnly$ levelOfDetail$MetricsOnly$ = detailLevel = levelOfDetail;
        LevelOfDetail$MetricsOnly$ levelOfDetail$MetricsOnly$2 = LevelOfDetail$MetricsOnly$.MODULE$;
        if (!(levelOfDetail$MetricsOnly$ != null ? !levelOfDetail$MetricsOnly$.equals(levelOfDetail$MetricsOnly$2) : levelOfDetail$MetricsOnly$2 != null)) {
            sampler = NoSampling$.MODULE$;
        } else {
            Sampler sampler2;
            String string2 = tracerConfig.getString("sampling");
            if ("all".equals(string2)) {
                sampler2 = SampleAll$.MODULE$;
            } else if ("random".equals(string2)) {
                sampler2 = new RandomSampler(tracerConfig.getInt("random-sampler.chance"));
            } else if ("ordered".equals(string2)) {
                sampler2 = new OrderedSampler(tracerConfig.getInt("ordered-sampler.sample-interval"));
            } else if ("threshold".equals(string2)) {
                sampler2 = new ThresholdSampler(ConfigTools$Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(tracerConfig), "threshold-sampler.minimum-elapsed-time").toNanos());
            } else if ("clock".equals(string2)) {
                sampler2 = new ClockSampler(ConfigTools$Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(tracerConfig), "clock-sampler.pause").toNanos());
            } else {
                throw new MatchError((Object)string2);
            }
            sampler = sampler2;
        }
        NoSampling$ sampler3 = sampler;
        ReflectiveDynamicAccess dynamic = new ReflectiveDynamicAccess(this.getClass().getClassLoader());
        String tokenGeneratorFQN = tracerConfig.getString("token-generator");
        Function0 tokenGenerator = (Function0)dynamic.createInstanceFor(tokenGeneratorFQN, (scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Function0.class)).get();
        return new TraceSettings(detailLevel, sampler3, (Function0<String>)tokenGenerator);
    }

    public TraceSettings apply(LevelOfDetail levelOfDetail, Sampler sampler, Function0<String> tokenGenerator) {
        return new TraceSettings(levelOfDetail, sampler, tokenGenerator);
    }

    public Option<Tuple3<LevelOfDetail, Sampler, Function0<String>>> unapply(TraceSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.levelOfDetail(), (Object)x$0.sampler(), x$0.tokenGenerator()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TraceSettings$() {
        MODULE$ = this;
    }
}

