/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.server;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.LDIFReader;
import java.io.InputStream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class UnboundIdContainer
implements InitializingBean,
DisposableBean,
Lifecycle,
ApplicationContextAware {
    private InMemoryDirectoryServer directoryServer;
    private String defaultPartitionSuffix;
    private int port = 53389;
    private ApplicationContext context;
    private boolean running;
    private String ldif;

    public UnboundIdContainer(String defaultPartitionSuffix, String ldif) {
        this.defaultPartitionSuffix = defaultPartitionSuffix;
        this.ldif = ldif;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{this.defaultPartitionSuffix});
            config.addAdditionalBindCredentials("uid=admin,ou=system", "secret");
            config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"LDAP", (int)this.port)});
            config.setEnforceSingleStructuralObjectClass(false);
            config.setEnforceAttributeSyntaxCompliance(true);
            DN dn = new DN(this.defaultPartitionSuffix);
            Entry entry = new Entry(dn);
            entry.addAttribute("objectClass", new String[]{"top", "domain", "extensibleObject"});
            entry.addAttribute("dc", dn.getRDN().getAttributeValues()[0]);
            InMemoryDirectoryServer directoryServer = new InMemoryDirectoryServer(config);
            directoryServer.add(entry);
            this.importLdif(directoryServer);
            directoryServer.startListening();
            this.port = directoryServer.getListenPort();
            this.directoryServer = directoryServer;
            this.running = true;
        }
        catch (LDAPException ex) {
            throw new RuntimeException("Server startup failed", ex);
        }
    }

    private void importLdif(InMemoryDirectoryServer directoryServer) {
        block15: {
            if (StringUtils.hasText((String)this.ldif)) {
                try {
                    Resource[] resources = this.context.getResources(this.ldif);
                    if (resources.length <= 0 || !resources[0].exists()) break block15;
                    try (InputStream inputStream = resources[0].getInputStream();){
                        directoryServer.importFromLDIF(false, new LDIFReader(inputStream));
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to load LDIF " + this.ldif, ex);
                }
            }
        }
    }

    public void stop() {
        this.directoryServer.shutDown(true);
    }

    public boolean isRunning() {
        return this.running;
    }
}

