/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.util.internal.logging.InternalLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;

public class MulticastEndpoint {
    private String mcastGroupIp = "228.10.10.10";
    private int mcastGroupPort = 12345;
    private String bindAddress = "192.168.0.10";
    private DatagramChannel datagramChannel;
    private Bootstrap connectionlessBootstrap;
    private InetSocketAddress multicastAddress;
    private static Executor executor = Executors.newCachedThreadPool();
    byte[] id;
    boolean init = false;
    EventLoopGroup group;
    public boolean debug = false;
    public InternalLogger logger;

    public void init(ChannelPipelineFactory factory) throws Exception {
        this.id = String.format("%1$020d", Math.abs(new Random(System.currentTimeMillis()).nextLong())).getBytes();
        this.group = new OioEventLoopGroup();
        this.connectionlessBootstrap = new Bootstrap();
        this.connectionlessBootstrap.group(this.group);
        this.connectionlessBootstrap.option(ChannelOption.SO_BROADCAST, (Object)true);
        this.connectionlessBootstrap.handler((ChannelHandler)factory);
        this.connectionlessBootstrap.channel(OioDatagramChannel.class);
        this.datagramChannel = (DatagramChannel)this.connectionlessBootstrap.bind((SocketAddress)new InetSocketAddress(this.mcastGroupPort)).sync().channel();
        this.multicastAddress = new InetSocketAddress(this.mcastGroupIp, this.mcastGroupPort);
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(this.bindAddress));
        this.datagramChannel.joinGroup(this.multicastAddress, null);
        this.init = true;
        if (this.debug) {
            factory.debug();
        }
    }

    public boolean isInit() {
        return this.init;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLogger(InternalLogger logger) {
        this.logger = logger;
    }

    public void send(ByteBuf msg) throws Exception {
        byte[] arr = msg.array();
        byte[] buf = new byte[arr.length + this.id.length];
        System.arraycopy(this.id, 0, buf, 0, this.id.length);
        System.arraycopy(arr, 0, buf, this.id.length, arr.length);
        ByteBuf bbuf = Unpooled.wrappedBuffer((byte[])buf);
        if (this.debug && this.logger != null) {
            this.logger.info("discovery send " + new String(bbuf.array()));
        }
        this.datagramChannel.writeAndFlush((Object)new DatagramPacket(bbuf, this.multicastAddress)).sync();
    }

    public String getMcastGroupIp() {
        return this.mcastGroupIp;
    }

    public int getMcastGroupPort() {
        return this.mcastGroupPort;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setMcastGroupIp(String mcastGroupIp) {
        this.mcastGroupIp = mcastGroupIp;
    }

    public void setMcastGroupPort(int mcastGroupPort) {
        this.mcastGroupPort = mcastGroupPort;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void close() {
        this.datagramChannel.close();
        try {
            this.group.shutdownGracefully().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ByteBuf getMessage(ByteBuf e) {
        if (this.checkMessage(e)) {
            return e.slice(this.id.length, e.readableBytes() - this.id.length);
        }
        return null;
    }

    public String getStringMessage(ByteBuf e) {
        ByteBuf m = this.getMessage(e);
        if (m == null) {
            return null;
        }
        return m.toString(Charset.defaultCharset());
    }

    public boolean checkMessage(ByteBuf e) {
        byte[] eId = new byte[this.id.length];
        e.getBytes(0, eId, 0, eId.length);
        return !Arrays.equals(this.id, eId);
    }
}

