/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.PropertyValue;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.AbstractRow;

public class SelectorRow
extends AbstractRow {
    private final String selector;
    private final Node node;
    private final double score;

    public SelectorRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator, String selector, Node node, double score) {
        super(columns, evaluator);
        this.selector = selector;
        this.node = node;
        this.score = score;
    }

    public Node getNode() {
        return this.node;
    }

    public Node getNode(String selectorName) throws RepositoryException {
        this.checkSelectorName(selectorName);
        return this.node;
    }

    public double getScore() {
        return this.score;
    }

    public double getScore(String selectorName) throws RepositoryException {
        this.checkSelectorName(selectorName);
        return this.score;
    }

    private void checkSelectorName(String name) throws RepositoryException {
        if (!this.selector.equals(name)) {
            throw new RepositoryException("Selector " + name + " is not included in this row");
        }
    }

    public String toString() {
        return "{ " + this.selector + ": " + this.node + " }";
    }
}

