/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\t\rh!B\u001b7\u0005ir\u0004\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006q\u0002!\t!\u001f\u0005\b}\u0002\u0011\r\u0011b\u0001\u0000\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u0005\u0001\"CA\b\u0001\t\u0007I1AA\t\u0011!\ty\u0002\u0001Q\u0001\n\u0005M\u0001\"CA\u0011\u0001\t\u0007I\u0011AA\u0012\u0011\u001d\t)\u0003\u0001Q\u0001\n\u0001D\u0011\"a\n\u0001\u0001\u0004%I!!\u000b\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0002\u0002CA \u0001\u0001\u0006K!a\u000b\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\b\u0003\u0013\u0002\u0001\u0015!\u0003u\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAn\u0001\u0011%\u0011Q\\\u0004\t\u0003g4\u0004\u0012\u0001\u001e\u0002v\u001a9QG\u000eE\u0001u\u0005]\bB\u0002=\u0019\t\u0003\tI\u0010C\u0005\u0002|b\u0011\r\u0011\"\u0003\u0002~\"A!Q\u0002\r!\u0002\u0013\ty\u0010C\u0005\u0003\u0010a\u0011\r\u0011\"\u0003\u0002~\"A!\u0011\u0003\r!\u0002\u0013\ty\u0010C\u0004\u0003\u0014a!IA!\u0006\t\u0013\t}\u0001D1A\u0005\n\t\u0005\u0002\u0002\u0003B\u00121\u0001\u0006I!!)\u0007\r\t\u0015\u0002\u0004\u0011B\u0014\u0011)\u0011Y$\tBK\u0002\u0013\u0005!Q\b\u0005\u000b\u0005\u007f\t#\u0011#Q\u0001\n\u0005M\u0004B\u0002=\"\t\u0003\u0011\t\u0005C\u0005\u0003J\u0005\n\t\u0011\"\u0001\u0003L!I!qJ\u0011\u0012\u0002\u0013\u0005!\u0011\u000b\u0005\n\u0005K\n\u0013\u0011!C!\u0005OB\u0011Ba\u001d\"\u0003\u0003%\tA!\u001e\t\u0013\tu\u0014%!A\u0005\u0002\t}\u0004\"\u0003BEC\u0005\u0005I\u0011\tBF\u0011%\u0011I*IA\u0001\n\u0003\u0011Y\nC\u0005\u0003 \u0006\n\t\u0011\"\u0011\u0003\"\"I!1U\u0011\u0002\u0002\u0013\u0005#QU\u0004\n\u0005SC\u0012\u0011!E\u0001\u0005W3\u0011B!\n\u0019\u0003\u0003E\tA!,\t\ra|C\u0011\u0001B^\u0011%\u0011ilLA\u0001\n\u000b\u0012y\fC\u0005\u0003B>\n\t\u0011\"!\u0003D\"I!qY\u0018\u0002\u0002\u0013\u0005%\u0011\u001a\u0005\n\u0005+|\u0013\u0011!C\u0005\u0005/\u0014\u0001#Q:z]\u000e$en\u001d*fg>dg/\u001a:\u000b\u0005]B\u0014\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005eR\u0014a\u00013og*\u00111\bP\u0001\u0003S>T\u0011!P\u0001\u0005C.\\\u0017m\u0005\u0003\u0001\u007f\u0015[\u0005C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\r\u0005\u0002G\u00136\tqI\u0003\u0002Iy\u0005)\u0011m\u0019;pe&\u0011!j\u0012\u0002\u0006\u0003\u000e$xN\u001d\t\u0003\r2K!!T$\u0003\u0019\u0005\u001bGo\u001c:M_\u001e<\u0017N\\4\u0002\u0011M,G\u000f^5oON\u001c\u0001\u0001\u0005\u0002R%6\t\u0001(\u0003\u0002Tq\tYAI\\:TKR$\u0018N\\4t\u0003\u0015\u0019\u0017m\u00195f!\t1v+D\u00017\u0013\tAfGA\u0007Bgft7\r\u00128t\u0007\u0006\u001c\u0007.Z\u0001\u000eG2LWM\u001c;GC\u000e$xN]=\u0011\u000b\u0001[V\f\u0019;\n\u0005q\u000b%!\u0003$v]\u000e$\u0018n\u001c83!\t1e,\u0003\u0002`\u000f\ny\u0011i\u0019;peJ+gMR1di>\u0014\u0018\u0010E\u0002bS2t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u0015|\u0015A\u0002\u001fs_>$h(C\u0001C\u0013\tA\u0017)A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'\u0001\u0002'jgRT!\u0001[!\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018a\u00018fi*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\t\u0004C&,\bC\u0001$w\u0013\t9xI\u0001\u0005BGR|'OU3g\u0003\u0019a\u0014N\\5u}Q!!p\u001f?~!\t1\u0006\u0001C\u0003O\t\u0001\u0007\u0001\u000bC\u0003U\t\u0001\u0007Q\u000bC\u0003Z\t\u0001\u0007!,\u0001\u0002fGV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA!\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\f\u0005\u0015!\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\u0006\u0019Qm\u0019\u0011\u0002\u000fQLW.Z8viV\u0011\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u001f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\t9BA\u0004US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\n1B\\1nKN+'O^3sgV\t\u0001-\u0001\u0007oC6,7+\u001a:wKJ\u001c\b%A\u0005sKF,Xm\u001d;JIV\u0011\u00111\u0006\t\u0004\u0001\u00065\u0012bAA\u0018\u0003\n)1\u000b[8si\u0006i!/Z9vKN$\u0018\nZ0%KF$B!!\u000e\u0002<A\u0019\u0001)a\u000e\n\u0007\u0005e\u0012I\u0001\u0003V]&$\b\"CA\u001f\u0019\u0005\u0005\t\u0019AA\u0016\u0003\rAH%M\u0001\u000be\u0016\fX/Z:u\u0013\u0012\u0004\u0013A\u00028fqRLE\r\u0006\u0002\u0002,\u0005I!/Z:pYZ,'o]\u000b\u0002i\u0006Q!/Z:pYZ,'o\u001d\u0011\u0002\u000fI,7-Z5wKV\u0011\u0011q\n\t\u0005\u0003#\n\u0019&D\u0001\u0001\u0013\r\t)&\u0013\u0002\b%\u0016\u001cW-\u001b<f\u0003Q\u0011Xm]8mm\u0016<\u0016\u000e\u001e5SKN|GN^3sgRA\u00111LA8\u0003\u0007\u000bY\n\u0005\u0004\u0002\u0004\u0005u\u0013\u0011M\u0005\u0005\u0003?\n)A\u0001\u0004GkR,(/\u001a\t\u0005\u0003G\nIGD\u0002R\u0003KJ1!a\u001a9\u0003-!en\u001d)s_R|7m\u001c7\n\t\u0005-\u0014Q\u000e\u0002\t%\u0016\u001cx\u000e\u001c<fI*\u0019\u0011q\r\u001d\t\u000f\u0005E$\u00031\u0001\u0002t\u0005!a.Y7f!\u0011\t)(! \u000f\t\u0005]\u0014\u0011\u0010\t\u0003G\u0006K1!a\u001fB\u0003\u0019\u0001&/\u001a3fM&!\u0011qPAA\u0005\u0019\u0019FO]5oO*\u0019\u00111P!\t\u000f\u0005\u0015%\u00031\u0001\u0002\b\u0006Y!/Z9vKN$H+\u001f9f!\u0011\tI)a&\u000f\t\u0005-\u0015Q\r\b\u0005\u0003\u001b\u000b)J\u0004\u0003\u0002\u0010\u0006MebA2\u0002\u0012&\tQ(\u0003\u0002<y%\u0011\u0011HO\u0005\u0005\u00033\u000biGA\u0006SKF,Xm\u001d;UsB,\u0007BBA#%\u0001\u0007A/\u0001\u0007tK:$\u0017+^3ti&|g\u000e\u0006\u0004\u0002\"\u0006U\u0016\u0011\u0018\t\u0007\u0003\u0007\ti&a)\u0011\t\u0005\u0015\u0016q\u0016\b\u0005\u0003O\u000bYK\u0004\u0003\u0002\f\u0006%\u0016BA\u001c9\u0013\r\tiKN\u0001\n\t:\u001c8\t\\5f]RLA!!-\u00024\n1\u0011I\\:xKJT1!!,7\u0011\u0019\t9l\u0005a\u0001k\u0006A!/Z:pYZ,'\u000fC\u0004\u0002<N\u0001\r!!0\u0002\u000f5,7o]1hKB!\u0011QUA`\u0013\u0011\t\t-a-\u0003\u0017\u0011s7/U;fgRLwN\\\u0001\u0012e\u0016\u001cx\u000e\u001c<f/&$\bnU3be\u000eDG\u0003CA.\u0003\u000f\fI-a3\t\u000f\u0005ED\u00031\u0001\u0002t!9\u0011Q\u0011\u000bA\u0002\u0005\u001d\u0005BBA\\)\u0001\u0007Q/\u0001\u0007sKN|GN^3GSJ\u001cH\u000f\u0006\u0005\u0002\\\u0005E\u0017q[Am\u0011\u001d\t\u0019.\u0006a\u0001\u0003+\f1b]3be\u000eDg*Y7fgB!\u0011-[A:\u0011\u001d\t))\u0006a\u0001\u0003\u000fCa!a.\u0016\u0001\u0004)\u0018a\u0002:fg>dg/\u001a\u000b\t\u00037\ny.!9\u0002d\"9\u0011\u0011\u000f\fA\u0002\u0005M\u0004bBAC-\u0001\u0007\u0011q\u0011\u0005\u0007\u0003o3\u0002\u0019A;)\u0007\u0001\t9\u000f\u0005\u0003\u0002j\u0006=XBAAv\u0015\r\ti\u000fP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAy\u0003W\u00141\"\u00138uKJt\u0017\r\\!qS\u0006\u0001\u0012i]=oG\u0012s7OU3t_24XM\u001d\t\u0003-b\u0019\"\u0001G \u0015\u0005\u0005U\u0018aC5qmR\nE\r\u001a:fgN,\"!a@\u0011\t\t\u0005!\u0011B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005AQ.\u0019;dQ&twMC\u0002\u0002\u001a\u0005KAAa\u0003\u0003\u0004\t)!+Z4fq\u0006a\u0011\u000e\u001d<5\u0003\u0012$'/Z:tA\u0005Y\u0011\u000e\u001d<7\u0003\u0012$'/Z:t\u00031I\u0007O\u001e\u001cBI\u0012\u0014Xm]:!\u00035I7/\u00138fi\u0006#GM]3tgR!!q\u0003B\u000f!\r\u0001%\u0011D\u0005\u0004\u00057\t%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003cr\u0002\u0019AA:\u0003\u0015)U\u000e\u001d;z+\t\t\t+\u0001\u0004F[B$\u0018\u0010\t\u0002\u0017%\u0016\u001cx\u000e\u001c<f\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]N9\u0011E!\u000b\u00030\tU\u0002cA1\u0003,%\u0019!QF6\u0003\u0013\u0015C8-\u001a9uS>t\u0007c\u0001!\u00032%\u0019!1G!\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0001Ia\u000e\n\u0007\te\u0012I\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0002ng\u001e,\"!a\u001d\u0002\t5\u001cx\r\t\u000b\u0005\u0005\u0007\u00129\u0005E\u0002\u0003F\u0005j\u0011\u0001\u0007\u0005\b\u0005w!\u0003\u0019AA:\u0003\u0011\u0019w\u000e]=\u0015\t\t\r#Q\n\u0005\n\u0005w)\u0003\u0013!a\u0001\u0003g\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003T)\"\u00111\u000fB+W\t\u00119\u0006\u0005\u0003\u0003Z\t\u0005TB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAAw\u0003&!!1\rB.\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t%\u0004\u0003\u0002B6\u0005cj!A!\u001c\u000b\u0007\t=\u0004/\u0001\u0003mC:<\u0017\u0002BA@\u0005[\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u001e\u0011\u0007\u0001\u0013I(C\u0002\u0003|\u0005\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!!\u0003\bB\u0019\u0001Ia!\n\u0007\t\u0015\u0015IA\u0002B]fD\u0011\"!\u0010*\u0003\u0003\u0005\rAa\u001e\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!$\u0011\r\t=%Q\u0013BA\u001b\t\u0011\tJC\u0002\u0003\u0014\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119J!%\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005/\u0011i\nC\u0005\u0002>-\n\t\u00111\u0001\u0003\u0002\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003x\u00051Q-];bYN$BAa\u0006\u0003(\"I\u0011QH\u0017\u0002\u0002\u0003\u0007!\u0011Q\u0001\u0017%\u0016\u001cx\u000e\u001c<f\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]B\u0019!QI\u0018\u0014\u000b=\u0012yK!\u000e\u0011\u0011\tE&qWA:\u0005\u0007j!Aa-\u000b\u0007\tU\u0016)A\u0004sk:$\u0018.\\3\n\t\te&1\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDC\u0001BV\u0003!!xn\u0015;sS:<GC\u0001B5\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\u0011\u0019E!2\t\u000f\tm\"\u00071\u0001\u0002t\u00059QO\\1qa2LH\u0003\u0002Bf\u0005#\u0004R\u0001\u0011Bg\u0003gJ1Aa4B\u0005\u0019y\u0005\u000f^5p]\"I!1[\u001a\u0002\u0002\u0003\u0007!1I\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!7\u0011\t\t-$1\\\u0005\u0005\u0005;\u0014iG\u0001\u0004PE*,7\r\u001e\u0015\u00041\u0005\u001d\bfA\f\u0002h\u0002")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final AsyncDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)A1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)(mode = resolve.requestType())));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)some.value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(resolved2, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1 & Serializable & scala.Serializable)resolved -> {
                            block0: {
                                if (!resolved.records().nonEmpty()) break block0;
                                CachePolicy.Ttl minTtl = ((ResourceRecord)resolved.records().minBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.ttl().value(), (Ordering)Duration.DurationIsOrdered$.MODULE$)).ttl();
                                $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, minTtl);
                            }
                            return resolved;
                        }, (ExecutionContext)this.$outer.ec()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String akka.io.dns.DnsProtocol$RequestType akka.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(akka.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ARecord record;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new MatchError((Object)inetAddress);
                }
                ARecord aRecord = record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
            }));
        } else {
            Future future2;
            List<ActorRef> list = resolvers;
            if (Nil$.MODULE$.equals(list)) {
                future2 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                ActorRef head = (ActorRef)colon2.head();
                List tail = colon2.tl$access$1();
                future2 = this.resolveWithSearch(name, requestType, head).recoverWith((PartialFunction)new scala.Serializable(this, name, requestType, tail){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncDnsResolver $outer;
                    private final String name$2;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Future<DnsProtocol.Resolved> future;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable t = (Throwable)option.get();
                            this.$outer.log().error(t, "Resolve failed. Trying next name server");
                            future = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                        } else {
                            future = function1.apply(x1);
                        }
                        return (B1)future;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$2 = name$2;
                        this.requestType$1 = requestType$1;
                        this.tail$1 = tail$1;
                    }
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(list);
            }
            future = future2;
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.failed().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            AsyncDnsResolver.$anonfun$sendQuestion$1(this, resolver, message, x$3);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future;
        if (this.settings.SearchDomains().nonEmpty()) {
            List list;
            List nameWithSearch = (List)this.settings.SearchDomains().map((Function1 & Serializable & scala.Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString(), List$.MODULE$.canBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar((Object)x$4)))) >= this.settings.NDots()) {
                String string = name;
                list = nameWithSearch.$colon$colon((Object)string);
            } else {
                list = (List)nameWithSearch.$colon$plus((Object)name, List$.MODULE$.canBuildFrom());
            }
            List toResolve = list;
            future = this.resolveFirst((List<String>)toResolve, requestType, resolver);
        } else {
            future = this.resolve(name, requestType, resolver);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<String> list = searchNames;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String searchName = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return this.resolve(searchName, requestType, resolver);
            }
        }
        if (bl) {
            String searchName = (String)colon2.head();
            List remaining = colon2.tl$access$1();
            return this.resolve(searchName, requestType, resolver).flatMap((Function1 & Serializable & scala.Serializable)resolved -> resolved.records().isEmpty() ? this.resolveFirst((List<String>)remaining, requestType, resolver) : Future$.MODULE$.successful(resolved), (ExecutionContext)this.ec());
        }
        if (!Nil$.MODULE$.equals(list)) throw new MatchError(list);
        return Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            future = ipv4Recs.flatMap((Function1 & Serializable & scala.Serializable)ipv4 -> ipv6Recs.map((Function1 & Serializable & scala.Serializable)ipv6 -> new DnsProtocol.Resolved(name, (Seq<ResourceRecord>)((Seq)ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom())), (Seq<ResourceRecord>)((Seq)ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom()))), (ExecutionContext)this.ec()), (ExecutionContext)this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            future = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1 & Serializable & scala.Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), (ExecutionContext)this.ec());
        } else {
            throw new MatchError((Object)requestType2);
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$sendQuestion$1(AsyncDnsResolver $this, ActorRef resolver$1, DnsClient.DnsQuestion message$1, Throwable x$3) {
        package$.MODULE$.actorRef2Scala(resolver$1).$bang(new DnsClient.DropRequest(message$1.id()), $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$4) {
        return x$4 == '.';
    }

    public AsyncDnsResolver(DnsSettings settings, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger((int)settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.msg();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$((Product)this);
        }
    }
}

