/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext;

import liquibase.database.Database;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BlobType;
import liquibase.datatype.core.ClobType;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.DatabaseObject;

public class CreateTableGeneratorOracle
extends CreateTableGenerator {
    public int getPriority() {
        return 10;
    }

    public boolean supports(CreateTableStatement statement, Database database) {
        return database.getShortName().equals("oracle");
    }

    public Sql[] generateSql(CreateTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Sql[] sqls = super.generateSql(statement, database, sqlGeneratorChain);
        StringBuilder sb = new StringBuilder(sqls[0].toSql());
        statement.getColumns().stream().filter(name -> this.isLob((LiquibaseDataType)statement.getColumnTypes().get(name))).forEach(name -> {
            String columnName = database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), name);
            sb.append(String.format(" LOB(%s) STORE AS SECUREFILE", columnName));
        });
        sqls[0] = this.cloneSql(sb.toString(), sqls[0]);
        return sqls;
    }

    private boolean isLob(LiquibaseDataType dataType) {
        return dataType instanceof ClobType || dataType instanceof BlobType;
    }

    private UnparsedSql cloneSql(String string, Sql sql) {
        return new UnparsedSql(string, sql.getEndDelimiter(), sql.getAffectedDatabaseObjects().toArray(new DatabaseObject[0]));
    }
}

