/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.DeadLetterSuppression;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterHeartbeatSenderState;
import akka.cluster.ClusterMessage;
import akka.cluster.HeartbeatNodeRing;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.event.LoggingAdapter;
import akka.remote.FailureDetectorRegistry;
import akka.remote.HeartbeatMessage;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rusA\u00029r\u0011\u0003\tXO\u0002\u0004xc\"\u0005\u0011\u000f\u001f\u0005\u0007\u007f\u0006!\t!a\u0001\u0007\r\u0005\u0015\u0011AQA\u0004\u0011)\t\u0019d\u0001BK\u0002\u0013\u0005\u0011Q\u0007\u0005\u000b\u0003{\u0019!\u0011#Q\u0001\n\u0005]\u0002BB@\u0004\t\u0003\ty\u0004C\u0005\u0002H\r\t\t\u0011\"\u0001\u0002J!I\u0011QJ\u0002\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003K\u001a\u0011\u0011!C!\u0003OB\u0011\"!\u001f\u0004\u0003\u0003%\t!a\u001f\t\u0013\u0005\r5!!A\u0005\u0002\u0005\u0015\u0005\"CAI\u0007\u0005\u0005I\u0011IAJ\u0011%\t\tkAA\u0001\n\u0003\t\u0019\u000bC\u0005\u0002.\u000e\t\t\u0011\"\u0011\u00020\"I\u0011\u0011W\u0002\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003k\u001b\u0011\u0011!C!\u0003o;\u0011\"a/\u0002\u0003\u0003E\t!!0\u0007\u0013\u0005\u0015\u0011!!A\t\u0002\u0005}\u0006BB@\u0013\t\u0003\ti\rC\u0005\u00022J\t\t\u0011\"\u0012\u00024\"I\u0011q\u001a\n\u0002\u0002\u0013\u0005\u0015\u0011\u001b\u0005\n\u0003+\u0014\u0012\u0011!CA\u0003/D\u0011\"a9\u0013\u0003\u0003%I!!:\u0007\r\u00055\u0018AQAx\u0011)\t\u0019\u0004\u0007BK\u0002\u0013\u0005\u0011\u0011\u001f\u0005\u000b\u0003{A\"\u0011#Q\u0001\n\u0005M\bBB@\u0019\t\u0003\tI\u0010C\u0005\u0002Ha\t\t\u0011\"\u0001\u0002\u0000\"I\u0011Q\n\r\u0012\u0002\u0013\u0005!1\u0001\u0005\n\u0003KB\u0012\u0011!C!\u0003OB\u0011\"!\u001f\u0019\u0003\u0003%\t!a\u001f\t\u0013\u0005\r\u0005$!A\u0005\u0002\t\u001d\u0001\"CAI1\u0005\u0005I\u0011IAJ\u0011%\t\t\u000bGA\u0001\n\u0003\u0011Y\u0001C\u0005\u0002.b\t\t\u0011\"\u0011\u00020\"I\u0011\u0011\u0017\r\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003kC\u0012\u0011!C!\u0005\u001f9\u0011Ba\u0005\u0002\u0003\u0003E\tA!\u0006\u0007\u0013\u00055\u0018!!A\t\u0002\t]\u0001BB@(\t\u0003\u0011Y\u0002C\u0005\u00022\u001e\n\t\u0011\"\u0012\u00024\"I\u0011qZ\u0014\u0002\u0002\u0013\u0005%Q\u0004\u0005\n\u0003+<\u0013\u0011!CA\u0005CA\u0011\"a9(\u0003\u0003%I!!:\b\u000f\t\u001d\u0012\u0001#!\u0003*\u00199!1F\u0001\t\u0002\n5\u0002BB@/\t\u0003\u0011y\u0003C\u0005\u0002f9\n\t\u0011\"\u0011\u0002h!I\u0011\u0011\u0010\u0018\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u0007s\u0013\u0011!C\u0001\u0005cA\u0011\"!%/\u0003\u0003%\t%a%\t\u0013\u0005\u0005f&!A\u0005\u0002\tU\u0002\"CAW]\u0005\u0005I\u0011IAX\u0011%\t\tLLA\u0001\n\u0003\n\u0019\fC\u0005\u0002d:\n\t\u0011\"\u0003\u0002f\u001a1!\u0011H\u0001C\u0005wA!\"a\r9\u0005+\u0007I\u0011AAy\u0011)\ti\u0004\u000fB\tB\u0003%\u00111\u001f\u0005\u0007\u007fb\"\tA!\u0010\t\u0013\u0005\u001d\u0003(!A\u0005\u0002\t\r\u0003\"CA'qE\u0005I\u0011\u0001B\u0002\u0011%\t)\u0007OA\u0001\n\u0003\n9\u0007C\u0005\u0002za\n\t\u0011\"\u0001\u0002|!I\u00111\u0011\u001d\u0002\u0002\u0013\u0005!q\t\u0005\n\u0003#C\u0014\u0011!C!\u0003'C\u0011\"!)9\u0003\u0003%\tAa\u0013\t\u0013\u00055\u0006(!A\u0005B\u0005=\u0006\"CAYq\u0005\u0005I\u0011IAZ\u0011%\t)\fOA\u0001\n\u0003\u0012yeB\u0005\u0003T\u0005\t\t\u0011#\u0001\u0003V\u0019I!\u0011H\u0001\u0002\u0002#\u0005!q\u000b\u0005\u0007\u007f\u001e#\tAa\u0017\t\u0013\u0005Ev)!A\u0005F\u0005M\u0006\"CAh\u000f\u0006\u0005I\u0011\u0011B/\u0011%\t)nRA\u0001\n\u0003\u0013\t\u0007C\u0005\u0002d\u001e\u000b\t\u0011\"\u0003\u0002f\u001a1q/\u001d\u0002r\u0005KBaa`'\u0005\u0002\tM\u0004\u0002\u0003:N\u0005\u0004%\tAa\u001e\t\u0011\t}T\n)A\u0005\u0005sB\u0011B!!N\u0005\u0004%\tAa!\t\u0011\t\u0015U\n)A\u0005\u0003KC\u0011Ba\"N\u0005\u0004%\tA!#\t\u0011\t]U\n)A\u0005\u0005\u0017C\u0011B!'N\u0005\u0004%\tAa'\t\u0011\t\u0005V\n)A\u0005\u0005;C\u0011Ba)N\u0005\u0004%\tA!*\t\u0011\t5V\n)A\u0005\u0005OC\u0011Ba,N\u0001\u0004%\tA!-\t\u0013\teV\n1A\u0005\u0002\tm\u0006\u0002\u0003Bc\u001b\u0002\u0006KAa-\t\u0013\t\u001dWJ1A\u0005\u0002\t%\u0007\u0002\u0003Bi\u001b\u0002\u0006IAa3\t\u0013\tMW\n1A\u0005\n\tU\u0007\"\u0003Bo\u001b\u0002\u0007I\u0011\u0002Bp\u0011!\u0011\u0019/\u0014Q!\n\t]\u0007b\u0002Bs\u001b\u0012\u0005#q\u001d\u0005\b\u0005SlE\u0011\tBt\u0011\u001d\u0011Y/\u0014C\u0001\u0005[DqA!?N\t\u0003\u0011Y\u0010C\u0004\u0004\f5#\tAa?\t\u000f\r5Q\n\"\u0001\u0003|\"91qB'\u0005\u0002\rE\u0001bBB\u001a\u001b\u0012\u00051Q\u0007\u0005\b\u0007wiE\u0011AB\u001f\u0011\u001d\u0019\t%\u0014C\u0001\u0007\u0007Bqaa\u0012N\t\u0003\u0019I\u0005C\u0004\u0004N5#\tAa:\t\u000f\r=S\n\"\u0003\u0003h\"91\u0011K'\u0005\u0002\rM\u0003bBB,\u001b\u0012\u00051\u0011L\u0001\u0017\u00072,8\u000f^3s\u0011\u0016\f'\u000f\u001e2fCR\u001cVM\u001c3fe*\u0011!o]\u0001\bG2,8\u000f^3s\u0015\u0005!\u0018\u0001B1lW\u0006\u0004\"A^\u0001\u000e\u0003E\u0014ac\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM]\n\u0003\u0003e\u0004\"A_?\u000e\u0003mT\u0011\u0001`\u0001\u0006g\u000e\fG.Y\u0005\u0003}n\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003U\u0014\u0011\u0002S3beR\u0014W-\u0019;\u0014\u0019\rI\u0018\u0011BA\b\u00037\t9#!\f\u0011\u0007Y\fY!C\u0002\u0002\u000eE\u0014ab\u00117vgR,'/T3tg\u0006<W\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)b]\u0001\u0007e\u0016lw\u000e^3\n\t\u0005e\u00111\u0003\u0002\u0011\u0011\u0016\f'\u000f\u001e2fCRlUm]:bO\u0016\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0019\u0018!B1di>\u0014\u0018\u0002BA\u0013\u0003?\u0011Q\u0003R3bI2+G\u000f^3s'V\u0004\bO]3tg&|g\u000eE\u0002{\u0003SI1!a\u000b|\u0005\u001d\u0001&o\u001c3vGR\u00042A_A\u0018\u0013\r\t\td\u001f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005MJ|W.\u0006\u0002\u00028A!\u0011QDA\u001d\u0013\u0011\tY$a\b\u0003\u000f\u0005#GM]3tg\u0006)aM]8nAQ!\u0011\u0011IA#!\r\t\u0019eA\u0007\u0002\u0003!9\u00111\u0007\u0004A\u0002\u0005]\u0012\u0001B2paf$B!!\u0011\u0002L!I\u00111G\u0004\u0011\u0002\u0003\u0007\u0011qG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tF\u000b\u0003\u00028\u0005M3FAA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}30\u0001\u0006b]:|G/\u0019;j_:LA!a\u0019\u0002Z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0003g\nAA[1wC&!\u0011qOA7\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0010\t\u0004u\u0006}\u0014bAAAw\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qQAG!\rQ\u0018\u0011R\u0005\u0004\u0003\u0017[(aA!os\"I\u0011qR\u0006\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0005CBAL\u0003;\u000b9)\u0004\u0002\u0002\u001a*\u0019\u00111T>\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002 \u0006e%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!*\u0002,B\u0019!0a*\n\u0007\u0005%6PA\u0004C_>dW-\u00198\t\u0013\u0005=U\"!AA\u0002\u0005\u001d\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002&\u0006e\u0006\"CAH!\u0005\u0005\t\u0019AAD\u0003%AU-\u0019:uE\u0016\fG\u000fE\u0002\u0002DI\u0019RAEAa\u0003[\u0001\u0002\"a1\u0002J\u0006]\u0012\u0011I\u0007\u0003\u0003\u000bT1!a2|\u0003\u001d\u0011XO\u001c;j[\u0016LA!a3\u0002F\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005u\u0016!B1qa2LH\u0003BA!\u0003'Dq!a\r\u0016\u0001\u0004\t9$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0017q\u001c\t\u0006u\u0006m\u0017qG\u0005\u0004\u0003;\\(AB(qi&|g\u000eC\u0005\u0002bZ\t\t\u00111\u0001\u0002B\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0004B!a\u001b\u0002j&!\u00111^A7\u0005\u0019y%M[3di\na\u0001*Z1si\n,\u0017\r\u001e*taNa\u0001$_A\u0005\u0003\u001f\tY\"a\n\u0002.U\u0011\u00111\u001f\t\u0004m\u0006U\u0018bAA|c\niQK\\5rk\u0016\fE\r\u001a:fgN$B!a?\u0002~B\u0019\u00111\t\r\t\u000f\u0005M2\u00041\u0001\u0002tR!\u00111 B\u0001\u0011%\t\u0019\u0004\bI\u0001\u0002\u0004\t\u00190\u0006\u0002\u0003\u0006)\"\u00111_A*)\u0011\t9I!\u0003\t\u0013\u0005=\u0005%!AA\u0002\u0005uD\u0003BAS\u0005\u001bA\u0011\"a$#\u0003\u0003\u0005\r!a\"\u0015\t\u0005\u0015&\u0011\u0003\u0005\n\u0003\u001f+\u0013\u0011!a\u0001\u0003\u000f\u000bA\u0002S3beR\u0014W-\u0019;SgB\u00042!a\u0011('\u00159#\u0011DA\u0017!!\t\u0019-!3\u0002t\u0006mHC\u0001B\u000b)\u0011\tYPa\b\t\u000f\u0005M\"\u00061\u0001\u0002tR!!1\u0005B\u0013!\u0015Q\u00181\\Az\u0011%\t\toKA\u0001\u0002\u0004\tY0A\u0007IK\u0006\u0014HOY3biRK7m\u001b\t\u0004\u0003\u0007r#!\u0004%fCJ$(-Z1u)&\u001c7n\u0005\u0004/s\u0006\u001d\u0012Q\u0006\u000b\u0003\u0005S!B!a\"\u00034!I\u0011q\u0012\u001a\u0002\u0002\u0003\u0007\u0011Q\u0010\u000b\u0005\u0003K\u00139\u0004C\u0005\u0002\u0010R\n\t\u00111\u0001\u0002\b\n1R\t\u001f9fGR,GMR5sgRDU-\u0019:uE\u0016\fGo\u0005\u00049s\u0006\u001d\u0012Q\u0006\u000b\u0005\u0005\u007f\u0011\t\u0005E\u0002\u0002DaBq!a\r<\u0001\u0004\t\u0019\u0010\u0006\u0003\u0003@\t\u0015\u0003\"CA\u001ayA\u0005\t\u0019AAz)\u0011\t9I!\u0013\t\u0013\u0005=\u0005)!AA\u0002\u0005uD\u0003BAS\u0005\u001bB\u0011\"a$C\u0003\u0003\u0005\r!a\"\u0015\t\u0005\u0015&\u0011\u000b\u0005\n\u0003\u001f+\u0015\u0011!a\u0001\u0003\u000f\u000ba#\u0012=qK\u000e$X\r\u001a$jeN$\b*Z1si\n,\u0017\r\u001e\t\u0004\u0003\u0007:5#B$\u0003Z\u00055\u0002\u0003CAb\u0003\u0013\f\u0019Pa\u0010\u0015\u0005\tUC\u0003\u0002B \u0005?Bq!a\rK\u0001\u0004\t\u0019\u0010\u0006\u0003\u0003$\t\r\u0004\"CAq\u0017\u0006\u0005\t\u0019\u0001B '\u0019i\u0015Pa\u001a\u0003nA!\u0011Q\u0004B5\u0013\u0011\u0011Y'a\b\u0003\u000b\u0005\u001bGo\u001c:\u0011\t\u0005u!qN\u0005\u0005\u0005c\nyB\u0001\u0007BGR|'\u000fT8hO&tw\r\u0006\u0002\u0003vA\u0011a/T\u000b\u0003\u0005s\u00022A\u001eB>\u0013\r\u0011i(\u001d\u0002\b\u00072,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004\u0013\u0001\u0005<fe\n|7/\u001a%fCJ$(-Z1u+\t\t)+A\twKJ\u0014wn]3IK\u0006\u0014HOY3bi\u0002\nADZ5mi\u0016\u0014\u0018J\u001c;fe:\fGn\u00117vgR,'/T3nE\u0016\u00148/\u0006\u0002\u0003\fB9!P!$\u0003\u0012\u0006\u0015\u0016b\u0001BHw\nIa)\u001e8di&|g.\r\t\u0004m\nM\u0015b\u0001BKc\n1Q*Z7cKJ\fQDZ5mi\u0016\u0014\u0018J\u001c;fe:\fGn\u00117vgR,'/T3nE\u0016\u00148\u000fI\u0001\u000eg\u0016dg\rS3beR\u0014W-\u0019;\u0016\u0005\tu\u0005c\u0001BP\u00079\u0011a\u000fA\u0001\u000fg\u0016dg\rS3beR\u0014W-\u0019;!\u0003=1\u0017-\u001b7ve\u0016$U\r^3di>\u0014XC\u0001BT!\u0019\t\tB!+\u00028%!!1VA\n\u0005]1\u0015-\u001b7ve\u0016$U\r^3di>\u0014(+Z4jgR\u0014\u00180\u0001\tgC&dWO]3EKR,7\r^8sA\u0005)1\u000f^1uKV\u0011!1\u0017\t\u0004m\nU\u0016b\u0001B\\c\nY2\t\\;ti\u0016\u0014\b*Z1si\n,\u0017\r^*f]\u0012,'o\u0015;bi\u0016\f\u0011b\u001d;bi\u0016|F%Z9\u0015\t\tu&1\u0019\t\u0004u\n}\u0016b\u0001Baw\n!QK\\5u\u0011%\tyIWA\u0001\u0002\u0004\u0011\u0019,\u0001\u0004ti\u0006$X\rI\u0001\u000eQ\u0016\f'\u000f\u001e2fCR$\u0016m]6\u0016\u0005\t-\u0007\u0003BA\u000f\u0005\u001bLAAa4\u0002 \tY1)\u00198dK2d\u0017M\u00197f\u00039AW-\u0019:uE\u0016\fG\u000fV1tW\u0002\nQ\u0002^5dWRKW.Z:uC6\u0004XC\u0001Bl!\rQ(\u0011\\\u0005\u0004\u00057\\(\u0001\u0002'p]\u001e\f\u0011\u0003^5dWRKW.Z:uC6\u0004x\fJ3r)\u0011\u0011iL!9\t\u0013\u0005=u,!AA\u0002\t]\u0017A\u0004;jG.$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\taJ,7\u000b^1siR\u0011!QX\u0001\ta>\u001cHo\u0015;pa\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a:\u0015\t\t=(Q\u001f\t\u0005\u0003;\u0011\t0\u0003\u0003\u0003t\u0006}!AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\b\u0005o\u001c\u0007\u0019AA\u001c\u0003\u001d\tG\r\u001a:fgN\fqA]3dK&4X-\u0006\u0002\u0003~B!!q`B\u0003\u001d\u0011\tib!\u0001\n\t\r\r\u0011qD\u0001\u0006\u0003\u000e$xN]\u0005\u0005\u0007\u000f\u0019IAA\u0004SK\u000e,\u0017N^3\u000b\t\r\r\u0011qD\u0001\rS:LG/[1mSjLgnZ\u0001\u0007C\u000e$\u0018N^3\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0005{\u001b\u0019\u0002C\u0004\u0004\u0016\u001d\u0004\raa\u0006\u0002\u0011Mt\u0017\r]:i_R\u0004Ba!\u0007\u0004.9!11DB\u0015\u001d\u0011\u0019iba\n\u000f\t\r}1QE\u0007\u0003\u0007CQAaa\t\u0002\u0002\u00051AH]8pizJ\u0011\u0001^\u0005\u0003eNL1aa\u000br\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u0019yc!\r\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\u0007\r-\u0012/A\u0005bI\u0012lU-\u001c2feR!!QXB\u001c\u0011\u001d\u0019I\u0004\u001ba\u0001\u0005#\u000b\u0011!\\\u0001\re\u0016lwN^3NK6\u0014WM\u001d\u000b\u0005\u0005{\u001by\u0004C\u0004\u0004:%\u0004\rA!%\u0002#Ut'/Z1dQ\u0006\u0014G.Z'f[\n,'\u000f\u0006\u0003\u0003>\u000e\u0015\u0003bBB\u001dU\u0002\u0007!\u0011S\u0001\u0010e\u0016\f7\r[1cY\u0016lU-\u001c2feR!!QXB&\u0011\u001d\u0019Id\u001ba\u0001\u0005#\u000b\u0011\u0002[3beR\u0014W-\u0019;\u0002#\rDWmY6US\u000e\\\u0017J\u001c;feZ\fG.\u0001\u0007iK\u0006\u0014HOY3biJ\u001b\b\u000f\u0006\u0003\u0003>\u000eU\u0003bBA\u001a]\u0002\u0007\u00111_\u0001\u0016iJLwmZ3s\r&\u00148\u000f\u001e%fCJ$(-Z1u)\u0011\u0011ila\u0017\t\u000f\u0005Mr\u000e1\u0001\u0002t\u0002")
public final class ClusterHeartbeatSender
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Function1<Member, Object> filterInternalClusterMembers;
    private final Heartbeat selfHeartbeat;
    private final FailureDetectorRegistry<Address> failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public Heartbeat selfHeartbeat() {
        return this.selfHeartbeat;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp() {
        return this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    }

    public void akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(long x$1) {
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = x$1;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.state().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)a -> {
            ClusterHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    this.$outer.context().become(this.$outer.active());
                    object = BoxedUnit.UNIT;
                } else if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(System.nanoTime());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof HeartbeatRsp) {
                    HeartbeatRsp heartbeatRsp = (HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.unreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.reachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ExpectedFirstHeartbeat) {
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.ReachableMember ? true : object instanceof ExpectedFirstHeartbeat)))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes2 = (SortedSet)snapshot.members().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes2, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m) {
        block0: {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) || this.state().contains(m.uniqueAddress()) || !BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block0;
            this.state_$eq(this.state().addMember(m.uniqueAddress()));
        }
    }

    public void removeMember(Member m) {
        block2: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block2;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
            } else {
                this.state_$eq(this.state().removeMember(m.uniqueAddress()));
            }
        }
    }

    public void unreachableMember(Member m) {
        this.state_$eq(this.state().unreachableMember(m.uniqueAddress()));
    }

    public void reachableMember(Member m) {
        this.state_$eq(this.state().reachableMember(m.uniqueAddress()));
    }

    public void heartbeat() {
        this.state().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)to -> {
            ClusterHeartbeatSender.$anonfun$heartbeat$1(this, to);
            return BoxedUnit.UNIT;
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp() >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.cluster().ClusterLogger().logWarning("Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, e.g. by running blocking tasks on the default dispatcher, CPU overload, or GC.", BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp())), BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(now);
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.cluster().ClusterLogger().logDebug("Heartbeat response from [{}]", from.address());
        }
        this.state_$eq(this.state().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.state().activeReceivers().apply((Object)from) || this.failureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.cluster().ClusterLogger().logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat((Object)from.address());
        }
    }

    public static final /* synthetic */ boolean $anonfun$filterInternalClusterMembers$1(ClusterHeartbeatSender $this, Member x$1) {
        String string = x$1.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(ClusterHeartbeatSender $this, UniqueAddress a) {
        $this.failureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(ClusterHeartbeatSender $this, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.failureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("First Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)$this.selfHeartbeat(), $this.self());
    }

    public ClusterHeartbeatSender() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.filterInternalClusterMembers = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterHeartbeatSender.$anonfun$filterInternalClusterMembers$1(this, x$1));
        this.selfHeartbeat = new Heartbeat(this.cluster().selfAddress());
        this.failureDetector = this.cluster().failureDetector();
        this.state = new ClusterHeartbeatSenderState(new HeartbeatNodeRing(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    scala.Serializable {
        private final UniqueAddress from;

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.from();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectedFirstHeartbeat;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;

        public Address from() {
            return this.from;
        }

        public Heartbeat copy(Address from) {
            return new Heartbeat(from);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.from();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Heartbeat;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Heartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            Heartbeat heartbeat = (Heartbeat)x$1;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public Heartbeat(Address from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;

        public UniqueAddress from() {
            return this.from;
        }

        public HeartbeatRsp copy(UniqueAddress from) {
            return new HeartbeatRsp(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.from();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HeartbeatRsp;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HeartbeatRsp)) return false;
            boolean bl = true;
            if (!bl) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public HeartbeatRsp(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }
}

