/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ExtendedActorSystem;
import com.xebialabs.deployit.core.TypeConversions$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.engine.tasker.satellite.KryoAkkaSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.KryoBasedSerializer;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\tMe\u0001\u0002\u000f\u001e\u00011B\u0001B\u0012\u0001\u0003\u0006\u0004%\ta\u0012\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0011\"AQ\u000b\u0001BC\u0002\u0013\ra\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t9\u0004\u0001C!\u0003sAq!a\u000f\u0001\t\u0003\ni\u0004C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|!9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\ti\u000b\u0001C\u0005\u0003_C\u0011\"!=\u0001#\u0003%I!a\u001f\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9!Q\u0001\u0001\u0005B\t\u001d\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011I\u0003\u0001C!\u0005WAqAa\r\u0001\t\u0003\u0012)\u0004C\u0004\u0003>\u0001!\tEa\u0010\t\u000f\t\r\u0003\u0001\"\u0011\u0003F!9!1\u000b\u0001\u0005\n\tU\u0003b\u0002B-\u0001\u0011%!1\f\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OBqAa\u001b\u0001\t\u0013\u0011iG\u0001\rTc2\u0004VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pefT!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\t\u001a\u0013A\u0002;bg.,'O\u0003\u0002%K\u00051QM\\4j]\u0016T!AJ\u0014\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001K\u0015\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\r\u0001i3gN\u001e?!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'N\u0007\u0002?%\u0011ag\b\u0002\u0016!\u0016tG-\u001b8h)\u0006\u001c8NU3q_NLGo\u001c:z!\tA\u0014(D\u0001\u001e\u0013\tQTDA\nQK:$\u0017N\\4UCN\\7/U;fe&,7\u000f\u0005\u00029y%\u0011Q(\b\u0002\u001b!\u0016tG-\u001b8h)\u0006\u001c8.T3uC\u0012\fG/Y)vKJLWm\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQa\u001d7gi)T\u0011aQ\u0001\tOJL'P\u001f7fI&\u0011Q\t\u0011\u0002\b\u0019><w-\u001b8h\u00031QGMY2UK6\u0004H.\u0019;f+\u0005A\u0005CA%S\u001b\u0005Q%BA&M\u0003\u0011\u0019wN]3\u000b\u00055s\u0015\u0001\u00026eE\u000eT!a\u0014)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!U\u0001\u0004_J<\u0017BA*K\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!A\b.\u000b\u0005-+\u0013B\u0001/Z\u0005)\u0019\u0016\u000f\u001c#jC2,7\r^\u0001\fgFdG)[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003AV$\"!\u00192\u0011\u0005a\u0002\u0001\"B+\u0006\u0001\b9\u0006\u0006\u00022e]>\u0004\"!\u001a7\u000e\u0003\u0019T!a\u001a5\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002jU\u00069a-Y2u_JL(BA6O\u0003\u0015\u0011W-\u00198t\u0013\tigMA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\n\u0001/\u0001\bnC&t7+\u001d7ES\u0006dWm\u0019;)\u0005\t\u0014\bCA3t\u0013\t!hMA\u0005BkR|w/\u001b:fI\")a)\u0002a\u0001\u0011\"\"Q\u000f\u001a8xC\u0005A\u0018\u0001E7bS:TEMY2UK6\u0004H.\u0019;fQ\t)(/A\u0003uCN\\7\u000fF\u0002}\u00033\u0001R!`A\u0003\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001B;uS2T!!a\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000fq(\u0001\u0002'jgR\u0004B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0019\u00111C\u0012\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0018\u00055!!\u0004+bg.<\u0016\u000e\u001e5CY>\u001c7\u000eC\u0004\u0002\u001c\u0019\u0001\r!!\b\u0002\u00191|\u0017\r\u001a$vY2\u001c\u0006/Z2\u0011\u00079\ny\"C\u0002\u0002\"=\u0012qAQ8pY\u0016\fg\u000e\u000b\u0004\u0007\u0003Kq\u0017\u0011\u0007\t\u0005\u0003O\ti#\u0004\u0002\u0002*)!\u00111FA\u0001\u0003\u0011a\u0017M\\4\n\t\u0005=\u0012\u0011\u0006\u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oONd#!a\r\"\u0005\u0005U\u0012aA1mY\u0006q1o\u00195fIVdW\r\u001a+bg.\u001cH#\u0001?\u0002\tQ\f7o\u001b\u000b\u0007\u0003\u007f\tY%a\u001e\u0011\u000b9\n\t%!\u0012\n\u0007\u0005\rsF\u0001\u0004PaRLwN\u001c\t\u0004i\u0005\u001d\u0013bAA%?\tY\u0001+\u001a8eS:<G+Y:l\u0011\u001d\ti\u0005\u0003a\u0001\u0003\u001f\na\u0001^1tW&#\u0007\u0003BA)\u0003crA!a\u0015\u0002n9!\u0011QKA6\u001d\u0011\t9&!\u001b\u000f\t\u0005e\u0013q\r\b\u0005\u00037\n)G\u0004\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tgK\u0001\u0007yI|w\u000e\u001e \n\u0003)J!\u0001K\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\t\u00113%C\u0002\u0002p\u0005\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002t\u0005U$A\u0002+bg.LEMC\u0002\u0002p\u0005B\u0011\"a\u0007\t!\u0003\u0005\r!!\b\u0002\u001dQ\f7o\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0010\u0016\u0005\u0003;\tyh\u000b\u0002\u0002\u0002B!\u00111QAF\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!C;oG\",7m[3e\u0015\t9w&\u0003\u0003\u0002\u000e\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!/Z1e'VlW.\u0019:z)\u0011\ty$a%\t\u000f\u00055#\u00021\u0001\u0002P\u0005a!/Z1e\rVdGn\u00159fGR!\u0011qHAM\u0011\u001d\tie\u0003a\u0001\u0003\u001f\nQ\u0002^8QK:$\u0017N\\4UCN\\G\u0003BA#\u0003?Cq!!)\r\u0001\u0004\t\u0019+\u0001\u0002sgB!\u0011QUAU\u001b\t\t9KC\u0002\u001f\u0003\u0003IA!a+\u0002(\nI!+Z:vYR\u001cV\r^\u0001\u0016a\u0016tG-\u001b8h)\u0006\u001c8N\u0012:p[\nKg.\u0019:z)1\t)%!-\u0002D\u0006M\u0017q]Aw\u0011\u001d\ti%\u0004a\u0001\u0003g\u0003B!!.\u0002>:!\u0011qWA]!\r\tifL\u0005\u0004\u0003w{\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0006\u0005'AB*ue&twMC\u0002\u0002<>Bq!!2\u000e\u0001\u0004\t9-A\u0007uCN\\7\u000b]3d\u0005f$Xm\u001d\t\u0006]\u0005%\u0017QZ\u0005\u0004\u0003\u0017|#!B!se\u0006L\bc\u0001\u0018\u0002P&\u0019\u0011\u0011[\u0018\u0003\t\tKH/\u001a\u0005\b\u0003+l\u0001\u0019AAl\u00035\u00198\r[3ek2,G\rR1uKB!\u0011\u0011\\Ar\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017\u0001\u0002;j[\u0016T1!!9Q\u0003\u0011Qw\u000eZ1\n\t\u0005\u0015\u00181\u001c\u0002\t\t\u0006$X\rV5nK\"9\u0011\u0011^\u0007A\u0002\u0005-\u0018!D<pe.,'/\u00113ee\u0016\u001c8\u000fE\u0003/\u0003\u0003\n\u0019\fC\u0005\u0002p6\u0001\n\u00111\u0001\u0002\u001e\u0005i\u0011n]*f]R$v.U;fk\u0016\fq\u0004]3oI&tw\rV1tW\u001a\u0013x.\u001c\"j]\u0006\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003\u0015\u0019Ho\u001c:f)\u0019\ty%a>\u0003\u0004!9\u0011\u0011`\bA\u0002\u0005m\u0018\u0001B:qK\u000e\u0004B!!@\u0002\u00006\t\u0011%C\u0002\u0003\u0002\u0005\u0012\u0011\u0003V1tWN\u0003XmY5gS\u000e\fG/[8o\u0011%\tIo\u0004I\u0001\u0002\u0004\tY/\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0005\u0013\u0011yA!\u0005\u0011\u00079\u0012Y!C\u0002\u0003\u000e=\u0012A!\u00168ji\"9\u0011Q\n\tA\u0002\u0005=\u0003bBA}!\u0001\u0007\u00111`\u0001\rgB,7\rV8CS:\f'/\u001f\u000b\u0005\u0003\u000f\u00149\u0002C\u0004\u0002zF\u0001\r!a?\u0002\u0015M,'/[1mSj,'/\u0006\u0002\u0003\u001eA!!q\u0004B\u0013\u001b\t\u0011\tCC\u0002\u0003$\u0005\n\u0011b]1uK2d\u0017\u000e^3\n\t\t\u001d\"\u0011\u0005\u0002\u0014\u0017JLxNQ1tK\u0012\u001cVM]5bY&TXM]\u0001\fG\"\fgnZ3Po:,'\u000f\u0006\u0004\u0003\n\t5\"q\u0006\u0005\b\u0003\u001b\u001a\u0002\u0019AA(\u0011\u001d\u0011\td\u0005a\u0001\u0003g\u000b\u0001B\\3x\u001f^tWM]\u0001\tg\u000eDW\rZ;mKR1!\u0011\u0002B\u001c\u0005sAq!!\u0014\u0015\u0001\u0004\ty\u0005C\u0004\u0003<Q\u0001\r!a6\u0002\t\u0011\fG/Z\u0001\u0007I\u0016dW\r^3\u0015\t\t%!\u0011\t\u0005\b\u0003\u001b*\u0002\u0019AA(\u0003A\u0001(/\u001a9be\u0016$v.\u00128rk\u0016,X\r\u0006\u0003\u0003H\tE\u0003C\u0002B%\u0005\u001b\nI!\u0004\u0002\u0003L)\u0011qpL\u0005\u0005\u0005\u001f\u0012YEA\u0002UefDq!!\u0014\u0017\u0001\u0004\ty%A\u0007fqR\u0014\u0018m\u0019;UCN\\\u0017\n\u001a\u000b\u0005\u0003\u001f\u00129\u0006C\u0004\u0002\"^\u0001\r!a)\u0002)\u0015DHO]1di^{'o[3s\u0003\u0012$'/Z:t)\u0011\tYO!\u0018\t\u000f\u0005\u0005\u0006\u00041\u0001\u0002$\u0006!R\r\u001f;sC\u000e$8k\u00195fIVdW\r\u001a#bi\u0016$B!a6\u0003d!9\u0011\u0011U\rA\u0002\u0005\r\u0016\u0001G3yiJ\f7\r\u001e+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]R!\u0011q\u0019B5\u0011\u001d\t\tK\u0007a\u0001\u0003G\u000bA#\u001a=ue\u0006\u001cG/S:TK:$Hk\\)vKV,G\u0003BA\u000f\u0005_Bq!!)\u001c\u0001\u0004\t\u0019\u000b\u000b\u0004\u0001\u0005gr'\u0011\u0011\t\u0005\u0005k\u0012i(\u0004\u0002\u0003x)\u0019qM!\u001f\u000b\u0007\tmd*A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002B@\u0005o\u0012Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017E\u0001BB\u0003Yi\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\bf\u0001\u0001\u0003\bB!!\u0011\u0012BH\u001b\t\u0011YIC\u0002\u0003\u000e:\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011\tJa#\u0003\u0013\r{W\u000e]8oK:$\b")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE;
    private String SELECT_SCHEDULED;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 1) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 8) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x10) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x40) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x400) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SENT_TO_QUEUE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SENT_TO_QUEUE$lzycompute() : this.UPDATE_SENT_TO_QUEUE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.toPendingTask(rs))).asScala()).toList() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.head();
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime((Timestamp)t)).orNull(Predef$.MODULE$.$conforms());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (rs, x$3) -> this.toPendingTask(rs));
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$4) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                return new Tuple5((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple5 tuple5 = x0$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String taskDescription = (String)tuple5._1();
                String owner = (String)tuple5._2();
                DateTime scheduledDate = (DateTime)tuple5._3();
                Option workerAddress = (Option)tuple5._4();
                boolean isSendToQueue = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, isSendToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$5) -> this.toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    private PendingTask toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pendingTask = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, isSentToQueue);
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull(Predef$.MODULE$.$conforms())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> exception.getMessage(), (Function0 & Serializable & scala.Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoBasedSerializer serializer() {
        return new KryoAkkaSerializer((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem()).serializer();
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void schedule(String taskId, DateTime date) {
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
    }

    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        Failure failure;
        SimpleSelectBuilder q = this.sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$6) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            failure = new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        } else if (option instanceof Some) {
            Failure failure2;
            Some some = (Some)option;
            PendingTask task = (PendingTask)some.value();
            if (task.isSentToQueue()) {
                failure2 = new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            } else {
                Success success;
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.jdbcTemplate().update(this.UPDATE_SENT_TO_QUEUE(), new Object[]{Boolean.TRUE, taskId}));
                if (try_ instanceof Success) {
                    success = new Success((Object)task);
                } else if (try_ instanceof Failure) {
                    Failure failure3 = (Failure)try_;
                    Throwable ex = failure3.exception();
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> ex.getMessage(), (Function0 & Serializable & scala.Serializable)() -> ex);
                    success = new Failure(ex);
                } else {
                    throw new MatchError((Object)try_);
                }
                failure2 = success;
            }
            failure = failure2;
        } else {
            throw new MatchError(option);
        }
        return failure;
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull(Predef$.MODULE$.$conforms());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

