/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.query.lucene.join.Constraints;

class ConstraintSplitInfo {
    private final QueryObjectModelFactory factory;
    private final Join source;
    private final List<Constraint> leftConstraints;
    private final List<Constraint> rightConstraints;
    private boolean isMultiple;
    private boolean hasLeftConstraints;
    private boolean hasRightConstraints;
    private ConstraintSplitInfo leftInnerConstraints = null;
    private ConstraintSplitInfo rightInnerConstraints = null;

    public ConstraintSplitInfo(QueryObjectModelFactory factory, Join source) {
        this(factory, source, new ArrayList<Constraint>(), new ArrayList<Constraint>());
    }

    private ConstraintSplitInfo(QueryObjectModelFactory factory, Join source, List<Constraint> leftConstraints, List<Constraint> rightConstraints) {
        this.factory = factory;
        this.source = source;
        this.leftConstraints = leftConstraints;
        this.rightConstraints = rightConstraints;
        this.isMultiple = false;
        this.hasLeftConstraints = false;
        this.hasRightConstraints = false;
    }

    public void addLeftConstraint(Constraint c) {
        if (this.isMultiple) {
            this.leftInnerConstraints.addLeftConstraint(c);
            this.rightInnerConstraints.addLeftConstraint(c);
            return;
        }
        this.leftConstraints.add(c);
        this.hasLeftConstraints = true;
    }

    public void addRightConstraint(Constraint c) {
        if (this.isMultiple) {
            this.leftInnerConstraints.addRightConstraint(c);
            this.rightInnerConstraints.addRightConstraint(c);
            return;
        }
        this.rightConstraints.add(c);
        this.hasRightConstraints = true;
    }

    public void splitOr() {
        if (this.isMultiple) {
            return;
        }
        this.isMultiple = true;
        ConstraintSplitInfo csi1 = new ConstraintSplitInfo(this.factory, this.source, new ArrayList<Constraint>(this.leftConstraints), new ArrayList<Constraint>(this.rightConstraints));
        csi1.hasLeftConstraints = this.hasLeftConstraints;
        csi1.hasRightConstraints = this.hasRightConstraints;
        this.leftInnerConstraints = csi1;
        ConstraintSplitInfo csi2 = new ConstraintSplitInfo(this.factory, this.source, new ArrayList<Constraint>(this.leftConstraints), new ArrayList<Constraint>(this.rightConstraints));
        csi2.hasLeftConstraints = this.hasLeftConstraints;
        csi2.hasRightConstraints = this.hasRightConstraints;
        this.rightInnerConstraints = csi2;
        this.leftConstraints.clear();
        this.rightConstraints.clear();
        this.hasLeftConstraints = false;
        this.hasRightConstraints = false;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public ConstraintSplitInfo getLeftInnerConstraints() {
        return this.leftInnerConstraints;
    }

    public ConstraintSplitInfo getRightInnerConstraints() {
        return this.rightInnerConstraints;
    }

    public Join getSource() {
        return this.source;
    }

    public Constraint getLeftConstraint() throws RepositoryException {
        return Constraints.and(this.factory, this.leftConstraints);
    }

    public Constraint getRightConstraint() throws RepositoryException {
        return Constraints.and(this.factory, this.rightConstraints);
    }

    public boolean isHasLeftConstraints() {
        return this.hasLeftConstraints;
    }

    public boolean isHasRightConstraints() {
        return this.hasRightConstraints;
    }

    public String toString() {
        if (this.isMultiple) {
            return "ConstraintSplitInfo [multiple=, leftInnerConstraints=" + this.leftInnerConstraints + ", rightInnerConstraints=" + this.rightInnerConstraints + "]";
        }
        return "ConstraintSplitInfo [single, leftConstraints=" + this.leftConstraints + ", rightConstraints=" + this.rightConstraints + ", hasLeftConstraints=" + this.hasLeftConstraints + ", hasRightConstraints=" + this.hasRightConstraints + "]";
    }
}

