/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.config;

import com.sksamuel.exts.Logging;
import com.sksamuel.exts.OptionImplicits$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;

public final class ConfigResolver$
implements Logging {
    public static ConfigResolver$ MODULE$;
    private final String EnvConfFilename;
    private final String OverrideFilename;
    private final String AppConfFilename;
    private final Path userHome;
    private final Path cwd;
    private final Logger logger;

    static {
        new ConfigResolver$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private String EnvConfFilename() {
        return this.EnvConfFilename;
    }

    private String OverrideFilename() {
        return this.OverrideFilename;
    }

    private String AppConfFilename() {
        return this.AppConfFilename;
    }

    private Path userHome() {
        return this.userHome;
    }

    private Path cwd() {
        return this.cwd;
    }

    public Config apply(boolean log) {
        Config refconf = ConfigFactory.defaultReference();
        Config appconf = ConfigFactory.parseResources((String)this.AppConfFilename());
        return this.loadOverrideConf$1(log).withFallback((ConfigMergeable)this.loadEnvConf$1(log)).withFallback((ConfigMergeable)appconf).withFallback((ConfigMergeable)refconf);
    }

    public boolean apply$default$1() {
        return false;
    }

    private final Config loadEnvConf$1(boolean log$1) {
        Path path;
        block0: {
            path = this.userHome().resolve(this.EnvConfFilename()).toAbsolutePath();
            if (!log$1) break block0;
            this.logger().info(new StringBuilder(21).append("Detecting env conf [").append(path).append("]").toString());
        }
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(path).option().fold((Function0 & java.io.Serializable & Serializable)() -> ConfigFactory.empty(), (Function1 & java.io.Serializable & Serializable)it -> ConfigFactory.parseFile((File)it.toFile()));
    }

    private final Config loadOverrideConf$1(boolean log$1) {
        Path path;
        block0: {
            path = this.cwd().resolve(this.OverrideFilename()).toAbsolutePath();
            if (!log$1) break block0;
            this.logger().info(new StringBuilder(26).append("Detecting override conf [").append(path).append("]").toString());
        }
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(path).option().fold((Function0 & java.io.Serializable & Serializable)() -> ConfigFactory.empty(), (Function1 & java.io.Serializable & Serializable)it -> ConfigFactory.parseFile((File)it.toFile()));
    }

    private ConfigResolver$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.EnvConfFilename = "env_exts.conf";
        this.OverrideFilename = "override.conf";
        this.AppConfFilename = "app_exts.conf";
        this.userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        this.cwd = Paths.get(".", new String[0]);
    }
}

