/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;

final class JdbcSharedStateManager
extends AbstractJDBCDriver
implements SharedStateManager {
    private static final Logger logger = Logger.getLogger(JdbcSharedStateManager.class);
    private static final int MAX_SETUP_ATTEMPTS = 20;
    private final String holderId;
    private final long lockExpirationMillis;
    private JdbcLeaseLock liveLock;
    private JdbcLeaseLock backupLock;
    private PreparedStatement readNodeId;
    private PreparedStatement writeNodeId;
    private PreparedStatement initializeNodeId;
    private PreparedStatement readState;
    private PreparedStatement writeState;

    public static JdbcSharedStateManager usingDataSource(String holderId, int networkTimeout, Executor networkTimeoutExecutor, long locksExpirationMillis, DataSource dataSource, SQLProvider provider) {
        JdbcSharedStateManager sharedStateManager = new JdbcSharedStateManager(holderId, locksExpirationMillis);
        sharedStateManager.setNetworkTimeout(networkTimeoutExecutor, networkTimeout);
        sharedStateManager.setDataSource(dataSource);
        sharedStateManager.setSqlProvider(provider);
        try {
            sharedStateManager.start();
            return sharedStateManager;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JdbcSharedStateManager usingConnectionUrl(String holderId, long locksExpirationMillis, String jdbcConnectionUrl, String jdbcDriverClass, SQLProvider provider) {
        return JdbcSharedStateManager.usingConnectionUrl(holderId, -1, null, locksExpirationMillis, jdbcConnectionUrl, jdbcDriverClass, provider);
    }

    public static JdbcSharedStateManager usingConnectionUrl(String holderId, int networkTimeout, Executor networkTimeoutExecutor, long locksExpirationMillis, String jdbcConnectionUrl, String jdbcDriverClass, SQLProvider provider) {
        JdbcSharedStateManager sharedStateManager = new JdbcSharedStateManager(holderId, locksExpirationMillis);
        sharedStateManager.setNetworkTimeout(networkTimeoutExecutor, networkTimeout);
        sharedStateManager.setJdbcConnectionUrl(jdbcConnectionUrl);
        sharedStateManager.setJdbcDriverClass(jdbcDriverClass);
        sharedStateManager.setSqlProvider(provider);
        try {
            sharedStateManager.start();
            return sharedStateManager;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createSchema() {
        try {
            this.createTable(new String[]{this.sqlProvider.createNodeManagerStoreTableSQL(), this.sqlProvider.createNodeIdSQL(), this.sqlProvider.createStateSQL(), this.sqlProvider.createLiveLockSQL(), this.sqlProvider.createBackupLockSQL()});
        }
        catch (SQLException e) {
            logger.debug((Object)"Error while creating the schema of the JDBC shared state manager", (Throwable)e);
        }
    }

    static JdbcLeaseLock createLiveLock(String holderId, Connection connection, SQLProvider sqlProvider, long expirationMillis) throws SQLException {
        return new JdbcLeaseLock(holderId, connection, connection.prepareStatement(sqlProvider.tryAcquireLiveLockSQL()), connection.prepareStatement(sqlProvider.tryReleaseLiveLockSQL()), connection.prepareStatement(sqlProvider.renewLiveLockSQL()), connection.prepareStatement(sqlProvider.isLiveLockedSQL()), connection.prepareStatement(sqlProvider.currentTimestampSQL()), expirationMillis, "LIVE");
    }

    static JdbcLeaseLock createBackupLock(String holderId, Connection connection, SQLProvider sqlProvider, long expirationMillis) throws SQLException {
        return new JdbcLeaseLock(holderId, connection, connection.prepareStatement(sqlProvider.tryAcquireBackupLockSQL()), connection.prepareStatement(sqlProvider.tryReleaseBackupLockSQL()), connection.prepareStatement(sqlProvider.renewBackupLockSQL()), connection.prepareStatement(sqlProvider.isBackupLockedSQL()), connection.prepareStatement(sqlProvider.currentTimestampSQL()), expirationMillis, "BACKUP");
    }

    protected void prepareStatements() throws SQLException {
        this.liveLock = JdbcSharedStateManager.createLiveLock(this.holderId, this.connection, this.sqlProvider, this.lockExpirationMillis);
        this.backupLock = JdbcSharedStateManager.createBackupLock(this.holderId, this.connection, this.sqlProvider, this.lockExpirationMillis);
        this.readNodeId = this.connection.prepareStatement(this.sqlProvider.readNodeIdSQL());
        this.writeNodeId = this.connection.prepareStatement(this.sqlProvider.writeNodeIdSQL());
        this.initializeNodeId = this.connection.prepareStatement(this.sqlProvider.initializeNodeIdSQL());
        this.writeState = this.connection.prepareStatement(this.sqlProvider.writeStateSQL());
        this.readState = this.connection.prepareStatement(this.sqlProvider.readStateSQL());
    }

    private JdbcSharedStateManager(String holderId, long lockExpirationMillis) {
        this.holderId = holderId;
        this.lockExpirationMillis = lockExpirationMillis;
    }

    @Override
    public LeaseLock liveLock() {
        return this.liveLock;
    }

    @Override
    public LeaseLock backupLock() {
        return this.backupLock;
    }

    private UUID rawReadNodeId() throws SQLException {
        PreparedStatement preparedStatement = this.readNodeId;
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) {
                UUID uUID = null;
                return uUID;
            }
            String nodeId = resultSet.getString(1);
            if (nodeId != null) {
                UUID uUID = new UUID(1, UUID.stringToBytes((String)nodeId));
                return uUID;
            }
            UUID uUID = null;
            return uUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID readNodeId() {
        Connection connection = this.connection;
        synchronized (connection) {
            UUID uUID;
            this.connection.setTransactionIsolation(2);
            boolean autoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(true);
            try {
                uUID = this.rawReadNodeId();
            }
            catch (Throwable throwable) {
                try {
                    this.connection.setAutoCommit(autoCommit);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.connection.setAutoCommit(autoCommit);
            return uUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNodeId(UUID nodeId) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(true);
                try {
                    this.rawWriteNodeId(nodeId);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void rawWriteNodeId(UUID nodeId) throws SQLException {
        PreparedStatement preparedStatement = this.writeNodeId;
        preparedStatement.setString(1, nodeId.toString());
        if (preparedStatement.executeUpdate() != 1) {
            throw new IllegalStateException("can't write NodeId on the JDBC Node Manager Store!");
        }
    }

    private boolean rawInitializeNodeId(UUID nodeId) throws SQLException {
        PreparedStatement preparedStatement = this.initializeNodeId;
        preparedStatement.setString(1, nodeId.toString());
        int rows = preparedStatement.executeUpdate();
        assert (rows <= 1);
        return rows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID setup(Supplier<? extends UUID> nodeIdFactory) {
        SQLException lastError = null;
        Connection connection = this.connection;
        synchronized (connection) {
            UUID newNodeId = nodeIdFactory.get();
            for (int attempts = 0; attempts < 20; ++attempts) {
                lastError = null;
                try {
                    UUID nodeId = this.initializeOrReadNodeId(newNodeId);
                    if (nodeId == null) continue;
                    return nodeId;
                }
                catch (SQLException e) {
                    logger.debug((Object)"Error while attempting to setup the NodeId", (Throwable)e);
                    lastError = e;
                }
            }
        }
        if (lastError != null) {
            logger.error((Object)"Unable to setup a NodeId on the JDBC shared state", lastError);
        } else {
            logger.error((Object)"Unable to setup a NodeId on the JDBC shared state");
        }
        throw new IllegalStateException("FAILED TO SETUP the JDBC Shared State NodeId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UUID initializeOrReadNodeId(UUID newNodeId) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.connection.setTransactionIsolation(8);
            boolean autoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                UUID nodeId = this.rawInitializeNodeId(newNodeId) ? newNodeId : this.rawReadNodeId();
                if (nodeId != null) {
                    this.connection.commit();
                    UUID uUID = nodeId;
                    return uUID;
                }
                this.connection.rollback();
                logger.debugf("Rollback after failed to update NodeId to %s and haven't found any NodeId", (Object)newNodeId);
                UUID uUID = null;
                return uUID;
            }
            catch (SQLException e) {
                this.connection.rollback();
                logger.debugf((Throwable)e, "Rollback while trying to update NodeId to %s", (Object)newNodeId);
                UUID uUID2 = null;
                return uUID2;
            }
            finally {
                this.connection.setAutoCommit(autoCommit);
            }
        }
    }

    private static SharedStateManager.State decodeState(String s) {
        if (s == null) {
            return SharedStateManager.State.NOT_STARTED;
        }
        switch (s) {
            case "L": {
                return SharedStateManager.State.LIVE;
            }
            case "F": {
                return SharedStateManager.State.FAILING_BACK;
            }
            case "P": {
                return SharedStateManager.State.PAUSED;
            }
            case "N": {
                return SharedStateManager.State.NOT_STARTED;
            }
        }
        throw new IllegalStateException("unknown state [" + s + "]");
    }

    private static String encodeState(SharedStateManager.State state) {
        switch (state) {
            case LIVE: {
                return "L";
            }
            case FAILING_BACK: {
                return "F";
            }
            case PAUSED: {
                return "P";
            }
            case NOT_STARTED: {
                return "N";
            }
        }
        throw new IllegalStateException("unknown state [" + (Object)((Object)state) + "]");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SharedStateManager.State readState() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    SharedStateManager.State state;
                    PreparedStatement preparedStatement = this.readState;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        state = !resultSet.next() ? SharedStateManager.State.FIRST_TIME_START : JdbcSharedStateManager.decodeState(resultSet.getString(1));
                    }
                    this.connection.commit();
                    SharedStateManager.State state2 = state;
                    return state2;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    throw new IllegalStateException(ie);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeState(SharedStateManager.State state) {
        String encodedState = JdbcSharedStateManager.encodeState(state);
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    PreparedStatement preparedStatement = this.writeState;
                    preparedStatement.setString(1, encodedState);
                    if (preparedStatement.executeUpdate() != 1) {
                        throw new IllegalStateException("can't write state to the JDBC Node Manager Store!");
                    }
                    this.connection.commit();
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    this.connection.setAutoCommit(true);
                    throw new IllegalStateException(ie);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.readNodeId.close();
            this.writeNodeId.close();
            this.initializeNodeId.close();
            this.readState.close();
            this.writeState.close();
            this.liveLock.close();
            this.backupLock.close();
            super.stop();
        }
    }

    @Override
    public void close() throws SQLException {
        this.stop();
    }
}

