/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005er!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007i\u0005\u0001\u000b\u0011\u0002\u0017\t\u000bU\nA\u0011\u0001\u001c\t\u000f\u0005\r\u0012\u0001\"\u0001\u0002&\u0019!\u0001e\u0005\u00019\u0011!ItA!A!\u0002\u0013Q\u0004\"\u0002\u0015\b\t\u0003A\u0005B\u0002&\bA\u0013%1\n\u0003\u0004Y\u000f\u0011\u00051#\u0017\u0005\u0006C\u001e!\tA\u0019\u0005\u0007c\u001e\u0001K\u0011\u0002:\t\u000f\u0005\u0015q\u0001\"\u0001\u0002\b!9\u0011\u0011C\u0004\u0005\u0002\u0005M\u0001bBA\t\u000f\u0011\u0005\u0011\u0011\u0004\u0005\t\u0003;9\u0001\u0015\"\u0003\u0002 \u0005y1\u000b\u001e:fC6,'OR1di>\u0014\u0018P\u0003\u0002\u0015+\u0005\u0011\u0011n\u001c\u0006\u0003-]\t\u0001\u0002]1dW\u0006<WM\u001d\u0006\u00031e\t\u0001\u0002\u001f7eKBdw.\u001f\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u0001\"aH\u0001\u000e\u0003M\u0011qb\u0015;sK\u0006lWM\u001d$bGR|'/_\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003\u0019awnZ4feV\tA\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005)1\u000f\u001c45U*\t\u0011'A\u0002pe\u001eL!a\r\u0018\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq\u0002Z3gCVdG/T1qa&twm\u001d\u000b\u0002oA\u0011qdB\n\u0003\u000f\t\nq\"\u0019:dQ&4X-T1qa&twm\u001d\t\u0005w\t+UI\u0004\u0002=\u0001B\u0011Q\bJ\u0007\u0002})\u0011q(H\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005#\u0013A\u0002)sK\u0012,g-\u0003\u0002D\t\n\u0019Q*\u00199\u000b\u0005\u0005#\u0003CA\u001eG\u0013\t9EI\u0001\u0004TiJLgn\u001a\u000b\u0003o%CQ!O\u0005A\u0002i\nqcZ3u\u0003J\u001c\u0007.\u001b<f\u000b:$(/_*ue\u0016\fW.\u001a:\u0015\u00051{\u0005CA\u0010N\u0013\tq5C\u0001\u0005TiJ,\u0017-\\3s\u0011\u0015\u0001&\u00021\u0001R\u0003\u00111\u0017\u000e\\3\u0011\u0005I3V\"A*\u000b\u0005Q!&\"A+\u0002\t)\fg/Y\u0005\u0003/N\u0013AAR5mK\u0006ir-\u001a;Be\u000eD\u0017N^3F]R\u0014\u0018p\u0015;sK\u0006l7\u000b\u001e:fC6,'\u000fF\u0002M5~CQaW\u0006A\u0002q\u000b!![:\u0011\u0005Ik\u0016B\u00010T\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b\u0001\\\u0001\u0019A#\u0002\t9\fW.Z\u0001\u0017O\u0016$\u0018I]2iSZ,w*\u001e;qkR\u001cFO]3b[R\u00111m\u001c\t\u0003I6l\u0011!\u001a\u0006\u0003M\u001e\f\u0011\"\u0019:dQ&4XM]:\u000b\u0005!L\u0017\u0001C2p[B\u0014Xm]:\u000b\u0005)\\\u0017aB2p[6|gn\u001d\u0006\u0003YB\na!\u00199bG\",\u0017B\u00018f\u0005M\t%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u0015\u0001H\u00021\u0001R\u0003\u0019!\u0018M]4fi\u0006Ir-\u001a;UCJ\f%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n)\r\u0019\u0018P\u001f\t\u0003i^l\u0011!\u001e\u0006\u0003m\u0016\f1\u0001^1s\u0013\tAXO\u0001\fUCJ\f%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u0015\u0001X\u00021\u0001R\u0011\u0015YX\u00021\u0001}\u0003)\u0019w.\u001c9sKN\u001cxN\u001d\t\u0005Gu|x0\u0003\u0002\u007fI\tIa)\u001e8di&|g.\r\t\u0004%\u0006\u0005\u0011bAA\u0002'\naq*\u001e;qkR\u001cFO]3b[\u0006\u0019\u0002.Y:Be\u000eD\u0017N^3FqR,gn]5p]R!\u0011\u0011BA\b!\r\u0019\u00131B\u0005\u0004\u0003\u001b!#a\u0002\"p_2,\u0017M\u001c\u0005\u0006A:\u0001\r!R\u0001\tgR\u0014X-Y7feR)A*!\u0006\u0002\u0018!)1l\u0004a\u00019\")\u0001m\u0004a\u0001\u000bR\u0019A*a\u0007\t\u000bA\u0003\u0002\u0019A)\u0002\u001d\u001d,G/\u0011:dQ&4X\rV=qKR\u0019Q)!\t\t\u000b\u0001\f\u0002\u0019A#\u0002\u0013\u0019|'oQ8oM&<GcA\u001c\u0002(!9\u0011\u0011\u0006\u0004A\u0002\u0005-\u0012AB2p]\u001aLw\r\u0005\u0003\u0002.\u0005URBAA\u0018\u0015\u0011\tI#!\r\u000b\u0007\u0005M2$\u0001\u0005usB,7/\u00194f\u0013\u0011\t9$a\f\u0003\r\r{gNZ5h\u0001")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    public static Logger logger() {
        return StreamerFactory$.MODULE$.logger();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable & scala.Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipFileArchiveStreamer(file);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarFileArchiveStreamer(file);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipArchiveStreamStreamer(resettableIs);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarArchiveStreamStreamer(resettableIs);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        ZipArchiveOutputStream zipArchiveOutputStream;
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(target);
        } else {
            String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zipArchiveOutputStream = new ZipArchiveOutputStream(target);
            } else {
                String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> os);
                } else {
                    String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new GzipCompressorOutputStream(os));
                    } else {
                        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new BZip2CompressorOutputStream(os));
                        } else {
                            String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
                            throw new UnsupportedArchiveExtensionException(new StringBuilder(59).append(target.getName()).append(" with extension ").append(originExt).append(" -> ").append(string).append(" is not a supported archive output type").toString());
                        }
                    }
                }
            }
        }
        return zipArchiveOutputStream;
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
    }

    public Streamer streamer(InputStream is, String name) {
        return this.hasArchiveExtension(name) ? this.getArchiveEntryStreamStreamer(is, name) : new FileStreamStreamer(is, name);
    }

    public Streamer streamer(File file) {
        return file.isDirectory() ? new DirectoryStreamer(file) : (this.hasArchiveExtension(file.getName()) ? this.getArchiveEntryStreamer(file) : new FileStreamer(file));
    }

    private String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(new StringBuilder(27).append(name).append(" is not a supported archive").toString());
        }
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError((Object)option);
        }
        String originExt = (String)tuple2._1();
        String mappedExt = (String)tuple2._2();
        StreamerFactory$.MODULE$.logger().debug(new StringBuilder(43).append("Detected mapped archive extension ").append(originExt).append(" -> ").append(mappedExt).append(" for ").append(name).toString());
        String string = mappedExt;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString());
    }

    public StreamerFactory(Map<String, String> archiveMappings) {
        this.archiveMappings = archiveMappings;
    }
}

