/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.File;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

public class NetworkServerControl {
    public static final int DEFAULT_PORTNUMBER = 1527;
    private static final String DERBYNET_JAR = "derbynet.jar";
    private static final String POLICY_FILENAME = "server.policy";
    private static final String POLICY_FILE_PROPERTY = "java.security.policy";
    private static final String DERBY_HOSTNAME_WILDCARD = "0.0.0.0";
    private static final String IPV6_HOSTNAME_WILDCARD = "::";
    private static final String SOCKET_PERMISSION_HOSTNAME_WILDCARD = "*";
    private NetworkServerControlImpl serverImpl;

    public NetworkServerControl(InetAddress inetAddress, int n, String string, String string2) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(inetAddress, n, string, string2);
    }

    public NetworkServerControl(String string, String string2) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(string, string2);
    }

    public NetworkServerControl(InetAddress inetAddress, int n) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(inetAddress, n);
    }

    public NetworkServerControl() throws Exception {
        this.serverImpl = new NetworkServerControlImpl();
    }

    public static void main(String[] stringArray) {
        NetworkServerControlImpl networkServerControlImpl = null;
        boolean bl = true;
        try {
            networkServerControlImpl = new NetworkServerControlImpl();
            int n = networkServerControlImpl.parseArgs(stringArray);
            if (n == 0) {
                try {
                    AccessController.doPrivileged(() -> {
                        System.setProperty("derby.__serverStartedFromCmdLine", "true");
                        return null;
                    });
                }
                catch (Exception exception) {
                    networkServerControlImpl.consoleExceptionPrintTrace(exception);
                    System.exit(1);
                }
            }
            if (NetworkServerControl.needsSecurityManager(networkServerControlImpl, n)) {
                NetworkServerControl.verifySecurityState(networkServerControlImpl);
                NetworkServerControl.installSecurityManager(networkServerControlImpl);
            }
            bl = false;
            networkServerControlImpl.executeWork(n);
        }
        catch (Exception exception) {
            if (exception.getMessage() == null || !exception.getMessage().equals("Unexpected exception") || bl) {
                if (networkServerControlImpl != null) {
                    networkServerControlImpl.consoleExceptionPrint(exception);
                } else {
                    exception.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    public void start(PrintWriter printWriter) throws Exception {
        this.serverImpl.start(printWriter);
    }

    public void shutdown() throws Exception {
        this.serverImpl.shutdown();
    }

    public void ping() throws Exception {
        this.serverImpl.ping();
    }

    public void trace(boolean bl) throws Exception {
        this.serverImpl.trace(bl);
    }

    public void trace(int n, boolean bl) throws Exception {
        this.serverImpl.trace(n, bl);
    }

    public void logConnections(boolean bl) throws Exception {
        this.serverImpl.logConnections(bl);
    }

    public void setTraceDirectory(String string) throws Exception {
        this.serverImpl.sendSetTraceDirectory(string);
    }

    public String getSysinfo() throws Exception {
        return this.serverImpl.sysinfo();
    }

    public String getRuntimeInfo() throws Exception {
        return this.serverImpl.runtimeInfo();
    }

    public void setMaxThreads(int n) throws Exception {
        this.serverImpl.netSetMaxThreads(n);
    }

    public int getMaxThreads() throws Exception {
        String string = this.serverImpl.getCurrentProperties().getProperty("derby.drda.maxThreads");
        return Integer.parseInt(string);
    }

    public void setTimeSlice(int n) throws Exception {
        this.serverImpl.netSetTimeSlice(n);
    }

    public int getTimeSlice() throws Exception {
        String string = this.serverImpl.getCurrentProperties().getProperty("derby.drda.timeSlice");
        return Integer.parseInt(string);
    }

    public Properties getCurrentProperties() throws Exception {
        return this.serverImpl.getCurrentProperties();
    }

    protected void setClientLocale(String string) {
        this.serverImpl.setClientLocale(string);
    }

    private static boolean needsSecurityManager(NetworkServerControlImpl networkServerControlImpl, int n) throws Exception {
        return System.getSecurityManager() == null && n == 0 && !networkServerControlImpl.runningUnsecure();
    }

    private static void verifySecurityState(NetworkServerControlImpl networkServerControlImpl) throws Exception {
    }

    private static void installSecurityManager(NetworkServerControlImpl networkServerControlImpl) throws Exception {
        if (PropertyUtil.getSystemProperty("derby.system.home") == null) {
            System.setProperty("derby.system.home", PropertyUtil.getSystemProperty("user.dir"));
        }
        if (PropertyUtil.getSystemProperty("derby.drda.traceDirectory") == null) {
            System.setProperty("derby.drda.traceDirectory", PropertyUtil.getSystemProperty("derby.system.home"));
        }
        System.setProperty("derby.security.host", NetworkServerControl.getHostNameForSocketPermission(networkServerControlImpl));
        System.setProperty("derby.security.port", String.valueOf(networkServerControlImpl.getPort()));
        URL uRL = NetworkServerControl.getCodeSourceURL(networkServerControlImpl);
        String string = NetworkServerControl.getCodeSourcePrefix(networkServerControlImpl, uRL);
        String string2 = new File(uRL.getFile()).getParentFile().getAbsolutePath();
        System.setProperty("derby.install.url", string);
        System.setProperty("derby.install.path", string2);
        String string3 = NetworkServerControl.getPolicyFileURL();
        System.setProperty(POLICY_FILE_PROPERTY, string3);
        SecurityManager securityManager = new SecurityManager();
        System.setSecurityManager(securityManager);
        if (securityManager.equals(System.getSecurityManager())) {
            String string4 = networkServerControlImpl.localizeMessage("DRDA_SecurityInstalled.I", null);
            networkServerControlImpl.consoleMessage(string4, true);
        }
    }

    private static String getHostNameForSocketPermission(NetworkServerControlImpl networkServerControlImpl) throws Exception {
        String string = networkServerControlImpl.getHost();
        if (NetworkServerControl.hostnamesEqual(DERBY_HOSTNAME_WILDCARD, string) || IPV6_HOSTNAME_WILDCARD.equals(string)) {
            string = SOCKET_PERMISSION_HOSTNAME_WILDCARD;
        } else if (NetworkServerControl.isIPV6Address(string)) {
            string = '[' + string + "]:0-";
        }
        return string;
    }

    private static boolean hostnamesEqual(String string, String string2) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            return inetAddress.equals(inetAddress2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isIPV6Address(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':' || Character.digit(c, 16) >= 0) continue;
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress instanceof Inet6Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static URL getCodeSourceURL(NetworkServerControlImpl networkServerControlImpl) throws Exception {
        ProtectionDomain protectionDomain = NetworkServerControl.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL uRL = codeSource.getLocation();
        return uRL;
    }

    private static String getCodeSourcePrefix(NetworkServerControlImpl networkServerControlImpl, URL uRL) throws Exception {
        String string;
        String string2 = uRL.toExternalForm().replaceFirst("^file://([^/].*)", "file:////$1");
        int n = string2.indexOf(DERBYNET_JAR);
        if (n < 0) {
            string = networkServerControlImpl.localizeMessage("DRDA_MissingNetworkJar.S", null);
            networkServerControlImpl.consoleError(string);
        }
        string = string2.substring(0, n);
        return string;
    }

    private static String getPolicyFileURL() throws Exception {
        String string = NetworkServerControl.class.getPackage().getName().replace('.', '/') + '/' + POLICY_FILENAME;
        URL uRL = NetworkServerControl.class.getClassLoader().getResource(string);
        String string2 = uRL.toExternalForm();
        return string2;
    }
}

