/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHolder {
    private BooterConfig config;
    private String username;
    private String password;
    private CloseableHttpClient httpClient;
    private ApacheHttpClient4Engine clientHttpEngine;
    private HttpHost host;
    private HttpHost proxyHost;
    private BasicHttpContext localcontext;
    private Proxies proxies;
    private static final Logger logger = LoggerFactory.getLogger(HttpClientHolder.class);

    HttpClientHolder(BooterConfig config) {
        this.config = config;
        this.username = config.getUsername();
        this.password = config.getPassword();
        if (config.isProxied()) {
            this.proxyHost = new HttpHost(config.getProxyHost(), config.getProxyPort());
        }
        this.host = new HttpHost(config.getHost(), config.getPort(), String.format("http%s", config.isSecure() ? "s" : ""));
        this.initializeClient();
        logger.debug("Client initialized for user={}", (Object)this.username);
        if (!config.isWithoutCredentials()) {
            this.tryAuthenticate(config);
        }
    }

    private void initializeClient() {
        logger.debug("Initializing client for user={}", (Object)this.username);
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        if (this.config.getConnectionPoolSize() != 0) {
            connManager.setDefaultMaxPerRoute(this.config.getConnectionPoolSize());
            connManager.setMaxTotal(this.config.getConnectionPoolSize());
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.disableCookieManagement();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connManager);
        for (HttpRequestInterceptor interceptor : this.config.getHttpRequestInterceptors()) {
            clientBuilder.addInterceptorLast(interceptor);
        }
        this.localcontext = new BasicHttpContext();
        if (this.config.isSecure()) {
            this.setupSecureComms(clientBuilder);
        }
        if (!this.config.isWithoutCredentials()) {
            this.addCredentials(clientBuilder, this.username, this.password);
        }
        this.enablePreemptiveAuthentication(this.host);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(1000).setSocketTimeout(this.config.getSocketTimeout()).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        if (this.config.isProxied()) {
            logger.debug("Configuring connection via proxy: {}", (Object)this.proxyHost);
            clientBuilder.setProxy(this.proxyHost);
        }
        this.httpClient = clientBuilder.build();
        this.clientHttpEngine = new ApacheHttpClient4Engine((HttpClient)this.httpClient, (HttpContext)this.localcontext);
        this.proxies = Proxies.reinitialize(this.proxies, this, this.config);
    }

    private void setupSecureComms(HttpClientBuilder clientBuilder) {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new BrowserCompatHostnameVerifier());
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslFactory);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot setup secure communications with XL Deploy", e);
        }
    }

    void shutdown() {
        logger.debug("Shutting down.");
        if (this.clientHttpEngine != null) {
            try {
                this.clientHttpEngine.close();
            }
            catch (Exception e) {
                logger.warn("Unable to cleanly shut down clientHttpEngine.", (Throwable)e);
            }
            this.clientHttpEngine = null;
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.warn("Unable to cleanly close httpClient.", (Throwable)e);
            }
            this.httpClient = null;
        }
        this.localcontext = null;
    }

    private void addCredentials(HttpClientBuilder clientBuilder, String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private void enablePreemptiveAuthentication(HttpHost host) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(host, (AuthScheme)basicAuth);
        this.localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
    }

    public void logout() {
        logger.debug("Logging out.");
        this.username = null;
        this.password = null;
    }

    public void loginAs(String username, String password) {
        logger.debug("Attempting to login as {}", (Object)username);
        this.config = BooterConfig.builder(this.config).withCredentials(username, password).build();
        this.username = this.config.getUsername();
        this.password = this.config.getPassword();
        this.initializeClient();
        logger.debug("Client initialized for user={}", (Object)username);
        this.tryAuthenticate(this.config);
        RemoteBooter.boot(this.config);
    }

    public String getUserName() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAuthenticate(BooterConfig config) {
        block9: {
            logger.info("Connecting to the XL Deploy server at {}...", (Object)config.getUrl());
            try {
                CloseableHttpResponse execute = this.httpClient.execute((HttpUriRequest)new HttpGet(config.getUrl() + "/server/info"), (HttpContext)this.localcontext);
                try {
                    int responseCode = execute.getStatusLine().getStatusCode();
                    if (responseCode == 200) {
                        logger.info("Successfully connected.");
                        break block9;
                    }
                    if (responseCode == 401 || responseCode == 403) {
                        throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                    }
                    if (responseCode == 402) {
                        throw new IllegalStateException("License not found, invalid, or expired; see the XL Deploy logs. Please contact your XebiaLabs sales representative for a valid license.");
                    }
                    throw new IllegalStateException("Could contact the server at " + config.getUrl() + " but received an HTTP error code, " + responseCode);
                }
                finally {
                    EntityUtils.consume((HttpEntity)execute.getEntity());
                    this.httpClient.getConnectionManager().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (MalformedURLException mue) {
                throw new IllegalStateException("Could not contact the server at " + config.getUrl(), mue);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not contact the server at " + config.getUrl(), e);
            }
        }
    }

    public HttpResponse execute(HttpUriRequest httpRequest) throws ClientProtocolException, IOException {
        return this.httpClient.execute(httpRequest, (HttpContext)this.localcontext);
    }

    public ClientHttpEngine createClientHttpEngine() {
        if (this.clientHttpEngine == null) {
            this.clientHttpEngine = new ApacheHttpClient4Engine((HttpClient)this.httpClient, (HttpContext)this.localcontext);
        }
        return this.clientHttpEngine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Proxies getProxies() {
        return this.proxies;
    }
}

