/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.satellite;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4AAD\b\u00019!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u00159\u0004\u0001\"\u00019\u0011\u001di\u0004A1A\u0005\nyBaa\u0013\u0001!\u0002\u0013y\u0004b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007%\u0002\u0001\u000b\u0011\u0002(\t\u000bM\u0003A\u0011\u0001+\t\u000bU\u0003A\u0011\u0001,\t\u000bq\u0003A\u0011A/\t\u000b}\u0003A\u0011\u00021\t\u000b\u0005\u0004A\u0011\u00021\t\u000b\t\u0004A\u0011\u00021\u0003\u0015=\u0013'.Z2u!>|GN\u0003\u0002\u0011#\u0005I1/\u0019;fY2LG/\u001a\u0006\u0003%M\ta\u0001^1tW\u0016\u0014(B\u0001\u000b\u0016\u0003\u0019)gnZ5oK*\u0011acF\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0001$G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AG\u0001\u0004G>l7\u0001A\u000b\u0003;9\u001a\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019qW/\u001c2feB\u0011qDJ\u0005\u0003O\u0001\u00121!\u00138u\u0003-qWm^%ogR\fgnY3\u0011\u0007}QC&\u0003\u0002,A\tIa)\u001e8di&|g\u000e\r\t\u0003[9b\u0001\u0001B\u00030\u0001\t\u0007\u0001GA\u0001U#\t\tD\u0007\u0005\u0002 e%\u00111\u0007\t\u0002\b\u001d>$\b.\u001b8h!\tyR'\u0003\u00027A\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\rI4\b\u0010\t\u0004u\u0001aS\"A\b\t\u000b\u0011\u001a\u0001\u0019A\u0013\t\u000b!\u001a\u0001\u0019A\u0015\u0002\tML'0Z\u000b\u0002\u007fA\u0011\u0001)S\u0007\u0002\u0003*\u0011!iQ\u0001\u0007CR|W.[2\u000b\u0005\u0011+\u0015AC2p]\u000e,(O]3oi*\u0011aiR\u0001\u0005kRLGNC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)\u000b%!D!u_6L7-\u00138uK\u001e,'/A\u0003tSj,\u0007%\u0001\u0003q_>dW#\u0001(\u0011\u0007=\u0003F&D\u0001D\u0013\t\t6I\u0001\nBeJ\f\u0017P\u00117pG.LgnZ)vKV,\u0017!\u00029p_2\u0004\u0013!\u00024fi\u000eDG#\u0001\u0017\u0002\u000fI,G.Z1tKR\u0011qK\u0017\t\u0003?aK!!\u0017\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u00067&\u0001\r\u0001L\u0001\u0002_\u0006\u0019\u0011\r\u001a3\u0015\u0005]s\u0006\"B.\u000b\u0001\u0004a\u0013!D2sK\u0006$Xm\u0014:CY>\u001c7.F\u0001-\u0003\u0019\u0019'/Z1uK\u0006)!\r\\8dW\u0002")
public class ObjectPool<T> {
    private final int number;
    private final Function0<T> newInstance;
    private final AtomicInteger size;
    private final ArrayBlockingQueue<T> pool;

    private AtomicInteger size() {
        return this.size;
    }

    private ArrayBlockingQueue<T> pool() {
        return this.pool;
    }

    public T fetch() {
        T t;
        T t2 = this.pool().poll();
        if (t2 != null) {
            t = t2;
        } else if (t2 == null) {
            t = this.createOrBlock();
        } else {
            throw new MatchError(t2);
        }
        return t;
    }

    public void release(T o) {
        this.pool().offer(o);
    }

    public void add(T o) {
        this.pool().add(o);
    }

    private T createOrBlock() {
        int n = this.size().get();
        int n2 = n;
        T t = n2 == this.number ? this.block() : this.create();
        return t;
    }

    private T create() {
        Object object;
        int n = this.size().incrementAndGet();
        int n2 = n;
        if (n2 > this.number) {
            this.size().decrementAndGet();
            object = this.fetch();
        } else {
            object = this.newInstance.apply();
        }
        return (T)object;
    }

    private T block() {
        int timeout = 5000;
        T t = this.pool().poll(timeout, TimeUnit.MILLISECONDS);
        if (t == null) {
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Couldn't acquire object in %d milliseconds.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)timeout)})));
        }
        T t2 = t;
        return t2;
    }

    public ObjectPool(int number, Function0<T> newInstance) {
        this.number = number;
        this.newInstance = newInstance;
        this.size = new AtomicInteger(0);
        this.pool = new ArrayBlockingQueue(number);
    }
}

