/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.updater.UpdaterBooter;

public class UpdateAction {
    static String _updateConfigFile;
    static YajswConfigurationImpl _currentConfig;
    static Process _p;
    static boolean _autoStart;
    static Logger _logger;

    public static void setUpdateConfig(String updateConfigFile) {
        _updateConfigFile = updateConfigFile;
    }

    public static void setCurrentConfig(YajswConfigurationImpl config) {
        _currentConfig = config;
    }

    public static void setAutostart() {
        _autoStart = true;
    }

    public static void setLogger(Logger logger) {
        _logger = logger;
    }

    public static void run() {
        try {
            if (_p != null) {
                return;
            }
            if (_updateConfigFile == null || _updateConfigFile.length() == 0) {
                return;
            }
            _p = OperatingSystem.instance().processManagerInstance().createProcess();
            _p.setCommand(UpdateAction.getUpdaterCommand());
            _p.setPipeStreams(false, false);
            _p.setVisible(false);
            _p.setWorkingDir(WrapperLoader.getWrapperHome());
            _p.setLogger(_logger);
            _p.setDebug(true);
            _p.start();
            _p.waitFor(10000L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static String[] getUpdaterCommand() {
        ArrayList<String> result = new ArrayList<String>();
        JavaHome javaHome = OperatingSystem.instance().getJavaHome((Configuration)_currentConfig);
        String java = javaHome.findJava(_currentConfig.getString("wrapper.java.command"), _currentConfig.getString("wrapper.java.customProcName"));
        result.add(java);
        result.add("-classpath");
        result.add(WrapperLoader.getWrapperJar() + File.pathSeparator + WrapperLoader.getWrapperAppJar());
        if (_autoStart) {
            result.add("-Dupdate.autostart=true");
        }
        result.add(UpdaterBooter.class.getName());
        result.add(_updateConfigFile);
        result.add(new File(_currentConfig.getCachedPath(false)).getAbsolutePath());
        String[] arrResult = new String[result.size()];
        for (int i = 0; i < arrResult.length; ++i) {
            arrResult[i] = (String)result.get(i);
        }
        return arrResult;
    }

    public static void main(String[] args) {
        UpdateAction.setUpdateConfig("z:/dev/yajsw/update.conf");
        System.setProperty("wrapper.config", "z:/dev/yajsw/conf/wrapper.helloworld.conf");
        YajswConfigurationImpl conf = new YajswConfigurationImpl();
        UpdateAction.setCurrentConfig(conf);
        System.out.println("service " + conf.getString("wrapper.ntservice.name", "?"));
        UpdateAction.run();
    }

    static {
        _autoStart = false;
    }
}

