/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.util.Map;
import kamon.metric.CounterKey;
import kamon.metric.CounterRecorder;
import kamon.metric.Entity;
import kamon.metric.EntityRecorder;
import kamon.metric.EntityRecorderFactory;
import kamon.metric.EntitySnapshot;
import kamon.metric.GaugeKey;
import kamon.metric.GaugeRecorder;
import kamon.metric.HistogramKey;
import kamon.metric.HistogramRecorder;
import kamon.metric.MetricsModule;
import kamon.metric.MetricsModuleImpl$;
import kamon.metric.MetricsSettings;
import kamon.metric.MetricsSettings$;
import kamon.metric.MinMaxCounterKey;
import kamon.metric.MinMaxCounterRecorder;
import kamon.metric.SingleInstrumentEntityRecorder$;
import kamon.metric.SubscriptionFilter;
import kamon.metric.SubscriptionsDispatcher;
import kamon.metric.SubscriptionsDispatcher$;
import kamon.metric.instrument.CollectionContext;
import kamon.metric.instrument.CollectionContext$;
import kamon.metric.instrument.Counter;
import kamon.metric.instrument.DefaultRefreshScheduler$;
import kamon.metric.instrument.Gauge;
import kamon.metric.instrument.Histogram;
import kamon.metric.instrument.InstrumentFactory;
import kamon.metric.instrument.MinMaxCounter;
import kamon.metric.instrument.UnitOfMeasurement;
import kamon.metric.instrument.UnitOfMeasurement$Unknown$;
import kamon.util.LazyActorRef;
import kamon.util.TriemapAtomicGetOrElseUpdate$;
import kamon.util.TriemapAtomicGetOrElseUpdate$Syntax$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg!B\u0001\u0003\u0001\u00111!!E'fiJL7m]'pIVdW-S7qY*\u00111\u0001B\u0001\u0007[\u0016$(/[2\u000b\u0003\u0015\tQa[1n_:\u001c2\u0001A\u0004\u000e!\tA1\"D\u0001\n\u0015\u0005Q\u0011!B:dC2\f\u0017B\u0001\u0007\n\u0005\u0019\te.\u001f*fMB\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u000e\u001b\u0016$(/[2t\u001b>$W\u000f\\3\t\u0011I\u0001!\u0011!Q\u0001\nQ\taaY8oM&<7\u0001\u0001\t\u0003+mi\u0011A\u0006\u0006\u0003%]Q!\u0001G\r\u0002\u0011QL\b/Z:bM\u0016T\u0011AG\u0001\u0004G>l\u0017B\u0001\u000f\u0017\u0005\u0019\u0019uN\u001c4jO\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\"\u0001I\u0011\u0011\u00059\u0001\u0001\"\u0002\n\u001e\u0001\u0004!\u0002bB\u0012\u0001\u0005\u0004%I\u0001J\u0001\u0011?R\u0014\u0018mY6fI\u0016sG/\u001b;jKN,\u0012!\n\t\u0005M-j\u0003'D\u0001(\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT!AK\u0005\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002-O\t9AK]5f\u001b\u0006\u0004\bC\u0001\b/\u0013\ty#A\u0001\u0004F]RLG/\u001f\t\u0003\u001dEJ!A\r\u0002\u0003\u001d\u0015sG/\u001b;z%\u0016\u001cwN\u001d3fe\"1A\u0007\u0001Q\u0001\n\u0015\n\u0011c\u0018;sC\u000e\\W\rZ#oi&$\u0018.Z:!\u0011\u001d1\u0004A1A\u0005\n]\nabX:vEN\u001c'/\u001b9uS>t7/F\u00019!\tID(D\u0001;\u0015\tYD!\u0001\u0003vi&d\u0017BA\u001f;\u00051a\u0015M_=BGR|'OU3g\u0011\u0019y\u0004\u0001)A\u0005q\u0005yql];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\b\u0005C\u0004B\u0001\u0001\u0007I\u0011\u0001\"\u0002\u0011M,G\u000f^5oON,\u0012a\u0011\t\u0003\u001d\u0011K!!\u0012\u0002\u0003\u001f5+GO]5dgN+G\u000f^5oONDqa\u0012\u0001A\u0002\u0013\u0005\u0001*\u0001\u0007tKR$\u0018N\\4t?\u0012*\u0017\u000f\u0006\u0002J\u0019B\u0011\u0001BS\u0005\u0003\u0017&\u0011A!\u00168ji\"9QJRA\u0001\u0002\u0004\u0019\u0015a\u0001=%c!1q\n\u0001Q!\n\r\u000b\u0011b]3ui&twm\u001d\u0011)\u00059\u000b\u0006C\u0001\u0005S\u0013\t\u0019\u0016B\u0001\u0005w_2\fG/\u001b7f\u0011\u001d)\u0006A1A\u0005\u0002Y\u000b1\u0002Z3gCVdG\u000fV1hgV\tq\u000b\u0005\u0003Y?\n\u0014gBA-^!\tQ\u0016\"D\u0001\\\u0015\ta6#\u0001\u0004=e>|GOP\u0005\u0003=&\ta\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\ri\u0015\r\u001d\u0006\u0003=&\u0001\"\u0001W2\n\u0005\u0011\f'AB*ue&tw\r\u0003\u0004g\u0001\u0001\u0006IaV\u0001\rI\u00164\u0017-\u001e7u)\u0006<7\u000f\t\u0005\u0006Q\u0002!\t![\u0001\fg\"|W\u000f\u001c3Ue\u0006\u001c7\u000e\u0006\u0002k[B\u0011\u0001b[\u0005\u0003Y&\u0011qAQ8pY\u0016\fg\u000eC\u0003oO\u0002\u0007Q&\u0001\u0004f]RLG/\u001f\u0005\u0006a\u0002!\t!]\u0001\u0012e\u0016<\u0017n\u001d;fe\"K7\u000f^8he\u0006lGC\u0002:yur\fI\u0001\u0005\u0002tm6\tAO\u0003\u0002v\u0005\u0005Q\u0011N\\:ueVlWM\u001c;\n\u0005]$(!\u0003%jgR|wM]1n\u0011\u0015Ix\u000e1\u0001c\u0003\u0011q\u0017-\\3\t\u000fm|\u0007\u0013!a\u0001/\u0006!A/Y4t\u0011\u001dix\u000e%AA\u0002y\f\u0011#\u001e8ji>3W*Z1tkJ,W.\u001a8u!\u0011Aq0a\u0001\n\u0007\u0005\u0005\u0011B\u0001\u0004PaRLwN\u001c\t\u0004g\u0006\u0015\u0011bAA\u0004i\n\tRK\\5u\u001f\u001alU-Y:ve\u0016lWM\u001c;\t\u0013\u0005-q\u000e%AA\u0002\u00055\u0011\u0001\u00043z]\u0006l\u0017n\u0019*b]\u001e,\u0007\u0003\u0002\u0005\u0000\u0003\u001f\u0001B!!\u0005\u0002$9!\u00111CA\u0010\u001d\u0011\t)\"!\b\u000f\t\u0005]\u00111\u0004\b\u00045\u0006e\u0011\"A\u0003\n\u0005\r!\u0011BA;\u0003\u0013\r\t\t\u0003^\u0001\n\u0011&\u001cHo\\4sC6LA!!\n\u0002(\taA)\u001f8b[&\u001c'+\u00198hK*\u0019\u0011\u0011\u0005;\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005y!/Z7pm\u0016D\u0015n\u001d;pOJ\fW\u000eF\u0003k\u0003_\t\t\u0004\u0003\u0004z\u0003S\u0001\rA\u0019\u0005\u0007w\u0006%\u0002\u0019A,\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\u0005)\"/Z4jgR,'/T5o\u001b\u0006D8i\\;oi\u0016\u0014H\u0003DA\u001d\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0003cA:\u0002<%\u0019\u0011Q\b;\u0003\u001b5Kg.T1y\u0007>,h\u000e^3s\u0011\u0019I\u00181\u0007a\u0001E\"A10a\r\u0011\u0002\u0003\u0007q\u000b\u0003\u0005~\u0003g\u0001\n\u00111\u0001\u007f\u0011)\tY!a\r\u0011\u0002\u0003\u0007\u0011Q\u0002\u0005\u000b\u0003\u0013\n\u0019\u0004%AA\u0002\u0005-\u0013a\u0004:fMJ,7\u000f[%oi\u0016\u0014h/\u00197\u0011\t!y\u0018Q\n\t\u0005\u0003\u001f\n9&\u0004\u0002\u0002R)!\u00111KA+\u0003!!WO]1uS>t'B\u0001\u0015\n\u0013\u0011\tI&!\u0015\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013a\u0005:f[>4X-T5o\u001b\u0006D8i\\;oi\u0016\u0014H#\u00026\u0002b\u0005\r\u0004BB=\u0002\\\u0001\u0007!\r\u0003\u0004|\u00037\u0002\ra\u0016\u0005\b\u0003O\u0002A\u0011AA5\u00035\u0011XmZ5ti\u0016\u0014x)Y;hKRq\u00111NA9\u0003g\n))a\"\u0002\n\u0006-\u0005cA:\u0002n%\u0019\u0011q\u000e;\u0003\u000b\u001d\u000bWoZ3\t\re\f)\u00071\u0001c\u0011!\t)(!\u001aA\u0002\u0005]\u0014A\u0004<bYV,7i\u001c7mK\u000e$xN\u001d\t\u0005\u0003s\nyH\u0004\u0003\u0002\u0014\u0005m\u0014bAA?i\u0006)q)Y;hK&!\u0011\u0011QAB\u0005U\u0019UO\u001d:f]R4\u0016\r\\;f\u0007>dG.Z2u_JT1!! u\u0011!Y\u0018Q\rI\u0001\u0002\u00049\u0006\u0002C?\u0002fA\u0005\t\u0019\u0001@\t\u0015\u0005-\u0011Q\rI\u0001\u0002\u0004\ti\u0001\u0003\u0006\u0002J\u0005\u0015\u0004\u0013!a\u0001\u0003\u0017Bq!a$\u0001\t\u0003\t\t*A\u0006sK6|g/Z$bk\u001e,G#\u00026\u0002\u0014\u0006U\u0005BB=\u0002\u000e\u0002\u0007!\r\u0003\u0004|\u0003\u001b\u0003\ra\u0016\u0005\b\u00033\u0003A\u0011AAN\u0003=\u0011XmZ5ti\u0016\u00148i\\;oi\u0016\u0014HCCAO\u0003G\u000b)+a*\u0002*B\u00191/a(\n\u0007\u0005\u0005FOA\u0004D_VtG/\u001a:\t\re\f9\n1\u0001c\u0011!Y\u0018q\u0013I\u0001\u0002\u00049\u0006\u0002C?\u0002\u0018B\u0005\t\u0019\u0001@\t\u0015\u0005-\u0011q\u0013I\u0001\u0002\u0004\ti\u0001C\u0004\u0002.\u0002!\t!a,\u0002\u001bI,Wn\u001c<f\u0007>,h\u000e^3s)\u0015Q\u0017\u0011WAZ\u0011\u0019I\u00181\u0016a\u0001E\"110a+A\u0002]CaA\u001c\u0001\u0005\u0002\u0005]V\u0003BA]\u0003\u007f#b!a/\u0002L\u0006U\u0007\u0003BA_\u0003\u007fc\u0001\u0001\u0002\u0005\u0002B\u0006U&\u0019AAb\u0005\u0005!\u0016cAAcaA\u0019\u0001\"a2\n\u0007\u0005%\u0017BA\u0004O_RD\u0017N\\4\t\u0011\u00055\u0017Q\u0017a\u0001\u0003\u001f\fqB]3d_J$WM\u001d$bGR|'/\u001f\t\u0006\u001d\u0005E\u00171X\u0005\u0004\u0003'\u0014!!F#oi&$\u0018PU3d_J$WM\u001d$bGR|'/\u001f\u0005\u0007]\u0006U\u0006\u0019A\u0017\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\u0006a!/Z7pm\u0016,e\u000e^5usR\u0019!.!8\t\r9\f9\u000e1\u0001.\u0011\u001d\t\t\u000f\u0001C\u0001\u0003G\fAAZ5oIR!\u0011Q]At!\rAq\u0010\r\u0005\u0007]\u0006}\u0007\u0019A\u0017\t\u000f\u0005-\b\u0001\"\u0001\u0002n\u0006I1/\u001e2tGJL'-\u001a\u000b\b\u0013\u0006=\u0018\u0011 B\u0007\u0011!\t\t0!;A\u0002\u0005M\u0018A\u00024jYR,'\u000fE\u0002\u000f\u0003kL1!a>\u0003\u0005I\u0019VOY:de&\u0004H/[8o\r&dG/\u001a:\t\u0011\u0005m\u0018\u0011\u001ea\u0001\u0003{\f!b];cg\u000e\u0014\u0018NY3s!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\tQ!Y2u_JT!Aa\u0002\u0002\t\u0005\\7.Y\u0005\u0005\u0005\u0017\u0011\tA\u0001\u0005BGR|'OU3g\u0011\u001d\u0011y!!;A\u0002)\f\u0011\u0002]3s[\u0006tWM\u001c;\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016\u0005YQO\\:vEN\u001c'/\u001b2f)\rI%q\u0003\u0005\t\u0003w\u0014\t\u00021\u0001\u0002~\"9!1\u0004\u0001\u0005\u0002\tu\u0011!\b2vS2$G)\u001a4bk2$8i\u001c7mK\u000e$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0005\t}\u0001cA:\u0003\"%\u0019!1\u0005;\u0003#\r{G\u000e\\3di&|gnQ8oi\u0016DH\u000fC\u0004\u0003(\u0001!\tA!\u000b\u0002#%t7\u000f\u001e:v[\u0016tGOR1di>\u0014\u0018\u0010\u0006\u0003\u0003,\tE\u0002cA:\u0003.%\u0019!q\u0006;\u0003#%s7\u000f\u001e:v[\u0016tGOR1di>\u0014\u0018\u0010C\u0004\u00034\t\u0015\u0002\u0019\u00012\u0002\u0011\r\fG/Z4pefD\u0001Ba\u000e\u0001\t\u0003!!\u0011H\u0001\u0011G>dG.Z2u':\f\u0007o\u001d5piN$BAa\u000f\u0003DA)\u0001lX\u0017\u0003>A\u0019aBa\u0010\n\u0007\t\u0005#A\u0001\bF]RLG/_*oCB\u001c\bn\u001c;\t\u0011\t\u0015#Q\u0007a\u0001\u0005?\t\u0011cY8mY\u0016\u001cG/[8o\u0007>tG/\u001a=u\u0011%\u0011I\u0005\u0001a\u0001\n\u0013\u0011Y%A\u0004`gf\u001cH/Z7\u0016\u0005\t5\u0003\u0003BA\u0000\u0005\u001fJAA!\u0015\u0003\u0002\tY\u0011i\u0019;peNK8\u000f^3n\u0011%\u0011)\u0006\u0001a\u0001\n\u0013\u00119&A\u0006`gf\u001cH/Z7`I\u0015\fHcA%\u0003Z!IQJa\u0015\u0002\u0002\u0003\u0007!Q\n\u0005\t\u0005;\u0002\u0001\u0015)\u0003\u0003N\u0005Aql]=ti\u0016l\u0007\u0005\u0003\u0006\u0003b\u0001A)\u0019!C\u0005\u0005G\naaX:uCJ$X#A%\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003j\u0005)1\u000f^1siR)\u0011Ja\u001b\u0003p!A!Q\u000eB3\u0001\u0004\u0011i%\u0001\u0004tsN$X-\u001c\u0005\b\u0005c\u0012)\u00071\u0001\u0015\u0003%qWm^\"p]\u001aLw\rC\u0005\u0003v\u0001\t\n\u0011\"\u0011\u0003x\u00059\"/Z4jgR,'oR1vO\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0005sR3a\u0016B>W\t\u0011i\b\u0005\u0003\u0003\u0000\t%UB\u0001BA\u0015\u0011\u0011\u0019I!\"\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BD\u0013\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-%\u0011\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003BH\u0001E\u0005I\u0011\tBI\u0003]\u0011XmZ5ti\u0016\u0014x)Y;hK\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0014*\u001aaPa\u001f\t\u0013\t]\u0005!%A\u0005B\te\u0015a\u0006:fO&\u001cH/\u001a:HCV<W\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YJ\u000b\u0003\u0002\u000e\tm\u0004\"\u0003BP\u0001E\u0005I\u0011\tBQ\u0003]\u0011XmZ5ti\u0016\u0014x)Y;hK\u0012\"WMZ1vYR$c'\u0006\u0002\u0003$*\"\u00111\nB>\u0011%\u00119\u000bAI\u0001\n\u0003\u00129(A\rsK\u001eL7\u000f^3s\u0007>,h\u000e^3sI\u0011,g-Y;mi\u0012\u0012\u0004\"\u0003BV\u0001E\u0005I\u0011\tBI\u0003e\u0011XmZ5ti\u0016\u00148i\\;oi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0013\t=\u0006!%A\u0005B\te\u0015!\u0007:fO&\u001cH/\u001a:D_VtG/\u001a:%I\u00164\u0017-\u001e7uIQ:\u0001Ba-\u0003\u0011\u0003!!QW\u0001\u0012\u001b\u0016$(/[2t\u001b>$W\u000f\\3J[Bd\u0007c\u0001\b\u00038\u001a9\u0011A\u0001E\u0001\t\te6c\u0001B\\\u000f!9aDa.\u0005\u0002\tuFC\u0001B[\u0011!\u0011\tMa.\u0005\u0002\t\r\u0017!B1qa2LHc\u0001\u0011\u0003F\"1!Ca0A\u0002Q\u0001")
public class MetricsModuleImpl
implements MetricsModule {
    private BoxedUnit _start;
    private final TrieMap<Entity, EntityRecorder> _trackedEntities;
    private final LazyActorRef _subscriptions;
    private volatile MetricsSettings settings;
    private final Map<String, String> defaultTags;
    private ActorSystem _system;
    private volatile boolean bitmap$0;

    public static MetricsModuleImpl apply(Config config) {
        return MetricsModuleImpl$.MODULE$.apply(config);
    }

    @Override
    public boolean shouldTrack(String entityName, String category) {
        return MetricsModule.shouldTrack$(this, entityName, category);
    }

    @Override
    public Histogram histogram(String name) {
        return MetricsModule.histogram$(this, name);
    }

    @Override
    public Histogram histogram(String name, UnitOfMeasurement unitOfMeasurement) {
        return MetricsModule.histogram$((MetricsModule)this, name, unitOfMeasurement);
    }

    @Override
    public Histogram histogram(String name, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.histogram$((MetricsModule)this, name, dynamicRange);
    }

    @Override
    public Histogram histogram(String name, UnitOfMeasurement unitOfMeasurement, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.histogram$((MetricsModule)this, name, unitOfMeasurement, dynamicRange);
    }

    @Override
    public Histogram histogram(String name, Map<String, String> tags) {
        return MetricsModule.histogram$((MetricsModule)this, name, tags);
    }

    @Override
    public Histogram histogram(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement) {
        return MetricsModule.histogram$((MetricsModule)this, name, tags, unitOfMeasurement);
    }

    @Override
    public Histogram histogram(String name, Map<String, String> tags, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.histogram$((MetricsModule)this, name, tags, dynamicRange);
    }

    @Override
    public Histogram histogram(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.histogram$(this, name, tags, unitOfMeasurement, dynamicRange);
    }

    @Override
    public boolean removeHistogram(String name) {
        return MetricsModule.removeHistogram$(this, name);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name) {
        return MetricsModule.minMaxCounter$(this, name);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, UnitOfMeasurement unitOfMeasurement) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, unitOfMeasurement);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, dynamicRange);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, FiniteDuration refreshInterval) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, refreshInterval);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, Histogram.DynamicRange dynamicRange, FiniteDuration refreshInterval) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, dynamicRange, refreshInterval);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, UnitOfMeasurement unitOfMeasurement, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, unitOfMeasurement, dynamicRange);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, Map<String, String> tags) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, tags);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, tags, unitOfMeasurement);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, Map<String, String> tags, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.minMaxCounter$((MetricsModule)this, name, tags, dynamicRange);
    }

    @Override
    public MinMaxCounter minMaxCounter(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement, Histogram.DynamicRange dynamicRange) {
        return MetricsModule.minMaxCounter$(this, name, tags, unitOfMeasurement, dynamicRange);
    }

    @Override
    public boolean removeMinMaxCounter(String name) {
        return MetricsModule.removeMinMaxCounter$(this, name);
    }

    @Override
    public Gauge gauge(String name, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$(this, name, valueCollector);
    }

    @Override
    public Gauge gauge(String name, UnitOfMeasurement unitOfMeasurement, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, unitOfMeasurement, valueCollector);
    }

    @Override
    public Gauge gauge(String name, Histogram.DynamicRange dynamicRange, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, dynamicRange, valueCollector);
    }

    @Override
    public Gauge gauge(String name, FiniteDuration refreshInterval, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, refreshInterval, valueCollector);
    }

    @Override
    public Gauge gauge(String name, Histogram.DynamicRange dynamicRange, FiniteDuration refreshInterval, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, dynamicRange, refreshInterval, valueCollector);
    }

    @Override
    public Gauge gauge(String name, UnitOfMeasurement unitOfMeasurement, Histogram.DynamicRange dynamicRange, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, unitOfMeasurement, dynamicRange, valueCollector);
    }

    @Override
    public Gauge gauge(String name, Map<String, String> tags, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, tags, valueCollector);
    }

    @Override
    public Gauge gauge(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, tags, unitOfMeasurement, valueCollector);
    }

    @Override
    public Gauge gauge(String name, Map<String, String> tags, Histogram.DynamicRange dynamicRange, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$((MetricsModule)this, name, tags, dynamicRange, valueCollector);
    }

    @Override
    public Gauge gauge(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement, Histogram.DynamicRange dynamicRange, Gauge.CurrentValueCollector valueCollector) {
        return MetricsModule.gauge$(this, name, tags, unitOfMeasurement, dynamicRange, valueCollector);
    }

    @Override
    public boolean removeGauge(String name) {
        return MetricsModule.removeGauge$(this, name);
    }

    @Override
    public Counter counter(String name) {
        return MetricsModule.counter$(this, name);
    }

    @Override
    public Counter counter(String name, UnitOfMeasurement unitOfMeasurement) {
        return MetricsModule.counter$((MetricsModule)this, name, unitOfMeasurement);
    }

    @Override
    public Counter counter(String name, Map<String, String> tags) {
        return MetricsModule.counter$((MetricsModule)this, name, tags);
    }

    @Override
    public Counter counter(String name, Map<String, String> tags, UnitOfMeasurement unitOfMeasurement) {
        return MetricsModule.counter$(this, name, tags, unitOfMeasurement);
    }

    @Override
    public boolean removeCounter(String name) {
        return MetricsModule.removeCounter$(this, name);
    }

    @Override
    public <T extends EntityRecorder> T entity(EntityRecorderFactory<T> recorderFactory, String name) {
        return (T)MetricsModule.entity$(this, recorderFactory, name);
    }

    @Override
    public <T extends EntityRecorder> T entity(EntityRecorderFactory<T> recorderFactory, String name, Map<String, String> tags) {
        return (T)MetricsModule.entity$(this, recorderFactory, name, tags);
    }

    @Override
    public boolean removeEntity(String name, String category) {
        return MetricsModule.removeEntity$(this, name, category);
    }

    @Override
    public boolean removeEntity(String name, String category, Map<String, String> tags) {
        return MetricsModule.removeEntity$(this, name, category, tags);
    }

    @Override
    public Option<EntityRecorder> find(String name, String category) {
        return MetricsModule.find$(this, name, category);
    }

    @Override
    public Option<EntityRecorder> find(String name, String category, Map<String, String> tags) {
        return MetricsModule.find$(this, name, category, tags);
    }

    @Override
    public void subscribe(SubscriptionFilter filter, ActorRef subscriber) {
        MetricsModule.subscribe$(this, filter, subscriber);
    }

    @Override
    public void subscribe(String category, String selection, ActorRef subscriber, boolean permanently) {
        MetricsModule.subscribe$(this, category, selection, subscriber, permanently);
    }

    @Override
    public void subscribe(String category, String selection, ActorRef subscriber) {
        MetricsModule.subscribe$(this, category, selection, subscriber);
    }

    @Override
    public Map<String, String> registerHistogram$default$2() {
        return MetricsModule.registerHistogram$default$2$(this);
    }

    @Override
    public Option<UnitOfMeasurement> registerHistogram$default$3() {
        return MetricsModule.registerHistogram$default$3$(this);
    }

    @Override
    public Option<Histogram.DynamicRange> registerHistogram$default$4() {
        return MetricsModule.registerHistogram$default$4$(this);
    }

    @Override
    public Map<String, String> registerMinMaxCounter$default$2() {
        return MetricsModule.registerMinMaxCounter$default$2$(this);
    }

    @Override
    public Option<UnitOfMeasurement> registerMinMaxCounter$default$3() {
        return MetricsModule.registerMinMaxCounter$default$3$(this);
    }

    @Override
    public Option<Histogram.DynamicRange> registerMinMaxCounter$default$4() {
        return MetricsModule.registerMinMaxCounter$default$4$(this);
    }

    @Override
    public Option<FiniteDuration> registerMinMaxCounter$default$5() {
        return MetricsModule.registerMinMaxCounter$default$5$(this);
    }

    private TrieMap<Entity, EntityRecorder> _trackedEntities() {
        return this._trackedEntities;
    }

    private LazyActorRef _subscriptions() {
        return this._subscriptions;
    }

    @Override
    public MetricsSettings settings() {
        return this.settings;
    }

    public void settings_$eq(MetricsSettings x$1) {
        this.settings = x$1;
    }

    public Map<String, String> defaultTags() {
        return this.defaultTags;
    }

    @Override
    public boolean shouldTrack(Entity entity) {
        return BoxesRunTime.unboxToBoolean((Object)this.settings().entityFilters().get((Object)entity.category()).map((Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)filter.accept(entity.name()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.settings().trackUnmatchedEntities()));
    }

    @Override
    public Histogram registerHistogram(String name, Map<String, String> tags, Option<UnitOfMeasurement> unitOfMeasurement, Option<Histogram.DynamicRange> dynamicRange) {
        Entity histogramEntity = new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.Histogram(), (Map<String, String>)tags.$plus$plus(this.defaultTags()));
        EntityRecorder recorder = TriemapAtomicGetOrElseUpdate$Syntax$.MODULE$.atomicGetOrElseUpdate$extension1(TriemapAtomicGetOrElseUpdate$.MODULE$.Syntax(this._trackedEntities()), histogramEntity, (Function0 & Serializable & scala.Serializable)() -> {
            InstrumentFactory factory = this.instrumentFactory(histogramEntity.category());
            return new HistogramRecorder(new HistogramKey(histogramEntity.category(), (UnitOfMeasurement)unitOfMeasurement.getOrElse((Function0 & Serializable & scala.Serializable)() -> UnitOfMeasurement$Unknown$.MODULE$)), factory.createHistogram(name, dynamicRange));
        }, (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.cleanup();
            return BoxedUnit.UNIT;
        });
        return ((HistogramRecorder)recorder).instrument();
    }

    @Override
    public boolean removeHistogram(String name, Map<String, String> tags) {
        return this._trackedEntities().remove((Object)new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.Histogram(), (Map<String, String>)tags.$plus$plus(this.defaultTags()))).isDefined();
    }

    @Override
    public MinMaxCounter registerMinMaxCounter(String name, Map<String, String> tags, Option<UnitOfMeasurement> unitOfMeasurement, Option<Histogram.DynamicRange> dynamicRange, Option<FiniteDuration> refreshInterval) {
        Entity minMaxCounterEntity = new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.MinMaxCounter(), (Map<String, String>)tags.$plus$plus(this.defaultTags()));
        EntityRecorder recorder = TriemapAtomicGetOrElseUpdate$Syntax$.MODULE$.atomicGetOrElseUpdate$extension1(TriemapAtomicGetOrElseUpdate$.MODULE$.Syntax(this._trackedEntities()), minMaxCounterEntity, (Function0 & Serializable & scala.Serializable)() -> {
            InstrumentFactory factory = this.instrumentFactory(minMaxCounterEntity.category());
            return new MinMaxCounterRecorder(new MinMaxCounterKey(minMaxCounterEntity.category(), (UnitOfMeasurement)unitOfMeasurement.getOrElse((Function0 & Serializable & scala.Serializable)() -> UnitOfMeasurement$Unknown$.MODULE$)), factory.createMinMaxCounter(name, dynamicRange, refreshInterval));
        }, (Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.cleanup();
            return BoxedUnit.UNIT;
        });
        return ((MinMaxCounterRecorder)recorder).instrument();
    }

    @Override
    public boolean removeMinMaxCounter(String name, Map<String, String> tags) {
        return this._trackedEntities().remove((Object)new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.MinMaxCounter(), (Map<String, String>)tags.$plus$plus(this.defaultTags()))).isDefined();
    }

    @Override
    public Gauge registerGauge(String name, Gauge.CurrentValueCollector valueCollector, Map<String, String> tags, Option<UnitOfMeasurement> unitOfMeasurement, Option<Histogram.DynamicRange> dynamicRange, Option<FiniteDuration> refreshInterval) {
        Entity gaugeEntity = new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.Gauge(), (Map<String, String>)tags.$plus$plus(this.defaultTags()));
        EntityRecorder recorder = TriemapAtomicGetOrElseUpdate$Syntax$.MODULE$.atomicGetOrElseUpdate$extension1(TriemapAtomicGetOrElseUpdate$.MODULE$.Syntax(this._trackedEntities()), gaugeEntity, (Function0 & Serializable & scala.Serializable)() -> {
            InstrumentFactory factory = this.instrumentFactory(gaugeEntity.category());
            return new GaugeRecorder(new GaugeKey(gaugeEntity.category(), (UnitOfMeasurement)unitOfMeasurement.getOrElse((Function0 & Serializable & scala.Serializable)() -> UnitOfMeasurement$Unknown$.MODULE$)), factory.createGauge(name, dynamicRange, refreshInterval, valueCollector));
        }, (Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.cleanup();
            return BoxedUnit.UNIT;
        });
        return ((GaugeRecorder)recorder).instrument();
    }

    @Override
    public Map<String, String> registerGauge$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Option<UnitOfMeasurement> registerGauge$default$4() {
        return None$.MODULE$;
    }

    @Override
    public Option<Histogram.DynamicRange> registerGauge$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Option<FiniteDuration> registerGauge$default$6() {
        return None$.MODULE$;
    }

    @Override
    public boolean removeGauge(String name, Map<String, String> tags) {
        return this._trackedEntities().remove((Object)new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.Gauge(), (Map<String, String>)tags.$plus$plus(this.defaultTags()))).isDefined();
    }

    @Override
    public Counter registerCounter(String name, Map<String, String> tags, Option<UnitOfMeasurement> unitOfMeasurement, Option<Histogram.DynamicRange> dynamicRange) {
        Entity counterEntity = new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.Counter(), (Map<String, String>)tags.$plus$plus(this.defaultTags()));
        EntityRecorder recorder = TriemapAtomicGetOrElseUpdate$Syntax$.MODULE$.atomicGetOrElseUpdate$extension1(TriemapAtomicGetOrElseUpdate$.MODULE$.Syntax(this._trackedEntities()), counterEntity, (Function0 & Serializable & scala.Serializable)() -> {
            InstrumentFactory factory = this.instrumentFactory(counterEntity.category());
            return new CounterRecorder(new CounterKey(counterEntity.category(), (UnitOfMeasurement)unitOfMeasurement.getOrElse((Function0 & Serializable & scala.Serializable)() -> UnitOfMeasurement$Unknown$.MODULE$)), factory.createCounter());
        }, (Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.cleanup();
            return BoxedUnit.UNIT;
        });
        return ((CounterRecorder)recorder).instrument();
    }

    @Override
    public Map<String, String> registerCounter$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Option<UnitOfMeasurement> registerCounter$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Option<Histogram.DynamicRange> registerCounter$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean removeCounter(String name, Map<String, String> tags) {
        return this._trackedEntities().remove((Object)new Entity(name, SingleInstrumentEntityRecorder$.MODULE$.Counter(), (Map<String, String>)tags.$plus$plus(this.defaultTags()))).isDefined();
    }

    @Override
    public <T extends EntityRecorder> T entity(EntityRecorderFactory<T> recorderFactory, Entity entity) {
        Map x$93 = entity.tags().$plus$plus(this.defaultTags());
        String x$94 = entity.copy$default$1();
        String x$95 = entity.copy$default$2();
        return (T)TriemapAtomicGetOrElseUpdate$Syntax$.MODULE$.atomicGetOrElseUpdate$extension1(TriemapAtomicGetOrElseUpdate$.MODULE$.Syntax(this._trackedEntities()), entity.copy(x$94, x$95, (Map<String, String>)x$93), (Function0 & Serializable & scala.Serializable)() -> recorderFactory.createRecorder(this.instrumentFactory(recorderFactory.category())), (Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.cleanup();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean removeEntity(Entity entity) {
        Map x$96 = entity.tags().$plus$plus(this.defaultTags());
        String x$97 = entity.copy$default$1();
        String x$98 = entity.copy$default$2();
        Option removedEntity = this._trackedEntities().remove((Object)entity.copy(x$97, x$98, (Map<String, String>)x$96));
        removedEntity.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.cleanup();
            return BoxedUnit.UNIT;
        });
        return removedEntity.isDefined();
    }

    @Override
    public Option<EntityRecorder> find(Entity entity) {
        Map x$99 = entity.tags().$plus$plus(this.defaultTags());
        String x$100 = entity.copy$default$1();
        String x$101 = entity.copy$default$2();
        return this._trackedEntities().get((Object)entity.copy(x$100, x$101, (Map<String, String>)x$99));
    }

    @Override
    public void subscribe(SubscriptionFilter filter, ActorRef subscriber, boolean permanent) {
        SubscriptionsDispatcher.Subscribe x$102 = new SubscriptionsDispatcher.Subscribe(filter, subscriber, permanent);
        ActorRef x$103 = this._subscriptions().tell$default$2(x$102);
        this._subscriptions().tell(x$102, x$103);
    }

    @Override
    public void unsubscribe(ActorRef subscriber) {
        SubscriptionsDispatcher.Unsubscribe x$104 = new SubscriptionsDispatcher.Unsubscribe(subscriber);
        ActorRef x$105 = this._subscriptions().tell$default$2(x$104);
        this._subscriptions().tell(x$104, x$105);
    }

    @Override
    public CollectionContext buildDefaultCollectionContext() {
        return CollectionContext$.MODULE$.apply(this.settings().defaultCollectionContextBufferSize());
    }

    @Override
    public InstrumentFactory instrumentFactory(String category) {
        return (InstrumentFactory)this.settings().instrumentFactories().getOrElse((Object)category, (Function0 & Serializable & scala.Serializable)() -> this.settings().defaultInstrumentFactory());
    }

    public Map<Entity, EntitySnapshot> collectSnapshots(CollectionContext collectionContext) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        this._trackedEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Entity identity = (Entity)tuple2._1();
            EntityRecorder recorder = (EntityRecorder)tuple2._2();
            Builder builder = builder.$plus$eq((Object)new Tuple2((Object)identity, (Object)recorder.collect(collectionContext)));
            return builder;
        });
        return (Map)builder.result();
    }

    private ActorSystem _system() {
        return this._system;
    }

    private void _system_$eq(ActorSystem x$1) {
        this._system = x$1;
    }

    private void _start$lzycompute() {
        MetricsModuleImpl metricsModuleImpl = this;
        synchronized (metricsModuleImpl) {
            if (!this.bitmap$0) {
                this._subscriptions().point(this._system().actorOf(SubscriptionsDispatcher$.MODULE$.props(this.settings().tickInterval(), this), "metrics"));
                this.settings().pointScheduler(DefaultRefreshScheduler$.MODULE$.apply(this._system().scheduler(), (ExecutionContext)this._system().dispatcher()));
                this.bitmap$0 = true;
            }
        }
    }

    private void _start() {
        block0: {
            if (this.bitmap$0) break block0;
            this._start$lzycompute();
        }
    }

    public synchronized void start(ActorSystem system, Config newConfig) {
        this.settings_$eq(MetricsSettings$.MODULE$.apply(newConfig));
        this._system_$eq(system);
        this._start();
        this._system_$eq(null);
    }

    public MetricsModuleImpl(Config config) {
        MetricsModule.$init$(this);
        this._trackedEntities = TrieMap$.MODULE$.empty();
        this._subscriptions = new LazyActorRef();
        this.settings = MetricsSettings$.MODULE$.apply(config);
        this.defaultTags = config.hasPath("kamon.default-tags") ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(config.getConfig("kamon.default-tags").resolve().entrySet()).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Map.Entry<String, ConfigValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    ConfigValueType configValueType = A12.getValue().valueType();
                    ConfigValueType configValueType2 = ConfigValueType.STRING;
                    if (!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null)) {
                        object = new Tuple2((Object)A12.getKey(), (Object)((String)A12.getValue().unwrapped()));
                        return (B1)object;
                    }
                }
                if (A1 != null) {
                    A1 A13 = A1;
                    ConfigValueType configValueType = A13.getValue().valueType();
                    ConfigValueType configValueType3 = ConfigValueType.NUMBER;
                    if (!(configValueType != null ? !configValueType.equals(configValueType3) : configValueType3 != null)) {
                        object = new Tuple2((Object)A13.getKey(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)A13.getValue().unwrapped()))).toString());
                        return (B1)object;
                    }
                }
                if (A1 != null) {
                    A1 A14 = A1;
                    ConfigValueType configValueType = A14.getValue().valueType();
                    ConfigValueType configValueType4 = ConfigValueType.BOOLEAN;
                    if (!(configValueType != null ? !configValueType.equals(configValueType4) : configValueType4 != null)) {
                        object = new Tuple2((Object)A14.getKey(), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)A14.getValue().unwrapped()))).toString());
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Map.Entry<String, ConfigValue> x1) {
                Map.Entry<String, ConfigValue> entry = x1;
                if (entry != null) {
                    Map.Entry<String, ConfigValue> entry2 = entry;
                    ConfigValueType configValueType = entry2.getValue().valueType();
                    ConfigValueType configValueType2 = ConfigValueType.STRING;
                    if (configValueType == null) {
                        if (configValueType2 == null) return true;
                    } else if (configValueType.equals(configValueType2)) {
                        return true;
                    }
                }
                if (entry != null) {
                    Map.Entry<String, ConfigValue> entry3 = entry;
                    ConfigValueType configValueType = entry3.getValue().valueType();
                    ConfigValueType configValueType3 = ConfigValueType.NUMBER;
                    if (configValueType == null) {
                        if (configValueType3 == null) return true;
                    } else if (configValueType.equals(configValueType3)) {
                        return true;
                    }
                }
                if (entry == null) return false;
                Map.Entry<String, ConfigValue> entry4 = entry;
                ConfigValueType configValueType = entry4.getValue().valueType();
                ConfigValueType configValueType4 = ConfigValueType.BOOLEAN;
                if (configValueType != null) {
                    if (!configValueType.equals(configValueType4)) return false;
                    return true;
                }
                if (configValueType4 == null) return true;
                return false;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
        this._system = null;
    }
}

