/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.stitch.model;

import com.xebialabs.xlplatform.documentation.PublicApi;

import java.util.List;

/**
 * StitchProcessor represents processor that is used to transform files.
 */
@PublicApi
public interface StitchProcessor {

  /**
   * Returns processor type.
   * @return processor type as {@link String}.
   */
  String getType();

  /**
   * Returns name of the namespace containing this processor.
   * @return namespace name as {@link String}.
   */
  String getNamespaceName();

  /**
   * Returns processors parameters.
   * @return processor parameter as list of {@link StitchParameter}.
   */
  List<? extends StitchParameter> getParameters();

  /**
   * Returns processor description.
   * @return processor description as {@link String}.
   */
  String describeAsString();
}
