/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.w3c.dom.Element;

public final class FileConfiguration
extends ConfigurationImpl
implements Deployable {
    private static final long serialVersionUID = -4766689627675039596L;
    private static final String CONFIGURATION_SCHEMA_URL = "schema/artemis-configuration.xsd";
    private static final String CONFIGURATION_SCHEMA_ROOT_ELEMENT = "core";
    public static final int DEFAULT_CONFIRMATION_WINDOW_SIZE = 0x100000;
    private boolean parsed = false;

    @Override
    public void parse(Element config, URL url) throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        parser.setValidateAIO(true);
        parser.parseMainConfig(config, this);
        this.setConfigurationUrl(url);
        this.parseSystemProperties();
        this.parsed = true;
    }

    @Override
    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public String getRootElement() {
        return CONFIGURATION_SCHEMA_ROOT_ELEMENT;
    }

    @Override
    public void buildService(ActiveMQSecurityManager securityManager, MBeanServer mBeanServer, Map<String, Deployable> deployables, Map<String, ActiveMQComponent> components, ActivateCallback activateCallback) {
        ActiveMQServerImpl activeMQServer = new ActiveMQServerImpl(this, mBeanServer, securityManager);
        if (activateCallback != null) {
            activeMQServer.registerActivateCallback(activateCallback);
        }
        components.put(this.getRootElement(), (ActiveMQComponent)activeMQServer);
    }

    @Override
    public String getSchema() {
        return CONFIGURATION_SCHEMA_URL;
    }
}

