/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public abstract class ContextRefresher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    protected static final String[] DEFAULT_PROPERTY_SOURCES = new String[]{"commandLineArgs", "defaultProperties"};
    protected Set<String> standardSources = new HashSet<String>(Arrays.asList("systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams", "configurationProperties"));
    private ConfigurableApplicationContext context;
    private RefreshScope scope;

    protected ContextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        this.context = context;
        this.scope = scope;
    }

    protected ConfigurableApplicationContext getContext() {
        return this.context;
    }

    protected RefreshScope getScope() {
        return this.scope;
    }

    public synchronized Set<String> refresh() {
        Set<String> keys = this.refreshEnvironment();
        this.scope.refreshAll();
        return keys;
    }

    public synchronized Set<String> refreshEnvironment() {
        Map<String, Object> before = this.extract(this.context.getEnvironment().getPropertySources());
        this.updateEnvironment();
        Set<String> keys = this.changes(before, this.extract(this.context.getEnvironment().getPropertySources())).keySet();
        this.context.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(this.context, keys));
        return keys;
    }

    protected abstract void updateEnvironment();

    protected StandardEnvironment copyEnvironment(ConfigurableEnvironment input) {
        StandardEnvironment environment = new StandardEnvironment();
        MutablePropertySources capturedPropertySources = environment.getPropertySources();
        for (String name : DEFAULT_PROPERTY_SOURCES) {
            if (!input.getPropertySources().contains(name)) continue;
            if (capturedPropertySources.contains(name)) {
                capturedPropertySources.replace(name, input.getPropertySources().get(name));
                continue;
            }
            capturedPropertySources.addLast(input.getPropertySources().get(name));
        }
        environment.setActiveProfiles(input.getActiveProfiles());
        environment.setDefaultProfiles(input.getDefaultProfiles());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spring.jmx.enabled", false);
        map.put("spring.main.sources", "");
        map.put("spring.main.web-application-type", "NONE");
        capturedPropertySources.addFirst((PropertySource)new MapPropertySource(REFRESH_ARGS_PROPERTY_SOURCE, map));
        return environment;
    }

    private Map<String, Object> changes(Map<String, Object> before, Map<String, Object> after) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : before.keySet()) {
            if (!after.containsKey(key)) {
                result.put(key, null);
                continue;
            }
            if (this.equal(before.get(key), after.get(key))) continue;
            result.put(key, after.get(key));
        }
        for (String key : after.keySet()) {
            if (before.containsKey(key)) continue;
            result.put(key, after.get(key));
        }
        return result;
    }

    private boolean equal(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    private Map<String, Object> extract(MutablePropertySources propertySources) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            if (this.standardSources.contains(source.getName())) continue;
            this.extract(source, result);
        }
        return result;
    }

    private void extract(PropertySource<?> parent, Map<String, Object> result) {
        if (parent instanceof CompositePropertySource) {
            try {
                ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
                for (PropertySource source : ((CompositePropertySource)parent).getPropertySources()) {
                    sources.add(0, source);
                }
                for (PropertySource source : sources) {
                    this.extract(source, result);
                }
            }
            catch (Exception e) {
                return;
            }
        } else if (parent instanceof EnumerablePropertySource) {
            for (String key : ((EnumerablePropertySource)parent).getPropertyNames()) {
                result.put(key, parent.getProperty(key));
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class Empty {
        protected Empty() {
        }
    }
}

