/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.actors.ProcessorBase;
import org.jboss.logging.Logger;

public class OrderedExecutor
extends ProcessorBase<Runnable>
implements ArtemisExecutor {
    private static final Logger logger = Logger.getLogger(OrderedExecutor.class);
    private boolean fair;

    public OrderedExecutor(Executor delegate) {
        super(delegate);
    }

    @Override
    public boolean isFair() {
        return this.fair;
    }

    @Override
    public OrderedExecutor setFair(boolean fair) {
        this.fair = fair;
        return this;
    }

    @Override
    protected final void doTask(Runnable task) {
        try {
            task.run();
            if (this.fair) {
                this.yield();
            }
        }
        catch (ActiveMQInterruptedException e) {
            logger.debug((Object)"Interrupted Thread", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn((Object)t.getMessage(), t);
        }
    }

    @Override
    public final void execute(Runnable run) {
        this.task(run);
    }

    public String toString() {
        return "OrderedExecutor(tasks=" + this.tasks + ")";
    }
}

