/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import com.amazonaws.services.s3.AmazonS3;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpClient;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.AwsS3RepositoryConfiguration;
import org.springframework.cloud.config.server.config.CompositeRepositoryConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.CredhubConfiguration;
import org.springframework.cloud.config.server.config.CredhubRepositoryConfiguration;
import org.springframework.cloud.config.server.config.DefaultRepositoryConfiguration;
import org.springframework.cloud.config.server.config.GitRepositoryConfiguration;
import org.springframework.cloud.config.server.config.GoogleCloudSourceConfiguration;
import org.springframework.cloud.config.server.config.JdbcRepositoryConfiguration;
import org.springframework.cloud.config.server.config.NativeRepositoryConfiguration;
import org.springframework.cloud.config.server.config.RedisRepositoryConfiguration;
import org.springframework.cloud.config.server.config.SpringVaultRepositoryConfiguration;
import org.springframework.cloud.config.server.config.SvnRepositoryConfiguration;
import org.springframework.cloud.config.server.config.VaultConfiguration;
import org.springframework.cloud.config.server.config.VaultRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.ConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.ConsulEnvironmentWatch;
import org.springframework.cloud.config.server.environment.CredhubEnvironmentProperties;
import org.springframework.cloud.config.server.environment.CredhubEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.HttpClientConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.HttpClientVaultRestTemplateFactory;
import org.springframework.cloud.config.server.environment.HttpRequestConfigTokenProvider;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentProperties;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.RedisEnvironmentProperties;
import org.springframework.cloud.config.server.environment.RedisEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.SvnEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.cloud.config.server.environment.vault.SpringVaultEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.support.GoogleCloudSourceSupport;
import org.springframework.cloud.config.server.support.TransportConfigCallbackFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.vault.core.VaultTemplate;
import org.tmatesoft.svn.core.SVNException;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SvnKitEnvironmentProperties.class, CredhubEnvironmentProperties.class, JdbcEnvironmentProperties.class, NativeEnvironmentProperties.class, VaultEnvironmentProperties.class, RedisEnvironmentProperties.class, AwsS3EnvironmentProperties.class})
@Import(value={CompositeRepositoryConfiguration.class, JdbcRepositoryConfiguration.class, VaultConfiguration.class, VaultRepositoryConfiguration.class, SpringVaultRepositoryConfiguration.class, CredhubConfiguration.class, CredhubRepositoryConfiguration.class, SvnRepositoryConfiguration.class, NativeRepositoryConfiguration.class, GitRepositoryConfiguration.class, RedisRepositoryConfiguration.class, GoogleCloudSourceConfiguration.class, AwsS3RepositoryConfiguration.class, DefaultRepositoryConfiguration.class})
public class EnvironmentRepositoryConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.health.enabled"}, matchIfMissing=true)
    public ConfigServerHealthIndicator configServerHealthIndicator(EnvironmentRepository repository) {
        return new ConfigServerHealthIndicator(repository);
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public MultipleJGitEnvironmentProperties multipleJGitEnvironmentProperties() {
        return new MultipleJGitEnvironmentProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConfigTokenProvider.class})
    public ConfigTokenProvider defaultConfigTokenProvider(ObjectProvider<HttpServletRequest> httpRequest) {
        return new HttpRequestConfigTokenProvider(httpRequest);
    }

    @Configuration(proxyBeanMethods=false)
    static class NativeFactoryConfig {
        NativeFactoryConfig() {
        }

        @Bean
        public NativeEnvironmentRepositoryFactory nativeEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties properties) {
            return new NativeEnvironmentRepositoryFactory(environment, properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CredHubOperations.class})
    static class CredhubFactoryConfig {
        CredhubFactoryConfig() {
        }

        @Bean
        public CredhubEnvironmentRepositoryFactory credhubEnvironmentRepositoryFactory(Optional<CredHubOperations> credHubOperations) {
            return new CredhubEnvironmentRepositoryFactory(credHubOperations.orElse(null));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={StringRedisTemplate.class})
    static class RedisFactoryConfig {
        RedisFactoryConfig() {
        }

        @Bean
        @ConditionalOnBean(value={StringRedisTemplate.class})
        public RedisEnvironmentRepositoryFactory redisEnvironmentRepositoryFactory(StringRedisTemplate redis) {
            return new RedisEnvironmentRepositoryFactory(redis);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JdbcTemplate.class})
    @ConditionalOnProperty(value={"spring.cloud.config.server.jdbc.enabled"}, matchIfMissing=true)
    static class JdbcFactoryConfig {
        JdbcFactoryConfig() {
        }

        @Bean
        @ConditionalOnBean(value={JdbcTemplate.class})
        public JdbcEnvironmentRepositoryFactory jdbcEnvironmentRepositoryFactory(JdbcTemplate jdbc) {
            return new JdbcEnvironmentRepositoryFactory(jdbc);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={VaultTemplate.class})
    @Import(value={SpringVaultClientConfiguration.class})
    static class SpringVaultFactoryConfig {
        SpringVaultFactoryConfig() {
        }

        @Bean
        public SpringVaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, SpringVaultClientConfiguration vaultClientConfiguration) {
            return new SpringVaultEnvironmentRepositoryFactory(request, watch, vaultClientConfiguration);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.vault.core.VaultTemplate"})
    static class VaultHttpClientConfig {
        VaultHttpClientConfig() {
        }

        @Bean
        public VaultEnvironmentRepositoryFactory.VaultRestTemplateFactory vaultRestTemplateFactory() {
            return new HttpClientVaultRestTemplateFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.vault.core.VaultTemplate"})
    static class VaultFactoryConfig {
        VaultFactoryConfig() {
        }

        @Bean
        public VaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, Optional<VaultEnvironmentRepositoryFactory.VaultRestTemplateFactory> vaultRestTemplateFactory, ConfigTokenProvider tokenProvider) {
            return new VaultEnvironmentRepositoryFactory(request, watch, vaultRestTemplateFactory, tokenProvider);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SVNException.class})
    static class SvnFactoryConfig {
        SvnFactoryConfig() {
        }

        @Bean
        public SvnEnvironmentRepositoryFactory svnEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server) {
            return new SvnEnvironmentRepositoryFactory(environment, server);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AmazonS3.class})
    static class AwsS3FactoryConfig {
        AwsS3FactoryConfig() {
        }

        @Bean
        public AwsS3EnvironmentRepositoryFactory awsS3EnvironmentRepositoryFactory(ConfigServerProperties server) {
            return new AwsS3EnvironmentRepositoryFactory(server);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class, TransportConfigCallback.class})
    static class JGitHttpClientConfig {
        JGitHttpClientConfig() {
        }

        @Bean
        public ConfigurableHttpConnectionFactory httpClientConnectionFactory() {
            return new HttpClientConfigurableHttpConnectionFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={TransportConfigCallback.class})
    static class JGitFactoryConfig {
        JGitFactoryConfig() {
        }

        @Bean
        public MultipleJGitEnvironmentRepositoryFactory gitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, Optional<ConfigurableHttpConnectionFactory> jgitHttpConnectionFactory, Optional<TransportConfigCallback> customTransportConfigCallback, Optional<GoogleCloudSourceSupport> googleCloudSourceSupport) {
            TransportConfigCallbackFactory transportConfigCallbackFactory = new TransportConfigCallbackFactory(customTransportConfigCallback.orElse(null), googleCloudSourceSupport.orElse(null));
            return new MultipleJGitEnvironmentRepositoryFactory(environment, server, jgitHttpConnectionFactory, transportConfigCallbackFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={EnvironmentWatch.class})
    protected static class DefaultEnvironmentWatch {
        protected DefaultEnvironmentWatch() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new EnvironmentWatch.Default();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.config.server.consul.watch.enabled"})
    protected static class ConsulEnvironmentWatchConfiguration {
        protected ConsulEnvironmentWatchConfiguration() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new ConsulEnvironmentWatch();
        }
    }
}

