/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationStartSyncMessage
extends PacketImpl {
    private long[] ids;
    private SyncDataType dataType;
    private boolean synchronizationIsFinished;
    private String nodeID;
    private boolean allowsAutoFailBack;

    public ReplicationStartSyncMessage() {
        super((byte)120);
    }

    public ReplicationStartSyncMessage(List<Long> filenames) {
        this();
        this.ids = new long[filenames.size()];
        for (int i = 0; i < filenames.size(); ++i) {
            this.ids[i] = filenames.get(i);
        }
        this.dataType = SyncDataType.LargeMessages;
        this.nodeID = "";
    }

    public ReplicationStartSyncMessage(String nodeID, long nodeDataVersion) {
        this(nodeID);
        this.ids = new long[1];
        this.ids[0] = nodeDataVersion;
        this.dataType = SyncDataType.ActivationSequence;
    }

    public ReplicationStartSyncMessage(String nodeID) {
        this();
        this.synchronizationIsFinished = true;
        this.nodeID = nodeID;
    }

    public ReplicationStartSyncMessage(JournalFile[] datafiles, AbstractJournalStorageManager.JournalContent contentType, String nodeID, boolean allowsAutoFailBack) {
        this();
        this.nodeID = nodeID;
        this.allowsAutoFailBack = allowsAutoFailBack;
        this.synchronizationIsFinished = false;
        this.ids = new long[datafiles.length];
        for (int i = 0; i < datafiles.length; ++i) {
            this.ids[i] = datafiles[i].getFileID();
        }
        switch (contentType) {
            case MESSAGES: {
                this.dataType = SyncDataType.JournalMessages;
                break;
            }
            case BINDINGS: {
                this.dataType = SyncDataType.JournalBindings;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int expectedEncodeSize() {
        int size = 15 + this.nodeID.length() * 3;
        return size += 5 + 8 * this.ids.length;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.synchronizationIsFinished);
        buffer.writeBoolean(this.allowsAutoFailBack);
        buffer.writeString(this.nodeID);
        buffer.writeByte(this.dataType.code);
        buffer.writeInt(this.ids.length);
        for (long id : this.ids) {
            buffer.writeLong(id);
        }
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.synchronizationIsFinished = buffer.readBoolean();
        this.allowsAutoFailBack = buffer.readBoolean();
        this.nodeID = buffer.readString();
        this.dataType = SyncDataType.getDataType(buffer.readByte());
        int length = buffer.readInt();
        this.ids = new long[length];
        for (int i = 0; i < length; ++i) {
            this.ids[i] = buffer.readLong();
        }
    }

    public boolean isServerToFailBack() {
        return this.allowsAutoFailBack;
    }

    public boolean isSynchronizationFinished() {
        return this.synchronizationIsFinished;
    }

    public SyncDataType getDataType() {
        return this.dataType;
    }

    public long[] getFileIds() {
        return this.ids;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowsAutoFailBack ? 1231 : 1237);
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + Arrays.hashCode(this.ids);
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.synchronizationIsFinished ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationStartSyncMessage)) {
            return false;
        }
        ReplicationStartSyncMessage other = (ReplicationStartSyncMessage)((Object)obj);
        if (this.allowsAutoFailBack != other.allowsAutoFailBack) {
            return false;
        }
        if (this.dataType != other.dataType) {
            return false;
        }
        if (!Arrays.equals(this.ids, other.ids)) {
            return false;
        }
        if (this.nodeID == null ? other.nodeID != null : !this.nodeID.equals(other.nodeID)) {
            return false;
        }
        return this.synchronizationIsFinished == other.synchronizationIsFinished;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getParentString());
        buf.append(", synchronizationIsFinished=" + this.synchronizationIsFinished);
        buf.append(", dataType=" + (Object)((Object)this.dataType));
        buf.append(", nodeID=" + this.nodeID);
        buf.append(", ids=" + Arrays.toString(this.ids));
        buf.append(", allowsAutoFailBack=" + this.allowsAutoFailBack);
        buf.append("]");
        return buf.toString();
    }

    public static enum SyncDataType {
        JournalBindings(AbstractJournalStorageManager.JournalContent.BINDINGS.typeByte),
        JournalMessages(AbstractJournalStorageManager.JournalContent.MESSAGES.typeByte),
        LargeMessages(2),
        ActivationSequence(3);

        private byte code;

        private SyncDataType(byte code) {
            this.code = code;
        }

        public static AbstractJournalStorageManager.JournalContent getJournalContentType(SyncDataType dataType) {
            return AbstractJournalStorageManager.JournalContent.getType(dataType.code);
        }

        public static SyncDataType getDataType(byte code) {
            if (code == SyncDataType.JournalBindings.code) {
                return JournalBindings;
            }
            if (code == SyncDataType.JournalMessages.code) {
                return JournalMessages;
            }
            if (code == SyncDataType.LargeMessages.code) {
                return LargeMessages;
            }
            if (code == SyncDataType.ActivationSequence.code) {
                return ActivationSequence;
            }
            throw new InvalidParameterException("invalid byte: " + code);
        }
    }
}

